// This library was created by the tool.
// Source: https://unicode.org/Public/13.0.0/ucd/UnicodeData.txt
// Unicode Version: 13.0.0

library unicode;

import 'dart:collection';
import 'package:lists/lists.dart';

const int NOT_ASSIGNED = 0;
const int notAssigned = 0;
const int CONTROL = 1;
const int control = 1;
const int FORMAT = 2;
const int format = 2;
const int PRIVATE_USE = 3;
const int privateUse = 3;
const int SURROGATE = 4;
const int surrogate = 4;
const int LOWERCASE_LETTER = 5;
const int lowercaseLetter = 5;
const int MODIFIER_LETTER = 6;
const int modifierLetter = 6;
const int OTHER_LETTER = 7;
const int otherLetter = 7;
const int TITLECASE_LETTER = 8;
const int titlecaseLetter = 8;
const int UPPERCASE_LETTER = 9;
const int uppercaseLetter = 9;
const int SPACING_MARK = 10;
const int spacingMark = 10;
const int ENCOSING_MARK = 11;
const int encosingMark = 11;
const int NONSPACING_MARK = 12;
const int nonspacingMark = 12;
const int DECIMAL_NUMBER = 13;
const int decimalNumber = 13;
const int LETTER_NUMBER = 14;
const int letterNumber = 14;
const int OTHER_NUMBER = 15;
const int otherNumber = 15;
const int CONNECTOR_PUNCTUATION = 16;
const int connectorPunctuation = 16;
const int DASH_PUNCTUATION = 17;
const int dashPunctuation = 17;
const int CLOSE_PUNCTUATION = 18;
const int closePunctuation = 18;
const int FINAL_PUNCTUATION = 19;
const int finalPunctuation = 19;
const int INITIAL_PUNCTUATION = 20;
const int initialPunctuation = 20;
const int OTHER_PUNCTUATION = 21;
const int otherPunctuation = 21;
const int OPEN_PUNCTUATION = 22;
const int openPunctuation = 22;
const int CURRENCY_SYMBOL = 23;
const int currencySymbol = 23;
const int MODIFIER_SYMBOL = 24;
const int modifierSymbol = 24;
const int MATH_SYMBOL = 25;
const int mathSymbol = 25;
const int OTHER_SYMBOL = 26;
const int otherSymbol = 26;
const int LINE_SEPARATOR = 27;
const int lineSeparator = 27;
const int PARAGRAPH_SEPARATOR = 28;
const int paragraphSeparator = 28;
const int SPACE_SEPARATOR = 29;
const int spaceSeparator = 29;

final SparseList<int> generalCategories = _generateIntGroup([0, 31, 1, 32, 1, 29, 1, 3, 21, 3, 1, 23, 1, 3, 21, 3, 1, 22, 1, 1, 18, 1, 1, 21, 1, 1, 25, 1, 1, 21, 1, 1, 17, 1, 2, 21, 2, 10, 13, 10, 2, 21, 2, 3, 25, 3, 2, 21, 2, 26, 9, 26, 1, 22, 1, 1, 21, 1, 1, 18, 1, 1, 24, 1, 1, 16, 1, 1, 24, 1, 26, 5, 26, 1, 22, 1, 1, 25, 1, 1, 18, 1, 1, 25, 1, 33, 1, 33, 1, 29, 1, 1, 21, 1, 4, 23, 4, 1, 26, 1, 1, 21, 1, 1, 24, 1, 1, 26, 1, 1, 7, 1, 1, 20, 1, 1, 25, 1, 1, 2, 1, 1, 26, 1, 1, 24, 1, 1, 26, 1, 1, 25, 1, 2, 15, 2, 1, 24, 1, 1, 5, 1, 2, 21, 2, 1, 24, 1, 1, 15, 1, 1, 7, 1, 1, 19, 1, 3, 15, 3, 1, 21, 1, 23, 9, 23, 1, 25, 1, 7, 9, 7, 24, 5, 24, 1, 25, 1, 8, 5, 8, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 2, 5, 2, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 2, 5, 2, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 2, 9, 2, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 3, 5, 3, 2, 9, 2, 1, 5, 1, 1, 9, 1, 1, 5, 1, 2, 9, 2, 1, 5, 1, 3, 9, 3, 2, 5, 2, 4, 9, 4, 1, 5, 1, 2, 9, 2, 1, 5, 1, 3, 9, 3, 3, 5, 3, 2, 9, 2, 1, 5, 1, 2, 9, 2, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 2, 9, 2, 1, 5, 1, 1, 9, 1, 2, 5, 2, 1, 9, 1, 1, 5, 1, 2, 9, 2, 1, 5, 1, 3, 9, 3, 1, 5, 1, 1, 9, 1, 1, 5, 1, 2, 9, 2, 2, 5, 2, 1, 7, 1, 1, 9, 1, 3, 5, 3, 4, 7, 4, 1, 9, 1, 1, 8, 1, 1, 5, 1, 1, 9, 1, 1, 8, 1, 1, 5, 1, 1, 9, 1, 1, 8, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 2, 5, 2, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 2, 5, 2, 1, 9, 1, 1, 8, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 3, 9, 3, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 7, 5, 7, 2, 9, 2, 1, 5, 1, 2, 9, 2, 2, 5, 2, 1, 9, 1, 1, 5, 1, 4, 9, 4, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 69, 5, 69, 1, 7, 1, 27, 5, 27, 18, 6, 18, 4, 24, 4, 12, 6, 12, 14, 24, 14, 5, 6, 5, 7, 24, 7, 1, 6, 1, 1, 24, 1, 1, 6, 1, 17, 24, 17, 112, 12, 112, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 6, 1, 1, 24, 1, 1, 9, 1, 1, 5, 3, 3, 6, 1, 3, 5, 3, 1, 21, 1, 1, 9, 5, 6, 24, 2, 1, 9, 1, 1, 21, 1, 3, 9, 4, 2, 9, 2, 3, 9, 2, 1, 5, 1, 17, 9, 18, 10, 9, 9, 35, 5, 35, 1, 9, 1, 2, 5, 2, 3, 9, 3, 3, 5, 3, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 5, 5, 5, 1, 9, 1, 1, 5, 1, 1, 25, 1, 1, 9, 1, 1, 5, 1, 2, 9, 2, 2, 5, 2, 51, 9, 51, 48, 5, 48, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 26, 1, 5, 12, 5, 2, 11, 2, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 2, 9, 2, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 2, 5, 2, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 2, 39, 9, 40, 3, 6, 1, 6, 21, 6, 41, 5, 41, 1, 21, 1, 1, 17, 3, 4, 26, 2, 1, 23, 2, 46, 12, 45, 1, 17, 1, 1, 12, 1, 1, 21, 1, 2, 12, 2, 1, 21, 1, 2, 12, 2, 1, 21, 1, 1, 12, 9, 35, 7, 31, 8, 7, 4, 2, 21, 13, 17, 2, 6, 3, 25, 3, 2, 21, 2, 1, 23, 1, 2, 21, 2, 2, 26, 2, 11, 12, 11, 1, 21, 1, 1, 2, 2, 3, 21, 2, 32, 7, 32, 1, 6, 1, 10, 7, 10, 21, 12, 21, 10, 13, 10, 4, 21, 4, 2, 7, 2, 1, 12, 1, 99, 7, 99, 1, 21, 1, 1, 7, 1, 7, 12, 7, 1, 2, 1, 1, 26, 1, 6, 12, 6, 2, 6, 2, 2, 12, 2, 1, 26, 1, 4, 12, 4, 2, 7, 2, 10, 13, 10, 3, 7, 3, 2, 26, 2, 1, 7, 1, 14, 21, 15, 2, 2, 1, 1, 7, 1, 1, 12, 1, 30, 7, 30, 27, 12, 29, 91, 7, 89, 11, 12, 11, 1, 7, 15, 24, 13, 10, 33, 7, 33, 9, 12, 9, 2, 6, 2, 1, 26, 1, 3, 21, 3, 1, 6, 3, 3, 12, 1, 2, 23, 2, 22, 7, 22, 4, 12, 4, 1, 6, 1, 9, 12, 9, 1, 6, 1, 3, 12, 3, 1, 6, 1, 5, 12, 7, 17, 21, 16, 26, 7, 25, 3, 12, 5, 3, 21, 2, 12, 7, 64, 74, 7, 22, 19, 7, 29, 26, 12, 15, 1, 2, 1, 32, 12, 32, 1, 10, 1, 54, 7, 54, 1, 12, 1, 1, 10, 1, 1, 12, 1, 1, 7, 1, 3, 10, 3, 8, 12, 8, 4, 10, 4, 1, 12, 1, 2, 10, 2, 1, 7, 1, 7, 12, 7, 10, 7, 10, 2, 12, 2, 2, 21, 2, 10, 13, 10, 1, 21, 1, 1, 6, 1, 15, 7, 15, 1, 12, 1, 2, 10, 3, 9, 7, 10, 4, 7, 4, 24, 7, 23, 8, 7, 8, 2, 7, 4, 7, 7, 6, 3, 12, 1, 1, 7, 1, 3, 10, 3, 4, 12, 6, 4, 10, 4, 4, 10, 2, 1, 12, 1, 1, 7, 9, 9, 10, 5, 6, 7, 3, 4, 7, 3, 2, 12, 4, 12, 13, 10, 2, 7, 2, 2, 23, 2, 6, 15, 6, 1, 26, 1, 1, 23, 1, 1, 7, 1, 1, 21, 1, 1, 12, 3, 4, 12, 2, 1, 10, 2, 7, 7, 10, 6, 7, 4, 24, 7, 23, 8, 7, 8, 3, 7, 3, 3, 7, 3, 3, 7, 4, 3, 12, 2, 4, 10, 3, 2, 12, 6, 6, 12, 4, 5, 12, 6, 4, 12, 8, 11, 7, 5, 2, 7, 8, 17, 13, 10, 2, 12, 2, 3, 7, 3, 1, 12, 1, 1, 21, 11, 12, 12, 2, 1, 10, 2, 10, 7, 10, 4, 7, 4, 23, 7, 23, 8, 7, 8, 3, 7, 3, 6, 7, 7, 3, 12, 1, 1, 7, 1, 3, 10, 3, 5, 12, 6, 3, 12, 2, 1, 10, 2, 3, 10, 2, 1, 12, 3, 3, 7, 16, 17, 7, 2, 2, 12, 4, 12, 13, 10, 1, 21, 1, 1, 23, 8, 8, 7, 1, 6, 12, 7, 2, 12, 1, 2, 10, 3, 9, 7, 10, 4, 7, 4, 24, 7, 23, 8, 7, 8, 3, 7, 3, 6, 7, 7, 3, 12, 1, 1, 7, 1, 1, 10, 1, 1, 12, 1, 1, 10, 1, 4, 12, 6, 4, 10, 4, 4, 10, 2, 1, 12, 8, 9, 12, 2, 1, 10, 5, 6, 7, 3, 4, 7, 3, 2, 12, 4, 12, 13, 10, 1, 26, 1, 1, 7, 1, 6, 15, 16, 11, 12, 1, 1, 7, 2, 7, 7, 9, 6, 7, 4, 5, 7, 7, 5, 7, 3, 2, 7, 2, 3, 7, 5, 5, 7, 5, 6, 7, 6, 15, 7, 16, 6, 10, 2, 1, 12, 1, 2, 10, 5, 6, 10, 4, 4, 10, 3, 1, 12, 3, 3, 7, 7, 7, 10, 15, 24, 13, 10, 3, 15, 3, 6, 26, 6, 1, 23, 1, 1, 26, 6, 6, 12, 1, 3, 10, 3, 1, 12, 1, 8, 7, 9, 4, 7, 4, 24, 7, 24, 17, 7, 19, 4, 7, 1, 3, 12, 3, 4, 10, 5, 4, 12, 4, 5, 12, 11, 9, 12, 3, 4, 7, 8, 7, 7, 2, 2, 12, 4, 12, 13, 17, 8, 21, 1, 7, 15, 7, 1, 26, 1, 1, 7, 1, 1, 12, 1, 2, 10, 2, 1, 21, 1, 8, 7, 9, 4, 7, 4, 24, 7, 24, 11, 7, 11, 6, 7, 7, 3, 12, 1, 1, 7, 1, 1, 10, 1, 1, 12, 1, 5, 10, 6, 2, 12, 1, 2, 10, 3, 3, 10, 2, 2, 12, 9, 9, 10, 9, 8, 7, 2, 3, 7, 2, 2, 12, 4, 12, 13, 11, 3, 7, 15, 15, 12, 2, 2, 10, 2, 9, 7, 10, 4, 7, 4, 42, 7, 41, 2, 12, 2, 1, 7, 1, 3, 10, 3, 4, 12, 5, 4, 10, 4, 4, 10, 3, 1, 12, 1, 1, 7, 1, 1, 26, 5, 7, 7, 3, 1, 10, 1, 7, 15, 7, 3, 7, 3, 2, 12, 4, 12, 13, 10, 9, 15, 9, 1, 26, 1, 6, 7, 7, 2, 12, 1, 2, 10, 3, 19, 7, 21, 27, 7, 25, 10, 7, 10, 2, 7, 3, 9, 7, 10, 4, 12, 5, 7, 10, 3, 3, 12, 4, 2, 12, 2, 9, 10, 14, 16, 13, 12, 4, 10, 2, 1, 21, 13, 60, 7, 48, 1, 12, 1, 2, 7, 2, 7, 12, 11, 5, 23, 1, 6, 7, 6, 1, 6, 1, 8, 12, 8, 1, 21, 1, 10, 13, 10, 2, 21, 39, 39, 7, 3, 2, 7, 2, 6, 7, 6, 25, 7, 25, 2, 7, 2, 11, 7, 10, 1, 12, 1, 2, 7, 2, 9, 12, 9, 1, 7, 3, 7, 7, 6, 2, 6, 2, 7, 12, 8, 12, 13, 12, 6, 7, 36, 33, 7, 1, 3, 26, 3, 15, 21, 15, 1, 26, 1, 1, 21, 1, 3, 26, 3, 2, 12, 2, 6, 26, 6, 10, 13, 10, 10, 15, 10, 1, 26, 1, 1, 12, 1, 1, 26, 1, 1, 12, 1, 1, 26, 1, 1, 12, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 2, 10, 2, 8, 7, 9, 37, 7, 40, 18, 12, 14, 1, 10, 1, 5, 12, 5, 1, 21, 1, 2, 12, 2, 5, 7, 5, 11, 12, 12, 37, 12, 37, 9, 26, 8, 1, 12, 1, 6, 26, 7, 3, 26, 2, 5, 21, 5, 4, 26, 4, 2, 21, 39, 80, 7, 43, 2, 10, 2, 4, 12, 4, 1, 10, 1, 6, 12, 6, 1, 10, 1, 2, 12, 2, 2, 10, 2, 2, 12, 2, 1, 7, 1, 10, 13, 10, 6, 21, 6, 6, 7, 6, 2, 10, 2, 2, 12, 2, 4, 7, 4, 3, 12, 3, 1, 7, 1, 3, 10, 3, 2, 7, 2, 7, 10, 7, 3, 7, 3, 4, 12, 4, 13, 7, 13, 1, 12, 1, 2, 10, 2, 2, 12, 2, 6, 10, 6, 1, 12, 1, 1, 7, 1, 1, 10, 1, 10, 13, 10, 3, 10, 3, 1, 12, 1, 2, 26, 2, 38, 9, 39, 2, 9, 6, 6, 9, 3, 45, 5, 43, 1, 21, 1, 1, 6, 1, 3, 5, 3, 329, 7, 330, 5, 7, 6, 9, 7, 8, 2, 7, 2, 5, 7, 6, 43, 7, 42, 5, 7, 6, 35, 7, 34, 5, 7, 6, 9, 7, 8, 2, 7, 2, 5, 7, 6, 17, 7, 16, 58, 7, 58, 5, 7, 6, 69, 7, 69, 5, 12, 3, 9, 21, 9, 20, 15, 23, 19, 7, 16, 10, 26, 16, 92, 9, 88, 8, 5, 8, 3, 17, 1, 620, 7, 620, 1, 26, 1, 1, 21, 1, 17, 7, 17, 1, 29, 1, 26, 7, 26, 1, 22, 1, 1, 18, 4, 78, 7, 75, 3, 21, 3, 3, 14, 3, 8, 7, 15, 20, 7, 14, 5, 7, 4, 3, 12, 14, 29, 7, 18, 3, 12, 3, 2, 21, 11, 27, 7, 18, 2, 12, 14, 25, 7, 14, 4, 7, 4, 3, 12, 14, 64, 7, 52, 2, 12, 2, 1, 10, 1, 7, 12, 7, 8, 10, 8, 1, 12, 1, 2, 10, 2, 11, 12, 11, 3, 21, 3, 1, 6, 1, 3, 21, 3, 1, 23, 1, 1, 7, 1, 1, 12, 3, 12, 13, 16, 16, 15, 16, 12, 21, 6, 1, 17, 1, 4, 21, 4, 3, 12, 3, 1, 2, 2, 11, 13, 16, 41, 7, 35, 1, 6, 1, 53, 7, 60, 12, 7, 5, 2, 12, 2, 34, 7, 34, 1, 12, 1, 1, 7, 6, 75, 7, 80, 41, 7, 32, 4, 12, 3, 4, 10, 4, 2, 12, 2, 3, 10, 7, 6, 10, 2, 1, 12, 1, 6, 10, 6, 3, 12, 7, 5, 26, 4, 5, 21, 2, 10, 13, 10, 30, 7, 32, 7, 7, 16, 55, 7, 48, 30, 7, 32, 16, 13, 10, 1, 15, 4, 37, 26, 34, 23, 7, 23, 2, 12, 2, 2, 10, 2, 1, 12, 3, 4, 21, 2, 53, 7, 53, 1, 10, 1, 1, 12, 1, 1, 10, 1, 7, 12, 8, 2, 12, 1, 1, 10, 1, 1, 12, 1, 2, 10, 2, 8, 12, 8, 6, 10, 6, 10, 12, 12, 3, 12, 1, 10, 13, 16, 16, 13, 16, 13, 21, 7, 1, 6, 1, 6, 21, 8, 16, 12, 14, 1, 11, 1, 2, 12, 65, 67, 12, 4, 1, 10, 1, 47, 7, 47, 1, 12, 1, 1, 10, 1, 5, 12, 5, 1, 10, 1, 1, 12, 1, 5, 10, 5, 1, 12, 1, 2, 10, 2, 7, 7, 11, 14, 13, 10, 7, 21, 7, 10, 26, 10, 9, 12, 9, 9, 26, 12, 5, 12, 2, 1, 10, 1, 30, 7, 30, 1, 10, 1, 4, 12, 4, 2, 10, 2, 2, 12, 2, 1, 10, 1, 3, 12, 3, 2, 7, 2, 10, 13, 10, 44, 7, 44, 1, 12, 1, 1, 10, 1, 2, 12, 2, 3, 10, 3, 1, 12, 1, 1, 10, 1, 3, 12, 3, 2, 10, 10, 12, 21, 4, 36, 7, 36, 8, 10, 8, 8, 12, 8, 2, 10, 2, 2, 12, 5, 8, 21, 5, 10, 13, 13, 6, 7, 3, 10, 13, 10, 30, 7, 30, 6, 6, 6, 2, 21, 2, 9, 5, 16, 50, 9, 45, 5, 9, 3, 8, 21, 16, 11, 12, 3, 1, 21, 1, 13, 12, 13, 1, 10, 1, 7, 12, 7, 4, 7, 4, 1, 12, 1, 6, 7, 6, 1, 12, 1, 2, 7, 2, 1, 10, 1, 2, 12, 2, 1, 7, 6, 49, 5, 44, 63, 6, 63, 13, 5, 13, 1, 6, 1, 34, 5, 34, 37, 6, 37, 58, 12, 59, 6, 12, 5, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 9, 5, 9, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 9, 5, 9, 8, 9, 8, 6, 5, 8, 8, 9, 8, 10, 5, 8, 8, 9, 8, 8, 5, 8, 8, 9, 8, 6, 5, 8, 8, 9, 8, 10, 5, 9, 2, 9, 2, 2, 9, 2, 2, 9, 2, 2, 9, 1, 8, 5, 8, 8, 9, 8, 14, 5, 16, 10, 5, 8, 8, 8, 8, 8, 5, 8, 8, 8, 8, 8, 5, 8, 8, 8, 8, 5, 5, 6, 3, 5, 2, 4, 9, 4, 1, 8, 1, 1, 24, 1, 1, 5, 1, 3, 24, 3, 3, 5, 4, 3, 5, 2, 4, 9, 4, 1, 8, 1, 3, 24, 3, 4, 5, 6, 4, 5, 2, 4, 9, 5, 4, 24, 3, 8, 5, 8, 5, 9, 5, 3, 24, 5, 5, 5, 4, 3, 5, 2, 4, 9, 4, 1, 8, 1, 2, 24, 3, 12, 29, 11, 5, 2, 5, 6, 17, 6, 2, 21, 2, 1, 20, 1, 1, 19, 1, 1, 22, 1, 2, 20, 2, 1, 19, 1, 1, 22, 1, 1, 20, 1, 8, 21, 8, 1, 27, 1, 1, 28, 1, 5, 2, 5, 1, 29, 1, 9, 21, 9, 1, 20, 1, 1, 19, 1, 4, 21, 4, 2, 16, 2, 3, 21, 3, 1, 25, 1, 1, 22, 1, 1, 18, 1, 11, 21, 11, 1, 25, 1, 1, 21, 1, 1, 16, 1, 10, 21, 10, 1, 29, 1, 5, 2, 6, 11, 2, 10, 1, 15, 1, 1, 6, 3, 8, 15, 6, 3, 25, 3, 1, 22, 1, 1, 18, 1, 1, 6, 1, 10, 15, 10, 3, 25, 3, 1, 22, 1, 1, 18, 2, 14, 6, 16, 35, 23, 48, 29, 12, 13, 4, 11, 4, 1, 12, 1, 3, 11, 3, 12, 12, 27, 17, 26, 2, 1, 9, 1, 4, 26, 4, 1, 9, 1, 2, 26, 2, 1, 5, 1, 3, 9, 3, 2, 5, 2, 3, 9, 3, 1, 5, 1, 1, 26, 1, 1, 9, 1, 2, 26, 2, 1, 25, 1, 5, 9, 5, 6, 26, 6, 1, 9, 1, 1, 26, 1, 1, 9, 1, 1, 26, 1, 1, 9, 1, 1, 26, 1, 4, 9, 4, 1, 26, 1, 1, 5, 1, 4, 9, 4, 1, 5, 1, 4, 7, 4, 1, 5, 1, 2, 26, 2, 2, 5, 2, 2, 9, 2, 5, 25, 5, 1, 9, 1, 4, 5, 4, 1, 26, 1, 1, 25, 1, 2, 26, 2, 1, 5, 1, 1, 26, 1, 16, 15, 16, 35, 14, 35, 1, 9, 1, 1, 5, 1, 4, 14, 4, 1, 15, 1, 2, 26, 6, 9, 25, 5, 5, 26, 5, 2, 25, 2, 4, 26, 4, 1, 25, 1, 2, 26, 2, 1, 25, 1, 2, 26, 2, 1, 25, 1, 7, 26, 7, 1, 25, 1, 31, 26, 31, 2, 25, 2, 2, 26, 2, 1, 25, 1, 1, 26, 1, 1, 25, 1, 31, 26, 31, 268, 25, 268, 8, 26, 8, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 20, 26, 20, 2, 25, 2, 7, 26, 7, 1, 22, 1, 1, 18, 1, 81, 26, 81, 1, 25, 1, 30, 26, 30, 25, 25, 25, 40, 26, 40, 6, 25, 6, 69, 26, 94, 36, 26, 32, 81, 15, 60, 78, 26, 78, 22, 15, 22, 183, 26, 183, 1, 25, 1, 9, 26, 9, 1, 25, 1, 54, 26, 54, 8, 25, 8, 111, 26, 111, 1, 25, 1, 248, 26, 248, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 30, 15, 30, 44, 26, 44, 5, 25, 5, 1, 22, 1, 1, 18, 1, 31, 25, 31, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 16, 25, 16, 256, 26, 256, 131, 25, 131, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 63, 25, 63, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 32, 25, 32, 1, 22, 1, 1, 18, 1, 258, 25, 258, 48, 26, 48, 21, 25, 21, 2, 26, 2, 6, 25, 6, 39, 26, 41, 34, 26, 33, 106, 26, 105, 47, 9, 48, 48, 5, 48, 2, 9, 1, 1, 5, 1, 3, 9, 3, 2, 5, 2, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 4, 9, 4, 1, 5, 1, 1, 9, 1, 2, 5, 2, 1, 9, 1, 6, 5, 6, 2, 6, 2, 3, 9, 3, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 2, 5, 2, 6, 26, 6, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 3, 12, 3, 1, 9, 1, 1, 5, 6, 9, 21, 4, 1, 15, 1, 2, 21, 2, 38, 5, 39, 2, 5, 6, 6, 5, 3, 58, 7, 63, 8, 6, 1, 1, 21, 15, 15, 12, 1, 23, 7, 32, 16, 7, 8, 8, 7, 8, 8, 7, 8, 8, 7, 8, 8, 7, 8, 8, 7, 8, 8, 7, 8, 8, 7, 8, 33, 12, 32, 2, 21, 2, 1, 20, 1, 1, 19, 1, 1, 20, 1, 1, 19, 1, 3, 21, 3, 1, 20, 1, 1, 19, 1, 1, 21, 1, 1, 20, 1, 1, 19, 1, 9, 21, 9, 1, 17, 1, 2, 21, 2, 1, 17, 1, 1, 21, 1, 1, 20, 1, 1, 19, 1, 2, 21, 2, 1, 20, 1, 1, 19, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 5, 21, 5, 1, 6, 1, 10, 21, 10, 2, 17, 2, 4, 21, 4, 1, 17, 1, 1, 21, 1, 1, 22, 1, 13, 21, 13, 2, 26, 2, 1, 21, 46, 71, 26, 27, 90, 26, 101, 226, 26, 240, 38, 26, 16, 5, 29, 1, 3, 21, 3, 1, 26, 1, 1, 6, 1, 1, 7, 1, 1, 14, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 2, 26, 2, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 17, 1, 1, 22, 1, 2, 18, 2, 1, 26, 1, 9, 14, 9, 4, 12, 4, 2, 10, 2, 1, 17, 1, 5, 6, 5, 2, 26, 2, 3, 14, 3, 1, 6, 1, 1, 7, 1, 1, 21, 1, 2, 26, 3, 87, 7, 88, 4, 12, 2, 2, 24, 2, 2, 6, 2, 1, 7, 1, 1, 17, 1, 90, 7, 90, 1, 21, 1, 3, 6, 3, 1, 7, 6, 48, 7, 44, 95, 7, 95, 3, 26, 2, 4, 15, 4, 10, 26, 10, 32, 7, 32, 36, 26, 48, 28, 7, 16, 31, 26, 32, 11, 15, 10, 30, 26, 30, 8, 15, 8, 1, 26, 1, 15, 15, 15, 32, 26, 32, 10, 15, 10, 39, 26, 39, 15, 15, 15, 320, 26, 320, 6592, 7, 6592, 64, 26, 64, 20989, 7, 20992, 24, 7, 21, 1, 6, 1, 1143, 7, 1146, 58, 26, 64, 49, 7, 40, 6, 6, 6, 2, 21, 2, 268, 7, 268, 1, 6, 1, 3, 21, 3, 16, 7, 16, 10, 13, 10, 2, 7, 22, 21, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 7, 1, 1, 12, 1, 3, 11, 3, 1, 21, 1, 10, 12, 10, 1, 21, 1, 1, 6, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 2, 6, 2, 2, 12, 2, 70, 7, 70, 10, 14, 10, 2, 12, 2, 6, 21, 14, 31, 24, 23, 9, 6, 9, 2, 24, 2, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 3, 5, 3, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 6, 1, 8, 5, 8, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 2, 9, 2, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 6, 1, 2, 24, 2, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 7, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 3, 5, 3, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 5, 9, 5, 1, 5, 1, 5, 9, 5, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 1, 1, 9, 1, 1, 5, 3, 3, 9, 1, 1, 5, 1, 4, 9, 4, 1, 5, 1, 1, 9, 1, 1, 5, 43, 43, 9, 1, 1, 5, 1, 1, 7, 1, 2, 6, 2, 1, 5, 1, 7, 7, 7, 1, 12, 1, 3, 7, 3, 1, 12, 1, 4, 7, 4, 1, 12, 1, 23, 7, 23, 2, 10, 2, 2, 12, 2, 1, 10, 1, 4, 26, 4, 1, 12, 4, 9, 15, 6, 2, 26, 2, 1, 23, 1, 1, 26, 7, 58, 7, 52, 4, 21, 12, 10, 10, 2, 50, 7, 50, 16, 10, 16, 2, 12, 10, 10, 21, 2, 10, 13, 16, 24, 12, 18, 6, 7, 6, 3, 21, 3, 1, 7, 1, 1, 21, 1, 2, 7, 2, 1, 12, 1, 10, 13, 10, 28, 7, 28, 8, 12, 8, 2, 21, 2, 23, 7, 23, 11, 12, 11, 2, 10, 13, 12, 21, 1, 29, 7, 32, 6, 12, 3, 1, 10, 1, 47, 7, 47, 1, 12, 1, 2, 10, 2, 4, 12, 4, 2, 10, 2, 2, 12, 2, 3, 10, 3, 13, 21, 14, 2, 6, 1, 10, 13, 14, 6, 21, 2, 5, 7, 5, 1, 12, 1, 1, 6, 1, 9, 7, 9, 10, 13, 10, 5, 7, 6, 42, 7, 41, 6, 12, 6, 2, 10, 2, 2, 12, 2, 2, 10, 2, 2, 12, 11, 12, 7, 3, 1, 12, 1, 8, 7, 8, 1, 12, 1, 1, 10, 3, 12, 13, 12, 6, 21, 4, 16, 7, 16, 1, 6, 1, 6, 7, 6, 3, 26, 3, 1, 7, 1, 1, 10, 1, 1, 12, 1, 1, 10, 1, 50, 7, 50, 1, 12, 1, 1, 7, 1, 3, 12, 3, 2, 7, 2, 2, 12, 2, 5, 7, 5, 2, 12, 2, 1, 7, 1, 1, 12, 1, 1, 7, 25, 26, 7, 2, 1, 6, 1, 2, 21, 2, 11, 7, 11, 1, 10, 1, 2, 12, 2, 2, 10, 2, 2, 21, 2, 1, 7, 1, 2, 6, 2, 1, 10, 1, 1, 12, 11, 16, 7, 8, 8, 7, 8, 8, 7, 15, 16, 7, 8, 8, 7, 8, 44, 5, 43, 1, 24, 1, 4, 6, 4, 9, 5, 9, 1, 6, 1, 2, 24, 6, 84, 5, 80, 35, 7, 35, 2, 10, 2, 1, 12, 1, 2, 10, 2, 1, 12, 1, 2, 10, 2, 1, 21, 1, 1, 10, 1, 1, 12, 3, 12, 13, 16, 11178, 7, 11184, 35, 7, 27, 53, 7, 53, 2052, 4, 2048, 6400, 3, 6400, 366, 7, 368, 108, 7, 144, 45, 5, 19, 17, 5, 10, 6, 7, 1, 1, 12, 1, 10, 7, 10, 1, 25, 1, 13, 7, 14, 6, 7, 6, 2, 7, 2, 3, 7, 3, 3, 7, 3, 109, 7, 108, 16, 24, 33, 380, 7, 363, 1, 18, 1, 1, 22, 17, 80, 7, 66, 56, 7, 94, 52, 7, 12, 1, 23, 1, 1, 26, 3, 18, 12, 16, 7, 21, 7, 1, 22, 1, 1, 18, 1, 1, 21, 7, 22, 12, 16, 1, 21, 1, 2, 17, 2, 2, 16, 2, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 2, 21, 2, 1, 22, 1, 1, 18, 1, 4, 21, 4, 3, 16, 3, 3, 21, 4, 5, 21, 4, 1, 17, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 1, 22, 1, 1, 18, 1, 3, 21, 3, 1, 25, 1, 1, 17, 1, 3, 25, 4, 2, 21, 1, 1, 23, 1, 2, 21, 6, 9, 7, 6, 136, 7, 137, 3, 2, 2, 4, 21, 3, 1, 23, 1, 3, 21, 3, 1, 22, 1, 1, 18, 1, 1, 21, 1, 1, 25, 1, 1, 21, 1, 1, 17, 1, 2, 21, 2, 10, 13, 10, 2, 21, 2, 3, 25, 3, 2, 21, 2, 26, 9, 26, 1, 22, 1, 1, 21, 1, 1, 18, 1, 1, 24, 1, 1, 16, 1, 1, 24, 1, 26, 5, 26, 1, 22, 1, 1, 25, 1, 1, 18, 1, 1, 25, 1, 1, 22, 1, 1, 18, 1, 1, 21, 1, 1, 22, 1, 1, 18, 1, 2, 21, 2, 10, 7, 10, 1, 6, 1, 45, 7, 45, 2, 6, 2, 31, 7, 34, 9, 7, 8, 8, 7, 8, 8, 7, 8, 5, 7, 6, 5, 23, 2, 1, 25, 1, 1, 24, 1, 1, 26, 1, 2, 23, 3, 2, 26, 1, 4, 25, 4, 2, 26, 12, 13, 2, 3, 2, 26, 4, 14, 7, 13, 27, 7, 27, 20, 7, 20, 3, 7, 3, 16, 7, 17, 16, 7, 48, 157, 7, 128, 8, 21, 7, 49, 15, 48, 12, 26, 9, 53, 14, 53, 4, 15, 4, 17, 26, 17, 2, 15, 2, 3, 26, 4, 14, 26, 16, 4, 26, 48, 92, 26, 45, 1, 12, 131, 159, 7, 32, 52, 7, 64, 16, 12, 1, 27, 15, 31, 36, 7, 32, 4, 15, 13, 29, 7, 20, 1, 14, 1, 8, 7, 8, 1, 14, 6, 43, 7, 38, 5, 12, 10, 35, 7, 31, 2, 21, 1, 36, 7, 40, 12, 7, 8, 1, 21, 1, 5, 14, 47, 82, 9, 40, 40, 5, 40, 78, 7, 80, 12, 13, 16, 42, 9, 40, 40, 5, 40, 44, 7, 48, 60, 7, 63, 12, 21, 145, 455, 7, 320, 31, 7, 32, 18, 7, 160, 158, 7, 8, 3, 7, 2, 45, 7, 45, 3, 7, 5, 4, 7, 3, 25, 7, 24, 2, 21, 1, 8, 15, 8, 23, 7, 23, 2, 26, 2, 7, 15, 7, 31, 7, 39, 17, 15, 57, 67, 7, 20, 3, 7, 7, 10, 15, 5, 22, 7, 22, 6, 15, 9, 4, 21, 1, 26, 7, 31, 6, 21, 65, 120, 7, 60, 6, 15, 2, 2, 7, 2, 16, 15, 18, 48, 15, 46, 1, 7, 1, 3, 12, 4, 3, 12, 7, 9, 12, 4, 4, 7, 5, 4, 7, 4, 30, 7, 31, 5, 12, 7, 5, 12, 1, 9, 15, 16, 16, 21, 16, 36, 7, 29, 2, 15, 2, 1, 21, 1, 29, 7, 29, 3, 15, 35, 40, 7, 8, 1, 26, 1, 28, 7, 28, 2, 12, 6, 9, 15, 5, 7, 21, 16, 63, 7, 57, 10, 21, 7, 22, 7, 24, 10, 15, 8, 19, 7, 24, 13, 15, 8, 18, 7, 25, 11, 21, 16, 19, 15, 87, 153, 7, 128, 106, 9, 64, 64, 5, 58, 13, 15, 6, 36, 7, 36, 4, 12, 12, 18, 13, 304, 325, 15, 32, 43, 7, 43, 3, 12, 2, 1, 17, 3, 4, 7, 80, 107, 7, 29, 10, 15, 10, 1, 7, 9, 30, 7, 22, 11, 12, 11, 4, 15, 4, 5, 21, 91, 107, 7, 21, 7, 15, 27, 43, 7, 32, 10, 10, 1, 1, 12, 1, 1, 10, 1, 53, 7, 53, 15, 12, 15, 7, 21, 11, 24, 15, 20, 10, 13, 25, 18, 12, 3, 1, 10, 1, 45, 7, 45, 3, 10, 3, 4, 12, 4, 2, 10, 2, 2, 12, 2, 2, 21, 2, 1, 2, 1, 4, 21, 15, 12, 2, 3, 27, 7, 32, 17, 13, 16, 9, 12, 3, 36, 7, 36, 5, 12, 5, 1, 10, 1, 8, 12, 9, 11, 13, 10, 4, 21, 4, 1, 7, 1, 2, 10, 2, 1, 7, 9, 43, 7, 35, 1, 12, 1, 2, 21, 2, 1, 7, 10, 11, 12, 2, 1, 10, 1, 48, 7, 48, 3, 10, 3, 9, 12, 9, 2, 10, 2, 4, 7, 4, 4, 21, 4, 4, 12, 4, 1, 21, 1, 1, 10, 1, 1, 12, 1, 10, 13, 10, 1, 7, 1, 1, 21, 1, 1, 7, 1, 3, 21, 4, 21, 15, 31, 29, 7, 19, 26, 7, 25, 3, 10, 3, 3, 12, 3, 2, 10, 2, 1, 12, 1, 1, 10, 1, 2, 12, 2, 6, 21, 6, 1, 12, 66, 72, 7, 8, 2, 7, 2, 5, 7, 5, 16, 7, 16, 11, 7, 10, 1, 21, 7, 53, 7, 47, 1, 12, 1, 3, 10, 3, 8, 12, 13, 15, 13, 16, 8, 12, 2, 2, 10, 3, 9, 7, 10, 4, 7, 4, 24, 7, 23, 8, 7, 8, 3, 7, 3, 6, 7, 6, 3, 12, 2, 1, 7, 1, 2, 10, 2, 1, 12, 1, 4, 10, 6, 4, 10, 4, 5, 10, 5, 3, 7, 7, 7, 10, 6, 10, 7, 5, 2, 10, 4, 9, 12, 10, 8, 12, 144, 192, 7, 53, 3, 10, 3, 8, 12, 8, 2, 10, 2, 3, 12, 3, 1, 10, 1, 1, 12, 1, 4, 7, 4, 5, 21, 5, 10, 13, 10, 2, 21, 3, 2, 21, 1, 1, 12, 1, 3, 7, 33, 78, 7, 48, 3, 10, 3, 6, 12, 6, 1, 10, 1, 1, 12, 1, 4, 10, 4, 2, 12, 2, 1, 10, 1, 2, 12, 2, 2, 7, 2, 1, 21, 1, 1, 7, 9, 18, 13, 176, 213, 7, 47, 3, 10, 3, 4, 12, 6, 6, 10, 4, 2, 12, 2, 1, 10, 1, 2, 12, 2, 23, 21, 23, 4, 7, 4, 2, 12, 36, 82, 7, 48, 3, 10, 3, 8, 12, 8, 2, 10, 2, 1, 12, 1, 1, 10, 1, 2, 12, 2, 3, 21, 3, 1, 7, 12, 21, 13, 16, 19, 21, 32, 62, 7, 43, 1, 12, 1, 1, 10, 1, 1, 12, 1, 2, 10, 2, 6, 12, 6, 1, 10, 1, 1, 12, 1, 1, 7, 8, 17, 13, 64, 81, 7, 29, 5, 12, 3, 2, 10, 2, 4, 12, 4, 1, 10, 1, 5, 12, 9, 14, 13, 10, 2, 15, 2, 3, 21, 3, 1, 26, 193, 236, 7, 44, 3, 10, 3, 9, 12, 9, 1, 10, 1, 2, 12, 2, 1, 21, 101, 132, 9, 32, 32, 5, 32, 10, 13, 10, 9, 15, 21, 20, 7, 10, 3, 7, 3, 10, 7, 9, 3, 7, 3, 25, 7, 24, 6, 10, 7, 3, 10, 4, 4, 12, 2, 1, 10, 1, 1, 12, 1, 1, 7, 1, 1, 10, 1, 1, 7, 1, 1, 10, 1, 1, 12, 1, 3, 21, 12, 19, 13, 80, 78, 7, 10, 41, 7, 39, 3, 10, 3, 4, 12, 6, 4, 12, 2, 4, 10, 4, 1, 12, 1, 1, 7, 1, 1, 21, 1, 1, 7, 1, 1, 10, 28, 28, 7, 1, 10, 12, 10, 40, 7, 40, 6, 12, 6, 1, 10, 1, 1, 7, 1, 4, 12, 4, 8, 21, 8, 1, 12, 9, 9, 7, 1, 6, 12, 6, 2, 10, 2, 3, 12, 3, 46, 7, 46, 13, 12, 13, 1, 10, 1, 2, 12, 2, 3, 21, 3, 1, 7, 1, 5, 21, 34, 86, 7, 320, 272, 7, 10, 38, 7, 37, 1, 10, 1, 7, 12, 8, 7, 12, 6, 1, 10, 1, 1, 12, 1, 1, 7, 1, 5, 21, 15, 20, 13, 10, 19, 15, 22, 5, 21, 2, 30, 7, 32, 24, 12, 23, 2, 10, 1, 7, 12, 7, 1, 10, 1, 2, 12, 2, 1, 10, 1, 2, 12, 75, 80, 7, 8, 3, 7, 3, 39, 7, 38, 6, 12, 9, 4, 12, 2, 3, 12, 3, 8, 12, 7, 1, 7, 1, 1, 12, 9, 18, 13, 16, 12, 7, 7, 3, 7, 3, 33, 7, 32, 5, 10, 6, 3, 12, 3, 3, 10, 2, 1, 12, 1, 1, 10, 1, 1, 12, 1, 1, 7, 8, 17, 13, 320, 329, 7, 19, 2, 12, 2, 2, 10, 2, 2, 21, 185, 184, 7, 16, 36, 15, 21, 8, 26, 8, 4, 23, 4, 17, 26, 30, 14, 21, 1, 922, 7, 1024, 213, 14, 112, 6, 21, 16, 207, 7, 2944, 3819, 7, 1072, 10, 2, 4048, 4622, 7, 9216, 9202, 7, 576, 38, 7, 32, 11, 13, 14, 6, 21, 98, 126, 7, 32, 7, 12, 5, 1, 21, 11, 58, 7, 48, 7, 12, 7, 5, 21, 5, 4, 26, 4, 4, 6, 4, 1, 21, 1, 1, 26, 11, 20, 13, 11, 8, 15, 8, 22, 7, 26, 24, 7, 707, 720, 9, 32, 32, 5, 32, 23, 15, 23, 4, 21, 105, 176, 7, 79, 5, 12, 1, 1, 7, 1, 55, 10, 62, 11, 12, 4, 13, 6, 77, 66, 6, 2, 1, 21, 1, 1, 6, 1, 1, 12, 12, 13, 10, 16, 6150, 7, 6144, 1246, 7, 1280, 51, 7, 8960, 9238, 7, 336, 52, 7, 20, 21, 7, 12, 404, 7, 2704, 2415, 7, 112, 18, 7, 16, 12, 7, 16, 17, 7, 12, 3, 26, 1, 2, 12, 2, 1, 21, 1, 4, 2, 4960, 5202, 26, 256, 49, 26, 41, 62, 26, 60, 2, 10, 2, 3, 12, 3, 3, 26, 3, 6, 10, 6, 8, 2, 8, 8, 12, 8, 2, 26, 2, 7, 12, 7, 30, 26, 30, 4, 12, 4, 59, 26, 82, 89, 26, 66, 3, 12, 3, 1, 26, 155, 174, 15, 32, 99, 26, 96, 34, 15, 160, 161, 9, 26, 26, 5, 26, 26, 9, 26, 7, 5, 8, 19, 5, 18, 26, 9, 26, 26, 5, 26, 1, 9, 2, 3, 9, 4, 3, 9, 3, 4, 9, 4, 6, 9, 5, 9, 9, 8, 4, 5, 5, 2, 5, 2, 8, 5, 8, 12, 5, 11, 26, 9, 26, 26, 5, 26, 2, 9, 3, 5, 9, 6, 10, 9, 9, 8, 9, 8, 27, 5, 26, 2, 9, 3, 5, 9, 5, 6, 9, 6, 2, 9, 4, 10, 9, 8, 27, 5, 26, 26, 9, 26, 26, 5, 26, 26, 9, 26, 26, 5, 26, 26, 9, 26, 26, 5, 26, 26, 9, 26, 26, 5, 26, 26, 9, 26, 26, 5, 26, 26, 9, 26, 28, 5, 30, 27, 9, 25, 1, 25, 1, 25, 5, 25, 1, 25, 1, 6, 5, 6, 25, 9, 25, 1, 25, 1, 25, 5, 25, 1, 25, 1, 6, 5, 6, 25, 9, 25, 1, 25, 1, 25, 5, 25, 1, 25, 1, 6, 5, 6, 25, 9, 25, 1, 25, 1, 25, 5, 25, 1, 25, 1, 6, 5, 6, 25, 9, 25, 1, 25, 1, 25, 5, 25, 1, 25, 1, 6, 5, 6, 1, 9, 1, 1, 5, 3, 52, 13, 50, 512, 26, 512, 55, 12, 55, 4, 26, 4, 50, 12, 50, 8, 26, 8, 1, 12, 1, 14, 26, 14, 1, 12, 1, 2, 26, 2, 5, 21, 20, 20, 12, 6, 16, 12, 1375, 1367, 12, 8, 18, 12, 19, 9, 12, 8, 3, 12, 3, 6, 12, 218, 258, 7, 48, 10, 12, 7, 7, 6, 9, 12, 13, 14, 5, 7, 1, 1, 26, 369, 412, 7, 44, 4, 12, 4, 10, 13, 15, 6, 23, 1281, 1477, 7, 199, 11, 15, 9, 7, 12, 48, 75, 9, 34, 34, 5, 34, 7, 12, 7, 1, 6, 5, 14, 13, 14, 6, 21, 787, 844, 15, 59, 1, 26, 1, 3, 15, 3, 1, 23, 1, 4, 15, 80, 121, 15, 45, 1, 26, 1, 15, 15, 209, 198, 7, 5, 28, 7, 28, 3, 7, 3, 2, 7, 3, 3, 7, 2, 11, 7, 11, 5, 7, 5, 2, 7, 2, 2, 7, 7, 7, 7, 5, 5, 7, 2, 2, 7, 2, 2, 7, 2, 4, 7, 4, 3, 7, 3, 2, 7, 3, 3, 7, 2, 2, 7, 2, 2, 7, 2, 2, 7, 2, 2, 7, 2, 3, 7, 3, 2, 7, 3, 6, 7, 5, 8, 7, 8, 5, 7, 5, 5, 7, 5, 2, 7, 2, 11, 7, 11, 18, 7, 22, 8, 7, 4, 6, 7, 6, 18, 7, 69, 54, 25, 272, 314, 26, 48, 104, 26, 112, 27, 26, 17, 17, 26, 16, 16, 26, 16, 38, 26, 47, 23, 15, 13, 161, 26, 217, 85, 26, 42, 57, 26, 48, 13, 26, 16, 9, 26, 16, 20, 26, 160, 405, 26, 251, 5, 24, 5, 728, 26, 736, 21, 26, 16, 16, 26, 16, 119, 26, 128, 101, 26, 96, 19, 26, 32, 32, 26, 16, 60, 26, 64, 18, 26, 16, 46, 26, 48, 38, 26, 32, 4, 26, 80, 199, 26, 122, 83, 26, 83, 136, 26, 147, 26, 26, 16, 7, 26, 8, 6, 26, 8, 12, 26, 16, 34, 26, 32, 14, 26, 16, 12, 26, 16, 20, 26, 48, 188, 26, 148, 56, 26, 92, 47, 13, 1040, 43748, 7, 42752, 4183, 7, 4160, 233, 7, 224, 5764, 7, 5776, 7487, 7, 10576, 3645, 7, 2048, 6445, 7, 720897, 715959, 2, 31, 126, 2, 224, 368, 12, 65280, 130574, 3, 65536, 65536, 3]);

final SparseBoolList notAssignedCharacters = _generateCategory(0);

final SparseBoolList controlCharacters = _generateCategory(1);

final SparseBoolList formatCharacters = _generateCategory(2);

final SparseBoolList privateUseCharacters = _generateCategory(3);

final SparseBoolList surrogateCharacters = _generateCategory(4);

final SparseBoolList lowercaseLetterCharacters = _generateCategory(5);

final SparseBoolList modifierLetterCharacters = _generateCategory(6);

final SparseBoolList otherLetterCharacters = _generateCategory(7);

final SparseBoolList titlecaseLetterCharacters = _generateCategory(8);

final SparseBoolList uppercaseLetterCharacters = _generateCategory(9);

final SparseBoolList spacingMarkCharacters = _generateCategory(10);

final SparseBoolList encosingMarkCharacters = _generateCategory(11);

final SparseBoolList nonspacingMarkCharacters = _generateCategory(12);

final SparseBoolList decimalNumberCharacters = _generateCategory(13);

final SparseBoolList letterNumberCharacters = _generateCategory(14);

final SparseBoolList otherNumberCharacters = _generateCategory(15);

final SparseBoolList connectorPunctuationCharacters = _generateCategory(16);

final SparseBoolList dashPunctuationCharacters = _generateCategory(17);

final SparseBoolList closePunctuationCharacters = _generateCategory(18);

final SparseBoolList finalPunctuationCharacters = _generateCategory(19);

final SparseBoolList initialPunctuationCharacters = _generateCategory(20);

final SparseBoolList otherPunctuationCharacters = _generateCategory(21);

final SparseBoolList openPunctuationCharacters = _generateCategory(22);

final SparseBoolList currencySymbolCharacters = _generateCategory(23);

final SparseBoolList modifierSymbolCharacters = _generateCategory(24);

final SparseBoolList mathSymbolCharacters = _generateCategory(25);

final SparseBoolList otherSymbolCharacters = _generateCategory(26);

final SparseBoolList lineSeparatorCharacters = _generateCategory(27);

final SparseBoolList paragraphSeparatorCharacters = _generateCategory(28);

final SparseBoolList spaceSeparatorCharacters = _generateCategory(29);

final Map<int, int> simpleLowercaseMapping = _generateIntMapping([65, 97, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 102, 102, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 34, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -198, 2, 202, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -120, 1, 123, 2, 2, 2, 2, 4, 213, 1, -208, 2, 2, 2, 207, 1, -204, 2, 206, 1, 1, 1, -203, 3, 81, 1, 124, 1, 2, 1, -201, 2, 206, 1, 3, 2, 6, 1, -1, 1, -207, 4, 214, 1, 3, 2, 3, 1, -212, 2, 2, 2, 2, 2, 219, 1, -216, 2, 219, 3, -214, 2, 219, 1, -216, 2, 218, 1, 1, 1, -215, 2, 2, 2, 220, 1, -217, 4, 4, 8, 9, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 1, 0, 2, 2, 2, -96, 1, 42, 1, 58, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -129, 2, 133, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 10802, 1, -10793, 2, -162, 1, 10956, 3, -10788, 2, -194, 1, 265, 1, 3, 1, -69, 2, 2, 2, 2, 2, 2, 2, 2, 290, 290, 2, 2, 4, 4, 9, 124, 7, -71, 2, 1, 1, 1, 1, 1, 2, 29, 2, 1, 1, 1, 2, -29, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 36, 12, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, -55, 3, 64, 2, -6, 1, 9, 3, -128, 1, 1, 1, 1, 1, 211, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -47, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 49, 18, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 10, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 16, 1, -13, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 50, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2890, 10106, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 6, 6, 723, 32323, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -38855, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2203, -813, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 321, 3330, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, -7606, 2, 7618, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 11, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12, 12, 2, 2, 2, 2, 2, 2, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 25, 25, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, -65, 1, 1, 1, 66, 12, -65, 1, 1, 1, 1, 1, 1, 1, 78, 12, 13, 1, 1, 1, -91, 1, 1, 13, 105, 1, 1, 1, -103, 1, 1, 1, 106, 12, -109, 1, 1, 1, 3, 1, 1, 1, 118, 298, -7210, 4, -862, 1, 122, 7, 8297, 46, 34, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 5, 819, 844, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1841, 1863, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 50, 3, 2, -10742, 1, 6930, 1, -6912, 3, 10731, 2, 2, 2, 2, 2, -10779, 1, 32, 1, -33, 1, 2, 2, 10785, 3, 3, 9, -10807, 1, 1, 1, 10817, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 9, 9, 2, 2, 5, 5, 31054, 31054, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 20, 20, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 136, 136, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 11, 11, 2, 2, 2, -35331, 1, 35334, 2, 2, 2, 2, 2, 2, 2, 2, 5, 5, 2, -42279, 3, 42284, 2, 2, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -42307, 1, -10, 1, 5, 1, 11, 1, -2, 2, 52, 1, -23, 1, 22, 1, 43190, 1, -926, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 2, -47, 1, -42258, 1, 6924, 1, 35386, 2, 2, 44, 44, 22316, 22347, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1222, 1230, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 137, 137, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1965, 1989, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3054, 3022, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 21889, 21889, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 31393, 31395, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]);

final Map<int, int> simpleTitlecaseMapping = _generateIntMapping([97, 65, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 59, 834, 43, -732, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 154, 2, -120, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -229, 2, 233, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 1, -298, 1, 496, 3, -193, 2, 2, 3, 3, 4, 4, 6, 6, 3, 101, 4, -94, 1, 165, 4, -29, 3, -128, 2, 2, 2, 2, 3, 3, 5, 5, 3, 3, 4, 4, 2, 2, 3, 3, 4, 4, 2, 59, 5, -50, 1, 0, 1, 0, 1, 3, 1, 0, 1, 0, 1, 3, 1, 0, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, -77, 2, 80, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 1, 0, 1, 0, 2, 2, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 9, 9, 3, 10819, 1, 1, 2, -10814, 5, 5, 2, 2, 2, 2, 2, 2, 2, 2, 1, 10785, 1, -2, 1, 3, 1, -10991, 1, 5, 2, 3, 1, 1, 2, 5, 2, 1, 1, 42523, 4, -42520, 1, 42521, 2, -42520, 2, 42489, 1, 29, 2, -42515, 1, -1, 1, 42520, 1, -31564, 1, 31563, 3, -42513, 2, 10962, 1, -10961, 3, 2, 8, 10949, 3, -10942, 2, 42527, 1, -42524, 4, 42504, 1, -42499, 1, 150, 1, -147, 1, 1, 1, 147, 6, -142, 11, 42491, 1, -2, 167, -42007, 44, -41, 2, 2, 4, 4, 4, 135, 1, 1, 1, 1, 47, -121, 1, 2, 1, 1, 1, 1, 2, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -31, 1, 2, 1, 1, 2, 3, 1, 6, 4, 14, 1, -6, 1, 47, 2, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, -84, 1, 7, 1, 88, 1, -122, 2, 22, 3, 98, 3, 3, 53, 22, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -47, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 81, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 10, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, -13, 2, 16, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 50, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2890, 2938, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 761, 753, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2179, -4067, 1, 2, 1, 10, 1, 3, 1, 1, 1, 0, 1, 8, 1, 56, 1, 41448, 241, 307, 4, -31514, 17, 31587, 115, -35270, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, -52, 6, 64, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 11, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12, 12, 2, 2, 2, 2, 2, 2, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 75, 1, 1, 1, 13, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 29, 1, 1, 1, -15, 1, 1, 1, 15, 1, 1, 3, -115, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 2, 3, 11, -7203, 5, 7219, 13, 12, 1, 1, 15, 15, 1, 1, 4, 3, 14, 16, 347, 310, 34, 46, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 20, 844, 819, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1863, 1841, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 50, 4, -10790, 1, 4, 2, 10793, 2, 2, 2, 2, 7, 7, 3, 3, 11, 11, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 9, 9, 2, 2, 5, 5, 13, -7250, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 6, 6, 30996, 38259, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 20, 20, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 136, 136, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 11, 11, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 5, 5, 5, 5, 2, 2, 1, 50, 3, -46, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 12, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 5, 5, 2, 2, 44, 44, 861, -66, 29, -37907, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 21378, 60210, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1230, 1222, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 137, 137, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1989, 1965, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3022, 3054, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 21889, 21889, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 31395, 31393, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]);

final Map<int, int> simpleUppercaseMapping = _generateIntMapping([97, 65, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 59, 834, 43, -732, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 154, 2, -120, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, -229, 2, 233, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 1, -298, 1, 496, 3, -193, 2, 2, 3, 3, 4, 4, 6, 6, 3, 101, 4, -94, 1, 165, 4, -29, 3, -128, 2, 2, 2, 2, 3, 3, 5, 5, 3, 3, 4, 4, 2, 2, 3, 3, 4, 4, 2, 59, 6, -51, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, -77, 2, 80, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 1, 0, 2, 3, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 9, 9, 3, 10819, 1, 1, 2, -10814, 5, 5, 2, 2, 2, 2, 2, 2, 2, 2, 1, 10785, 1, -2, 1, 3, 1, -10991, 1, 5, 2, 3, 1, 1, 2, 5, 2, 1, 1, 42523, 4, -42520, 1, 42521, 2, -42520, 2, 42489, 1, 29, 2, -42515, 1, -1, 1, 42520, 1, -31564, 1, 31563, 3, -42513, 2, 10962, 1, -10961, 3, 2, 8, 10949, 3, -10942, 2, 42527, 1, -42524, 4, 42504, 1, -42499, 1, 150, 1, -147, 1, 1, 1, 147, 6, -142, 11, 42491, 1, -2, 167, -42007, 44, -41, 2, 2, 4, 4, 4, 135, 1, 1, 1, 1, 47, -121, 1, 2, 1, 1, 1, 1, 2, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -31, 1, 2, 1, 1, 2, 3, 1, 6, 4, 14, 1, -6, 1, 47, 2, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, -84, 1, 7, 1, 88, 1, -122, 2, 22, 3, 98, 3, 3, 53, 22, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -47, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 81, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 10, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, -13, 2, 16, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 50, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2890, 5946, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 761, -2255, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2179, -4067, 1, 2, 1, 10, 1, 3, 1, 1, 1, 0, 1, 8, 1, 56, 1, 41448, 241, 307, 4, -31514, 17, 31587, 115, -35270, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 6, -52, 6, 64, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 11, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12, 12, 2, 2, 2, 2, 2, 2, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 75, 1, 1, 1, 13, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 29, 1, 1, 1, -15, 1, 1, 1, 15, 1, 1, 3, -115, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 2, 3, 11, -7203, 5, 7219, 13, 12, 1, 1, 15, 15, 1, 1, 4, 3, 14, 16, 347, 310, 34, 46, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 20, 844, 819, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1863, 1841, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 50, 4, -10790, 1, 4, 2, 10793, 2, 2, 2, 2, 7, 7, 3, 3, 11, 11, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 9, 9, 2, 2, 5, 5, 13, -7250, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 6, 6, 30996, 38259, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 20, 20, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 136, 136, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 11, 11, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 5, 5, 5, 5, 2, 2, 1, 50, 3, -46, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 12, 12, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 5, 5, 2, 2, 44, 44, 861, -66, 29, -37907, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 21378, 60210, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1230, 1222, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 137, 137, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1989, 1965, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3022, 3054, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 21889, 21889, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 31395, 31393, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]);

bool isNotAssigned(int character) => notAssignedCharacters[character];

bool isControl(int character) => controlCharacters[character];

bool isFormat(int character) => formatCharacters[character];

bool isPrivateUse(int character) => privateUseCharacters[character];

bool isSurrogate(int character) => surrogateCharacters[character];

bool isLowercaseLetter(int character) => lowercaseLetterCharacters[character];

bool isModifierLetter(int character) => modifierLetterCharacters[character];

bool isOtherLetter(int character) => otherLetterCharacters[character];

bool isTitlecaseLetter(int character) => titlecaseLetterCharacters[character];

bool isUppercaseLetter(int character) => uppercaseLetterCharacters[character];

bool isSpacingMark(int character) => spacingMarkCharacters[character];

bool isEncosingMark(int character) => encosingMarkCharacters[character];

bool isNonspacingMark(int character) => nonspacingMarkCharacters[character];

bool isDecimalNumber(int character) => decimalNumberCharacters[character];

bool isLetterNumber(int character) => letterNumberCharacters[character];

bool isOtherNumber(int character) => otherNumberCharacters[character];

bool isConnectorPunctuation(int character) => connectorPunctuationCharacters[character];

bool isDashPunctuation(int character) => dashPunctuationCharacters[character];

bool isClosePunctuation(int character) => closePunctuationCharacters[character];

bool isFinalPunctuation(int character) => finalPunctuationCharacters[character];

bool isInitialPunctuation(int character) => initialPunctuationCharacters[character];

bool isOtherPunctuation(int character) => otherPunctuationCharacters[character];

bool isOpenPunctuation(int character) => openPunctuationCharacters[character];

bool isCurrencySymbol(int character) => currencySymbolCharacters[character];

bool isModifierSymbol(int character) => modifierSymbolCharacters[character];

bool isMathSymbol(int character) => mathSymbolCharacters[character];

bool isOtherSymbol(int character) => otherSymbolCharacters[character];

bool isLineSeparator(int character) => lineSeparatorCharacters[character];

bool isParagraphSeparator(int character) => paragraphSeparatorCharacters[character];

bool isSpaceSeparator(int character) => spaceSeparatorCharacters[character];

String toLowercase(String string) => _toCase(string, simpleLowercaseMapping);

String toTitlecase(String string) => _toCase(string, simpleTitlecaseMapping);

String toUppercase(String string) => _toCase(string, simpleUppercaseMapping);

int toRune(String string) {
  if (string == null) {
    throw ArgumentError('string: $string');
  }

  final length = string.length;
  if (length == 0) {
    throw StateError('An empty string contains no elements.');
  }

  final start = string.codeUnitAt(0);
  if (length == 1) {
    return start;
  }

  if ((start & 0xFC00) == 0xD800) {
    final end = string.codeUnitAt(1);
    if ((end & 0xFC00) == 0xDC00) {
      return (0x10000 + ((start & 0x3FF) << 10) + (end & 0x3FF));
    }
  }

  return start;
}

List<int> toRunes(String string) {
  if (string == null) {
    throw ArgumentError('string: $string');
  }

  final length = string.length;
  if (length == 0) {
    return const <int>[];
  }

  final runes = List.filled(length, 0);
  var i = 0;
  var pos = 0;
  for ( ; i < length; pos++) {
    final start = string.codeUnitAt(i);
    i++;
    if ((start & 0xFC00) == 0xD800 && i < length) {
      final end = string.codeUnitAt(i);
      if ((end & 0xFC00) == 0xDC00) {
        runes[pos] = (0x10000 + ((start & 0x3FF) << 10) + (end & 0x3FF));
        i++;
      } else {
        runes[pos] = start;
      }
    } else {
      runes[pos] = start;
    }
  }

  return runes.sublist(0, pos);  
}

SparseBoolList _generateBoolGroup(List<int> data) {
  final list = SparseBoolList();
  list.length = 1114112;
  final length = data.length;
  for (var i = 0; i < length; i += 2) {
    final start = data[i + 0];
    final end = data[i + 1];
    list.addGroup(GroupedRangeList<bool>(start, end, true));
  }

  list.freeze();
  return list;
}

SparseBoolList _generateCategory(int category) {
  final list = SparseBoolList();
  list.length = 1114112;
  for (var group in generalCategories.groups) {
    if (group.key == category) {
      list.addGroup(GroupedRangeList<bool>(group.start, group.end, true));
    }
  }

  list.freeze();
  return list;
}

SparseList<int> _generateIntGroup(List<int> data) {  
  var list = SparseList<int>(defaultValue: 0);
  list.length = 1114112;
  final length = data.length;
  var start = 0;
  var end = 0;
  for (var i = 0; i < length; i+= 3) {
    start += data[i + 0];
    end += data[i + 1];
    final key = data[i + 2];
    list.addGroup(GroupedRangeList<int>(start, end, key));
  }

  list.freeze();
  return list;
}

Map<int, int> _generateIntMapping(List<int> data) {  
  final map = HashMap<int, int>();
  final length = data.length;
  var key = 0;
  var value = 0;
  for (var i = 0; i < length; i+= 2) {
    key += data[i + 0];
    value += data[i + 1];
    map[key] = value;
  }

  return UnmodifiableMapView<int, int>(map);
}

String _toCase(String string, Map<int, int> mapping) {
  final runes = toRunes(string);
  final length = runes.length;
  for (var i = 0; i < length; i++) {
    var character = mapping[runes[i]];
    if (character != null) {
      runes[i] = character;
    }
  }
  return String.fromCharCodes(runes);
}

