import 'package:intl/date_symbols.dart' as intl;

class IntlEnShaw {
  static final dateSymbols = intl.DateSymbols(
    NAME: 'en_Shaw',
    ERAS: const <String>[
      'BC',
      'AD',
    ],
    ERANAMES: const <String>[
      'Before Christ',
      'Anno Domini',
    ],
    NARROWMONTHS: const <String>[
      '𐑡',
      '𐑓',
      '𐑥',
      '𐑱',
      '𐑥',
      '𐑡',
      '𐑡',
      '𐑷',
      '𐑕',
      '𐑪',
      '𐑯',
      '𐑛',
    ],
    STANDALONENARROWMONTHS: const <String>[
      '𐑡',
      '𐑓',
      '𐑥',
      '𐑱',
      '𐑥',
      '𐑡',
      '𐑡',
      '𐑷',
      '𐑕',
      '𐑪',
      '𐑯',
      '𐑛',
    ],
    MONTHS: const <String>[
      '𐑡𐑨𐑯𐑘𐑫𐑼𐑦',
      '𐑓𐑧𐑚𐑮𐑫𐑼𐑦',
      '𐑥𐑸𐑗',
      '𐑱𐑐𐑮𐑦𐑤',
      '𐑥𐑱',
      '𐑡𐑵𐑯',
      '𐑡𐑫𐑤𐑲',
      '𐑷𐑜𐑩𐑕𐑑',
      '𐑕𐑧𐑐𐑑𐑧𐑥𐑚𐑼',
      '𐑪𐑒𐑑𐑴𐑚𐑼',
      '𐑯𐑴𐑝𐑧𐑥𐑚𐑼',
      '𐑛𐑦𐑕𐑧𐑥𐑚𐑼',
    ],
    STANDALONEMONTHS: const <String>[
      '𐑡𐑨𐑯𐑘𐑫𐑼𐑦',
      '𐑓𐑧𐑚𐑮𐑫𐑼𐑦',
      '𐑥𐑸𐑗',
      '𐑱𐑐𐑮𐑦𐑤',
      '𐑥𐑱',
      '𐑡𐑵𐑯',
      '𐑡𐑫𐑤𐑲',
      '𐑷𐑜𐑩𐑕𐑑',
      '𐑕𐑧𐑐𐑑𐑧𐑥𐑚𐑼',
      '𐑪𐑒𐑑𐑴𐑚𐑼',
      '𐑯𐑴𐑝𐑧𐑥𐑚𐑼',
      '𐑛𐑦𐑕𐑧𐑥𐑚𐑼',
    ],
    SHORTMONTHS: const <String>[
      '𐑡𐑨𐑯',
      '𐑓𐑧𐑚',
      '𐑥𐑸𐑗',
      '𐑱𐑐𐑮',
      '𐑥𐑱',
      '𐑡𐑵𐑯',
      '𐑡𐑫𐑤',
      '𐑷𐑜',
      '𐑕𐑧𐑐',
      '𐑪𐑒𐑑',
      '𐑯𐑴𐑝',
      '𐑛𐑦𐑕',
    ],
    STANDALONESHORTMONTHS: const <String>[
      '𐑡𐑨𐑯',
      '𐑓𐑧𐑚',
      '𐑥𐑸𐑗',
      '𐑱𐑐𐑮',
      '𐑥𐑱',
      '𐑡𐑵𐑯',
      '𐑡𐑫𐑤',
      '𐑷𐑜',
      '𐑕𐑧𐑐',
      '𐑪𐑒𐑑',
      '𐑯𐑴𐑝',
      '𐑛𐑦𐑕',
    ],
    WEEKDAYS: const <String>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    STANDALONEWEEKDAYS: const <String>[
      'Sunday',
      'Monday',
      'Tuesday',
      'Wednesday',
      'Thursday',
      'Friday',
      'Saturday',
    ],
    SHORTWEEKDAYS: const <String>[
      '𐑕𐑳𐑯',
      '𐑥𐑳𐑯',
      '𐑑𐑿𐑟',
      '𐑢𐑧𐑯𐑟',
      '𐑔𐑻𐑟',
      '𐑓𐑮𐑲',
      '𐑕𐑨𐑑',
    ],
    STANDALONESHORTWEEKDAYS: const <String>[
      '𐑕𐑳𐑯',
      '𐑥𐑳𐑯',
      '𐑑𐑿𐑟',
      '𐑢𐑧𐑯𐑟',
      '𐑔𐑻𐑟',
      '𐑓𐑮𐑲',
      '𐑕𐑨𐑑',
    ],
    NARROWWEEKDAYS: const <String>[
      '𐑕',
      '𐑥',
      '𐑑',
      '𐑢',
      '𐑔',
      '𐑓',
      '𐑕',
    ],
    STANDALONENARROWWEEKDAYS: const <String>[
      '𐑕',
      '𐑥',
      '𐑑',
      '𐑢',
      '𐑔',
      '𐑓',
      '𐑕',
    ],
    SHORTQUARTERS: const <String>[
      'Q1',
      'Q2',
      'Q3',
      'Q4',
    ],
    QUARTERS: const <String>[
      '1st quarter',
      '2nd quarter',
      '3rd quarter',
      '4th quarter',
    ],
    AMPMS: const <String>[
      'AM',
      'PM',
    ],
    DATEFORMATS: const <String>[
      'EEEE, MMMM d, y',
      'MMMM d, y',
      'MMM d, y',
      'M/d/yy',
    ],
    TIMEFORMATS: const <String>[
      'h:mm:ss a zzzz',
      'h:mm:ss a z',
      'h:mm:ss a',
      'h:mm a',
    ],
    FIRSTDAYOFWEEK: 6,
    WEEKENDRANGE: const <int>[
      5,
      6,
    ],
    FIRSTWEEKCUTOFFDAY: 5,
    DATETIMEFORMATS: const <String>[
      "{1} 'at' {0}",
      "{1} 'at' {0}",
      '{1}, {0}',
      '{1}, {0}',
    ],
  );

  // from `flutter_localizations` / generated_date_localizations.dart / `datePatterns[en]`
  static const datePatterns = {
    'd': 'd',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L',
    'Md': 'M/d',
    'MEd': 'EEE, M/d',
    'MMM': 'LLL',
    'MMMd': 'MMM d',
    'MMMEd': 'EEE, MMM d',
    'MMMM': 'LLLL',
    'MMMMd': 'MMMM d',
    'MMMMEEEEd': 'EEEE, MMMM d',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M/y',
    'yMd': 'M/d/y',
    'yMEd': 'EEE, M/d/y',
    'yMMM': 'MMM y',
    'yMMMd': 'MMM d, y',
    'yMMMEd': 'EEE, MMM d, y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'MMMM d, y',
    'yMMMMEEEEd': 'EEEE, MMMM d, y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'h a',
    'jm': 'h:mm a',
    'jms': 'h:mm:ss a',
    'jmv': 'h:mm a v',
    'jmz': 'h:mm a z',
    'jz': 'h a z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  };
}
