# How to Play Roboyard

Roboyard is an engaging puzzle game where you guide robots through a grid to reach their targets. Master the mechanics, solve puzzles efficiently, and earn stars to progress through increasingly challenging levels.

## Game Mechanics

### Basic Controls
- Tap on a robot to select it
- Swipe in any direction to move the selected robot
- Robots will continue moving until they hit a wall or another robot
- Plan your moves carefully to reach the target positions

### Random Games
- Random games are generated based on the difficulty level in your Settings
- Practice with randomly generated puzzles to sharpen your problem-solving skills

## Map Generation

The game generates maps differently depending on the difficulty setting:

- **Beginner Difficulty**:
  - minimum number of moves for the optimal solution: 6
  - A new random map is generated each time you start a game
    - This allows for more variety and practice with different configurations
  - All walls must be placed at the outer rim or placed as a corner
  - A multicoloured goal is added, where you are free to choose, which robot to lead to

- **Advanced Difficulty**:
  - minimum number of moves: 8
  - no multicoloured goals allowed any more
  - A new random map is generated each time you start a game
  - There are more walls in the map and not all walls must be placed as a corner

- **Insane Difficulty**:
  - minimum number of moves: 10
  - The same map persists across restarts
       (This allows you to continue working on solving the same puzzle)
  - The goals must not always be placed in a wall-corner any more

- **Impossible Difficulty**:
  - minimum number of moves: 17

### Level Structure
- The game is divided into multiple difficulty sections:
  - Beginner (Levels 1-35)
  - Intermediate (Levels 36-70) - You need at least 35 stars in Beginner section
  - Advanced (Levels 71-105)
  - Expert (Levels 106-140)

## Star System

### Earning Stars
You can earn up to 3 stars per level based on your performance:
1. ⭐ Complete the level (any number of moves)
2. ⭐ Complete the level within optimal moves + 1
3. ⭐ Complete the level in optimal moves

### Level Progression
- Complete levels to unlock more challenging levels
- You need at least 35 stars to unlock the Intermediate section
- Keep practicing to improve your solutions and earn more stars
- Try to find the most efficient solution for each puzzle

## Tips for Success
1. **Plan Ahead**: Look at the entire board before making your first move
2. **Use Walls**: Walls and obstacles can help you position robots precisely
3. **Minimize Moves**: Try to reach the target in as few moves as possible
4. **Practice**: If you don't get all stars on your first try, you can always replay levels
5. **Watch for Patterns**: Similar puzzle layouts might require similar solving strategies

## Getting Help
- The game will show hints if you're stuck
- For simpler puzzles (less than 8 moves), special hints are available from the start
- Keep trying different approaches - there's often more than one way to solve a puzzle!

1. For random games:
  ◦ Show numPreHints (2-4) hints saying "The AI found a solution in less than [solution+numPreHints] moves" and decreasing
  ◦ Show a final exact hint "The AI found a solution in X moves" with toast notification
  ◦ Then show all actual move hints numbered "1/X", "2/X", etc.
  ◦ In the example: if solution is 7 moves and numPreHints is 4, they should see:
      ▪ "The AI found a solution in less than 11 moves" (7+4)
      ▪ "The AI found a solution in less than 10 moves" (7+3)
      ▪ "The AI found a solution in less than 9 moves" (7+2)
      ▪ "The AI found a solution in less than 8 moves" (7+1)
      ▪ "The AI found a solution in 7 moves" (with toast)
      ▪ Then all 7 move hints
      ▪ Then "All hints are shown"
        
2. For level games 1 - 10:
  ◦ Always show the first 2 normal hints (no pre-hints)
  ◦ Then diable the hint button
    
3. For level games > 10:
  ◦ No pre-hints
  ◦ No normal hints
  ◦ diable the hint button
    
4. After resetting hint count (after seeing all hints):
  ◦ Only show normal hints, no pre-hints in a random game
  ◦ in level games nothing more
