/*
 *
 * Copyright (C) 2014 Tobias Schoene www.yaacc.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.yaacc.upnp.server.contentdirectory;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.provider.MediaStore;
import android.util.Log;

import org.fourthline.cling.support.model.DIDLObject;
import org.fourthline.cling.support.model.SortCriterion;
import org.fourthline.cling.support.model.container.Container;
import org.fourthline.cling.support.model.container.MusicAlbum;
import org.fourthline.cling.support.model.container.StorageFolder;
import org.fourthline.cling.support.model.item.Item;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.yaacc.R;
import de.yaacc.upnp.server.YaaccUpnpServerService;

/**
 * Browser  for the music albums folder.
 *
 * @author openbit (Tobias Schoene)
 */
public class MusicAlbumsFolderBrowser extends ContentBrowser {
    public MusicAlbumsFolderBrowser(Context context) {
        super(context);
    }

    @Override
    public DIDLObject browseMeta(YaaccContentDirectory contentDirectory, String myId, long firstResult, long maxResults, SortCriterion[] orderby) {

        return new StorageFolder(ContentDirectoryIDs.MUSIC_ALBUMS_FOLDER.getId(), ContentDirectoryIDs.MUSIC_FOLDER.getId(), getContext().getString(R.string.albums), "yaacc", getSize(contentDirectory, myId),
                null);
    }

    @SuppressLint("Range")
    @Override
    public Integer getSize(YaaccContentDirectory contentDirectory, String myId) {

        String[] projection = {MediaStore.Audio.Albums._ID};
        String selection = "";
        String[] selectionArgs = null;
        int result = 0;
        try (Cursor mediaCursor = contentDirectory.getContext().getContentResolver().query(MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI, projection, selection,
                selectionArgs, null)) {
            if (mediaCursor != null && mediaCursor.getCount() > 0 && mediaCursor.moveToFirst()) {
                while (!mediaCursor.isAfterLast()) {
                    if (getMusicTrackSize(contentDirectory, mediaCursor.getString(mediaCursor.getColumnIndex(MediaStore.Audio.Albums._ID))) > 0) {
                        result++;
                    }
                    mediaCursor.moveToNext();
                }
            }
        }
        return result;
    }


    private Integer getMusicTrackSize(YaaccContentDirectory contentDirectory, String parentId) {

        String[] projection = {MediaStore.Audio.Media._ID};
        String selection = MediaStore.Audio.Media.ALBUM_ID + "=? " + "and (" + makeLikeClause(MediaStore.Audio.Media.DATA, getMediaPathes().size()) + ")";
        List<String> selectionArgsList = new ArrayList<>();
        selectionArgsList.add(parentId);
        selectionArgsList.addAll(getMediaPathesForLikeClause());
        String[] selectionArgs = selectionArgsList.toArray(new String[0]);
        try (Cursor cursor = contentDirectory.getContext().getContentResolver().query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, projection, selection,
                selectionArgs, null)) {
            return cursor.getCount();
        }

    }

    @Override
    public List<Container> browseContainer(YaaccContentDirectory contentDirectory, String myId, long firstResult, long maxResults, SortCriterion[] orderby) {
        List<Container> result = new ArrayList<>();
        String[] projection = {MediaStore.Audio.Albums._ID, MediaStore.Audio.Albums.ALBUM};
        String selection = "";
        String[] selectionArgs = null;
        Map<String, MusicAlbum> folderMap = new HashMap<>();
        try (Cursor mediaCursor = contentDirectory.getContext().getContentResolver().query(MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI, projection, selection,
                selectionArgs, MediaStore.Audio.Albums.ALBUM + " ASC")) {

            if (mediaCursor != null && mediaCursor.getCount() > 0) {
                mediaCursor.moveToFirst();
                while (!mediaCursor.isAfterLast()) {

                    @SuppressLint("Range") String id = mediaCursor.getString(mediaCursor.getColumnIndex(MediaStore.Audio.Albums._ID));
                    @SuppressLint("Range") String name = mediaCursor.getString(mediaCursor.getColumnIndex(MediaStore.Audio.Albums.ALBUM));
                    MusicAlbum musicAlbum = new MusicAlbum(ContentDirectoryIDs.MUSIC_ALBUM_PREFIX.getId() + id, ContentDirectoryIDs.MUSIC_ALBUMS_FOLDER.getId(), name, "", 0);
                    URI albumArtUri = URI.create("http://"
                            + contentDirectory.getIpAddress() + ":"
                            + YaaccUpnpServerService.PORT + "/album/" + id);
                    musicAlbum.setAlbumArtURIs(new URI[]{albumArtUri});
                    folderMap.put(id, musicAlbum);
                    mediaCursor.moveToNext();
                }

                for (Map.Entry<String, MusicAlbum> entry : folderMap.entrySet()) {
                    int tracks = getMusicTrackSize(contentDirectory, entry.getKey());
                    entry.getValue().setChildCount(tracks);
                    if (tracks > 0) {
                        Log.d(getClass().getName(), "Album Folder: " + entry.getValue().getId() + " Name: " + entry.getValue().getTitle());
                        result.add(entry.getValue());
                    }
                }
            } else {
                Log.d(getClass().getName(), "System media store is empty.");
            }
        }
        int start = firstResult > 0 ? (int) firstResult : 0;
        if (firstResult >= (result.size() - 1)) {
            start = result.size() - 1;
        }
        int end = start + (int) maxResults;
        if (maxResults > result.size() - 1) {
            end = result.size();
        }
        return result.subList(start, end);

    }

    @Override
    public List<Item> browseItem(YaaccContentDirectory contentDirectory, String myId, long firstResult, long maxResults, SortCriterion[] orderby) {
        return new ArrayList<>();

    }

}
