/*
 * This file is part of wger Workout Manager <https://github.com/wger-project>.
 * Copyright (c)  2025 wger Team
 *
 * wger Workout Manager is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Mocks generated by Mockito 5.4.6 from annotations
// in wger/test/widgets/routines/gym_mode/log_page_test.dart.
// Do not manually edit this file.

// ignore_for_file: no_leading_underscores_for_library_prefixes
import 'dart:async' as _i19;
import 'dart:ui' as _i20;

import 'package:mockito/mockito.dart' as _i1;
import 'package:mockito/src/dummies.dart' as _i23;
import 'package:wger/database/exercises/exercise_database.dart' as _i3;
import 'package:wger/models/exercises/category.dart' as _i5;
import 'package:wger/models/exercises/equipment.dart' as _i6;
import 'package:wger/models/exercises/exercise.dart' as _i4;
import 'package:wger/models/exercises/language.dart' as _i8;
import 'package:wger/models/exercises/muscle.dart' as _i7;
import 'package:wger/models/workouts/base_config.dart' as _i15;
import 'package:wger/models/workouts/day.dart' as _i12;
import 'package:wger/models/workouts/day_data.dart' as _i22;
import 'package:wger/models/workouts/log.dart' as _i17;
import 'package:wger/models/workouts/repetition_unit.dart' as _i10;
import 'package:wger/models/workouts/routine.dart' as _i11;
import 'package:wger/models/workouts/session.dart' as _i16;
import 'package:wger/models/workouts/slot.dart' as _i13;
import 'package:wger/models/workouts/slot_entry.dart' as _i14;
import 'package:wger/models/workouts/weight_unit.dart' as _i9;
import 'package:wger/providers/base_provider.dart' as _i2;
import 'package:wger/providers/exercises.dart' as _i18;
import 'package:wger/providers/routines.dart' as _i21;

// ignore_for_file: type=lint
// ignore_for_file: avoid_redundant_argument_values
// ignore_for_file: avoid_setters_without_getters
// ignore_for_file: comment_references
// ignore_for_file: deprecated_member_use
// ignore_for_file: deprecated_member_use_from_same_package
// ignore_for_file: implementation_imports
// ignore_for_file: invalid_use_of_visible_for_testing_member
// ignore_for_file: must_be_immutable
// ignore_for_file: prefer_const_constructors
// ignore_for_file: unnecessary_parenthesis
// ignore_for_file: camel_case_types
// ignore_for_file: subtype_of_sealed_class
// ignore_for_file: invalid_use_of_internal_member

class _FakeWgerBaseProvider_0 extends _i1.SmartFake implements _i2.WgerBaseProvider {
  _FakeWgerBaseProvider_0(Object parent, Invocation parentInvocation)
    : super(parent, parentInvocation);
}

class _FakeExerciseDatabase_1 extends _i1.SmartFake implements _i3.ExerciseDatabase {
  _FakeExerciseDatabase_1(Object parent, Invocation parentInvocation)
    : super(parent, parentInvocation);
}

class _FakeExercise_2 extends _i1.SmartFake implements _i4.Exercise {
  _FakeExercise_2(Object parent, Invocation parentInvocation) : super(parent, parentInvocation);
}

class _FakeExerciseCategory_3 extends _i1.SmartFake implements _i5.ExerciseCategory {
  _FakeExerciseCategory_3(Object parent, Invocation parentInvocation)
    : super(parent, parentInvocation);
}

class _FakeEquipment_4 extends _i1.SmartFake implements _i6.Equipment {
  _FakeEquipment_4(Object parent, Invocation parentInvocation) : super(parent, parentInvocation);
}

class _FakeMuscle_5 extends _i1.SmartFake implements _i7.Muscle {
  _FakeMuscle_5(Object parent, Invocation parentInvocation) : super(parent, parentInvocation);
}

class _FakeLanguage_6 extends _i1.SmartFake implements _i8.Language {
  _FakeLanguage_6(Object parent, Invocation parentInvocation) : super(parent, parentInvocation);
}

class _FakeWeightUnit_7 extends _i1.SmartFake implements _i9.WeightUnit {
  _FakeWeightUnit_7(Object parent, Invocation parentInvocation) : super(parent, parentInvocation);
}

class _FakeRepetitionUnit_8 extends _i1.SmartFake implements _i10.RepetitionUnit {
  _FakeRepetitionUnit_8(Object parent, Invocation parentInvocation)
    : super(parent, parentInvocation);
}

class _FakeRoutine_9 extends _i1.SmartFake implements _i11.Routine {
  _FakeRoutine_9(Object parent, Invocation parentInvocation) : super(parent, parentInvocation);
}

class _FakeDay_10 extends _i1.SmartFake implements _i12.Day {
  _FakeDay_10(Object parent, Invocation parentInvocation) : super(parent, parentInvocation);
}

class _FakeSlot_11 extends _i1.SmartFake implements _i13.Slot {
  _FakeSlot_11(Object parent, Invocation parentInvocation) : super(parent, parentInvocation);
}

class _FakeSlotEntry_12 extends _i1.SmartFake implements _i14.SlotEntry {
  _FakeSlotEntry_12(Object parent, Invocation parentInvocation) : super(parent, parentInvocation);
}

class _FakeBaseConfig_13 extends _i1.SmartFake implements _i15.BaseConfig {
  _FakeBaseConfig_13(Object parent, Invocation parentInvocation) : super(parent, parentInvocation);
}

class _FakeWorkoutSession_14 extends _i1.SmartFake implements _i16.WorkoutSession {
  _FakeWorkoutSession_14(Object parent, Invocation parentInvocation)
    : super(parent, parentInvocation);
}

class _FakeLog_15 extends _i1.SmartFake implements _i17.Log {
  _FakeLog_15(Object parent, Invocation parentInvocation) : super(parent, parentInvocation);
}

/// A class which mocks [ExercisesProvider].
///
/// See the documentation for Mockito's code generation for more information.
class MockExercisesProvider extends _i1.Mock implements _i18.ExercisesProvider {
  MockExercisesProvider() {
    _i1.throwOnMissingStub(this);
  }

  @override
  _i2.WgerBaseProvider get baseProvider =>
      (super.noSuchMethod(
            Invocation.getter(#baseProvider),
            returnValue: _FakeWgerBaseProvider_0(
              this,
              Invocation.getter(#baseProvider),
            ),
          )
          as _i2.WgerBaseProvider);

  @override
  _i3.ExerciseDatabase get database =>
      (super.noSuchMethod(
            Invocation.getter(#database),
            returnValue: _FakeExerciseDatabase_1(
              this,
              Invocation.getter(#database),
            ),
          )
          as _i3.ExerciseDatabase);

  @override
  List<_i4.Exercise> get exercises =>
      (super.noSuchMethod(
            Invocation.getter(#exercises),
            returnValue: <_i4.Exercise>[],
          )
          as List<_i4.Exercise>);

  @override
  List<_i4.Exercise> get filteredExercises =>
      (super.noSuchMethod(
            Invocation.getter(#filteredExercises),
            returnValue: <_i4.Exercise>[],
          )
          as List<_i4.Exercise>);

  @override
  Map<int, List<_i4.Exercise>> get exerciseByVariation =>
      (super.noSuchMethod(
            Invocation.getter(#exerciseByVariation),
            returnValue: <int, List<_i4.Exercise>>{},
          )
          as Map<int, List<_i4.Exercise>>);

  @override
  List<_i5.ExerciseCategory> get categories =>
      (super.noSuchMethod(
            Invocation.getter(#categories),
            returnValue: <_i5.ExerciseCategory>[],
          )
          as List<_i5.ExerciseCategory>);

  @override
  List<_i7.Muscle> get muscles =>
      (super.noSuchMethod(
            Invocation.getter(#muscles),
            returnValue: <_i7.Muscle>[],
          )
          as List<_i7.Muscle>);

  @override
  List<_i6.Equipment> get equipment =>
      (super.noSuchMethod(
            Invocation.getter(#equipment),
            returnValue: <_i6.Equipment>[],
          )
          as List<_i6.Equipment>);

  @override
  List<_i8.Language> get languages =>
      (super.noSuchMethod(
            Invocation.getter(#languages),
            returnValue: <_i8.Language>[],
          )
          as List<_i8.Language>);

  @override
  set database(_i3.ExerciseDatabase? value) => super.noSuchMethod(
    Invocation.setter(#database, value),
    returnValueForMissingStub: null,
  );

  @override
  set exercises(List<_i4.Exercise>? value) => super.noSuchMethod(
    Invocation.setter(#exercises, value),
    returnValueForMissingStub: null,
  );

  @override
  set filteredExercises(List<_i4.Exercise>? newFilteredExercises) => super.noSuchMethod(
    Invocation.setter(#filteredExercises, newFilteredExercises),
    returnValueForMissingStub: null,
  );

  @override
  set languages(List<_i8.Language>? languages) => super.noSuchMethod(
    Invocation.setter(#languages, languages),
    returnValueForMissingStub: null,
  );

  @override
  bool get hasListeners =>
      (super.noSuchMethod(Invocation.getter(#hasListeners), returnValue: false) as bool);

  @override
  _i19.Future<void> setFilters(_i18.Filters? newFilters) =>
      (super.noSuchMethod(
            Invocation.method(#setFilters, [newFilters]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  void initFilters() => super.noSuchMethod(
    Invocation.method(#initFilters, []),
    returnValueForMissingStub: null,
  );

  @override
  _i19.Future<void> findByFilters() =>
      (super.noSuchMethod(
            Invocation.method(#findByFilters, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  void clear() => super.noSuchMethod(
    Invocation.method(#clear, []),
    returnValueForMissingStub: null,
  );

  @override
  _i4.Exercise findExerciseById(int? id) =>
      (super.noSuchMethod(
            Invocation.method(#findExerciseById, [id]),
            returnValue: _FakeExercise_2(
              this,
              Invocation.method(#findExerciseById, [id]),
            ),
          )
          as _i4.Exercise);

  @override
  List<_i4.Exercise> findExercisesByVariationId(
    int? variationId, {
    int? exerciseIdToExclude,
  }) =>
      (super.noSuchMethod(
            Invocation.method(
              #findExercisesByVariationId,
              [variationId],
              {#exerciseIdToExclude: exerciseIdToExclude},
            ),
            returnValue: <_i4.Exercise>[],
          )
          as List<_i4.Exercise>);

  @override
  _i5.ExerciseCategory findCategoryById(int? id) =>
      (super.noSuchMethod(
            Invocation.method(#findCategoryById, [id]),
            returnValue: _FakeExerciseCategory_3(
              this,
              Invocation.method(#findCategoryById, [id]),
            ),
          )
          as _i5.ExerciseCategory);

  @override
  _i6.Equipment findEquipmentById(int? id) =>
      (super.noSuchMethod(
            Invocation.method(#findEquipmentById, [id]),
            returnValue: _FakeEquipment_4(
              this,
              Invocation.method(#findEquipmentById, [id]),
            ),
          )
          as _i6.Equipment);

  @override
  _i7.Muscle findMuscleById(int? id) =>
      (super.noSuchMethod(
            Invocation.method(#findMuscleById, [id]),
            returnValue: _FakeMuscle_5(
              this,
              Invocation.method(#findMuscleById, [id]),
            ),
          )
          as _i7.Muscle);

  @override
  _i8.Language findLanguageById(int? id) =>
      (super.noSuchMethod(
            Invocation.method(#findLanguageById, [id]),
            returnValue: _FakeLanguage_6(
              this,
              Invocation.method(#findLanguageById, [id]),
            ),
          )
          as _i8.Language);

  @override
  _i19.Future<void> fetchAndSetCategoriesFromApi() =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetCategoriesFromApi, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetMusclesFromApi() =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetMusclesFromApi, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetEquipmentsFromApi() =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetEquipmentsFromApi, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetLanguagesFromApi() =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetLanguagesFromApi, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetAllExercises() =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetAllExercises, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<_i4.Exercise?> fetchAndSetExercise(int? exerciseId) =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetExercise, [exerciseId]),
            returnValue: _i19.Future<_i4.Exercise?>.value(),
          )
          as _i19.Future<_i4.Exercise?>);

  @override
  _i19.Future<_i4.Exercise> handleUpdateExerciseFromApi(
    _i3.ExerciseDatabase? database,
    int? exerciseId,
  ) =>
      (super.noSuchMethod(
            Invocation.method(#handleUpdateExerciseFromApi, [
              database,
              exerciseId,
            ]),
            returnValue: _i19.Future<_i4.Exercise>.value(
              _FakeExercise_2(
                this,
                Invocation.method(#handleUpdateExerciseFromApi, [
                  database,
                  exerciseId,
                ]),
              ),
            ),
          )
          as _i19.Future<_i4.Exercise>);

  @override
  _i19.Future<void> initCacheTimesLocalPrefs({dynamic forceInit = false}) =>
      (super.noSuchMethod(
            Invocation.method(#initCacheTimesLocalPrefs, [], {
              #forceInit: forceInit,
            }),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> clearAllCachesAndPrefs() =>
      (super.noSuchMethod(
            Invocation.method(#clearAllCachesAndPrefs, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetInitialData() =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetInitialData, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> setExercisesFromDatabase(
    _i3.ExerciseDatabase? database, {
    bool? forceDeleteCache = false,
  }) =>
      (super.noSuchMethod(
            Invocation.method(
              #setExercisesFromDatabase,
              [database],
              {#forceDeleteCache: forceDeleteCache},
            ),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> updateExerciseCache(_i3.ExerciseDatabase? database) =>
      (super.noSuchMethod(
            Invocation.method(#updateExerciseCache, [database]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetMuscles(_i3.ExerciseDatabase? database) =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetMuscles, [database]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetCategories(_i3.ExerciseDatabase? database) =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetCategories, [database]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetLanguages(_i3.ExerciseDatabase? database) =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetLanguages, [database]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetEquipments(_i3.ExerciseDatabase? database) =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetEquipments, [database]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<List<_i4.Exercise>> searchExercise(
    String? name, {
    String? languageCode = 'en',
    bool? searchEnglish = false,
  }) =>
      (super.noSuchMethod(
            Invocation.method(
              #searchExercise,
              [name],
              {#languageCode: languageCode, #searchEnglish: searchEnglish},
            ),
            returnValue: _i19.Future<List<_i4.Exercise>>.value(
              <_i4.Exercise>[],
            ),
          )
          as _i19.Future<List<_i4.Exercise>>);

  @override
  void addListener(_i20.VoidCallback? listener) => super.noSuchMethod(
    Invocation.method(#addListener, [listener]),
    returnValueForMissingStub: null,
  );

  @override
  void removeListener(_i20.VoidCallback? listener) => super.noSuchMethod(
    Invocation.method(#removeListener, [listener]),
    returnValueForMissingStub: null,
  );

  @override
  void dispose() => super.noSuchMethod(
    Invocation.method(#dispose, []),
    returnValueForMissingStub: null,
  );

  @override
  void notifyListeners() => super.noSuchMethod(
    Invocation.method(#notifyListeners, []),
    returnValueForMissingStub: null,
  );
}

/// A class which mocks [RoutinesProvider].
///
/// See the documentation for Mockito's code generation for more information.
class MockRoutinesProvider extends _i1.Mock implements _i21.RoutinesProvider {
  MockRoutinesProvider() {
    _i1.throwOnMissingStub(this);
  }

  @override
  _i2.WgerBaseProvider get baseProvider =>
      (super.noSuchMethod(
            Invocation.getter(#baseProvider),
            returnValue: _FakeWgerBaseProvider_0(
              this,
              Invocation.getter(#baseProvider),
            ),
          )
          as _i2.WgerBaseProvider);

  @override
  List<_i11.Routine> get items =>
      (super.noSuchMethod(
            Invocation.getter(#items),
            returnValue: <_i11.Routine>[],
          )
          as List<_i11.Routine>);

  @override
  List<_i9.WeightUnit> get weightUnits =>
      (super.noSuchMethod(
            Invocation.getter(#weightUnits),
            returnValue: <_i9.WeightUnit>[],
          )
          as List<_i9.WeightUnit>);

  @override
  _i9.WeightUnit get defaultWeightUnit =>
      (super.noSuchMethod(
            Invocation.getter(#defaultWeightUnit),
            returnValue: _FakeWeightUnit_7(
              this,
              Invocation.getter(#defaultWeightUnit),
            ),
          )
          as _i9.WeightUnit);

  @override
  List<_i10.RepetitionUnit> get repetitionUnits =>
      (super.noSuchMethod(
            Invocation.getter(#repetitionUnits),
            returnValue: <_i10.RepetitionUnit>[],
          )
          as List<_i10.RepetitionUnit>);

  @override
  _i10.RepetitionUnit get defaultRepetitionUnit =>
      (super.noSuchMethod(
            Invocation.getter(#defaultRepetitionUnit),
            returnValue: _FakeRepetitionUnit_8(
              this,
              Invocation.getter(#defaultRepetitionUnit),
            ),
          )
          as _i10.RepetitionUnit);

  @override
  set activeRoutine(_i11.Routine? value) => super.noSuchMethod(
    Invocation.setter(#activeRoutine, value),
    returnValueForMissingStub: null,
  );

  @override
  set weightUnits(List<_i9.WeightUnit>? weightUnits) => super.noSuchMethod(
    Invocation.setter(#weightUnits, weightUnits),
    returnValueForMissingStub: null,
  );

  @override
  set repetitionUnits(List<_i10.RepetitionUnit>? repetitionUnits) => super.noSuchMethod(
    Invocation.setter(#repetitionUnits, repetitionUnits),
    returnValueForMissingStub: null,
  );

  @override
  bool get hasListeners =>
      (super.noSuchMethod(Invocation.getter(#hasListeners), returnValue: false) as bool);

  @override
  void clear() => super.noSuchMethod(
    Invocation.method(#clear, []),
    returnValueForMissingStub: null,
  );

  @override
  _i9.WeightUnit findWeightUnitById(int? id) =>
      (super.noSuchMethod(
            Invocation.method(#findWeightUnitById, [id]),
            returnValue: _FakeWeightUnit_7(
              this,
              Invocation.method(#findWeightUnitById, [id]),
            ),
          )
          as _i9.WeightUnit);

  @override
  _i10.RepetitionUnit findRepetitionUnitById(int? id) =>
      (super.noSuchMethod(
            Invocation.method(#findRepetitionUnitById, [id]),
            returnValue: _FakeRepetitionUnit_8(
              this,
              Invocation.method(#findRepetitionUnitById, [id]),
            ),
          )
          as _i10.RepetitionUnit);

  @override
  List<_i11.Routine> getPlans() =>
      (super.noSuchMethod(
            Invocation.method(#getPlans, []),
            returnValue: <_i11.Routine>[],
          )
          as List<_i11.Routine>);

  @override
  _i11.Routine findById(int? id) =>
      (super.noSuchMethod(
            Invocation.method(#findById, [id]),
            returnValue: _FakeRoutine_9(
              this,
              Invocation.method(#findById, [id]),
            ),
          )
          as _i11.Routine);

  @override
  int findIndexById(int? id) =>
      (super.noSuchMethod(
            Invocation.method(#findIndexById, [id]),
            returnValue: 0,
          )
          as int);

  @override
  _i19.Future<void> fetchAndSetAllRoutinesFull() =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetAllRoutinesFull, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetAllRoutinesSparse() =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetAllRoutinesSparse, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> setExercisesAndUnits(
    List<_i22.DayData>? entries, {
    Map<int, _i4.Exercise>? exercises,
  }) =>
      (super.noSuchMethod(
            Invocation.method(
              #setExercisesAndUnits,
              [entries],
              {#exercises: exercises},
            ),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<_i11.Routine> fetchAndSetRoutineSparse(int? planId) =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetRoutineSparse, [planId]),
            returnValue: _i19.Future<_i11.Routine>.value(
              _FakeRoutine_9(
                this,
                Invocation.method(#fetchAndSetRoutineSparse, [planId]),
              ),
            ),
          )
          as _i19.Future<_i11.Routine>);

  @override
  _i19.Future<_i11.Routine> fetchAndSetRoutineFull(int? routineId) =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetRoutineFull, [routineId]),
            returnValue: _i19.Future<_i11.Routine>.value(
              _FakeRoutine_9(
                this,
                Invocation.method(#fetchAndSetRoutineFull, [routineId]),
              ),
            ),
          )
          as _i19.Future<_i11.Routine>);

  @override
  _i19.Future<_i11.Routine> addRoutine(_i11.Routine? routine) =>
      (super.noSuchMethod(
            Invocation.method(#addRoutine, [routine]),
            returnValue: _i19.Future<_i11.Routine>.value(
              _FakeRoutine_9(this, Invocation.method(#addRoutine, [routine])),
            ),
          )
          as _i19.Future<_i11.Routine>);

  @override
  _i19.Future<void> editRoutine(_i11.Routine? routine) =>
      (super.noSuchMethod(
            Invocation.method(#editRoutine, [routine]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> deleteRoutine(int? id) =>
      (super.noSuchMethod(
            Invocation.method(#deleteRoutine, [id]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetRepetitionUnits() =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetRepetitionUnits, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetWeightUnits() =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetWeightUnits, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> fetchAndSetUnits() =>
      (super.noSuchMethod(
            Invocation.method(#fetchAndSetUnits, []),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<_i12.Day> addDay(_i12.Day? day) =>
      (super.noSuchMethod(
            Invocation.method(#addDay, [day]),
            returnValue: _i19.Future<_i12.Day>.value(
              _FakeDay_10(this, Invocation.method(#addDay, [day])),
            ),
          )
          as _i19.Future<_i12.Day>);

  @override
  _i19.Future<void> editDay(_i12.Day? day) =>
      (super.noSuchMethod(
            Invocation.method(#editDay, [day]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> editDays(List<_i12.Day>? days) =>
      (super.noSuchMethod(
            Invocation.method(#editDays, [days]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> deleteDay(int? dayId) =>
      (super.noSuchMethod(
            Invocation.method(#deleteDay, [dayId]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<_i13.Slot> addSlot(_i13.Slot? slot, int? routineId) =>
      (super.noSuchMethod(
            Invocation.method(#addSlot, [slot, routineId]),
            returnValue: _i19.Future<_i13.Slot>.value(
              _FakeSlot_11(
                this,
                Invocation.method(#addSlot, [slot, routineId]),
              ),
            ),
          )
          as _i19.Future<_i13.Slot>);

  @override
  _i19.Future<void> deleteSlot(int? slotId, int? routineId) =>
      (super.noSuchMethod(
            Invocation.method(#deleteSlot, [slotId, routineId]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> editSlot(_i13.Slot? slot, int? routineId) =>
      (super.noSuchMethod(
            Invocation.method(#editSlot, [slot, routineId]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> editSlots(List<_i13.Slot>? slots, int? routineId) =>
      (super.noSuchMethod(
            Invocation.method(#editSlots, [slots, routineId]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<_i14.SlotEntry> addSlotEntry(
    _i14.SlotEntry? entry,
    int? routineId,
  ) =>
      (super.noSuchMethod(
            Invocation.method(#addSlotEntry, [entry, routineId]),
            returnValue: _i19.Future<_i14.SlotEntry>.value(
              _FakeSlotEntry_12(
                this,
                Invocation.method(#addSlotEntry, [entry, routineId]),
              ),
            ),
          )
          as _i19.Future<_i14.SlotEntry>);

  @override
  _i19.Future<void> deleteSlotEntry(int? id, int? routineId) =>
      (super.noSuchMethod(
            Invocation.method(#deleteSlotEntry, [id, routineId]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> editSlotEntry(_i14.SlotEntry? entry, int? routineId) =>
      (super.noSuchMethod(
            Invocation.method(#editSlotEntry, [entry, routineId]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  String getConfigUrl(_i14.ConfigType? type) =>
      (super.noSuchMethod(
            Invocation.method(#getConfigUrl, [type]),
            returnValue: _i23.dummyValue<String>(
              this,
              Invocation.method(#getConfigUrl, [type]),
            ),
          )
          as String);

  @override
  _i19.Future<_i15.BaseConfig> editConfig(
    _i15.BaseConfig? config,
    _i14.ConfigType? type,
  ) =>
      (super.noSuchMethod(
            Invocation.method(#editConfig, [config, type]),
            returnValue: _i19.Future<_i15.BaseConfig>.value(
              _FakeBaseConfig_13(
                this,
                Invocation.method(#editConfig, [config, type]),
              ),
            ),
          )
          as _i19.Future<_i15.BaseConfig>);

  @override
  _i19.Future<_i15.BaseConfig> addConfig(
    _i15.BaseConfig? config,
    _i14.ConfigType? type,
  ) =>
      (super.noSuchMethod(
            Invocation.method(#addConfig, [config, type]),
            returnValue: _i19.Future<_i15.BaseConfig>.value(
              _FakeBaseConfig_13(
                this,
                Invocation.method(#addConfig, [config, type]),
              ),
            ),
          )
          as _i19.Future<_i15.BaseConfig>);

  @override
  _i19.Future<void> deleteConfig(int? id, _i14.ConfigType? type) =>
      (super.noSuchMethod(
            Invocation.method(#deleteConfig, [id, type]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<void> handleConfig(
    _i14.SlotEntry? entry,
    num? value,
    _i14.ConfigType? type,
  ) =>
      (super.noSuchMethod(
            Invocation.method(#handleConfig, [entry, value, type]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  _i19.Future<List<_i16.WorkoutSession>> fetchSessionData() =>
      (super.noSuchMethod(
            Invocation.method(#fetchSessionData, []),
            returnValue: _i19.Future<List<_i16.WorkoutSession>>.value(
              <_i16.WorkoutSession>[],
            ),
          )
          as _i19.Future<List<_i16.WorkoutSession>>);

  @override
  _i19.Future<_i16.WorkoutSession> addSession(
    _i16.WorkoutSession? session,
    int? routineId,
  ) =>
      (super.noSuchMethod(
            Invocation.method(#addSession, [session, routineId]),
            returnValue: _i19.Future<_i16.WorkoutSession>.value(
              _FakeWorkoutSession_14(
                this,
                Invocation.method(#addSession, [session, routineId]),
              ),
            ),
          )
          as _i19.Future<_i16.WorkoutSession>);

  @override
  _i19.Future<_i16.WorkoutSession> editSession(_i16.WorkoutSession? session) =>
      (super.noSuchMethod(
            Invocation.method(#editSession, [session]),
            returnValue: _i19.Future<_i16.WorkoutSession>.value(
              _FakeWorkoutSession_14(
                this,
                Invocation.method(#editSession, [session]),
              ),
            ),
          )
          as _i19.Future<_i16.WorkoutSession>);

  @override
  _i19.Future<_i17.Log> addLog(_i17.Log? log) =>
      (super.noSuchMethod(
            Invocation.method(#addLog, [log]),
            returnValue: _i19.Future<_i17.Log>.value(
              _FakeLog_15(this, Invocation.method(#addLog, [log])),
            ),
          )
          as _i19.Future<_i17.Log>);

  @override
  _i19.Future<void> deleteLog(int? logId, int? routineId) =>
      (super.noSuchMethod(
            Invocation.method(#deleteLog, [logId, routineId]),
            returnValue: _i19.Future<void>.value(),
            returnValueForMissingStub: _i19.Future<void>.value(),
          )
          as _i19.Future<void>);

  @override
  void addListener(_i20.VoidCallback? listener) => super.noSuchMethod(
    Invocation.method(#addListener, [listener]),
    returnValueForMissingStub: null,
  );

  @override
  void removeListener(_i20.VoidCallback? listener) => super.noSuchMethod(
    Invocation.method(#removeListener, [listener]),
    returnValueForMissingStub: null,
  );

  @override
  void dispose() => super.noSuchMethod(
    Invocation.method(#dispose, []),
    returnValueForMissingStub: null,
  );

  @override
  void notifyListeners() => super.noSuchMethod(
    Invocation.method(#notifyListeners, []),
    returnValueForMissingStub: null,
  );
}
