// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Russian (`ru`).
class AppLocalizationsRu extends AppLocalizations {
  AppLocalizationsRu([String locale = 'ru']) : super(locale);

  @override
  String get userProfile => 'Ваш профиль';

  @override
  String get login => 'Войти';

  @override
  String get logout => 'Выйти';

  @override
  String get register => 'Зарегистрироваться';

  @override
  String get useDefaultServer => 'Использовать сервер по умолчанию';

  @override
  String get useCustomServer => 'Использовать пользовательский сервер';

  @override
  String get invalidUrl => 'Пожалуйста, введите действительный URL';

  @override
  String get usernameValidChars =>
      'Имя пользователя может содержать только буквы, цифры и символы @, +, ., - и _';

  @override
  String get passwordsDontMatch => 'Пароли не совпадают';

  @override
  String get passwordTooShort => 'Пароль слишком короткий';

  @override
  String get selectAvailablePlates => 'Выберите подходящие блины';

  @override
  String get barWeight => 'Вес штанги';

  @override
  String get useColors => 'Использовать цвета';

  @override
  String get password => 'Пароль';

  @override
  String get confirmPassword => 'Подтверждение пароля';

  @override
  String get invalidEmail => 'Пожалуйста, введите действительный адрес электронной почты';

  @override
  String get email => 'Адрес электронной почты';

  @override
  String get username => 'Имя пользователя';

  @override
  String get invalidUsername => 'Пожалуйста, введите действительное имя пользователя';

  @override
  String get useApiToken => 'Использовать токен API';

  @override
  String get useUsernameAndPassword => 'Использовать имя пользователя и пароль';

  @override
  String get apiToken => 'API токен';

  @override
  String get invalidApiToken => 'Пожалуйста, введите действительный ключ API';

  @override
  String get apiTokenValidChars =>
      'API-ключ может содержать только буквы a–f, цифры 0–9 и иметь длину ровно 40 символов';

  @override
  String get customServerUrl => 'URL-адрес экземпляра wger';

  @override
  String get customServerHint =>
      'Введите адрес вашего собственного сервера, иначе будет использован адрес по умолчанию';

  @override
  String get reset => 'Сброс';

  @override
  String get registerInstead => 'У вас нет аккаунта? Зарегистрируйтесь сейчас';

  @override
  String get loginInstead => 'Уже есть аккаунт? Войти';

  @override
  String get labelBottomNavWorkout => 'Тренировка';

  @override
  String get labelBottomNavNutrition => 'Питание';

  @override
  String get labelWorkoutLogs => 'Журналы тренировок';

  @override
  String get labelWorkoutPlan => 'План тренировки';

  @override
  String get labelDashboard => 'Панель управления';

  @override
  String get success => 'Успешно';

  @override
  String get successfullyDeleted => 'Удалено';

  @override
  String get successfullySaved => 'Сохранено';

  @override
  String get exerciseList => 'Список упражнений';

  @override
  String get exercise => 'Упражнение';

  @override
  String get exercises => 'Упражнения';

  @override
  String get exerciseName => 'Название упражнения';

  @override
  String get searchExercise => 'Найдите упражнение, которое нужно добавить';

  @override
  String get noIngredientsDefined => 'Ингредиенты пока не определены';

  @override
  String get noMatchingExerciseFound => 'Не выбрано упражнение для замены';

  @override
  String get searchNamesInEnglish => 'Также ищите названия на английском';

  @override
  String get equipment => 'Оборудование';

  @override
  String get muscles => 'Мышцы';

  @override
  String get musclesSecondary => 'Вторичные мышцы';

  @override
  String get category => 'Категория';

  @override
  String get startDate => 'Дата начала';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => 'Тренировки';

  @override
  String get newRoutine => 'Новая тренировка';

  @override
  String get noRoutines => 'У вас нет тренировок';

  @override
  String get reps => 'Повтор';

  @override
  String get restTime => 'Время отдыха';

  @override
  String get sets => 'Подходы';

  @override
  String get rir => 'ПвЗ';

  @override
  String get rirNotUsed => 'ПвЗ не используется';

  @override
  String get useMetric => 'Использовать метрические единицы измерения для веса тела.';

  @override
  String get weightUnit => 'Единица веса';

  @override
  String get repetitionUnit => 'Единица повторения';

  @override
  String get set => 'Подход';

  @override
  String get dayDescriptionHelp =>
      'Описание того, что делается в этот день (например, \'день подтягиваний\') или какие части тела тренируются (например, \'грудь и плечи\')';

  @override
  String exerciseNr(String nr) {
    return 'Упражнение $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Супер подход';
  }

  @override
  String get sameRepetitions =>
      'Если количество повторений и вес не меняются от подхода к подходу, достаточно указать данные один раз. Например, для 4 подходов введите 10 повторений, и это автоматически преобразуется в \'4 x 10\'.';

  @override
  String get comment => 'Комментарий';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Впечатление';

  @override
  String get notes => 'Заметки';

  @override
  String get workoutSession => 'Записанная тренировка';

  @override
  String get restDay => 'День отдыха';

  @override
  String get isRestDay => 'Выходной день';

  @override
  String get isRestDayHelp =>
      'Пожалуйста, имейте в виду, что если вы отметите этот день как день отдыха, все подходы и упражнения будут удалены.';

  @override
  String get needsLogsToAdvance => 'Требуются записи для прогресса';

  @override
  String get needsLogsToAdvanceHelp =>
      'Выберите, если вы хотите, чтобы программа переходила к следующему запланированному дню только после того, как вы записали тренировку за текущий день.';

  @override
  String get routineDays => 'Дней в тренировке';

  @override
  String get resultingRoutine => 'Итоговая тренировка';

  @override
  String get newDay => 'Новый день';

  @override
  String get newSet => 'Новый подход (сет)';

  @override
  String get selectExercises =>
      'Если вы хотите сделать супер подход (сет), вы можете найти несколько упражнений, они будут сгруппированы вместе';

  @override
  String get gymMode => 'Режим тренажерного зала';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Пластины (блины)';

  @override
  String get plateCalculatorNotDivisible =>
      'Невозможно достичь веса с имеющимися пластинами (весами)';

  @override
  String get pause => 'Пауза';

  @override
  String get jumpTo => 'Перейти к';

  @override
  String get todaysWorkout => 'Ваша сегодняшняя тренировка';

  @override
  String get logHelpEntries =>
      'Если в один день есть несколько записей с одинаковым количеством повторений, но разными весами, то на диаграмме отображается только запись с большим весом.';

  @override
  String get logHelpEntriesUnits =>
      'Обратите внимание, что на графиках отображаются только записи с указанием веса (кг или фунты) и повторений. Другие комбинации, такие как время или \"до отказа\", здесь игнорируются.';

  @override
  String get description => 'Описание';

  @override
  String get name => 'Имя';

  @override
  String get save => 'Сохранить';

  @override
  String get verify => 'Подтвердить';

  @override
  String get addSet => 'Добавить сет';

  @override
  String get addMeal => 'Добавить блюдо';

  @override
  String get mealLogged => 'Блюдо записано в дневник';

  @override
  String get ingredientLogged => 'Ингредиент занесен в дневник';

  @override
  String get logMeal => 'Запишите прием пищи в дневник питания';

  @override
  String get addIngredient => 'Добавить ингредиент';

  @override
  String get logIngredient => 'Записать в дневнике питания';

  @override
  String get searchIngredient => 'Поиск ингредиента';

  @override
  String get nutritionalPlan => 'План питания';

  @override
  String get nutritionalDiary => 'Дневник питания';

  @override
  String get nutritionalPlans => 'Планы питания';

  @override
  String get noNutritionalPlans => 'У вас нет планов питания';

  @override
  String get onlyLogging => 'Только отслеживать калории';

  @override
  String get onlyLoggingHelpText =>
      'Поставьте флажок, если вы хотите отслеживать только потребление калорий и не хотите создавать подробный план питания с конкретными блюдами';

  @override
  String get goalMacro => 'Цели по макронутриентам';

  @override
  String get selectMealToLog => 'Выберите прием пищи для записи в дневник';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Your current nutrition plan has no meals defined';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'To add meals to the plan, go to the nutritional plan details';

  @override
  String get goalEnergy => 'Цель по энергии';

  @override
  String get goalProtein => 'Цель по белкам';

  @override
  String get goalCarbohydrates => 'Цель по углеводам';

  @override
  String get goalFat => 'Цель по жирам';

  @override
  String get goalFiber => 'Цель по волокну';

  @override
  String get anErrorOccurred => 'Произошла ошибка!';

  @override
  String get errorInfoDescription =>
      'We\'re sorry, but something went wrong. You can help us fix this by reporting the issue on GitHub.';

  @override
  String get errorInfoDescription2 =>
      'You can continue using the app, but some features may not work.';

  @override
  String get errorViewDetails => 'Technical details';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Couldn\'t connect to server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'The application could not connect to the server. Please check your internet connection or the server URL and try again. If the problem persists, contact the server administrator.';

  @override
  String get copyToClipboard => 'Copy to clipboard';

  @override
  String get weight => 'Вес';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name за все время';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name последние 30 дней';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName во время плана питания $planName';
  }

  @override
  String get measurement => 'Измерение';

  @override
  String get measurements => 'Измерения';

  @override
  String get measurementCategoriesHelpText =>
      'Категория измерения, например \'бицепс\' или \'жир\'';

  @override
  String get measurementEntriesHelpText =>
      'Единица, используемая для измерения в категории, например \'см\' или \'%\'';

  @override
  String get date => 'Дата';

  @override
  String get endDate => 'Дата окончания';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'Значение';

  @override
  String get start => 'Старт';

  @override
  String get time => 'Время';

  @override
  String get timeStart => 'Время начала';

  @override
  String get timeEnd => 'Время окончания';

  @override
  String get timeStartAhead => 'Время начала не может быть раньше времени окончания';

  @override
  String get ingredient => 'Ингредиент';

  @override
  String get energy => 'Энергия';

  @override
  String get energyShort => 'Э';

  @override
  String get macronutrients => 'Макроэлементы';

  @override
  String get planned => 'Запланировано';

  @override
  String get logged => 'Записано';

  @override
  String get today => 'Сегодня';

  @override
  String get loggedToday => 'Записано на сегодня';

  @override
  String get weekAverage => 'В среднем за 7 дней';

  @override
  String get surplus => 'превышение';

  @override
  String get deficit => 'дефицит';

  @override
  String get difference => 'Разница';

  @override
  String get percentEnergy => 'Процент энергии';

  @override
  String get gPerBodyKg => 'г на кг тела';

  @override
  String get total => 'Всего';

  @override
  String get kcal => 'ккал';

  @override
  String kcalValue(String value) {
    return '$value калорий';
  }

  @override
  String get kJ => 'кДж';

  @override
  String get g => 'г';

  @override
  String gValue(String value) {
    return '$value гр';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Белки';

  @override
  String get proteinShort => 'Б';

  @override
  String get carbohydrates => 'Углеводы';

  @override
  String get carbohydratesShort => 'У';

  @override
  String get sugars => 'Сахар';

  @override
  String get fat => 'Жиры';

  @override
  String get fatShort => 'Ж';

  @override
  String get saturatedFat => 'Насыщенные жиры';

  @override
  String get fiber => 'Клетчатка';

  @override
  String get sodium => 'Натрий';

  @override
  String get amount => 'Количество';

  @override
  String get unit => 'Единица';

  @override
  String get newEntry => 'Новая запись';

  @override
  String get noWeightEntries => 'У вас нет записей о весе';

  @override
  String get noMeasurementEntries => 'У вас нет записей измерений';

  @override
  String get moreMeasurementEntries => 'Добавить новое измерение';

  @override
  String get edit => 'Редактировать';

  @override
  String get loadingText => 'Загрузка…';

  @override
  String get delete => 'Удалить';

  @override
  String confirmDelete(String toDelete) {
    return 'Вы уверены, что хотите удалить \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Новый план питания';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'Переключить сведения';

  @override
  String get goToDetailPage => 'Перейти на страницу сведений';

  @override
  String get aboutWhySupportTitle => 'Open Source & free to use ❤️';

  @override
  String get aboutDescription =>
      'Спасибо за использование wger! wger - это совместный проект с открытым исходным кодом, созданный фитнес энтузиастами со всего мира.';

  @override
  String get aboutDonateTitle => 'Пожертвовать';

  @override
  String get aboutDonateText =>
      'Купите нам кофе, чтобы помочь проекту, оплатить затраты на сервер и поддерживать нас в тонусе';

  @override
  String get aboutContributeTitle => 'Contribute';

  @override
  String get aboutContributeText =>
      'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!';

  @override
  String get aboutBugsListTitle => 'Report a problem or suggest a feature';

  @override
  String get aboutTranslationListTitle => 'Translate the application';

  @override
  String get aboutSourceListTitle => 'View source code';

  @override
  String get aboutJoinCommunityTitle => 'Join the community';

  @override
  String get aboutMastodonTitle => 'Мастодонт';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Others';

  @override
  String get calendar => 'Календарь';

  @override
  String get goToToday => 'Перейти на сегодня';

  @override
  String get enterValue => 'Пожалуйста, введите значение';

  @override
  String get selectEntry => 'Пожалуйста, выберите запись';

  @override
  String get selectExercise => 'Пожалуйста, выберите упражнение';

  @override
  String enterCharacters(String min, String max) {
    return 'Пожалуйста, введите между $min и $max символами';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Пожалуйста, введите как минимум $min символов';
  }

  @override
  String get baseNameEnglish =>
      'Для всех упражнений необходимо базовое название на английском языке';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Количество сетов на упражнение: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Установите единицы измерения и ПвЗ';

  @override
  String get enterValidNumber => 'Пожалуйста, введите правильное число';

  @override
  String get selectIngredient => 'Пожалуйста, выберите ингредиент';

  @override
  String get recentlyUsedIngredients => 'Недавно добавленные ингредиенты';

  @override
  String get selectImage => 'Пожалуйста, выберите изображение';

  @override
  String get optionsLabel => 'Опции';

  @override
  String get takePicture => 'Сфотографировать';

  @override
  String get chooseFromLibrary => 'Выбрать из библиотеки фотографий';

  @override
  String get gallery => 'Галерея';

  @override
  String get addImage => 'Добавить изображение';

  @override
  String get dataCopied => 'Данные копируются в новую запись';

  @override
  String get appUpdateTitle => 'Требуется обновление';

  @override
  String get appUpdateContent =>
      'Эта версия приложения не совместима с сервером, пожалуйста, обновите ваше приложение.';

  @override
  String get productFound => 'Продукт найден';

  @override
  String productFoundDescription(String productName) {
    return 'Штрихкод соответствует этому продукту: $productName. Вы хотите продолжить?';
  }

  @override
  String get productNotFound => 'Продукт не найден';

  @override
  String productNotFoundDescription(String barcode) {
    return 'Продукт со отсканированным штрихкодом $barcode не найден в базе данных wger';
  }

  @override
  String get scanBarcode => 'Сканировать штрихкод';

  @override
  String get close => 'Закрыть';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'Изображения должны быть совместимы с CC BY SA лицензией. Если вы сомневаетесь, загружайте только те фотографии, которые вы сделали сами';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'Варианты';

  @override
  String alsoKnownAs(String aliases) {
    return 'Также известно как: $aliases';
  }

  @override
  String get verifiedEmail => 'Подтвержденный адрес электронной почты';

  @override
  String get unVerifiedEmail => 'Неподтвержденный адрес электронной почты';

  @override
  String get verifiedEmailReason =>
      'Вам необходимо подтвердить свой адрес электронной почты, чтобы добавлять упражнения';

  @override
  String verifiedEmailInfo(String email) {
    return 'Письмо с подтверждением отправлено на $email';
  }

  @override
  String get alternativeNames => 'Альтернативные названия';

  @override
  String get oneNamePerLine => 'Одно название на строку';

  @override
  String get whatVariationsExist =>
      'Какие варианты этого упражнения существуют, если таковые имеются?';

  @override
  String get previous => 'Предыдущее';

  @override
  String get next => 'Следующее';

  @override
  String get images => 'Изображения';

  @override
  String get language => 'Язык';

  @override
  String get addExercise => 'Добавить упражнение';

  @override
  String get fitInWeek => 'Fit in week';

  @override
  String get fitInWeekHelp =>
      'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.';

  @override
  String get addSuperset => 'Add superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set has progression';

  @override
  String get setHasProgressionWarning =>
      'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.';

  @override
  String get setHasNoExercises => 'This set has no exercises yet!';

  @override
  String get contributeExercise => 'Добавить упражнение';

  @override
  String get translation => 'Перевод';

  @override
  String get translateExercise => 'Перевести это упражнение';

  @override
  String get baseData => 'Основы на английском';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Настройки';

  @override
  String get settingsCacheTitle => 'Кэш';

  @override
  String get settingsExerciseCacheDescription => 'Кэш упражнений';

  @override
  String get settingsIngredientCacheDescription => 'Кэш ингредиентов';

  @override
  String get settingsCacheDeletedSnackbar => 'Кэш успешно очищен';

  @override
  String get aboutPageTitle => 'О Wger';

  @override
  String contributeExerciseWarning(String days) {
    return 'Вы можете добавлять упражнения только в том случае, если ваша учетная запись старше $days дней и вы подтвердили свою электронную почту';
  }

  @override
  String get simpleMode => 'Simple mode';

  @override
  String get simpleModeHelp => 'Hide some of the more advanced settings when editing exercises';

  @override
  String get progressionRules =>
      'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.';

  @override
  String get cacheWarning =>
      'Из-за кэширования может пройти некоторое время, прежде чем изменения станут видны во всем приложении.';

  @override
  String get textPromptTitle => 'Готовы начать?';

  @override
  String get textPromptSubheading => 'Нажмите кнопку действия, чтобы начать';

  @override
  String get abs => 'Пресс';

  @override
  String get arms => 'Руки';

  @override
  String get back => 'Спина';

  @override
  String get barbell => 'Штанга';

  @override
  String get bench => 'Скамья';

  @override
  String get biceps => 'Бицепсы';

  @override
  String get body_weight => 'Вес тела';

  @override
  String get calves => 'Икры';

  @override
  String get cardio => 'Кардио';

  @override
  String get chest => 'Грудь';

  @override
  String get dumbbell => 'Гантели';

  @override
  String get glutes => 'Ягодицы';

  @override
  String get gym_mat => 'Спортивный коврик';

  @override
  String get hamstrings => 'Бёдра';

  @override
  String get incline_bench => 'Наклонная скамья';

  @override
  String get kettlebell => 'Гиря';

  @override
  String get kilometers => 'Километры';

  @override
  String get kilometers_per_hour => 'км/ч';

  @override
  String get lats => 'Широчайшие';

  @override
  String get legs => 'Ноги';

  @override
  String get lower_back => 'Нижняя часть спины';

  @override
  String get max_reps => 'Максимальное количество повторений';

  @override
  String get miles => 'Мили';

  @override
  String get miles_per_hour => 'миль/ч';

  @override
  String get minutes => 'Минут';

  @override
  String get plates => 'Блины';

  @override
  String get pull_up_bar => 'Турник';

  @override
  String get quads => 'Четырехглавые';

  @override
  String get repetitions => 'Повторений';

  @override
  String get resistance_band => 'Resistance band';

  @override
  String get sz_bar => 'SZ-гриф';

  @override
  String get seconds => 'Секунд';

  @override
  String get shoulders => 'Плечи';

  @override
  String get swiss_ball => 'Гимнастический мяч';

  @override
  String get triceps => 'Трицепс';

  @override
  String get until_failure => 'До отказа';

  @override
  String get kg => 'кг';

  @override
  String get lb => 'фунт';

  @override
  String get none__bodyweight_exercise_ => 'без (с собственным весом)';

  @override
  String get log => 'Журнал';

  @override
  String get done => 'Завершить';

  @override
  String get overallChangeWeight => 'Общее изменение';

  @override
  String get goalTypeMeals => 'Из еды';

  @override
  String get goalTypeBasic => 'Базовый';

  @override
  String get goalTypeAdvanced => 'Расширенный';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'в среднем';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Режим темы';

  @override
  String get darkMode => 'Всегда темный режим';

  @override
  String get lightMode => 'Всегда светлый режим';

  @override
  String get systemMode => 'Системные настройки';
}
