// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Portuguese (`pt`).
class AppLocalizationsPt extends AppLocalizations {
  AppLocalizationsPt([String locale = 'pt']) : super(locale);

  @override
  String get userProfile => 'Seu perfil';

  @override
  String get login => 'Entrar';

  @override
  String get logout => 'Sair';

  @override
  String get register => 'Registrar';

  @override
  String get useDefaultServer => 'Usar servidor padrão';

  @override
  String get useCustomServer => 'Usar servidor personalizado';

  @override
  String get invalidUrl => 'Por favor, insira um URL válido';

  @override
  String get usernameValidChars =>
      'Um nome de usuário pode conter apenas letras, dígitos e os caracteres @, +, ., - e _';

  @override
  String get passwordsDontMatch => 'As senhas não correspondem';

  @override
  String get passwordTooShort => 'A senha é muito curta';

  @override
  String get selectAvailablePlates => 'Seleciona anilhas disponíveis';

  @override
  String get barWeight => 'Peso da barra';

  @override
  String get useColors => 'Usa cores';

  @override
  String get password => 'Senha';

  @override
  String get confirmPassword => 'Confirmar senha';

  @override
  String get invalidEmail => 'Por favor insira um endereço de e-mail válido';

  @override
  String get email => 'Endereço de e-mail';

  @override
  String get username => 'Nome do usuário';

  @override
  String get invalidUsername => 'Insira um nome de usuário válido';

  @override
  String get useApiToken => 'Usa código API';

  @override
  String get useUsernameAndPassword => 'Usa nome de utilizador e palavra passe';

  @override
  String get apiToken => 'Códibo API';

  @override
  String get invalidApiToken => 'Por favor, introduz uma chave API válida';

  @override
  String get apiTokenValidChars =>
      'Uma chave API pode apenas conter letras a-f, números 0-9 e ter exatamente 40 caracteres';

  @override
  String get customServerUrl => 'URL da instância wger';

  @override
  String get customServerHint =>
      'Digite o endereço do seu próprio servidor, ou então o padrão será usado';

  @override
  String get reset => 'Redefinir';

  @override
  String get registerInstead => 'Não tem uma conta? Registre agora';

  @override
  String get loginInstead => 'Já tem uma conta? Faça login';

  @override
  String get labelBottomNavWorkout => 'Treino';

  @override
  String get labelBottomNavNutrition => 'Nutrição';

  @override
  String get labelWorkoutLogs => 'Registros de treinamento';

  @override
  String get labelWorkoutPlan => 'Plano de treino';

  @override
  String get labelDashboard => 'Painel';

  @override
  String get success => 'Sucesso';

  @override
  String get successfullyDeleted => 'Excluído';

  @override
  String get successfullySaved => 'Salvou';

  @override
  String get exerciseList => 'Lista de Exercício';

  @override
  String get exercise => 'Exercício';

  @override
  String get exercises => 'Exercícios';

  @override
  String get exerciseName => 'Nome do exercício';

  @override
  String get searchExercise => 'Procurar exercício';

  @override
  String get noIngredientsDefined => 'Sem ingredientes definido ainda';

  @override
  String get noMatchingExerciseFound => 'Nenhum exercício correspondente encontrado';

  @override
  String get searchNamesInEnglish => 'Também buscar nomes em inglês';

  @override
  String get equipment => 'Equipamento';

  @override
  String get muscles => 'Músculos';

  @override
  String get musclesSecondary => 'Músculos secundários';

  @override
  String get category => 'Categoria';

  @override
  String get startDate => 'Data de início';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => 'Rotinas';

  @override
  String get newRoutine => 'Nova rotina';

  @override
  String get noRoutines => 'Você não tem rotinas';

  @override
  String get reps => 'Reps';

  @override
  String get restTime => 'Tempo de descanso';

  @override
  String get sets => 'Séries';

  @override
  String get rir => 'ReR';

  @override
  String get rirNotUsed => 'ReR não utilizado';

  @override
  String get useMetric => 'Use unidades métricas para o peso corpora';

  @override
  String get weightUnit => 'Unidade de peso';

  @override
  String get repetitionUnit => 'Unidade de repetição';

  @override
  String get set => 'Set';

  @override
  String get dayDescriptionHelp =>
      'Uma descrição do que é feito neste dia (por exemplo, \'dia de treino\') ou quais partes do corpo são treinadas (por exemplo, \'peito e ombros\')';

  @override
  String exerciseNr(String nr) {
    return 'Exercício $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'Se você fizer as mesmas repetições e peso para todos os conjuntos, você pode preencher apenas uma linha. Por exemplo, para 4 séries, basta digitar 10 para as repetições, isso se torna automaticamente \"4 x 10\".';

  @override
  String get comment => 'Comentário';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Impressão';

  @override
  String get notes => 'Notas';

  @override
  String get workoutSession => 'Sessão de treino';

  @override
  String get restDay => 'Dia de descanso';

  @override
  String get isRestDay => 'É tempo de descanso';

  @override
  String get isRestDayHelp =>
      'Favor notar que todos os sets e exercícios serão removidos quando você marcar um dia como dia de descanso.';

  @override
  String get needsLogsToAdvance => 'Precisa de dados para avançar';

  @override
  String get needsLogsToAdvanceHelp =>
      'Seleciona se queres que a rotina progrida para o dia seguinte agendado apenas se registaste um treino no dia';

  @override
  String get routineDays => 'Dias na rotina';

  @override
  String get resultingRoutine => 'Rotina resultante';

  @override
  String get newDay => 'Novo dia';

  @override
  String get newSet => 'Novo set';

  @override
  String get selectExercises =>
      'Se você quiser fazer um conjunto, você pode procurar vários exercícios, eles serão agrupados';

  @override
  String get gymMode => 'Modo treino';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Pratos';

  @override
  String get plateCalculatorNotDivisible =>
      'Não é possível atingir o peso com as placas disponíveis';

  @override
  String get pause => 'Pausar';

  @override
  String get jumpTo => 'Pular';

  @override
  String get todaysWorkout => 'Seu treino hoje';

  @override
  String get logHelpEntries =>
      'Se em um mesmo dia houver mais de uma entrada com o mesmo número de repetições, mas com pesos diferentes, apenas a entrada com maior peso é mostrada no gráfico.';

  @override
  String get logHelpEntriesUnits =>
      'Observe que apenas as entradas com uma unidade de peso (kg ou lb) e repetições são registradas, outras combinações como tempo ou até falha são ignoradas aqui.';

  @override
  String get description => 'Descrição';

  @override
  String get name => 'Nome';

  @override
  String get save => 'Salvar';

  @override
  String get verify => 'Verificar';

  @override
  String get addSet => 'Adicionar set';

  @override
  String get addMeal => 'Adicionar refeição';

  @override
  String get mealLogged => 'Refeição registrada no gráfico';

  @override
  String get ingredientLogged => 'Ingrediente ativo registrado diariamente';

  @override
  String get logMeal => 'Registar esta refeição no diário de nutrição';

  @override
  String get addIngredient => 'Adicionar ingrediente';

  @override
  String get logIngredient => 'Registar ingrediente no diário de nutrição';

  @override
  String get searchIngredient => 'Procurar ingrediente';

  @override
  String get nutritionalPlan => 'Plano nutricional';

  @override
  String get nutritionalDiary => 'Gráfico nutricional';

  @override
  String get nutritionalPlans => 'Planos nutricionais';

  @override
  String get noNutritionalPlans => 'Você não tem planos nutricionais';

  @override
  String get onlyLogging => 'Só controlar calorias';

  @override
  String get onlyLoggingHelpText =>
      'Marque a caixa se você desejar apenas o seu registo de calorias e não quer a configuração de um detalhado plano nutricional com refeições';

  @override
  String get goalMacro => 'Macro objetivos';

  @override
  String get selectMealToLog => 'Selecione uma refeição para entrar no diário';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'O teu plano nutricional atual não tem refeições definidas';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Para adicionar refeições ao plano, vai aos detalhes do plano nutricional';

  @override
  String get goalEnergy => 'Meta energética';

  @override
  String get goalProtein => 'Meta proteica';

  @override
  String get goalCarbohydrates => 'Meta de carboidratos';

  @override
  String get goalFat => 'Meta de gordura';

  @override
  String get goalFiber => 'Meta de fibra';

  @override
  String get anErrorOccurred => 'Um erro ocorreu!';

  @override
  String get errorInfoDescription =>
      'Lamentamos, mas algo correu mal. Podes ajudar a corrigir isto reportando o erro no GitHub.';

  @override
  String get errorInfoDescription2 =>
      'Podes continuar a usar a aplicação, mas algumas funções podem não funcionar.';

  @override
  String get errorViewDetails => 'Detalhes técnicos';

  @override
  String get applicationLogs => 'Registos da aplicação';

  @override
  String get errorCouldNotConnectToServer => 'Não foi possível ligar ao servidor';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'A aplicação não conseguiu ligar-se ao servidor. Por favor, verifica a ligação à rede ou o URL do servidor e tenta novamente. Se o problema persistir, contacta o administrador do servidor.';

  @override
  String get copyToClipboard => 'Copia para a memória';

  @override
  String get weight => 'Peso';

  @override
  String get min => 'Min';

  @override
  String get max => 'Máximo';

  @override
  String chartAllTimeTitle(String name) {
    return '$name de todo o tempo';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name Ultimos 30 dias';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName Durante o plano nutricional $planName';
  }

  @override
  String get measurement => 'Medição';

  @override
  String get measurements => 'Medidas';

  @override
  String get measurementCategoriesHelpText =>
      'Categoria de medição, como \'bíceps\' ou \'gordura corporal\'';

  @override
  String get measurementEntriesHelpText =>
      'A unidade usada para medir a categoria, como \'cm\' ou \'%\'';

  @override
  String get date => 'Data';

  @override
  String get endDate => 'Data de término';

  @override
  String get openEnded => 'Sem fim definido';

  @override
  String get value => 'Valor';

  @override
  String get start => 'Iniciar';

  @override
  String get time => 'Tempo';

  @override
  String get timeStart => 'Hora de início';

  @override
  String get timeEnd => 'Hora do final';

  @override
  String get timeStartAhead => 'A hora de início não pode ser anterior à hora de término';

  @override
  String get ingredient => 'Ingrediente';

  @override
  String get energy => 'Energia';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutrientes';

  @override
  String get planned => 'Planejado';

  @override
  String get logged => 'Registrado';

  @override
  String get today => 'Hoje';

  @override
  String get loggedToday => 'Registrado hoje';

  @override
  String get weekAverage => 'Média dos 7 dias';

  @override
  String get surplus => 'Excedente';

  @override
  String get deficit => 'Défice';

  @override
  String get difference => 'Diferença';

  @override
  String get percentEnergy => 'Porcentagem de energia';

  @override
  String get gPerBodyKg => 'g por kg';

  @override
  String get total => 'Total';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Proteína';

  @override
  String get proteinShort => 'p';

  @override
  String get carbohydrates => 'Carboidratos';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Açúcares';

  @override
  String get fat => 'Gordura';

  @override
  String get fatShort => 'G';

  @override
  String get saturatedFat => 'Gordura saturada';

  @override
  String get fiber => 'Fibra';

  @override
  String get sodium => 'Sódio';

  @override
  String get amount => 'Quantidade';

  @override
  String get unit => 'Unidade';

  @override
  String get newEntry => 'Nova entrada';

  @override
  String get noWeightEntries => 'Você não tem entradas de peso';

  @override
  String get noMeasurementEntries => 'Você não tem entradas de medição';

  @override
  String get moreMeasurementEntries => 'Adicionar nova medição';

  @override
  String get edit => 'Editar';

  @override
  String get loadingText => 'Carregando...';

  @override
  String get delete => 'Deletar';

  @override
  String confirmDelete(String toDelete) {
    return 'Tem certeza que deseja excluir \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Novo plano nutricional';

  @override
  String get overview => 'Panorama';

  @override
  String get toggleDetails => 'Alternar detalhes';

  @override
  String get goToDetailPage => 'Ir para a página de detalhes';

  @override
  String get aboutWhySupportTitle => 'Código aberto & livre para usar ❤️';

  @override
  String get aboutDescription =>
      'Obrigado por usar o wger! wger é um projeto colaborativo de código aberto, feito por entusiastas do fitness de todo o mundo.';

  @override
  String get aboutDonateTitle => 'Faz uma doação';

  @override
  String get aboutDonateText =>
      'Embora o projeto seja, e será sempre, gratuito, manter o servidor não o é! O desenvolvimento também leva bastante do tempo dos voluntários. O teu contributo suporta diretamente estes custos ajudando a manter o serviço constante.';

  @override
  String get aboutContributeTitle => 'Contribui';

  @override
  String get aboutContributeText =>
      'Todos os tipos de contribuição são bem-vindos. Quer sejas um desenvolvedor, um tradutor ou apenas um apaixonado pelo exercício, todas as migalhas de suporte são apreciadas!';

  @override
  String get aboutBugsListTitle => 'Relata um problema ou sugere uma funcionalidade';

  @override
  String get aboutTranslationListTitle => 'Traduz a aplicação';

  @override
  String get aboutSourceListTitle => 'Vê o código fonte';

  @override
  String get aboutJoinCommunityTitle => 'Junta-te à comunidade';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Outros';

  @override
  String get calendar => 'Calendário';

  @override
  String get goToToday => 'Voltar para hoje';

  @override
  String get enterValue => 'por favor insira um valor';

  @override
  String get selectEntry => 'Por favor selecione uma entrada';

  @override
  String get selectExercise => 'Selecione um exercício';

  @override
  String enterCharacters(String min, String max) {
    return 'Insira entre $min e $max caracteres';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Por favor, selecione ao menos $min de caracteres';
  }

  @override
  String get baseNameEnglish => 'Todos os exercícios precisam de um nome base em inglês';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Séries por exercício: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Definir unidades e ReR';

  @override
  String get enterValidNumber => 'Por favor insira um número válido';

  @override
  String get selectIngredient => 'Selecione um ingrediente';

  @override
  String get recentlyUsedIngredients => 'Ingredientes adicionados recentemente';

  @override
  String get selectImage => 'Selecione uma imagem';

  @override
  String get optionsLabel => 'Opções';

  @override
  String get takePicture => 'Tirar uma foto';

  @override
  String get chooseFromLibrary => 'Escolher da galeria';

  @override
  String get gallery => 'Galeria de fotos';

  @override
  String get addImage => 'Adicionar imagem';

  @override
  String get dataCopied => 'Dados copiados para nova entrada';

  @override
  String get appUpdateTitle => 'Atualização necessária';

  @override
  String get appUpdateContent =>
      'Esta versão do aplicativo não é compatível com o servidor, atualize seu aplicativo.';

  @override
  String get productFound => 'Produto encontrado';

  @override
  String productFoundDescription(String productName) {
    return 'O código de barras corresponde a este produto: $productName. Você quer continuar?';
  }

  @override
  String get productNotFound => 'Produto não encontrado';

  @override
  String productNotFoundDescription(String barcode) {
    return 'O produto com o código de barras digitalizado $barcode não foi encontrado no banco de dados';
  }

  @override
  String get scanBarcode => 'Digitalizar código de barras';

  @override
  String get close => 'Fechar';

  @override
  String get identicalExercisePleaseDiscard =>
      'Se encontrares um exercício igual ao que estás a introduzir, por favor descarta o teu rascunho e edita antes esse exercício.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Por favor, verifica que a informação introduzida está correta antes de submeter o exercício';

  @override
  String get add_exercise_image_license =>
      'As imagens devem ser compatíveis com a licença CC BY SA. Em caso de dúvida, carregue apenas fotos que você mesmo tirou.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'Variações';

  @override
  String alsoKnownAs(String aliases) {
    return 'Também chamado de: $aliases';
  }

  @override
  String get verifiedEmail => 'Email verificado';

  @override
  String get unVerifiedEmail => 'Verificação pendente';

  @override
  String get verifiedEmailReason =>
      'É necessário verificar seu email para contribuir com exercícios';

  @override
  String verifiedEmailInfo(String email) {
    return 'Um email de verificação foi enviado para $email';
  }

  @override
  String get alternativeNames => 'Outros nomes';

  @override
  String get oneNamePerLine => 'Somente um nome por linha';

  @override
  String get whatVariationsExist =>
      'Se houver alguma, quais as possíveis variações para esse exercício?';

  @override
  String get previous => 'Anterior';

  @override
  String get next => 'Próximo';

  @override
  String get images => 'Imagens';

  @override
  String get language => 'Idioma';

  @override
  String get addExercise => 'Adicionar exercício';

  @override
  String get fitInWeek => 'Encaixa na semana';

  @override
  String get fitInWeekHelp =>
      'Se selecionado, os dias repetir-se-ão num ciclo semanal, caso contrário, os dias seguir-se-ão sequencialmente independentemente do início de nova semana.';

  @override
  String get addSuperset => 'Adiciona um superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'A série tem progressão';

  @override
  String get setHasProgressionWarning =>
      'Por favor, nota que, de momento, não é possível editar todos os valores para uma série na aplicação móvel ou configurar a progressão automática. Por agora, por favor, usa a aplicação web.';

  @override
  String get setHasNoExercises => 'Esta série ainda não tem exercícios!';

  @override
  String get contributeExercise => 'Contribua um exercício';

  @override
  String get translation => 'Tradução';

  @override
  String get translateExercise => 'Traduzir este exercício';

  @override
  String get baseData => 'Básico em inglês';

  @override
  String get enterTextInLanguage => 'Por favor, introduz o texto la linguagem correta!';

  @override
  String get settingsTitle => 'Configurações';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Arquivo de exercícios';

  @override
  String get settingsIngredientCacheDescription => 'Arquivo de ingredientes';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache limpa com sucesso';

  @override
  String get aboutPageTitle => 'Sobre nós & suporte';

  @override
  String contributeExerciseWarning(String days) {
    return 'Só podes contribuir com exercícios se a tua conta tiver mais de $days dias e tiveres verificado o teu e-mail';
  }

  @override
  String get simpleMode => 'Modo simples';

  @override
  String get simpleModeHelp =>
      'Esconde alguns dos parâmetros mais avançados quando editando exercícios';

  @override
  String get progressionRules =>
      'Este exercício tem regras de progressão e não pode ser editado na aplicação móvel. Por favor, usa a aplicação web para editar este exercício.';

  @override
  String get cacheWarning =>
      'Devido ao \"caching\", pode levar algum tempo até que as alterações sejam visíveis em todo o aplicativo.';

  @override
  String get textPromptTitle => 'Podemos começar?';

  @override
  String get textPromptSubheading => 'Aperte o botão de ação para começar';

  @override
  String get abs => 'Abdominal';

  @override
  String get arms => 'Braços';

  @override
  String get back => 'Costas';

  @override
  String get barbell => 'Barra';

  @override
  String get bench => 'Supino';

  @override
  String get biceps => 'Bíceps';

  @override
  String get body_weight => 'Peso Corporal';

  @override
  String get calves => 'Panturrilha';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Peito';

  @override
  String get dumbbell => 'Haltere';

  @override
  String get glutes => 'Glúteos';

  @override
  String get gym_mat => 'Colchonete';

  @override
  String get hamstrings => 'Posterior de coxa';

  @override
  String get incline_bench => 'Supino inclinado';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Quilômetros';

  @override
  String get kilometers_per_hour => 'Quilômetros Por Hora';

  @override
  String get lats => 'Dorsal';

  @override
  String get legs => 'Pernas';

  @override
  String get lower_back => 'Lombar';

  @override
  String get max_reps => 'Repetição Máxima';

  @override
  String get miles => 'Milhas';

  @override
  String get miles_per_hour => 'Milhas por Hora';

  @override
  String get minutes => 'Minutos';

  @override
  String get plates => 'Pratos';

  @override
  String get pull_up_bar => 'Barra fixa';

  @override
  String get quads => 'Quadríceps';

  @override
  String get repetitions => 'Repetições';

  @override
  String get resistance_band => 'Banda elástica';

  @override
  String get sz_bar => 'Barra SZ';

  @override
  String get seconds => 'Segundos';

  @override
  String get shoulders => 'Ombro';

  @override
  String get swiss_ball => 'Bola suíça';

  @override
  String get triceps => 'Tríceps';

  @override
  String get until_failure => 'Até a falha';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'nenhum (somente peso do corpo)';

  @override
  String get log => 'Log';

  @override
  String get done => 'Feito';

  @override
  String get overallChangeWeight => 'Mudança geral';

  @override
  String get goalTypeMeals => 'A partir de refeições';

  @override
  String get goalTypeBasic => 'Básico';

  @override
  String get goalTypeAdvanced => 'Avançado';

  @override
  String get indicatorRaw => 'Crú';

  @override
  String get indicatorAvg => 'Média';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Tema';

  @override
  String get darkMode => 'Modo sempre escuro';

  @override
  String get lightMode => 'Modo sempre a luz de';

  @override
  String get systemMode => 'Configurações do sistema';
}

/// The translations for Portuguese, as used in Brazil (`pt_BR`).
class AppLocalizationsPtBr extends AppLocalizationsPt {
  AppLocalizationsPtBr() : super('pt_BR');

  @override
  String get userProfile => 'Seu perfil';

  @override
  String get login => 'Entrar';

  @override
  String get logout => 'Sair';

  @override
  String get register => 'Inscrever-se';

  @override
  String get useDefaultServer => 'Usar servidor padrão';

  @override
  String get useCustomServer => 'Usar servidor customizado';

  @override
  String get invalidUrl => 'Por favor, digite uma URL válida';

  @override
  String get usernameValidChars =>
      'Um usuário deve apenas conter letras, digitos e os caracteres @, +, ., -, ou _';

  @override
  String get passwordsDontMatch => 'As senhas não coincidem';

  @override
  String get passwordTooShort => 'A senha é muito curta';

  @override
  String get selectAvailablePlates => 'Selecione os pesos disponíveis';

  @override
  String get barWeight => 'Peso da barra';

  @override
  String get useColors => 'Use cores';

  @override
  String get password => 'Senha';

  @override
  String get confirmPassword => 'Confirme sua senha';

  @override
  String get invalidEmail => 'Por favor insira um endereço de e-mail válido';

  @override
  String get email => 'Endereço de email';

  @override
  String get username => 'Usuário';

  @override
  String get invalidUsername => 'Por favor insira um nome de usuário válido';

  @override
  String get useApiToken => 'Usar Token API';

  @override
  String get useUsernameAndPassword => 'Usar usuário e senha';

  @override
  String get apiToken => 'Token API';

  @override
  String get invalidApiToken => 'Por favor, entre com a API key válida';

  @override
  String get apiTokenValidChars =>
      'A chave API deve ter apenas letras a-f, números 0-9 e ter exatamente 40 caracteres';

  @override
  String get customServerUrl => 'URL da instância wger';

  @override
  String get customServerHint =>
      'Digite o endereço do seu próprio servidor, caso contrário o padrão será usado';

  @override
  String get reset => 'Redefinir';

  @override
  String get registerInstead => 'Não tem uma conta? Registrar agora';

  @override
  String get loginInstead => 'Já tem uma conta ? Entre';

  @override
  String get labelBottomNavWorkout => 'Treino';

  @override
  String get labelBottomNavNutrition => 'Nutrição';

  @override
  String get labelWorkoutLogs => 'Registros de treinos';

  @override
  String get labelWorkoutPlan => 'Plano de treino';

  @override
  String get labelDashboard => 'Painel';

  @override
  String get success => 'Bem-sucedido';

  @override
  String get successfullyDeleted => 'Removido com êxito';

  @override
  String get successfullySaved => 'Salvo';

  @override
  String get exerciseList => 'Lista de exercícios';

  @override
  String get exercise => 'Exercício';

  @override
  String get exercises => 'Exercícios';

  @override
  String get exerciseName => 'Nome do exercício';

  @override
  String get searchExercise => 'Exercício de pesquisa para adicionar';

  @override
  String get noIngredientsDefined => 'Nenhum ingrediente definido ainda';

  @override
  String get noMatchingExerciseFound => 'Sem exercícios correspondentes encontrados';

  @override
  String get searchNamesInEnglish => 'Procure também nomes em inglês';

  @override
  String get equipment => 'Equipamento';

  @override
  String get muscles => 'Músculos';

  @override
  String get musclesSecondary => 'Músculos secundários';

  @override
  String get category => 'Categoria';

  @override
  String get startDate => 'Data inicial';

  @override
  String get dayTypeCustom => 'Personalizado';

  @override
  String get dayTypeEnom => 'Cada minuto a minuto';

  @override
  String get dayTypeAmrap => 'Tantas rodadas quanto possível';

  @override
  String get dayTypeHiit => 'Treinamento intervalado de alta intensidade';

  @override
  String get dayTypeTabata => 'Método Tabata';

  @override
  String get dayTypeEdt => 'Treinamento de densidade crescente';

  @override
  String get dayTypeRft => 'Rodadas para ganhar tempo';

  @override
  String get dayTypeAfap => 'O mais rápido possível';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Drop set';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Parcial';

  @override
  String get slotEntryTypeForced => 'Forçado';

  @override
  String get slotEntryTypeTut => 'Tempo Sob Tensão';

  @override
  String get slotEntryTypeIso => 'Fixação isométrica';

  @override
  String get slotEntryTypeJump => 'Pular';

  @override
  String get routines => 'Rotinas';

  @override
  String get newRoutine => 'Nova rotina';

  @override
  String get noRoutines => 'Não tens rotinas';

  @override
  String get reps => 'Repetições';

  @override
  String get restTime => 'Tempo de descanso';

  @override
  String get sets => 'Séries';

  @override
  String get rir => 'ReR';

  @override
  String get rirNotUsed => 'RiR não usado';

  @override
  String get useMetric => 'Use unidades métricas para peso corporal';

  @override
  String get weightUnit => 'Unidade de peso';

  @override
  String get repetitionUnit => 'Unidade de repetição';

  @override
  String get set => 'Série';

  @override
  String get dayDescriptionHelp =>
      'Uma descrição do que é feito neste dia (por exemplo, \'dia de puxar\') ou quais partes do corpo são treinadas (por exemplo, \'peito e ombros\')';

  @override
  String exerciseNr(String nr) {
    return 'Exercício $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Supersérie $nr';
  }

  @override
  String get sameRepetitions =>
      'Se você fizer as mesmas repetições e peso para todas as séries, poderá preencher apenas uma linha. Por exemplo, para 4 séries basta inserir 10 para as repetições, isso automaticamente se torna \"4 x 10\".';

  @override
  String get comment => 'Comentário';

  @override
  String get impressionGood => 'Boa';

  @override
  String get impressionNeutral => 'Neutra';

  @override
  String get impressionBad => 'Ruim';

  @override
  String get impression => 'Impressão';

  @override
  String get notes => 'Comentários';

  @override
  String get workoutSession => 'Sessão de treino';

  @override
  String get restDay => 'Dia de descanso';

  @override
  String get isRestDay => 'É dia de descanso';

  @override
  String get isRestDayHelp =>
      'Por favor, note que todos as séries e exercícios serão removidos quando marcar um dia como um dia de descanso.';

  @override
  String get needsLogsToAdvance => 'Precisa de logs para avançar';

  @override
  String get needsLogsToAdvanceHelp =>
      'Selecione se deseja que a rotina de treino avance para o próximo dia agendado somente se você cadastrou o dia de treino';

  @override
  String get routineDays => 'Dias de treino';

  @override
  String get resultingRoutine => 'Treino resultante';

  @override
  String get newDay => 'Novo dia';

  @override
  String get newSet => 'Nova séries';

  @override
  String get selectExercises =>
      'Se quiser fazer um superséries você pode procurar vários exercícios, eles estarão agrupados';

  @override
  String get gymMode => 'Modo Gym';

  @override
  String get gymModeShowExercises => 'Mostrar páginas de visão geral dos exercícios';

  @override
  String get gymModeShowTimer => 'Mostrar cronômetro entre séries';

  @override
  String get gymModeTimerType => 'Tipo de temporizador';

  @override
  String get gymModeTimerTypeHelText =>
      'Se uma série tiver tempo de pausa, sempre será usada uma contagem regressiva.';

  @override
  String get countdown => 'Contagem regressiva';

  @override
  String get stopwatch => 'cronômetro';

  @override
  String get gymModeDefaultCountdownTime => 'Tempo de contagem regressiva padrão, em segundos';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notificar no final da contagem regressiva';

  @override
  String get duration => 'Duração';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Treino concluído';

  @override
  String get plateCalculator => 'Pratos';

  @override
  String get plateCalculatorNotDivisible =>
      'Não é possível atingir o peso com os pratos disponíveis';

  @override
  String get pause => 'Pausar';

  @override
  String get jumpTo => 'Pule para';

  @override
  String get todaysWorkout => 'Seu treino hoje';

  @override
  String get logHelpEntries =>
      'Se em um mesmo dia houver mais de uma inscrição com o mesmo número de repetições, mas pesos diferentes, apenas a inscrição com maior peso será mostrada no diagrama.';

  @override
  String get logHelpEntriesUnits =>
      'Observe que apenas as entradas com uma unidade de peso (kg ou lb) e repetições são registradas; outras combinações, como tempo ou até a falha, são ignoradas aqui.';

  @override
  String get description => 'Descrição';

  @override
  String get name => 'Nome';

  @override
  String get save => 'Salvar';

  @override
  String get verify => 'Verificar';

  @override
  String get addSet => 'Adicionar séries';

  @override
  String get addMeal => 'Adicionar refeição';

  @override
  String get mealLogged => 'Refeição registrada no diário';

  @override
  String get ingredientLogged => 'Ingrediente registrado no diário';

  @override
  String get logMeal => 'Registrar refeição para diário de nutrição';

  @override
  String get addIngredient => 'Adicionar ingrediente';

  @override
  String get logIngredient => 'Salvar ingrediente no diário nutricional';

  @override
  String get searchIngredient => 'Pesquisar Ingrediente';

  @override
  String get nutritionalPlan => 'Plano nutricional';

  @override
  String get nutritionalDiary => 'Diário nutricional';

  @override
  String get nutritionalPlans => 'Planos nutricionais';

  @override
  String get noNutritionalPlans => 'Você não tem planos nutricionais';

  @override
  String get onlyLogging => 'Apenas acompanhe calorias';

  @override
  String get onlyLoggingHelpText =>
      'Marque a caixa se você apenas quiser registrar suas calorias e não quer configurar um plano nutricional detalhado com refeições específicas';

  @override
  String get goalMacro => 'Macro Objetivos';

  @override
  String get selectMealToLog => 'Selecione uma refeição para registrar no diário';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Seu plano nutricional não tem refeições definidas';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Para adicionar refeições para o planejamento, vá para Detalhes de Plano Nutricional';

  @override
  String get goalEnergy => 'Meta energética';

  @override
  String get goalProtein => 'Meta de proteína';

  @override
  String get goalCarbohydrates => 'Meta de carbohidratos';

  @override
  String get goalFat => 'Meta de gordura';

  @override
  String get goalFiber => 'Meta de fibras';

  @override
  String get anErrorOccurred => 'Ocorreu um erro!';

  @override
  String get errorInfoDescription =>
      'Algo de errado aconteceu. Você pode nos ajudar a concertar esse problema reportando o problema no Github.';

  @override
  String get errorInfoDescription2 =>
      'Você pode continuar usando o applicativo, mas algumas funcionalidades não estarão disponíveis.';

  @override
  String get errorViewDetails => 'Detalhes técnicos';

  @override
  String get applicationLogs => 'Registros de aplicativos';

  @override
  String get errorCouldNotConnectToServer => 'Não foi possível conectar ao servidor';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'O aplicativo não conseguiu conectar ao servidor. Verifique sua conexão de internet ou a URL do servidor e tente novamente. Se o problema persistir, contact o administrador.';

  @override
  String get copyToClipboard => 'Copiar ao clipboard';

  @override
  String get weight => 'Peso';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name total';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name últimos 30 dias';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName durante plano nutricional $planName';
  }

  @override
  String get measurement => 'Medição';

  @override
  String get measurements => 'Medidas';

  @override
  String get measurementCategoriesHelpText =>
      'Categoria de medição, como \'bíceps\' ou \'gordura corporal\'';

  @override
  String get measurementEntriesHelpText =>
      'A unidade usada para medir a categoria, como \'cm\' ou \'%\'';

  @override
  String get date => 'Data';

  @override
  String get endDate => 'Data final';

  @override
  String get openEnded => 'Aberto';

  @override
  String get value => 'Valor';

  @override
  String get start => 'Começar';

  @override
  String get time => 'Tempo';

  @override
  String get timeStart => 'Hora de início';

  @override
  String get timeEnd => 'Fim do tempo';

  @override
  String get timeStartAhead => 'O horário de início não pode ser anterior ao horário de término';

  @override
  String get ingredient => 'Ingrediente';

  @override
  String get energy => 'Energia';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutrientes';

  @override
  String get planned => 'Planejado';

  @override
  String get logged => 'Desconectar';

  @override
  String get today => 'Hoje';

  @override
  String get loggedToday => 'Registrado hoje';

  @override
  String get weekAverage => 'Média de 7 dias';

  @override
  String get surplus => 'excedente';

  @override
  String get deficit => 'déficit';

  @override
  String get difference => 'Diferença';

  @override
  String get percentEnergy => 'Porcentagem de energia';

  @override
  String get gPerBodyKg => 'g por kg corporal';

  @override
  String get total => 'Total';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Proteína';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Carboidratos';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Açúcar';

  @override
  String get fat => 'Gordura';

  @override
  String get fatShort => 'G';

  @override
  String get saturatedFat => 'Gordura saturada';

  @override
  String get fiber => 'Fibra';

  @override
  String get sodium => 'Sódio';

  @override
  String get amount => 'Quantia';

  @override
  String get unit => 'Unidade';

  @override
  String get newEntry => 'Nova entrada';

  @override
  String get noWeightEntries => 'Você não tem entradas de peso';

  @override
  String get noMeasurementEntries => 'Você não tem entradas de medição';

  @override
  String get moreMeasurementEntries => 'Adicionar nova medição';

  @override
  String get edit => 'Editar';

  @override
  String get loadingText => 'Carregando...';

  @override
  String get delete => 'Excluir';

  @override
  String confirmDelete(String toDelete) {
    return 'Tem certeza de que deseja excluir \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Novo plano nutricional';

  @override
  String get overview => 'visão global';

  @override
  String get toggleDetails => 'Alterar detalhes';

  @override
  String get goToDetailPage => 'Ir para a página de detalhes';

  @override
  String get aboutWhySupportTitle => 'Código aberto e de uso gratuito ❤️';

  @override
  String get aboutDescription =>
      'Obrigado por usar o Wger! Wger é um projeto colaborativo de código aberto, feito por entusiastas do fitness de todo o mundo.';

  @override
  String get aboutDonateTitle => 'Faça uma doação';

  @override
  String get aboutDonateText =>
      'Enquanto o aplicativo e serviço é de graça, desenvolvê-lo não é. O desenvolvimento tomar tempo e recursos de voluntários. Sua contribuição pode ajudar a tornar o aplicativo melhor e a manter o serviço rodando por mais tempo.';

  @override
  String get aboutContributeTitle => 'Contribua';

  @override
  String get aboutContributeText =>
      'Todos os tipos de contribuidores são bem vindos. Se você é um desenvolvedor, tradutor ou alguém apaixonado pelo fitness, toda ajuda é bem vinda!';

  @override
  String get aboutBugsListTitle => 'Reportar um problema ou sugerir uma funcionalidade';

  @override
  String get aboutTranslationListTitle => 'Traduzir a aplicação';

  @override
  String get aboutSourceListTitle => 'Ver o código fonte';

  @override
  String get aboutJoinCommunityTitle => 'Entre para a comunidade';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Outros';

  @override
  String get calendar => 'Calendário';

  @override
  String get goToToday => 'Vá para hoje';

  @override
  String get enterValue => 'por favor insira um valor';

  @override
  String get selectEntry => 'Por favor, selecione uma entrada';

  @override
  String get selectExercise => 'Por favor, selecione um exercício';

  @override
  String enterCharacters(String min, String max) {
    return 'Por favor, utilize entre $min e $max caracteres';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Insira um valor entre $min e $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Por favor, utilize pelo menos $min caracteres';
  }

  @override
  String get baseNameEnglish => 'Todos os exercícios necessitam de um nome base em inglês';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Séries por exercício: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Unidades e RIR da série';

  @override
  String get enterValidNumber => 'Por favor, insira um número válido';

  @override
  String get selectIngredient => 'Por favor, selecione um ingrediente';

  @override
  String get recentlyUsedIngredients => 'Ingredientes adicionados recentemente';

  @override
  String get selectImage => 'Por favor, selecione uma imagem';

  @override
  String get optionsLabel => 'Opções';

  @override
  String get takePicture => 'Tire uma foto';

  @override
  String get chooseFromLibrary => 'Escolher na galeria';

  @override
  String get gallery => 'Galeria';

  @override
  String get addImage => 'Adicionar imagem';

  @override
  String get dataCopied => 'Dados copiados para o novo registro';

  @override
  String get appUpdateTitle => 'Atualização necessária';

  @override
  String get appUpdateContent =>
      'Esta versão do aplicativo não é compatível com o servidor, por favor atualize o aplicativo.';

  @override
  String get productFound => 'Produto encontrado';

  @override
  String productFoundDescription(String productName) {
    return 'O código de barras corresponde a este produto: $productName. Deseja continuar?';
  }

  @override
  String get productNotFound => 'Produto não encontrado';

  @override
  String productNotFoundDescription(String barcode) {
    return 'O produto com o código de barras escaneado $barcode não foi encontrado no banco de dados da wger';
  }

  @override
  String get scanBarcode => 'Escaneie o código de barras';

  @override
  String get close => 'Fechar';

  @override
  String get identicalExercisePleaseDiscard =>
      'Se você notar um exercício idêntico ao que você está adicionando, descarte o rascunho e edite o exercício.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Verifique se as informações inseridas estão corretas antes de enviar o exercício';

  @override
  String get add_exercise_image_license =>
      'As imagens devem ser compatíveis com a licença CC BY SA. Em caso de dúvida, faça upload apenas de fotos que você mesmo tenha tirado.';

  @override
  String get imageDetailsTitle => 'Detalhes da imagem';

  @override
  String get imageDetailsLicenseTitle => 'Titulo';

  @override
  String get imageDetailsLicenseTitleHint => 'Insira o título da imagem';

  @override
  String get imageDetailsSourceLink => 'Link para o site de origem';

  @override
  String get author => 'Autor(s)';

  @override
  String get authorHint => 'Digite o nome do autor';

  @override
  String get imageDetailsAuthorLink => 'Link para o site ou perfil do autor';

  @override
  String get imageDetailsDerivativeSource =>
      'Link para a fonte original, se este for um trabalho derivado';

  @override
  String get imageDetailsDerivativeHelp =>
      'Um trabalho derivado é baseado em um trabalho anterior, mas contém conteúdo novo e criativo suficiente para ter direito aos seus próprios direitos autorais.';

  @override
  String get imageDetailsImageType => 'Tipo de imagem';

  @override
  String get imageDetailsLicenseNotice =>
      'Ao enviar esta imagem, você concorda em liberá-la sob CC-BY-SA-4. A imagem deve ser de sua autoria ou o autor deve tê-la divulgado sob uma licença compatível com ela.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'Consulte o texto da licença.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat não compatível';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return 'Imagens $imageFormat ainda não são suportadas.';
  }

  @override
  String get add => 'adicionar';

  @override
  String get variations => 'Variações';

  @override
  String alsoKnownAs(String aliases) {
    return 'Também conhecido como:$aliases';
  }

  @override
  String get verifiedEmail => 'Email verificado';

  @override
  String get unVerifiedEmail => 'Email não verificado';

  @override
  String get verifiedEmailReason =>
      'Você precisa verificar seu e-mail para contribuir com exercícios';

  @override
  String verifiedEmailInfo(String email) {
    return 'Um e-mail foi enviado para $email';
  }

  @override
  String get alternativeNames => 'Nomes alternativos';

  @override
  String get oneNamePerLine => 'Um nome por linha';

  @override
  String get whatVariationsExist => 'Quais variações deste exercício existem, se houver?';

  @override
  String get previous => 'Anterior';

  @override
  String get next => 'Próximo';

  @override
  String get images => 'Imagens';

  @override
  String get language => 'Linguagem';

  @override
  String get addExercise => 'Adicionar exercício';

  @override
  String get fitInWeek => 'Treino na semana';

  @override
  String get fitInWeekHelp =>
      'Se ligado, os dias vão se repetir semanalmente, caso contrário os dias seguirão sequencialmente se considerar o começo de uma nova semana.';

  @override
  String get addSuperset => 'Adicionar superséries';

  @override
  String get superset => 'Supersérie';

  @override
  String get setHasProgression => 'Treino tem prograssão';

  @override
  String get setHasProgressionWarning =>
      'Observe que, no momento, não é possível editar todas as configurações de um séries no aplicativo móvel nem configurar a progressão automática. Por enquanto, use o aplicativo web.';

  @override
  String get setHasNoExercises => 'Este séries ainda não tem exercícios!';

  @override
  String get contributeExercise => 'Contribuir com um exercício';

  @override
  String get translation => 'Tradução';

  @override
  String get translateExercise => 'Traduza este exercício agora';

  @override
  String get baseData => 'Fundamentos em inglês';

  @override
  String get enterTextInLanguage => 'Por favor, insira o texto no idioma correto!';

  @override
  String get settingsTitle => 'Configurações';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Cache do exercício';

  @override
  String get settingsIngredientCacheDescription => 'Cache de Ingredientes';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache limpa com sucesso';

  @override
  String get aboutPageTitle => 'Sobre o nós & Suporte';

  @override
  String contributeExerciseWarning(String days) {
    return 'Você só pode contribuir com exercícios se sua conta tiver mais de $days dias e se você tiver verificado seu e-mail';
  }

  @override
  String get simpleMode => 'Modo simples';

  @override
  String get simpleModeHelp => 'Esconder informações avançadas enquanto estiver editando exercicio';

  @override
  String get progressionRules =>
      'Este exercício tem regras de progressão e não pode ser editado no aplicativo móvel. Use o aplicativo web para editá-lo.';

  @override
  String get cacheWarning =>
      'Devido ao cache pode demorar algum tempo até que mudanças estejam visíveis na aplicação.';

  @override
  String get textPromptTitle => 'Pronto para iniciar?';

  @override
  String get textPromptSubheading => 'Aperte o botão de ação para começar';

  @override
  String get abs => 'Abdômen';

  @override
  String get arms => 'Braços';

  @override
  String get back => 'Costas';

  @override
  String get barbell => 'Barra';

  @override
  String get bench => 'Banco';

  @override
  String get biceps => 'Bíceps';

  @override
  String get body_weight => 'Peso Corporal';

  @override
  String get calves => 'Panturrilha';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Peito';

  @override
  String get dumbbell => 'Haltere';

  @override
  String get glutes => 'Glúteos';

  @override
  String get gym_mat => 'Tapete';

  @override
  String get hamstrings => 'Tendões';

  @override
  String get incline_bench => 'Banco inclinado';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Quilômetros';

  @override
  String get kilometers_per_hour => 'Quilômetros por hora';

  @override
  String get lats => 'Dorsal';

  @override
  String get legs => 'Pernas';

  @override
  String get lower_back => 'Lombar';

  @override
  String get max_reps => 'Repetições Máximas';

  @override
  String get miles => 'Milhas';

  @override
  String get miles_per_hour => 'Milhas por hora';

  @override
  String get minutes => 'Minutos';

  @override
  String get plates => 'Anilhas';

  @override
  String get pull_up_bar => 'Barra de Pull-up';

  @override
  String get quads => 'Quadríceps';

  @override
  String get repetitions => 'Repetições';

  @override
  String get resistance_band => 'Banda de resistência';

  @override
  String get sz_bar => 'Barra Curvada';

  @override
  String get seconds => 'Segundos';

  @override
  String get shoulders => 'Ombros';

  @override
  String get swiss_ball => 'Bola Suíça';

  @override
  String get triceps => 'Tríceps';

  @override
  String get until_failure => 'Até a falha';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'nenhum (exercício com peso corporal)';

  @override
  String get log => 'Registro';

  @override
  String get done => 'Feito';

  @override
  String get overallChangeWeight => 'Mudança geral';

  @override
  String get goalTypeMeals => 'De refeições';

  @override
  String get goalTypeBasic => 'Básico';

  @override
  String get goalTypeAdvanced => 'Avançado';

  @override
  String get indicatorRaw => 'bruto';

  @override
  String get indicatorAvg => 'média';

  @override
  String get endWorkout => 'Terminar treino';

  @override
  String get themeMode => 'Tema';

  @override
  String get darkMode => 'Sempre modo escuro';

  @override
  String get lightMode => 'Sempre modo claro';

  @override
  String get systemMode => 'Configurações do sistema';
}

/// The translations for Portuguese, as used in Portugal (`pt_PT`).
class AppLocalizationsPtPt extends AppLocalizationsPt {
  AppLocalizationsPtPt() : super('pt_PT');

  @override
  String get userProfile => 'O teu perfil';

  @override
  String get login => 'Iniciar sessão';

  @override
  String get logout => 'Terminar sessão';

  @override
  String get register => 'Registar';

  @override
  String get useDefaultServer => 'Usar servidor predefinido';

  @override
  String get useCustomServer => 'Usar servidor personalizado';

  @override
  String get invalidUrl => 'Introduz um URL válido';

  @override
  String get usernameValidChars =>
      'O nome de utilizador só pode conter letras, números e os caracteres @, +, ., - e _';

  @override
  String get passwordsDontMatch => 'As palavras-passe não coincidem';

  @override
  String get passwordTooShort => 'A palavra-passe é demasiado curta';

  @override
  String get selectAvailablePlates => 'Selecionar discos disponíveis';

  @override
  String get barWeight => 'Peso da barra';

  @override
  String get useColors => 'Usar cores';

  @override
  String get password => 'Palavra-passe';

  @override
  String get confirmPassword => 'Confirmar palavra-passe';

  @override
  String get invalidEmail => 'Introduz um e-mail válido';

  @override
  String get email => 'Endereço de e-mail';

  @override
  String get username => 'Nome de utilizador';

  @override
  String get invalidUsername => 'Introduz um nome de utilizador válido';

  @override
  String get useApiToken => 'Usar Token da API';

  @override
  String get useUsernameAndPassword => 'Usar nome de utilizador e palavra-passe';

  @override
  String get apiToken => 'Token da API';

  @override
  String get invalidApiToken => 'Introduz uma chave API válida';

  @override
  String get apiTokenValidChars =>
      'Uma chave API só pode conter letras de a-f, números de 0-9 e ter exatamente 40 caracteres';

  @override
  String get customServerUrl => 'URL da instância wger';

  @override
  String get customServerHint =>
      'Introduz o endereço do teu próprio servidor, senão será usado o predefinido';

  @override
  String get reset => 'Repor';

  @override
  String get registerInstead => 'Ainda não tens conta? Regista-te agora';

  @override
  String get loginInstead => 'Já tens conta? Inicia sessão';

  @override
  String get labelBottomNavWorkout => 'Treino';

  @override
  String get labelBottomNavNutrition => 'Nutrição';

  @override
  String get labelWorkoutLogs => 'Registos de treino';

  @override
  String get labelWorkoutPlan => 'Plano de treino';

  @override
  String get labelDashboard => 'Painel';

  @override
  String get success => 'Sucesso';

  @override
  String get successfullyDeleted => 'Eliminado';

  @override
  String get successfullySaved => 'Guardado';

  @override
  String get exerciseList => 'Lista de exercícios';

  @override
  String get exercise => 'Exercício';

  @override
  String get exercises => 'Exercícios';

  @override
  String get exerciseName => 'Nome do exercício';

  @override
  String get searchExercise => 'Procura um exercício para adicionar';

  @override
  String get noIngredientsDefined => 'Ainda não há ingredientes definidos';

  @override
  String get noMatchingExerciseFound => 'Não foram encontrados exercícios';

  @override
  String get searchNamesInEnglish => 'Também procurar nomes em inglês';

  @override
  String get equipment => 'Equipamento';

  @override
  String get muscles => 'Músculos';

  @override
  String get musclesSecondary => 'Músculos secundários';

  @override
  String get category => 'Categoria';

  @override
  String get startDate => 'Data de início';

  @override
  String get dayTypeCustom => 'Customizado';

  @override
  String get dayTypeEnom => 'A cada minuto';

  @override
  String get dayTypeAmrap => 'O máximo de rondas possível';

  @override
  String get dayTypeHiit => 'Treino intervalado de alta intensidade';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Treino de densidade crescente';

  @override
  String get dayTypeRft => 'Rondas por tempo';

  @override
  String get dayTypeAfap => 'O mais rápido possível';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get routines => 'Rotinas';

  @override
  String get newRoutine => 'Nova rotina';

  @override
  String get noRoutines => 'Ainda não tens rotinas';

  @override
  String get reps => 'Repetições';

  @override
  String get restTime => 'Tempo de descanso';

  @override
  String get sets => 'Séries';

  @override
  String get rir => 'Repetições em Reserva';

  @override
  String get rirNotUsed => 'ReR não utilizado';

  @override
  String get useMetric => 'Usar unidades métricas para peso corporal';

  @override
  String get weightUnit => 'Unidade de peso';

  @override
  String get repetitionUnit => 'Unidade de repetição';

  @override
  String get set => 'Série';

  @override
  String get dayDescriptionHelp =>
      'Descrição do que é feito neste dia (ex.: \"dia de puxar\") ou que músculos são treinados (ex.: \"peito e ombros\")';

  @override
  String exerciseNr(String nr) {
    return 'Exercício $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'Se fizeres o mesmo número de repetições e peso em todas as séries, basta preencher uma linha. Por exemplo: para 4 séries de 10, escreve \"10\" e fica automaticamente \"4 x 10\".';

  @override
  String get comment => 'Comentário';

  @override
  String get impression => 'Impressão';

  @override
  String get notes => 'Notas';

  @override
  String get workoutSession => 'Sessão de treino';

  @override
  String get restDay => 'Dia de descanso';

  @override
  String get isRestDay => 'É dia de descanso';

  @override
  String get isRestDayHelp =>
      'Nota que todas as séries e exercícios serão removidos se marcares o dia como descanso.';

  @override
  String get needsLogsToAdvance => 'Precisa de registos para avançar';

  @override
  String get needsLogsToAdvanceHelp =>
      'Seleciona se queres que a rotina avance para o próximo dia apenas se registares um treino';

  @override
  String get routineDays => 'Dias na rotina';

  @override
  String get resultingRoutine => 'Rotina resultante';

  @override
  String get newDay => 'Novo dia';

  @override
  String get newSet => 'Nova série';

  @override
  String get selectExercises =>
      'Se quiseres fazer um superset, podes procurar vários exercícios - eles serão agrupados';

  @override
  String get gymMode => 'Modo ginásio';

  @override
  String get plateCalculator => 'Discos';

  @override
  String get plateCalculatorNotDivisible =>
      'Não é possível atingir o peso com os discos disponíveis';

  @override
  String get pause => 'Pausa';

  @override
  String get jumpTo => 'Ir para';

  @override
  String get todaysWorkout => 'O teu treino de hoje';

  @override
  String get logHelpEntries =>
      'Se houver várias entradas no mesmo dia com o mesmo número de repetições mas pesos diferentes, só aparece no gráfico a de maior peso.';

  @override
  String get logHelpEntriesUnits =>
      'Apenas são mostradas entradas com unidade de peso (kg ou lb) e repetições, outras como tempo ou até falhar são ignoradas.';

  @override
  String get description => 'Descrição';

  @override
  String get name => 'Nome';

  @override
  String get save => 'Guardar';

  @override
  String get verify => 'Verificar';

  @override
  String get addSet => 'Adicionar série';

  @override
  String get addMeal => 'Adicionar refeição';

  @override
  String get mealLogged => 'Refeição registada no diário';

  @override
  String get ingredientLogged => 'Ingrediente registado no diário';

  @override
  String get logMeal => 'Registar refeição no diário nutricional';

  @override
  String get addIngredient => 'Adicionar ingrediente';

  @override
  String get logIngredient => 'Registar ingrediente no diário nutricional';

  @override
  String get searchIngredient => 'Procurar ingrediente';

  @override
  String get nutritionalPlan => 'Plano nutricional';

  @override
  String get nutritionalDiary => 'Diário nutricional';

  @override
  String get nutritionalPlans => 'Planos nutricionais';

  @override
  String get noNutritionalPlans => 'Ainda não tens planos nutricionais';

  @override
  String get onlyLogging => 'Registar apenas calorias';

  @override
  String get onlyLoggingHelpText =>
      'Marca esta opção se quiseres registar só as calorias, sem plano nutricional detalhado';

  @override
  String get goalMacro => 'Objetivos de macronutrientes';

  @override
  String get selectMealToLog => 'Seleciona uma refeição para registar no diário';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'O teu plano nutricional atual não tem refeições definidas';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Para adicionar refeições ao plano, vai aos detalhes do plano nutricional';

  @override
  String get goalEnergy => 'Objetivo energético';

  @override
  String get goalProtein => 'Objetivo de proteína';

  @override
  String get goalCarbohydrates => 'Objetivo de hidratos de carbono';

  @override
  String get goalFat => 'Objetivo de gordura';

  @override
  String get goalFiber => 'Objetivo de fibra';

  @override
  String get anErrorOccurred => 'Ocorreu um erro!';

  @override
  String get errorInfoDescription =>
      'Lamentamos, algo correu mal. Podes ajudar a corrigir isto ao reportar o problema no GitHub.';

  @override
  String get errorInfoDescription2 =>
      'Podes continuar a usar a app, mas algumas funcionalidades podem não funcionar.';

  @override
  String get errorViewDetails => 'Detalhes técnicos';

  @override
  String get applicationLogs => 'Registos da aplicação';

  @override
  String get errorCouldNotConnectToServer => 'Não foi possível ligar ao servidor';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'A aplicação não conseguiu ligar ao servidor. Verifica a ligação à internet ou o URL do servidor e tenta outra vez. Se continuar, contacta o administrador do servidor.';

  @override
  String get copyToClipboard => 'Copiar para a área de transferência';

  @override
  String get weight => 'Peso';

  @override
  String get min => 'Mín';

  @override
  String get max => 'Máx';

  @override
  String chartAllTimeTitle(String name) {
    return '$name total';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name últimos 30 dias';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName durante o plano nutricional $planName';
  }

  @override
  String get measurement => 'Medição';

  @override
  String get measurements => 'Medições';

  @override
  String get measurementCategoriesHelpText =>
      'Categoria de medição, como \'bíceps\' ou \'gordura corporal\'';

  @override
  String get measurementEntriesHelpText => 'Unidade usada para medir, como \'cm\' ou \'%\'';

  @override
  String get date => 'Data';

  @override
  String get endDate => 'Data de término';

  @override
  String get openEnded => 'Sem fim definido';

  @override
  String get value => 'Valor';

  @override
  String get start => 'Início';

  @override
  String get time => 'Hora';

  @override
  String get timeStart => 'Hora de início';

  @override
  String get timeEnd => 'Hora de fim';

  @override
  String get timeStartAhead => 'Hora de início não pode ser depois da hora de fim';

  @override
  String get ingredient => 'Ingrediente';

  @override
  String get energy => 'Energia';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutrientes';

  @override
  String get planned => 'Planeado';

  @override
  String get logged => 'Registado';

  @override
  String get today => 'Hoje';

  @override
  String get loggedToday => 'Registado hoje';

  @override
  String get weekAverage => 'Média de 7 dias';

  @override
  String get surplus => 'excedente';

  @override
  String get deficit => 'défice';

  @override
  String get difference => 'Diferença';

  @override
  String get percentEnergy => 'Percentagem da energia';

  @override
  String get gPerBodyKg => 'g por kg de corpo';

  @override
  String get total => 'Total';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Proteína';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Hidratos de carbono';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Açúcares';

  @override
  String get fat => 'Gordura';

  @override
  String get fatShort => 'F';

  @override
  String get saturatedFat => 'Gordura saturada';

  @override
  String get fiber => 'Fibras';

  @override
  String get sodium => 'Sódio';

  @override
  String get amount => 'Quantidade';

  @override
  String get unit => 'Unidade';

  @override
  String get newEntry => 'Nova entrada';

  @override
  String get noWeightEntries => 'Ainda não tens registos de peso';

  @override
  String get noMeasurementEntries => 'Ainda não tens registos de medições';

  @override
  String get moreMeasurementEntries => 'Adicionar nova medição';

  @override
  String get edit => 'Editar';

  @override
  String get loadingText => 'A carregar...';

  @override
  String get delete => 'Eliminar';

  @override
  String confirmDelete(String toDelete) {
    return 'Tens a certeza que queres eliminar \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Novo plano nutricional';

  @override
  String get toggleDetails => 'Mostrar detalhes';

  @override
  String get goToDetailPage => 'Ir para a página de detalhes';

  @override
  String get aboutWhySupportTitle => 'Código aberto e gratuito ❤️';

  @override
  String get aboutDescription =>
      'Obrigado por usares o wger! O wger é um projeto colaborativo de código aberto, feito por fãs de fitness de todo o mundo.';

  @override
  String get aboutDonateTitle => 'Fazer um donativo';

  @override
  String get aboutDonateText =>
      'Apesar de gratuito e assim continuará, manter o servidor tem custos! O desenvolvimento também exige muito tempo dos voluntários. A tua ajuda apoia diretamente estes custos.';

  @override
  String get aboutContributeTitle => 'Contribuir';

  @override
  String get aboutContributeText =>
      'Todos os tipos de contribuição são bem-vindos. Sejas programador, tradutor ou apenas apaixonado por fitness, toda a ajuda conta!';

  @override
  String get aboutBugsListTitle => 'Reportar um problema ou sugerir uma funcionalidade';

  @override
  String get aboutTranslationListTitle => 'Traduzir a aplicação';

  @override
  String get aboutSourceListTitle => 'Ver código-fonte';

  @override
  String get aboutJoinCommunityTitle => 'Junta-te à comunidade';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Outros';

  @override
  String get calendar => 'Calendário';

  @override
  String get goToToday => 'Ir para hoje';

  @override
  String get enterValue => 'Introduz um valor';

  @override
  String get selectEntry => 'Seleciona uma entrada';

  @override
  String get selectExercise => 'Seleciona um exercício';

  @override
  String enterCharacters(String min, String max) {
    return 'Escreve entre $min e $max caracteres';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Escreve pelo menos $min caracteres';
  }

  @override
  String get baseNameEnglish => 'Todos os exercícios precisam de nome base em inglês';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Séries por exercício: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Unidades de série e ReR';

  @override
  String get enterValidNumber => 'Introduz um número válido';

  @override
  String get selectIngredient => 'Seleciona um ingrediente';

  @override
  String get recentlyUsedIngredients => 'Ingredientes adicionados recentemente';

  @override
  String get selectImage => 'Seleciona uma imagem';

  @override
  String get optionsLabel => 'Opções';

  @override
  String get takePicture => 'Tirar foto';

  @override
  String get chooseFromLibrary => 'Escolher da galeria';

  @override
  String get gallery => 'Galeria';

  @override
  String get addImage => 'Adicionar imagem';

  @override
  String get dataCopied => 'Dados copiados para nova entrada';

  @override
  String get appUpdateTitle => 'Atualização necessária';

  @override
  String get appUpdateContent =>
      'Esta versão da aplicação não é compatível com o servidor. Por favor, atualiza a aplicação.';

  @override
  String get productFound => 'Produto encontrado';

  @override
  String productFoundDescription(String productName) {
    return 'O código de barras corresponde a este produto: $productName. Queres continuar?';
  }

  @override
  String get productNotFound => 'Produto não encontrado';

  @override
  String productNotFoundDescription(String barcode) {
    return 'O produto com o código $barcode não foi encontrado na base de dados wger';
  }

  @override
  String get scanBarcode => 'Ler código de barras';

  @override
  String get close => 'Fechar';

  @override
  String get add_exercise_image_license =>
      'Imagens têm de ser compatíveis com a licença CC BY SA. Se tiveres dúvidas, usa apenas fotos tiradas por ti.';

  @override
  String get variations => 'Variações';

  @override
  String alsoKnownAs(String aliases) {
    return 'Também conhecido como: $aliases';
  }

  @override
  String get verifiedEmail => 'E-mail verificado';

  @override
  String get unVerifiedEmail => 'E-mail não verificado';

  @override
  String get verifiedEmailReason =>
      'Tens de verificar o e-mail para poderes contribuir com exercícios';

  @override
  String verifiedEmailInfo(String email) {
    return 'Foi enviado um e-mail de verificação para $email';
  }

  @override
  String get alternativeNames => 'Nomes alternativos';

  @override
  String get oneNamePerLine => 'Um nome por linha';

  @override
  String get whatVariationsExist => 'Que variações deste exercício existem (se houver)?';

  @override
  String get previous => 'Anterior';

  @override
  String get next => 'Seguinte';

  @override
  String get images => 'Imagens';

  @override
  String get language => 'Idioma';

  @override
  String get addExercise => 'Adicionar exercício';

  @override
  String get fitInWeek => 'Ajustar à semana';

  @override
  String get fitInWeekHelp =>
      'Se ativado, os dias repetem-se semanalmente. Caso contrário, seguem-se em sequência sem respeitar o início da semana.';

  @override
  String get addSuperset => 'Adicionar Superset';

  @override
  String get setHasProgression => 'Série com progressão';

  @override
  String get setHasProgressionWarning =>
      'De momento não é possível editar todas as definições de uma série na app móvel ou configurar progressões automáticas. Usa a versão web.';

  @override
  String get setHasNoExercises => 'Esta série ainda não tem exercícios!';

  @override
  String get contributeExercise => 'Contribuir com um exercício';

  @override
  String get translation => 'Tradução';

  @override
  String get translateExercise => 'Traduz este exercício agora';

  @override
  String get baseData => 'Básico em inglês';

  @override
  String get settingsTitle => 'Definições';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Cache de exercícios';

  @override
  String get settingsIngredientCacheDescription => 'Cache de ingredientes';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache limpo com sucesso';

  @override
  String get aboutPageTitle => 'Sobre nós & Apoio';

  @override
  String contributeExerciseWarning(String days) {
    return 'Só podes contribuir com exercícios se a tua conta tiver mais de $days dias e e-mail verificado';
  }

  @override
  String get simpleMode => 'Modo simples';

  @override
  String get simpleModeHelp => 'Esconder opções mais avançadas ao editar exercícios';

  @override
  String get progressionRules =>
      'Este exercício tem regras de progressão e não pode ser editado na app. Usa a versão web para o editar.';

  @override
  String get cacheWarning =>
      'Por causa da cache, pode demorar um pouco até veres as alterações na app.';

  @override
  String get textPromptTitle => 'Pronto para começar?';

  @override
  String get textPromptSubheading => 'Clica no botão de ação para começar';

  @override
  String get abs => 'Abdominais';

  @override
  String get arms => 'Braços';

  @override
  String get back => 'Costas';

  @override
  String get barbell => 'Barra olímpica';

  @override
  String get bench => 'Banco';

  @override
  String get biceps => 'Bíceps';

  @override
  String get body_weight => 'Peso corporal';

  @override
  String get calves => 'Gémeos';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Peito';

  @override
  String get dumbbell => 'Halteres';

  @override
  String get glutes => 'Glúteos';

  @override
  String get gym_mat => 'Tapete de ginásio';

  @override
  String get hamstrings => 'Isquiotibiais';

  @override
  String get incline_bench => 'Banco inclinado';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Quilómetros';

  @override
  String get kilometers_per_hour => 'Km/h';

  @override
  String get lats => 'Dorsais';

  @override
  String get legs => 'Pernas';

  @override
  String get lower_back => 'Zona lombar';

  @override
  String get max_reps => 'Repetições máximas';

  @override
  String get miles => 'Milhas';

  @override
  String get miles_per_hour => 'Mi/h';

  @override
  String get minutes => 'Minutos';

  @override
  String get plates => 'Discos';

  @override
  String get pull_up_bar => 'Barra de elevações';

  @override
  String get quads => 'Quadríceps';

  @override
  String get repetitions => 'Repetições';

  @override
  String get resistance_band => 'Banda de resistência';

  @override
  String get sz_bar => 'Barra SZ';

  @override
  String get seconds => 'Segundos';

  @override
  String get shoulders => 'Ombros';

  @override
  String get swiss_ball => 'Bola suíça';

  @override
  String get triceps => 'Tríceps';

  @override
  String get until_failure => 'Até falhar';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'nenhum (exercício com peso corporal)';

  @override
  String get log => 'Registar';

  @override
  String get done => 'Concluído';

  @override
  String get overallChangeWeight => 'Alteração total';

  @override
  String get goalTypeMeals => 'Das refeições';

  @override
  String get goalTypeBasic => 'Básico';

  @override
  String get goalTypeAdvanced => 'Avançado';

  @override
  String get indicatorRaw => 'cru';

  @override
  String get indicatorAvg => 'média';

  @override
  String get themeMode => 'Modo de tema';

  @override
  String get darkMode => 'Modo escuro sempre';

  @override
  String get lightMode => 'Modo claro sempre';

  @override
  String get systemMode => 'Usar definições do sistema';
}
