// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Norwegian Bokmål (`nb`).
class AppLocalizationsNb extends AppLocalizations {
  AppLocalizationsNb([String locale = 'nb']) : super(locale);

  @override
  String get userProfile => 'Your profile';

  @override
  String get login => 'Logg inn';

  @override
  String get logout => 'Logg ut';

  @override
  String get register => 'Registrer';

  @override
  String get useDefaultServer => 'Bruk forvalgt tjener';

  @override
  String get useCustomServer => 'Bruk egendefinert tjener';

  @override
  String get invalidUrl => 'Skriv inn en gyldig nettadresse';

  @override
  String get usernameValidChars =>
      'A username may only contain letters, digits, and the characters @, +, ., -, and _';

  @override
  String get passwordsDontMatch => 'Passordene samsvarer ikke';

  @override
  String get passwordTooShort => 'Passordet er for kort';

  @override
  String get selectAvailablePlates => 'Select available plates';

  @override
  String get barWeight => 'Bar weight';

  @override
  String get useColors => 'Use colors';

  @override
  String get password => 'Passord';

  @override
  String get confirmPassword => 'Bekreft passord';

  @override
  String get invalidEmail => 'Skriv inn en gyldig e-postadresse';

  @override
  String get email => 'E-postadresse';

  @override
  String get username => 'Brukernavn';

  @override
  String get invalidUsername => 'Skriv inn et gyldig brukernavn';

  @override
  String get useApiToken => 'Use API Token';

  @override
  String get useUsernameAndPassword => 'Use username and password';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Please enter a valid API key';

  @override
  String get apiTokenValidChars =>
      'An API key may only contain the letters a-f, numbers 0-9 and be exactly 40 characters long';

  @override
  String get customServerUrl => 'Nettadresse til wger-instansen';

  @override
  String get customServerHint =>
      'Skriv inn adressen til din egen tjener, ellers vil den forvalgte brukes';

  @override
  String get reset => 'Tilbakestill';

  @override
  String get registerInstead => 'Registrer istedenfor';

  @override
  String get loginInstead => 'Logg inn istedenfor';

  @override
  String get labelBottomNavWorkout => 'Workout';

  @override
  String get labelBottomNavNutrition => 'Nutrition';

  @override
  String get labelWorkoutLogs => 'Treningslogger';

  @override
  String get labelWorkoutPlan => 'Trenkingsøktplan';

  @override
  String get labelDashboard => 'Oversikt';

  @override
  String get success => 'Success';

  @override
  String get successfullyDeleted => 'Slettet';

  @override
  String get successfullySaved => 'Lagret';

  @override
  String get exerciseList => 'Exercise list';

  @override
  String get exercise => 'Øvelse';

  @override
  String get exercises => 'Exercises';

  @override
  String get exerciseName => 'Exercise Name';

  @override
  String get searchExercise => 'Search exercise to add';

  @override
  String get noIngredientsDefined => 'No ingredients defined yet';

  @override
  String get noMatchingExerciseFound => 'No matching exercises found';

  @override
  String get searchNamesInEnglish => 'Also search for names in English';

  @override
  String get equipment => 'Utstyr';

  @override
  String get muscles => 'Muscles';

  @override
  String get musclesSecondary => 'Secondary muscles';

  @override
  String get category => 'Kategori';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => 'Routines';

  @override
  String get newRoutine => 'New routine';

  @override
  String get noRoutines => 'You have no routines';

  @override
  String get reps => 'Reps';

  @override
  String get restTime => 'Rest time';

  @override
  String get sets => 'Sets';

  @override
  String get rir => 'RiR';

  @override
  String get rirNotUsed => 'RiR not used';

  @override
  String get useMetric => 'Use metric units for body weight';

  @override
  String get weightUnit => 'Weight unit';

  @override
  String get repetitionUnit => 'Repetition unit';

  @override
  String get set => 'Set';

  @override
  String get dayDescriptionHelp =>
      'A description of what is done on this day (e.g. \'pull day\') or what body parts are trained (e.g. \'chest and shoulders\')';

  @override
  String exerciseNr(String nr) {
    return 'Exercise $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'If you do the same repetitions and weight for all sets you can just fill in one row. For example for 4 sets just enter 10 for the repetitions, this automatically becomes \"4 x 10\".';

  @override
  String get comment => 'Kommentar';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Inntrykk';

  @override
  String get notes => 'Notater';

  @override
  String get workoutSession => 'Treningsøkt';

  @override
  String get restDay => 'Rest day';

  @override
  String get isRestDay => 'Is rest day';

  @override
  String get isRestDayHelp =>
      'Please note that all sets and exercises will be removed when you mark a day as a rest day.';

  @override
  String get needsLogsToAdvance => 'Needs logs to advance';

  @override
  String get needsLogsToAdvanceHelp =>
      'Select if you want the routine to progress to the next scheduled day only if you\'ve logged a workout for the day';

  @override
  String get routineDays => 'Days in routine';

  @override
  String get resultingRoutine => 'Resulting routine';

  @override
  String get newDay => 'Ny dag';

  @override
  String get newSet => 'Nytt sett';

  @override
  String get selectExercises =>
      'If you want to do a superset you can search for several exercises, they will be grouped together';

  @override
  String get gymMode => 'Helsestudio-modus';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Plates';

  @override
  String get plateCalculatorNotDivisible => 'Not possible to reach weight with available plates';

  @override
  String get pause => 'Pause';

  @override
  String get jumpTo => 'Jump to';

  @override
  String get todaysWorkout => 'Your workout today';

  @override
  String get logHelpEntries =>
      'Kun tyngre vekt vises hvis én dag har forskjellige vekter med samme antall repetisjoner.';

  @override
  String get logHelpEntriesUnits => 'Kun oppføringer med vekt vises, ingen andre kombinasjoner.';

  @override
  String get description => 'Beskrivelse';

  @override
  String get name => 'Name';

  @override
  String get save => 'Lagre';

  @override
  String get verify => 'Verify';

  @override
  String get addSet => 'Add set';

  @override
  String get addMeal => 'Legg til måltid';

  @override
  String get mealLogged => 'Måltid lagt til i dagbok';

  @override
  String get ingredientLogged => 'Ingredient logged to diary';

  @override
  String get logMeal => 'Log meal to nutrition diary';

  @override
  String get addIngredient => 'Legg til ingrediens';

  @override
  String get logIngredient => 'Log ingredient to nutrition diary';

  @override
  String get searchIngredient => 'Search ingredient';

  @override
  String get nutritionalPlan => 'Ernæringsplan';

  @override
  String get nutritionalDiary => 'Ernæringsdagbok';

  @override
  String get nutritionalPlans => 'Ernæringsplaner';

  @override
  String get noNutritionalPlans => 'You have no nutritional plans';

  @override
  String get onlyLogging => 'Only track calories';

  @override
  String get onlyLoggingHelpText =>
      'Check the box if you only want to log your calories and don\'t want to setup a detailed nutritional plan with specific meals';

  @override
  String get goalMacro => 'Macro goals';

  @override
  String get selectMealToLog => 'Select a meal to log to diary';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Your current nutrition plan has no meals defined';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'To add meals to the plan, go to the nutritional plan details';

  @override
  String get goalEnergy => 'Energy goal';

  @override
  String get goalProtein => 'Protein goal';

  @override
  String get goalCarbohydrates => 'Carbohydrates goal';

  @override
  String get goalFat => 'Fat goal';

  @override
  String get goalFiber => 'Fiber goal';

  @override
  String get anErrorOccurred => 'En feil inntraff.';

  @override
  String get errorInfoDescription =>
      'We\'re sorry, but something went wrong. You can help us fix this by reporting the issue on GitHub.';

  @override
  String get errorInfoDescription2 =>
      'You can continue using the app, but some features may not work.';

  @override
  String get errorViewDetails => 'Technical details';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Couldn\'t connect to server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'The application could not connect to the server. Please check your internet connection or the server URL and try again. If the problem persists, contact the server administrator.';

  @override
  String get copyToClipboard => 'Kopier til utklippstavlen';

  @override
  String get weight => 'Vekt';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name all-time';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name last 30 days';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName during nutritional plan $planName';
  }

  @override
  String get measurement => 'Measurement';

  @override
  String get measurements => 'Measurements';

  @override
  String get measurementCategoriesHelpText =>
      'Measurement category, such as \'biceps\' or \'body fat\'';

  @override
  String get measurementEntriesHelpText =>
      'The unit used to measure the category such as \'cm\' or \'%\'';

  @override
  String get date => 'Dato';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'Verdi';

  @override
  String get start => 'Start';

  @override
  String get time => 'Tid';

  @override
  String get timeStart => 'Starttid';

  @override
  String get timeEnd => 'Slutt-tid';

  @override
  String get timeStartAhead => 'Start time cannot be ahead of end time';

  @override
  String get ingredient => 'Ingrediens';

  @override
  String get energy => 'Energi';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutrients';

  @override
  String get planned => 'Planned';

  @override
  String get logged => 'Logged';

  @override
  String get today => 'Today';

  @override
  String get loggedToday => 'Logged today';

  @override
  String get weekAverage => '7 day average';

  @override
  String get surplus => 'surplus';

  @override
  String get deficit => 'deficit';

  @override
  String get difference => 'Forskjell';

  @override
  String get percentEnergy => 'Percent of energy';

  @override
  String get gPerBodyKg => 'g per body kg';

  @override
  String get total => 'Total';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'KJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Protein';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Karbohydrater';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Sukkerarter';

  @override
  String get fat => 'Fett';

  @override
  String get fatShort => 'F';

  @override
  String get saturatedFat => 'Mettet fett';

  @override
  String get fiber => 'Fiber';

  @override
  String get sodium => 'Salt';

  @override
  String get amount => 'Mengde';

  @override
  String get unit => 'Enhet';

  @override
  String get newEntry => 'Ny oppføring';

  @override
  String get noWeightEntries => 'Du har ingen vektoppføringer';

  @override
  String get noMeasurementEntries => 'You have no measurement entries';

  @override
  String get moreMeasurementEntries => 'Add new measurement';

  @override
  String get edit => 'Rediger';

  @override
  String get loadingText => 'Laster…';

  @override
  String get delete => 'Slett';

  @override
  String confirmDelete(String toDelete) {
    return 'Are you sure you want to delete \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Ny ernæringsplan';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'Veksle detaljer';

  @override
  String get goToDetailPage => 'Go to detail page';

  @override
  String get aboutWhySupportTitle => 'Open Source & free to use ❤️';

  @override
  String get aboutDescription =>
      'Thank you for using wger! wger is a collaborative open source project, made by fitness enthusiasts from around the world.';

  @override
  String get aboutDonateTitle => 'Make a donation';

  @override
  String get aboutDonateText =>
      'While the project is free and will always remain it, running the server isn’t! Development also takes significant time and effort from volunteers. Your contribution directly supports these costs, helping to keep the service reliable.';

  @override
  String get aboutContributeTitle => 'Contribute';

  @override
  String get aboutContributeText =>
      'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!';

  @override
  String get aboutBugsListTitle => 'Report a problem or suggest a feature';

  @override
  String get aboutTranslationListTitle => 'Translate the application';

  @override
  String get aboutSourceListTitle => 'View source code';

  @override
  String get aboutJoinCommunityTitle => 'Join the community';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Others';

  @override
  String get calendar => 'Kalender';

  @override
  String get goToToday => 'Gå til dagens dato';

  @override
  String get enterValue => 'Skriv inn en verdi';

  @override
  String get selectEntry => 'Please select an entry';

  @override
  String get selectExercise => 'Please select an exercise';

  @override
  String enterCharacters(String min, String max) {
    return 'Please enter between $min and $max characters';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Please enter at least $min characters';
  }

  @override
  String get baseNameEnglish => 'All exercises need a base name in English';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Sets per exercise: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Set units and RiR';

  @override
  String get enterValidNumber => 'Skriv inn et gyldig nummer';

  @override
  String get selectIngredient => 'Velg en ingrediens';

  @override
  String get recentlyUsedIngredients => 'Recently added ingredients';

  @override
  String get selectImage => 'Please select an image';

  @override
  String get optionsLabel => 'Options';

  @override
  String get takePicture => 'Take a picture';

  @override
  String get chooseFromLibrary => 'Choose from photo library';

  @override
  String get gallery => 'Gallery';

  @override
  String get addImage => 'Add image';

  @override
  String get dataCopied => 'Data copied to new entry';

  @override
  String get appUpdateTitle => 'Update needed';

  @override
  String get appUpdateContent =>
      'This version of the app is not compatible with the server, please update your application.';

  @override
  String get productFound => 'Product found';

  @override
  String productFoundDescription(String productName) {
    return 'The barcode corresponds to this product: $productName. Do you want to continue?';
  }

  @override
  String get productNotFound => 'Product not found';

  @override
  String productNotFoundDescription(String barcode) {
    return 'The product with the scanned barcode $barcode was not found in the wger database';
  }

  @override
  String get scanBarcode => 'Scan barcode';

  @override
  String get close => 'Close';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'Images must be compatible with the CC BY SA license. If in doubt, upload only photos you\'ve taken yourself.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'Legg til';

  @override
  String get variations => 'Variations';

  @override
  String alsoKnownAs(String aliases) {
    return 'Also known as: $aliases';
  }

  @override
  String get verifiedEmail => 'Verified email';

  @override
  String get unVerifiedEmail => 'Unverified email';

  @override
  String get verifiedEmailReason => 'You need to verify your email to contribute exercises';

  @override
  String verifiedEmailInfo(String email) {
    return 'A verification email was sent to $email';
  }

  @override
  String get alternativeNames => 'Alternative names';

  @override
  String get oneNamePerLine => 'One name per line';

  @override
  String get whatVariationsExist => 'What variations of this exercise exist, if any?';

  @override
  String get previous => 'Previous';

  @override
  String get next => 'Next';

  @override
  String get images => 'Images';

  @override
  String get language => 'Language';

  @override
  String get addExercise => 'Add exercise';

  @override
  String get fitInWeek => 'Fit in week';

  @override
  String get fitInWeekHelp =>
      'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.';

  @override
  String get addSuperset => 'Add superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set has progression';

  @override
  String get setHasProgressionWarning =>
      'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.';

  @override
  String get setHasNoExercises => 'This set has no exercises yet!';

  @override
  String get contributeExercise => 'Contribute an exercise';

  @override
  String get translation => 'Translation';

  @override
  String get translateExercise => 'Translate this exercise now';

  @override
  String get baseData => 'Basics in English';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Settings';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Exercise cache';

  @override
  String get settingsIngredientCacheDescription => 'Ingredient cache';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache successfully cleared';

  @override
  String get aboutPageTitle => 'About us & Support';

  @override
  String contributeExerciseWarning(String days) {
    return 'You can only contribute exercises if your account is older than $days days and have verified your email';
  }

  @override
  String get simpleMode => 'Simple mode';

  @override
  String get simpleModeHelp => 'Hide some of the more advanced settings when editing exercises';

  @override
  String get progressionRules =>
      'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.';

  @override
  String get cacheWarning =>
      'Due to caching it might take some time till the changes are visible throughout the application.';

  @override
  String get textPromptTitle => 'Ready to start?';

  @override
  String get textPromptSubheading => 'Press the action button to begin';

  @override
  String get abs => 'Abs';

  @override
  String get arms => 'Arms';

  @override
  String get back => 'Back';

  @override
  String get barbell => 'Barbell';

  @override
  String get bench => 'Bench';

  @override
  String get biceps => 'Biceps';

  @override
  String get body_weight => 'Body Weight';

  @override
  String get calves => 'Calves';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Chest';

  @override
  String get dumbbell => 'Dumbbell';

  @override
  String get glutes => 'Glutes';

  @override
  String get gym_mat => 'Gym mat';

  @override
  String get hamstrings => 'Hamstrings';

  @override
  String get incline_bench => 'Incline bench';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Kilometers';

  @override
  String get kilometers_per_hour => 'Kilometers Per Hour';

  @override
  String get lats => 'Lats';

  @override
  String get legs => 'Legs';

  @override
  String get lower_back => 'Lower back';

  @override
  String get max_reps => 'Max Reps';

  @override
  String get miles => 'Miles';

  @override
  String get miles_per_hour => 'Miles Per Hour';

  @override
  String get minutes => 'Minutes';

  @override
  String get plates => 'Plates';

  @override
  String get pull_up_bar => 'Pull-up bar';

  @override
  String get quads => 'Quads';

  @override
  String get repetitions => 'Gjentagelser';

  @override
  String get resistance_band => 'Resistance band';

  @override
  String get sz_bar => 'SZ-Bar';

  @override
  String get seconds => 'Seconds';

  @override
  String get shoulders => 'Shoulders';

  @override
  String get swiss_ball => 'Swiss Ball';

  @override
  String get triceps => 'Triceps';

  @override
  String get until_failure => 'Until Failure';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'none (bodyweight exercise)';

  @override
  String get log => 'Log';

  @override
  String get done => 'Done';

  @override
  String get overallChangeWeight => 'Overall change';

  @override
  String get goalTypeMeals => 'From meals';

  @override
  String get goalTypeBasic => 'Basic';

  @override
  String get goalTypeAdvanced => 'Advanced';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'avg';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Theme mode';

  @override
  String get darkMode => 'Always dark mode';

  @override
  String get lightMode => 'Always light mode';

  @override
  String get systemMode => 'System settings';
}
