// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Korean (`ko`).
class AppLocalizationsKo extends AppLocalizations {
  AppLocalizationsKo([String locale = 'ko']) : super(locale);

  @override
  String get userProfile => '환경설정';

  @override
  String get login => '로그인';

  @override
  String get logout => '로그아웃';

  @override
  String get register => '등록';

  @override
  String get useDefaultServer => '기본 서버 정보';

  @override
  String get useCustomServer => '커스텀 서버 정보';

  @override
  String get invalidUrl => '올바른 URL 정보를 입력하세요';

  @override
  String get usernameValidChars => '사용자명은 문자, 숫자, \'@, +, ., -, _\' 만 가능합니다';

  @override
  String get passwordsDontMatch => '비밀번호가 불일치 합니다';

  @override
  String get passwordTooShort => '비밀번호가 너무 짧습니다';

  @override
  String get selectAvailablePlates => '사용 가능한 플레이트 선택';

  @override
  String get barWeight => '바 무게';

  @override
  String get useColors => '색상 사용';

  @override
  String get password => '비밀번호';

  @override
  String get confirmPassword => '비밀번호 확인';

  @override
  String get invalidEmail => '올바른 이메일 주소를 입력하세요';

  @override
  String get email => '이메일 주소';

  @override
  String get username => '사용자명';

  @override
  String get invalidUsername => '올바른 사용자명을 입력하세요';

  @override
  String get useApiToken => 'API 토큰값 사용';

  @override
  String get useUsernameAndPassword => '사용자명, 비밀번호 사용';

  @override
  String get apiToken => 'API 토큰값';

  @override
  String get invalidApiToken => '올바른 API 토큰값을 입력하세요';

  @override
  String get apiTokenValidChars => 'API 키값은 영소문자(a-f), 숫자(0-9), 40자 이어야 합니다';

  @override
  String get customServerUrl => 'wger 인스턴스의 URL';

  @override
  String get customServerHint => '서버 주소를 입력하세요 미입력시 기본 주소가 사용됩니다';

  @override
  String get reset => '초기화';

  @override
  String get registerInstead => '계정이 없나요? 지금 등록하세요';

  @override
  String get loginInstead => '이미 계정이 있으신가요? 로그인하세요';

  @override
  String get labelBottomNavWorkout => '운동';

  @override
  String get labelBottomNavNutrition => '영양물 섭취';

  @override
  String get labelWorkoutLogs => '트레이닝 이력';

  @override
  String get labelWorkoutPlan => '운동 계획';

  @override
  String get labelDashboard => '대시보드';

  @override
  String get success => '성공';

  @override
  String get successfullyDeleted => '삭제';

  @override
  String get successfullySaved => '저장';

  @override
  String get exerciseList => '예시 목록';

  @override
  String get exercise => '예시';

  @override
  String get exercises => '운동';

  @override
  String get exerciseName => '예시명';

  @override
  String get searchExercise => '추가할 예시 검색';

  @override
  String get noIngredientsDefined => '아직 정의된 성분이 없어요';

  @override
  String get noMatchingExerciseFound => '예시를 찾을 수 없어요';

  @override
  String get searchNamesInEnglish => '영어 이름도 검색해 보세요';

  @override
  String get equipment => '장비';

  @override
  String get muscles => '근육';

  @override
  String get musclesSecondary => '이차 근육';

  @override
  String get category => '카테고리';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => '루틴';

  @override
  String get newRoutine => '새로운 루틴';

  @override
  String get noRoutines => '루틴이 없어요';

  @override
  String get reps => '랩스';

  @override
  String get restTime => '휴식 시간';

  @override
  String get sets => '세트';

  @override
  String get rir => 'RiR';

  @override
  String get rirNotUsed => 'RiR 미사용';

  @override
  String get useMetric => '체중에는 미터법 단위를 사용하세요';

  @override
  String get weightUnit => '체중';

  @override
  String get repetitionUnit => '반복단위';

  @override
  String get set => '세트';

  @override
  String get dayDescriptionHelp =>
      '이 날에 무엇을 하는지에 대한 설명(예: \'풀 데이\') 또는 어떤 신체 부위를 훈련하는지에 대한 설명(예: \'가슴과 어깨\')';

  @override
  String exerciseNr(String nr) {
    return '예시 $nr';
  }

  @override
  String supersetNr(String nr) {
    return '슈퍼세트 $nr';
  }

  @override
  String get sameRepetitions =>
      '모든 세트에 동일한 반복 횟수와 중량을 적용하는 경우 한 줄만 입력하면 됩니다. 예를 들어 4세트를 하는 경우 반복 횟수에 10을 입력하면 자동으로 \"4 x 10\"이 됩니다.';

  @override
  String get comment => '댓글';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => '인상';

  @override
  String get notes => '메모';

  @override
  String get workoutSession => '운동 세션';

  @override
  String get restDay => '휴일';

  @override
  String get isRestDay => '쉬는 날인가';

  @override
  String get isRestDayHelp => '휴식일로 표시하면 모든 세트와 운동이 삭제됩니다.';

  @override
  String get needsLogsToAdvance => '진행하려면 로그가 필요합니다';

  @override
  String get needsLogsToAdvanceHelp => '운동을 기록한 경우에만 다음 예정된 날짜로 루틴을 진행하려면 선택하십시오';

  @override
  String get routineDays => '일상적인 루틴';

  @override
  String get resultingRoutine => '결과 루틴';

  @override
  String get newDay => '새로운 날';

  @override
  String get newSet => '새 세트';

  @override
  String get selectExercises => '슈퍼세트를 하고 싶다면 여러 운동을 검색하면 운동이 그룹화됩니다';

  @override
  String get gymMode => '체육관 모드';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => '플레이트';

  @override
  String get plateCalculatorNotDivisible => '사용 가능한 플레이트로는 무게에 도달할 수 없습니다';

  @override
  String get pause => '중지';

  @override
  String get jumpTo => '다음으로 이동';

  @override
  String get todaysWorkout => '오늘 운동';

  @override
  String get logHelpEntries =>
      '같은 날에 반복 횟수는 같지만 가중치가 다른 항목이 두 개 이상 있는 경우 다이어그램에는 가중치가 더 높은 항목만 표시됩니다.';

  @override
  String get logHelpEntriesUnits =>
      '무게 단위(kg 또는 lb)와 반복 횟수가 있는 항목만 차트에 표시되며, 시간이나 실패할 때까지의 시간 등의 다른 조합은 여기서는 무시됩니다.';

  @override
  String get description => '설명';

  @override
  String get name => '이름';

  @override
  String get save => '저장';

  @override
  String get verify => '확인';

  @override
  String get addSet => '세트 추가';

  @override
  String get addMeal => '식사 추가';

  @override
  String get mealLogged => '식사 기록이 일기에 기록됨';

  @override
  String get ingredientLogged => '일기에 기록된 재료';

  @override
  String get logMeal => '영양 일지에 식사 기록하기';

  @override
  String get addIngredient => '성분 추가';

  @override
  String get logIngredient => '영양 일지에 재료 기록하기';

  @override
  String get searchIngredient => '성분 검색';

  @override
  String get nutritionalPlan => '영양 계획';

  @override
  String get nutritionalDiary => '영양 일기';

  @override
  String get nutritionalPlans => '영양 계획';

  @override
  String get noNutritionalPlans => '영양 계획이 없습니다';

  @override
  String get onlyLogging => '칼로리만 추적 가능합니다';

  @override
  String get onlyLoggingHelpText => '칼로리만 기록하고 특정 식사에 대한 자세한 영양 계획을 세우고 싶지 않은 경우 상자를 체크하세요';

  @override
  String get goalMacro => '거시적 목표';

  @override
  String get selectMealToLog => '일기에 기록할 식사를 선택하세요';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Your current nutrition plan has no meals defined';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'To add meals to the plan, go to the nutritional plan details';

  @override
  String get goalEnergy => '에너지 목표';

  @override
  String get goalProtein => '단백질 목표';

  @override
  String get goalCarbohydrates => '탄수화물 목표';

  @override
  String get goalFat => '지방 목표';

  @override
  String get goalFiber => '섬유질 목표';

  @override
  String get anErrorOccurred => '오류가 발생했습니다!';

  @override
  String get errorInfoDescription => '죄송합니다. 문제가 발생했습니다. GitHub에 문제를 신고해 주시면 문제 해결에 도움이 됩니다.';

  @override
  String get errorInfoDescription2 => '앱을 계속 사용할 수 있지만 일부 기능이 작동하지 않을 수 있습니다.';

  @override
  String get errorViewDetails => '기술적인 세부사항';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => '서버에 연결할 수 없습니다';

  @override
  String get errorCouldNotConnectToServerDetails =>
      '애플리케이션이 서버에 연결할 수 없습니다. 인터넷 연결이나 서버 URL을 확인하고 다시 시도해 주세요. 문제가 지속되면 서버 관리자에게 문의하세요.';

  @override
  String get copyToClipboard => '클립보드에 복사';

  @override
  String get weight => '체중';

  @override
  String get min => '최소';

  @override
  String get max => '최대';

  @override
  String chartAllTimeTitle(String name) {
    return '$name 역대';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name 지난 30일';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName 영양 계획 $planName 중';
  }

  @override
  String get measurement => '측정';

  @override
  String get measurements => '측정';

  @override
  String get measurementCategoriesHelpText => '\'이두근\'이나 \'체지방\'과 같은 측정 범주';

  @override
  String get measurementEntriesHelpText => '\'cm\' 또는 \'%\'와 같이 범주를 측정하는 데 사용되는 단위';

  @override
  String get date => '일자';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => '값';

  @override
  String get start => '시작';

  @override
  String get time => '시간';

  @override
  String get timeStart => '시작 시간';

  @override
  String get timeEnd => '종료 시간';

  @override
  String get timeStartAhead => '시작 시간은 종료 시간보다 앞설 수 없습니다';

  @override
  String get ingredient => '재료';

  @override
  String get energy => '에너지';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => '다량 영양소';

  @override
  String get planned => '예정';

  @override
  String get logged => '기록됨';

  @override
  String get today => '오늘';

  @override
  String get loggedToday => '오늘 기록';

  @override
  String get weekAverage => '7일 평균';

  @override
  String get surplus => '여분';

  @override
  String get deficit => '부족';

  @override
  String get difference => '차이점';

  @override
  String get percentEnergy => '에너지 비율';

  @override
  String get gPerBodyKg => 'g 몸당 kg';

  @override
  String get total => '총';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => '단백질';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => '탄수화물';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => '설탕';

  @override
  String get fat => '지방';

  @override
  String get fatShort => 'F';

  @override
  String get saturatedFat => '포화지방';

  @override
  String get fiber => '섬유질';

  @override
  String get sodium => '나트륨';

  @override
  String get amount => '양';

  @override
  String get unit => '단위';

  @override
  String get newEntry => '신규 항목';

  @override
  String get noWeightEntries => '무게 항목이 없습니다';

  @override
  String get noMeasurementEntries => '측정 항목이 없습니다';

  @override
  String get moreMeasurementEntries => '새 측정 추가';

  @override
  String get edit => '편집';

  @override
  String get loadingText => '로딩...';

  @override
  String get delete => '삭제';

  @override
  String confirmDelete(String toDelete) {
    return '\'$toDelete\'을 삭제하시겠습니까?';
  }

  @override
  String get newNutritionalPlan => '새로운 영양 계획';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => '세부정보 전환';

  @override
  String get goToDetailPage => '상세페이지로 이동';

  @override
  String get aboutWhySupportTitle => '오픈 소스 & 무료로 사용 가능 ❤️';

  @override
  String get aboutDescription => 'wger를 이용해 주셔서 감사합니다! wger는 전 세계 피트니스 애호가들이 만든 협업 오픈 소스 프로젝트입니다.';

  @override
  String get aboutDonateTitle => '기부하기';

  @override
  String get aboutDonateText =>
      '이 프로젝트는 무료이며 앞으로도 계속 무료일 것이지만, 서버 운영은 그렇지 않습니다! 개발에는 자원봉사자들의 상당한 시간과 노력이 필요합니다. 여러분의 기부는 이러한 비용을 직접적으로 지원하여 서비스의 안정성을 유지하는 데 도움이 됩니다.';

  @override
  String get aboutContributeTitle => '기여하다';

  @override
  String get aboutContributeText =>
      '모든 유형의 기여를 환영합니다. 개발자, 번역가, 또는 단순히 피트니스에 열정이 있는 분이라면 누구든 환영합니다!';

  @override
  String get aboutBugsListTitle => '문제를 보고하거나 기능을 제안하세요';

  @override
  String get aboutTranslationListTitle => '어플리케이션 번역';

  @override
  String get aboutSourceListTitle => '소스코드 보기';

  @override
  String get aboutJoinCommunityTitle => '커뮤니티에 가입하세요';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => '기타';

  @override
  String get calendar => '달력';

  @override
  String get goToToday => '오늘로 이동';

  @override
  String get enterValue => '값을 입력하세요';

  @override
  String get selectEntry => '항목을 선택하세요';

  @override
  String get selectExercise => '운동을 선택해주세요';

  @override
  String enterCharacters(String min, String max) {
    return '$min~$max자 사이로 입력해 주세요';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return '최소 $min자 이상 입력해주세요';
  }

  @override
  String get baseNameEnglish => '모든 운동에는 영어로 된 기본 이름이 필요합니다';

  @override
  String nrOfSets(String nrOfSets) {
    return '운동당 세트: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => '단위 및 RiR 설정';

  @override
  String get enterValidNumber => '유효한 숫자를 입력하세요';

  @override
  String get selectIngredient => '성분을 선택해주세요';

  @override
  String get recentlyUsedIngredients => '최근 추가된 성분';

  @override
  String get selectImage => '이미지를 선택하세요';

  @override
  String get optionsLabel => '옵션';

  @override
  String get takePicture => '사진을 찍으세요';

  @override
  String get chooseFromLibrary => '사진 라이브러리에서 선택';

  @override
  String get gallery => '갤러리';

  @override
  String get addImage => '이미지 추가';

  @override
  String get dataCopied => '새 항목에 데이터가 복사되었습니다';

  @override
  String get appUpdateTitle => '업데이트 필요';

  @override
  String get appUpdateContent => '이 버전의 앱은 서버와 호환되지 않습니다. 애플리케이션을 업데이트하세요.';

  @override
  String get productFound => '제품 발견';

  @override
  String productFoundDescription(String productName) {
    return '바코드는 $productName 제품에 해당합니다. 계속하시겠습니까?';
  }

  @override
  String get productNotFound => '제품을 찾을 수 없습니다';

  @override
  String productNotFoundDescription(String barcode) {
    return '스캔된 바코드 $barcode가 있는 제품을 wger 데이터베이스에서 찾을 수 없습니다';
  }

  @override
  String get scanBarcode => '바코드 스캔';

  @override
  String get close => '닫기';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      '이미지는 CC BY SA 라이선스를 준수해야 합니다. 확실하지 않은 경우 직접 촬영한 사진만 업로드하세요.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => '변형';

  @override
  String alsoKnownAs(String aliases) {
    return '별칭으로도 알려짐: $aliases';
  }

  @override
  String get verifiedEmail => '확인된 이메일';

  @override
  String get unVerifiedEmail => '확인되지 않은 이메일';

  @override
  String get verifiedEmailReason => '연습문제에 참여하려면 이메일을 확인해야 합니다';

  @override
  String verifiedEmailInfo(String email) {
    return '$email로 확인 이메일이 전송되었습니다';
  }

  @override
  String get alternativeNames => '대체 이름';

  @override
  String get oneNamePerLine => '한 줄에 하나의 이름';

  @override
  String get whatVariationsExist => '이 운동에는 어떤 변형이 있나요?';

  @override
  String get previous => '이전';

  @override
  String get next => '다음';

  @override
  String get images => '이미지';

  @override
  String get language => '언어';

  @override
  String get addExercise => '운동 추가';

  @override
  String get fitInWeek => '일주일에 맞춰';

  @override
  String get fitInWeekHelp =>
      '이 기능을 활성화하면 요일이 주 단위로 반복되고, 활성화하지 않으면 새로운 주가 시작되는지 여부와 관계없이 요일이 순차적으로 반복됩니다.';

  @override
  String get addSuperset => '슈퍼세트 추가';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => '세트 진행 상황';

  @override
  String get setHasProgressionWarning =>
      '현재 모바일 앱에서는 세트의 모든 설정을 편집하거나 자동 진행을 설정할 수 없습니다. 당분간은 웹 앱을 이용해 주세요.';

  @override
  String get setHasNoExercises => '이 세트에는 아직 운동이 없습니다!';

  @override
  String get contributeExercise => '운동에 기여하다';

  @override
  String get translation => '번역';

  @override
  String get translateExercise => '지금 이 운동을 번역하세요';

  @override
  String get baseData => '영어를 기본으로';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => '설정';

  @override
  String get settingsCacheTitle => '캐쉬';

  @override
  String get settingsExerciseCacheDescription => '운동 캐시';

  @override
  String get settingsIngredientCacheDescription => '재료 캐시';

  @override
  String get settingsCacheDeletedSnackbar => '캐시가 성공적으로 지워졌습니다';

  @override
  String get aboutPageTitle => '회사 소개 및 지원';

  @override
  String contributeExerciseWarning(String days) {
    return '계정이 $days일 이상 경과하고 이메일을 인증한 경우에만 운동에 참여할 수 있습니다';
  }

  @override
  String get simpleMode => '단순 모드';

  @override
  String get simpleModeHelp => '운동 편집 시 고급 설정 중 일부를 숨깁니다';

  @override
  String get progressionRules => '이 운동에는 진행 규칙이 있으며 모바일 앱에서는 편집할 수 없습니다. 웹 애플리케이션을 사용하여 연습을 편집하세요.';

  @override
  String get cacheWarning => '캐싱으로 인해 변경 사항이 애플리케이션 전체에 표시될 때까지 시간이 걸릴 수 있습니다.';

  @override
  String get textPromptTitle => '시작할 준비가 되셨나요?';

  @override
  String get textPromptSubheading => '시작하려면 작업 버튼을 누르세요';

  @override
  String get abs => '복근';

  @override
  String get arms => '팔';

  @override
  String get back => '뒤로';

  @override
  String get barbell => '바벨';

  @override
  String get bench => '벤치프레스';

  @override
  String get biceps => '이두근';

  @override
  String get body_weight => '체중';

  @override
  String get calves => '장딴지';

  @override
  String get cardio => '심장강화';

  @override
  String get chest => '가슴';

  @override
  String get dumbbell => '덤벨';

  @override
  String get glutes => '엉덩이';

  @override
  String get gym_mat => '체육관 매트';

  @override
  String get hamstrings => '햄스트링';

  @override
  String get incline_bench => '인클라인 벤치';

  @override
  String get kettlebell => '케틀벨';

  @override
  String get kilometers => '킬로미터';

  @override
  String get kilometers_per_hour => 'km/h';

  @override
  String get lats => 'Lats';

  @override
  String get legs => '다리';

  @override
  String get lower_back => '허리 아래';

  @override
  String get max_reps => '최대 랩스';

  @override
  String get miles => '마일스';

  @override
  String get miles_per_hour => 'mi/h';

  @override
  String get minutes => '분';

  @override
  String get plates => '플레이트';

  @override
  String get pull_up_bar => '풀업 바';

  @override
  String get quads => '쿼드';

  @override
  String get repetitions => '반복';

  @override
  String get resistance_band => '저항밴드';

  @override
  String get sz_bar => 'SZ-바';

  @override
  String get seconds => '초';

  @override
  String get shoulders => '어깨';

  @override
  String get swiss_ball => '스위스볼';

  @override
  String get triceps => '삼두근';

  @override
  String get until_failure => '실패할 때까지';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => '없음(체중 운동)';

  @override
  String get log => '로그';

  @override
  String get done => '완료';

  @override
  String get overallChangeWeight => '전반적인 변화';

  @override
  String get goalTypeMeals => '식사부터';

  @override
  String get goalTypeBasic => '기본';

  @override
  String get goalTypeAdvanced => '고급';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => '평균';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => '테마 모드';

  @override
  String get darkMode => '항상 다크 모드';

  @override
  String get lightMode => '항상 라이트 모드';

  @override
  String get systemMode => '시스템 설정';
}
