// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Italian (`it`).
class AppLocalizationsIt extends AppLocalizations {
  AppLocalizationsIt([String locale = 'it']) : super(locale);

  @override
  String get userProfile => 'Il tuo profilo';

  @override
  String get login => 'Entra';

  @override
  String get logout => 'Disconnetti';

  @override
  String get register => 'Registrati';

  @override
  String get useDefaultServer => 'Usa il server predefinito';

  @override
  String get useCustomServer => 'Usa un server personale';

  @override
  String get invalidUrl => 'Inserisci un URL valido';

  @override
  String get usernameValidChars =>
      'Un nome utente può contenere solo lettere, cifre e i caratteri @, +, ., - e _';

  @override
  String get passwordsDontMatch => 'Le passwords non coincidono';

  @override
  String get passwordTooShort => 'La password è troppo corta';

  @override
  String get selectAvailablePlates => 'Seleziona i piatti disponibili';

  @override
  String get barWeight => 'Peso della barra';

  @override
  String get useColors => 'Usa colori';

  @override
  String get password => 'Password';

  @override
  String get confirmPassword => 'Conferma password';

  @override
  String get invalidEmail => 'Inserisci un indirizzo e-mail valido';

  @override
  String get email => 'Indirizzo e-mail';

  @override
  String get username => 'Nome utente';

  @override
  String get invalidUsername => 'Inserisci un nome utente valido';

  @override
  String get useApiToken => 'Usa il Token API';

  @override
  String get useUsernameAndPassword => 'Usa username e password';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Per favore inserisci una chiave API valida';

  @override
  String get apiTokenValidChars =>
      'Una chiave API può contenere solo lettere a-f, numeri 0-9 e deve essere lunga 40 caratteri';

  @override
  String get customServerUrl => 'URL istanza wger';

  @override
  String get customServerHint =>
      'Inserisci l\'indirizzo del tuo server personale o quello predefinito verrà utilizzato';

  @override
  String get reset => 'Rerimposta';

  @override
  String get registerInstead => 'Non hai un account? Registrati ora';

  @override
  String get loginInstead => 'Hai già un account? Registrati ora';

  @override
  String get labelBottomNavWorkout => 'Allenamento';

  @override
  String get labelBottomNavNutrition => 'Nutrizione';

  @override
  String get labelWorkoutLogs => 'Registri allenamenti';

  @override
  String get labelWorkoutPlan => 'Piano di allenamento';

  @override
  String get labelDashboard => 'Pannello di controllo';

  @override
  String get success => 'Completato';

  @override
  String get successfullyDeleted => 'Cancellato';

  @override
  String get successfullySaved => 'Salvato';

  @override
  String get exerciseList => 'Lista esercizi';

  @override
  String get exercise => 'Esercizio';

  @override
  String get exercises => 'Esercizi';

  @override
  String get exerciseName => 'Nome Esercizio';

  @override
  String get searchExercise => 'Cerca esercizio da aggiungere';

  @override
  String get noIngredientsDefined => 'Nessun ingrediente ancora definito';

  @override
  String get noMatchingExerciseFound => 'Non sono stati trovati esercizi corrispondenti';

  @override
  String get searchNamesInEnglish => 'Cerca anche nei nomi in inglese';

  @override
  String get equipment => 'Equipaggiamento';

  @override
  String get muscles => 'Muscoli';

  @override
  String get musclesSecondary => 'Muscoli secondari';

  @override
  String get category => 'Categoria';

  @override
  String get startDate => 'Data di inizio';

  @override
  String get dayTypeCustom => 'Personalizzato';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'Allenamento a intervalli ad alta intensità';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'Più velocemente possibile';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => 'Routine';

  @override
  String get newRoutine => 'Nuova routine';

  @override
  String get noRoutines => 'Non hai nessuna routine';

  @override
  String get reps => 'Ripetizioni';

  @override
  String get restTime => 'Tempo di riposo';

  @override
  String get sets => 'Serie';

  @override
  String get rir => 'RiR';

  @override
  String get rirNotUsed => 'RiR (Repetitions in Reserve) non utilizzato';

  @override
  String get useMetric => 'Us';

  @override
  String get weightUnit => 'Unità peso';

  @override
  String get repetitionUnit => 'Unità ripetizioni';

  @override
  String get set => 'Serie';

  @override
  String get dayDescriptionHelp =>
      'Una descrizione di ciò che è stato fatto. (p.e. «allenamento gambe») o quale parte del corpo sono state allenate (p.e. «petto e spalle»)';

  @override
  String exerciseNr(String nr) {
    return 'Esercizio $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Serie combinata$nr';
  }

  @override
  String get sameRepetitions =>
      'Se fai le stesse ripetizioni e peso per tutte le serie puoi compilare una sola riga. Per esempio per 4 serie inserisci semplicemente 10 per le ripetizioni, automaticamente diventerà una 4x10.';

  @override
  String get comment => 'Commento';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Sensazione';

  @override
  String get notes => 'Note';

  @override
  String get workoutSession => 'Sessione di allenamento';

  @override
  String get restDay => 'Giorno di riposo';

  @override
  String get isRestDay => 'È il giorno di riposo';

  @override
  String get isRestDayHelp =>
      'Tieni presente che tutte le serie e gli esercizi verranno rimossi quando contrassegni un giorno come giorno di riposo.';

  @override
  String get needsLogsToAdvance => 'Ha bisogno di registri per avanzare';

  @override
  String get needsLogsToAdvanceHelp =>
      'Seleziona se desideri che la routine proceda al giorno programmato successivo solo se hai registrato un allenamento per quel giorno';

  @override
  String get routineDays => 'Giorni di routine';

  @override
  String get resultingRoutine => 'Risultato Routine';

  @override
  String get newDay => 'Nuovo giorno';

  @override
  String get newSet => 'Nuova serie';

  @override
  String get selectExercises =>
      'Se vuoi fare un circuito (super set), puoi cercare e aggiungere diversi esercizi. Questi verranno collegati come circuito';

  @override
  String get gymMode => 'Modalità allenamento';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Piastre';

  @override
  String get plateCalculatorNotDivisible =>
      'Non è possibile raggiungere il peso con le piastre disponibili';

  @override
  String get pause => 'Pausa';

  @override
  String get jumpTo => 'Vai a';

  @override
  String get todaysWorkout => 'Allenamento di oggi';

  @override
  String get logHelpEntries =>
      'Se in una giornata c\'è più di esercizio con lo stesso numero di ripetizioni, ma con pesi differenti, solo l\'esercizio con il peso più alto viene mostrato nel diagramma.';

  @override
  String get logHelpEntriesUnits =>
      'Da notare che solo i dati con l\'unità del peso (kg o lb) e le ripetizioni sono mostrate. Altre combinazioni come tempo o «a cedimento» sono ignorate.';

  @override
  String get description => 'Descrizione';

  @override
  String get name => 'Nome';

  @override
  String get save => 'Salva';

  @override
  String get verify => 'Verifica';

  @override
  String get addSet => 'Aggiungi serie';

  @override
  String get addMeal => 'Aggiungi pasto';

  @override
  String get mealLogged => 'Pasto registrato nel diario';

  @override
  String get ingredientLogged => 'Ingrediente registrato nel diario';

  @override
  String get logMeal => 'Registra questo pasto nel diario';

  @override
  String get addIngredient => 'Aggiungi ingrediente';

  @override
  String get logIngredient => 'Salva l\'ingrediente nel diario nutrizionale';

  @override
  String get searchIngredient => 'Cerca ingrediente';

  @override
  String get nutritionalPlan => 'Piano nutrizionale';

  @override
  String get nutritionalDiary => 'Diario nutrizionale';

  @override
  String get nutritionalPlans => 'Piani nutrizionali';

  @override
  String get noNutritionalPlans => 'Non hai nessun piano nutrizionale';

  @override
  String get onlyLogging => 'Traccia solo le calorie';

  @override
  String get onlyLoggingHelpText =>
      'Selezionate la casella se volete registrare solo le calorie e non volete impostare un piano nutrizionale dettagliato con pasti specifici';

  @override
  String get goalMacro => 'Obiettivi dei macronutrienti';

  @override
  String get selectMealToLog => 'Selezionare un pasto da registrare nel diario';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Il tuo attuale piano nutrizionale non ha pasti definiti';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Per aggiungere pasti al piano, vai ai dettagli del piano nutrizionale';

  @override
  String get goalEnergy => 'Obiettivo energetico';

  @override
  String get goalProtein => 'Obbiettivo proteine';

  @override
  String get goalCarbohydrates => 'Obbiettivo carboidrati';

  @override
  String get goalFat => 'Obbiettivo grassi';

  @override
  String get goalFiber => 'Obbiettivo fibre';

  @override
  String get anErrorOccurred => 'È avvenuto un errore!';

  @override
  String get errorInfoDescription =>
      'Ci dispiace, ma si è verificato un problema. Puoi aiutarci a risolverlo segnalando il problema su GitHub.';

  @override
  String get errorInfoDescription2 =>
      'Puoi continuare a utilizzare l\'app, ma alcune funzionalità potrebbero non funzionare.';

  @override
  String get errorViewDetails => 'Dettagli Tecnici';

  @override
  String get applicationLogs => 'Registri dell\'applicazione';

  @override
  String get errorCouldNotConnectToServer => 'Impossibile connettersi al server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'L\'applicazione non è riuscita a connettersi al server. Controlla la tua connessione Internet o l\'URL del server e riprova. Se il problema persiste, contatta l\'amministratore del server.';

  @override
  String get copyToClipboard => 'Copia negli appunti';

  @override
  String get weight => 'Peso';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name totale';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name ultimi 30 giorni';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName durante il piano nutrizionale $planName';
  }

  @override
  String get measurement => 'Misura';

  @override
  String get measurements => 'Misure';

  @override
  String get measurementCategoriesHelpText =>
      'Categoria di misura, come «bicipiti» o «grasso corporeo»';

  @override
  String get measurementEntriesHelpText =>
      'L\'unità usata per misurare la categoria come «cm» o «%»';

  @override
  String get date => 'Data';

  @override
  String get endDate => 'Data di fine';

  @override
  String get openEnded => 'Senza fine';

  @override
  String get value => 'Valore';

  @override
  String get start => 'Inizia';

  @override
  String get time => 'Orario';

  @override
  String get timeStart => 'Ora di inizio';

  @override
  String get timeEnd => 'Ora di fine';

  @override
  String get timeStartAhead => 'L\'ora di inizio non può essere più avanti dell\'ora di fine';

  @override
  String get ingredient => 'Ingrediente';

  @override
  String get energy => 'Energia';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutrienti';

  @override
  String get planned => 'Pianificato';

  @override
  String get logged => 'Registrato';

  @override
  String get today => 'Oggi';

  @override
  String get loggedToday => 'Registrato oggi';

  @override
  String get weekAverage => 'Media di 7 giorni';

  @override
  String get surplus => 'eccedenza';

  @override
  String get deficit => 'deficit';

  @override
  String get difference => 'Differenza';

  @override
  String get percentEnergy => 'Percentuale di energia';

  @override
  String get gPerBodyKg => 'g per kg di corpo';

  @override
  String get total => 'Totale';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Proteine';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Carboidrati';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Zuccheri';

  @override
  String get fat => 'Grassi';

  @override
  String get fatShort => 'Gr';

  @override
  String get saturatedFat => 'Grassi saturi';

  @override
  String get fiber => 'Fibre';

  @override
  String get sodium => 'Sodio';

  @override
  String get amount => 'Quatità';

  @override
  String get unit => 'Unità';

  @override
  String get newEntry => 'Nuovo dato';

  @override
  String get noWeightEntries => 'Non hai nessun dato sul peso';

  @override
  String get noMeasurementEntries => 'Non hai voci di misurazione';

  @override
  String get moreMeasurementEntries => 'Aggiungi una nuova misura';

  @override
  String get edit => 'Modifica';

  @override
  String get loadingText => 'Caricamento…';

  @override
  String get delete => 'Elimina';

  @override
  String confirmDelete(String toDelete) {
    return 'Sei sicuro/a di voler cancellare \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Nuovo piano nutrizionale';

  @override
  String get overview => 'Panoramica';

  @override
  String get toggleDetails => 'Scegli dettagli';

  @override
  String get goToDetailPage => 'Vai alla pagina dettagli';

  @override
  String get aboutWhySupportTitle => 'Open Source & uso gratuito ❤️';

  @override
  String get aboutDescription =>
      'Grazie per esserti registrato/a su wger! wger è un progetto collaborativo con codice aperto, creato da entusiasti del fitness in tutto il mondo.';

  @override
  String get aboutDonateTitle => 'Fai una donazione';

  @override
  String get aboutDonateText =>
      'Mentre il progetto è gratuito e lo sarà sempre, tenere il server attivo no! Lo sviluppo richiede molto tempo e sforzo dai volontari. Il tuo contributo supporta direttamente questi costi, aiutando a tenere il servizio affidabile.';

  @override
  String get aboutContributeTitle => 'Contribuisci';

  @override
  String get aboutContributeText =>
      'Incoraggiamo ogni tipo di contributo. Che tu sia uno sviluppatore, un traduttore, o semplicemente appassionato di fitness, ogni piccolo supporto verrà apprezzato!';

  @override
  String get aboutBugsListTitle => 'Segnala un problema o suggerisci una funzionalità';

  @override
  String get aboutTranslationListTitle => 'Tradurre l\'applicazione';

  @override
  String get aboutSourceListTitle => 'Visualizza il codice sorgente';

  @override
  String get aboutJoinCommunityTitle => 'Unisciti alla comunità';

  @override
  String get aboutMastodonTitle => 'Mastodonte';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Altri';

  @override
  String get calendar => 'Calendario';

  @override
  String get goToToday => 'Seleziona giorno';

  @override
  String get enterValue => 'Inserisci un valore';

  @override
  String get selectEntry => 'Per favore seleziona un elemento';

  @override
  String get selectExercise => 'Prego, seleziona un esercizio';

  @override
  String enterCharacters(String min, String max) {
    return 'Inserisci una stringa tra $min e $max caratteri';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Inserisci almeno $min caratteri';
  }

  @override
  String get baseNameEnglish => 'Tutti gli esercizi necessitano di un nome base in inglese';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Serie per esercizio: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Scegli le unità e le RiR';

  @override
  String get enterValidNumber => 'Inserisci un numero valido';

  @override
  String get selectIngredient => 'Seleziona un ingrediente';

  @override
  String get recentlyUsedIngredients => 'Ingredienti aggiunti di recente';

  @override
  String get selectImage => 'Si prega di selezionare un\'immagine';

  @override
  String get optionsLabel => 'Opzioni';

  @override
  String get takePicture => 'Scatta una foto';

  @override
  String get chooseFromLibrary => 'Scegli dalla raccolta';

  @override
  String get gallery => 'Galleria';

  @override
  String get addImage => 'Aggiungi un\'immagine';

  @override
  String get dataCopied => 'Dati copiati nella nuova voce';

  @override
  String get appUpdateTitle => 'Aggiornamento necessario';

  @override
  String get appUpdateContent =>
      'Questa versione dell\'applicazione non è compatibile con il server, per favore aggiorna la tua applicazione.';

  @override
  String get productFound => 'Prodotto trovato';

  @override
  String productFoundDescription(String productName) {
    return 'Il codice a barre corrisponde a questo prodotto: $productName. Vuoi continuare?';
  }

  @override
  String get productNotFound => 'Prodotto non trovato';

  @override
  String productNotFoundDescription(String barcode) {
    return 'Il prodotto con il codice a barre scansionato $barcode non è stato trovato nel database wger';
  }

  @override
  String get scanBarcode => 'Scansiona il codice a barre';

  @override
  String get close => 'Chiudi';

  @override
  String get identicalExercisePleaseDiscard =>
      'Se trovate un esercizio identico a quello che state cercando di aggiungere, per favore scartate la vostra bozza e se necessario modificate l\'esercizio esistente.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Verificate che le informazioni siano corrette prima di aggiungere l\'esercizio';

  @override
  String get add_exercise_image_license =>
      'Le immagini devono essere compatibili con la licenza CC BY SA. In caso di dubbi, carica solo le foto che hai scattato tu stesso.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'Aggiungi';

  @override
  String get variations => 'Variazioni';

  @override
  String alsoKnownAs(String aliases) {
    return 'Conosciuto anche come: $aliases';
  }

  @override
  String get verifiedEmail => 'Email Verificata';

  @override
  String get unVerifiedEmail => 'Email non Verificata';

  @override
  String get verifiedEmailReason => 'Devi verificare la tua email per contribuire agli esercizi';

  @override
  String verifiedEmailInfo(String email) {
    return 'Un\'email di verifica è stata inviata a $email';
  }

  @override
  String get alternativeNames => 'Nomi Alternativi';

  @override
  String get oneNamePerLine => 'Un nome per linea';

  @override
  String get whatVariationsExist =>
      'Ci sono delle variazioni per questo esercizio, se ne esistono?';

  @override
  String get previous => 'Precedente';

  @override
  String get next => 'Successivo';

  @override
  String get images => 'Immagini';

  @override
  String get language => 'Lingua';

  @override
  String get addExercise => 'Aggiungi esercizi';

  @override
  String get fitInWeek => 'Settimana Fit in';

  @override
  String get fitInWeekHelp =>
      'Se abilitata, i giorni si ripeteranno in un ciclo settimanale, altrimenti i giorni si susseguiranno in sequenza, senza tener conto dell\'inizio di una nuova settimana.';

  @override
  String get addSuperset => 'Aggiungi superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Il set ha una progressione';

  @override
  String get setHasProgressionWarning =>
      'Si prega di notare che al momento non è possibile modificare tutte le impostazioni di un set sull\'applicazione mobile o configurare la progressione automatica. Per ora, si prega di utilizzare l\'applicazione web.';

  @override
  String get setHasNoExercises => 'Questo set non contiene ancora esercizi!';

  @override
  String get contributeExercise => 'Contribuisci aggiungendo un esercizio';

  @override
  String get translation => 'Traduzione';

  @override
  String get translateExercise => 'Traduci questo esercizio ora';

  @override
  String get baseData => 'Informazioni Base in Inglese';

  @override
  String get enterTextInLanguage => 'Aggiungete il testo usando la lingua giusta!';

  @override
  String get settingsTitle => 'Impostazioni';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Cache degli esercizi';

  @override
  String get settingsIngredientCacheDescription => 'Cache ingredienti';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache svuotata con successo';

  @override
  String get aboutPageTitle => 'Chi siamo & Supporto';

  @override
  String contributeExerciseWarning(String days) {
    return 'Puoi contribuire agli esercizi solo se il tuo account è più vecchio di $days giorni e hai verificato la tua email';
  }

  @override
  String get simpleMode => 'Modalità semplice';

  @override
  String get simpleModeHelp =>
      'Nascondi alcune delle impostazioni più avanzate durante la modifica degli esercizi';

  @override
  String get progressionRules =>
      'Questo esercizio ha delle regole di progressione e non può essere modificato sull\'app mobile. Per modificare questo esercizio, utilizza l\'applicazione web.';

  @override
  String get cacheWarning =>
      'A causa del caching potrebbe volerci del tempo affinchè i cambiamenti siano visibili attraverso l\'applicazione.';

  @override
  String get textPromptTitle => 'Pronto a iniziare?';

  @override
  String get textPromptSubheading => 'Premi il pulsante azione per iniziare';

  @override
  String get abs => 'Addominali';

  @override
  String get arms => 'Braccia';

  @override
  String get back => 'Schiena';

  @override
  String get barbell => 'Bilanciere';

  @override
  String get bench => 'Panca';

  @override
  String get biceps => 'Bicipiti';

  @override
  String get body_weight => 'Peso Corporeo';

  @override
  String get calves => 'Polpacci';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Petto';

  @override
  String get dumbbell => 'Manubrio';

  @override
  String get glutes => 'Glutei';

  @override
  String get gym_mat => 'Materassino da palestra';

  @override
  String get hamstrings => 'Cosce';

  @override
  String get incline_bench => 'Panca Inclinata';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Chilometri';

  @override
  String get kilometers_per_hour => 'Chilometri all\'ora';

  @override
  String get lats => 'Muscoli Dorsali';

  @override
  String get legs => 'Gambe';

  @override
  String get lower_back => 'Zona Lombare';

  @override
  String get max_reps => 'Ripetizioni massime';

  @override
  String get miles => 'Miglia';

  @override
  String get miles_per_hour => 'Miglia per ora';

  @override
  String get minutes => 'Minuti';

  @override
  String get plates => 'Piastre';

  @override
  String get pull_up_bar => 'Barra per trazioni';

  @override
  String get quads => 'Quadricipiti';

  @override
  String get repetitions => 'Ripetizioni';

  @override
  String get resistance_band => 'Fascia di resistenza';

  @override
  String get sz_bar => 'SZ-Bar';

  @override
  String get seconds => 'Secondi';

  @override
  String get shoulders => 'Spalle';

  @override
  String get swiss_ball => 'Fitball';

  @override
  String get triceps => 'Tricipiti';

  @override
  String get until_failure => 'Fino al fallimento';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'nessuno (esercizio con il peso corporeo)';

  @override
  String get log => 'Log';

  @override
  String get done => 'Fatto';

  @override
  String get overallChangeWeight => 'Variazione complessiva';

  @override
  String get goalTypeMeals => 'Dai pasti';

  @override
  String get goalTypeBasic => 'Base';

  @override
  String get goalTypeAdvanced => 'Avanzato';

  @override
  String get indicatorRaw => 'grezzo';

  @override
  String get indicatorAvg => 'med';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Modalità del tema';

  @override
  String get darkMode => 'Sempre in modalità scura';

  @override
  String get lightMode => 'Sempre in modalità chiara';

  @override
  String get systemMode => 'Parametri di sistema';
}
