// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Indonesian (`id`).
class AppLocalizationsId extends AppLocalizations {
  AppLocalizationsId([String locale = 'id']) : super(locale);

  @override
  String get userProfile => 'Profil Kamu';

  @override
  String get login => 'Masuk';

  @override
  String get logout => 'Keluar';

  @override
  String get register => 'Daftar';

  @override
  String get useDefaultServer => 'Gunakan server bawaan';

  @override
  String get useCustomServer => 'Gunakan server lain';

  @override
  String get invalidUrl => 'Mohon masukkan URL yang valid';

  @override
  String get usernameValidChars =>
      'Username hanya dapat diisi dengan hiruf, angka, dan karakter @, +, ., -, dan _';

  @override
  String get passwordsDontMatch => 'Password tidak sesuai';

  @override
  String get passwordTooShort => 'Password terlalu pendek';

  @override
  String get selectAvailablePlates => 'Pilih lempeng beban yang tersedia';

  @override
  String get barWeight => 'Berat batang';

  @override
  String get useColors => 'Gunakan warna';

  @override
  String get password => 'Kata sandi';

  @override
  String get confirmPassword => 'Konfirmasi Kata Sandi';

  @override
  String get invalidEmail => 'Mohon masukkan E-mail yang valid';

  @override
  String get email => 'Alamat E-mail';

  @override
  String get username => 'Nama pengguna';

  @override
  String get invalidUsername => 'Mohon masukkan username yang valid';

  @override
  String get useApiToken => 'Gunakan Token API';

  @override
  String get useUsernameAndPassword => 'Gunakan nama pengguna dan kata sandi';

  @override
  String get apiToken => 'Token API';

  @override
  String get invalidApiToken => 'Mohon masukan kunci API yang valid';

  @override
  String get apiTokenValidChars =>
      'Kunci API hanya boleh berisi huruf a-f, angka 0-9 dan harus berjumlah 40 karakter';

  @override
  String get customServerUrl => 'URL dari wger';

  @override
  String get customServerHint =>
      'Masukkan alamat servermu sendiri, jika tidak akan menggunakan server bawaan';

  @override
  String get reset => 'Reset';

  @override
  String get registerInstead => 'Tidak punya akun? Buat akun';

  @override
  String get loginInstead => 'Punya akun? Masuk';

  @override
  String get labelBottomNavWorkout => 'Workout';

  @override
  String get labelBottomNavNutrition => 'Nutrisi';

  @override
  String get labelWorkoutLogs => 'Log latihan';

  @override
  String get labelWorkoutPlan => 'Rencana workout';

  @override
  String get labelDashboard => 'Dashboard';

  @override
  String get success => 'Berhasil';

  @override
  String get successfullyDeleted => 'Terhapus';

  @override
  String get successfullySaved => 'Tersimpan';

  @override
  String get exerciseList => 'Daftar latihan';

  @override
  String get exercise => 'Latihan';

  @override
  String get exercises => 'Latihan';

  @override
  String get exerciseName => 'Nama Latihan';

  @override
  String get searchExercise => 'Cari latihan untuk ditambahkan';

  @override
  String get noIngredientsDefined => 'Belum ada bahan yang ditetapkan';

  @override
  String get noMatchingExerciseFound => 'Tidak ditemukan latihan yang sesuai';

  @override
  String get searchNamesInEnglish => 'Cari juga nama-nama dalam bahasa Inggris';

  @override
  String get equipment => 'Perlengkapan';

  @override
  String get muscles => 'Otot';

  @override
  String get musclesSecondary => 'Otot sekunder';

  @override
  String get category => 'Kategori';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => 'Rutinitas';

  @override
  String get newRoutine => 'Rutinitas baru';

  @override
  String get noRoutines => 'Kamu tidak memiliki rutinitas';

  @override
  String get reps => 'Repetisi';

  @override
  String get restTime => 'Waktu istirahat';

  @override
  String get sets => 'Set';

  @override
  String get rir => 'Repetisi tersisa';

  @override
  String get rirNotUsed => 'RiR tidak digunakan';

  @override
  String get useMetric => 'Gunakan unit metrik untuk berat badan';

  @override
  String get weightUnit => 'Satuan bobot';

  @override
  String get repetitionUnit => 'Satuan pengulangan';

  @override
  String get set => 'Set';

  @override
  String get dayDescriptionHelp =>
      'Deskripsi untuk yang sudah diselesaikan hari ini (contoh: \'pull day\') atau bagian tubuh mana yang sudah dilatih (contoh: \'dada dan pundak\')';

  @override
  String exerciseNr(String nr) {
    return 'Latihan ke-$nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset ke-$nr';
  }

  @override
  String get sameRepetitions =>
      'Jika Anda melakukan pengulangan dan bobot yang sama untuk semua set, Anda cukup mengisi satu baris. Misalnya untuk 4 set cukup masukkan 10 untuk pengulangan, ini secara otomatis menjadi \"4 x 10\".';

  @override
  String get comment => 'Komentar';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Kesan';

  @override
  String get notes => 'Catatan';

  @override
  String get workoutSession => 'Sesi workout';

  @override
  String get restDay => 'Hari istirahat';

  @override
  String get isRestDay => 'Hari ini adalah hari istirahat';

  @override
  String get isRestDayHelp =>
      'Harap diperhatikan bahwa semua set dan latihan akan dihapus ketika Anda menandai suatu hari sebagai hari istirahat.';

  @override
  String get needsLogsToAdvance => 'Perlu log untuk melanjutkan';

  @override
  String get needsLogsToAdvanceHelp =>
      'Pilih opsi ini jika Anda ingin rutinitas berlanjut ke hari berikutnya hanya setelah Anda mencatat latihan pada hari tersebut';

  @override
  String get routineDays => 'Hari dalam rutinitas';

  @override
  String get resultingRoutine => 'Rutinitas yang dihasilkan';

  @override
  String get newDay => 'Hari baru';

  @override
  String get newSet => 'Set baru';

  @override
  String get selectExercises =>
      'Jika Anda ingin melakukan superset, Anda dapat mencari beberapa latihan, mereka akan dikelompokkan bersama';

  @override
  String get gymMode => 'Mode gym';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Lempeng Beban';

  @override
  String get plateCalculatorNotDivisible =>
      'Tidak memungkinkan untuk mencapai bobot dengan plate yang tersedia';

  @override
  String get pause => 'Jeda';

  @override
  String get jumpTo => 'Lompat ke';

  @override
  String get todaysWorkout => 'Latihanmu hari ini';

  @override
  String get logHelpEntries =>
      'Jika dalam satu hari terdapat lebih dari satu entri dengan jumlah repetisi yang sama namun beban berbeda, hanya entri dengan beban tertinggi yang akan ditampilkan di diagram.';

  @override
  String get logHelpEntriesUnits =>
      'Perlu dicatat bahwa hanya entri dengan satuan beban (kg atau lb) dan repetisi yang akan ditampilkan di grafik. Kombinasi lain seperti waktu atau hingga gagal tidak diperhitungkan di sini.';

  @override
  String get description => 'Description';

  @override
  String get name => 'Nama';

  @override
  String get save => 'Simpan';

  @override
  String get verify => 'Verifikasi';

  @override
  String get addSet => 'Tambah set';

  @override
  String get addMeal => 'Tambah makanan';

  @override
  String get mealLogged => 'Makanan ditambahkan ke buku harian';

  @override
  String get ingredientLogged => 'Komposisi telah dicatat';

  @override
  String get logMeal => 'Catat makanan ke buku harian nutrisi';

  @override
  String get addIngredient => 'Tambah komposisi';

  @override
  String get logIngredient => 'Catat bahan ke buku harian nutrisi';

  @override
  String get searchIngredient => 'Cari komposisi';

  @override
  String get nutritionalPlan => 'Rencana Nutrisi';

  @override
  String get nutritionalDiary => 'Buku Harian Nutrisi';

  @override
  String get nutritionalPlans => 'Rencana Nutrisi';

  @override
  String get noNutritionalPlans => 'Anda belum memiliki rencana nutrisi';

  @override
  String get onlyLogging => 'Hanya melacak kalori';

  @override
  String get onlyLoggingHelpText =>
      'Centang kotak ini jika Anda hanya ingin mencatat kalori dan tidak ingin menyusun rencana nutrisi secara rinci dengan menu khusus';

  @override
  String get goalMacro => 'Target makronutrien';

  @override
  String get selectMealToLog => 'Pilih makanan untuk dicatat ke dalam buku harian';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Rencana nutrisi Anda saat ini belum memiliki menu yang ditentukan';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Untuk menambahkan menu ke dalam rencana, buka detail rencana nutrisi';

  @override
  String get goalEnergy => 'Target energi';

  @override
  String get goalProtein => 'Target protein';

  @override
  String get goalCarbohydrates => 'Target karbohidrat';

  @override
  String get goalFat => 'Target lemak';

  @override
  String get goalFiber => 'Target serat';

  @override
  String get anErrorOccurred => 'Terjadi kesalahan!';

  @override
  String get errorInfoDescription =>
      'Maaf, terjadi kesalahan. Anda dapat membantu kami memperbaikinya dengan melaporkan masalah ini di GitHub.';

  @override
  String get errorInfoDescription2 =>
      'Anda masih dapat menggunakan aplikasi, namun beberapa fitur mungkin tidak berfungsi.';

  @override
  String get errorViewDetails => 'Rincian teknis';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Tidak dapat terhubung ke server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'Aplikasi tidak dapat terhubung ke server. Silakan periksa koneksi internet atau URL server anda, lalu coba lagi. Jika masalah terus berlanjut, hubungi administrator server.';

  @override
  String get copyToClipboard => 'Salin ke papan klip';

  @override
  String get weight => 'Berat';

  @override
  String get min => 'Minimal';

  @override
  String get max => 'Maksimal';

  @override
  String chartAllTimeTitle(String name) {
    return '${name}Sepanjang waktu';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name 30 hari terakhir';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName selama rencana nutrisi $planName';
  }

  @override
  String get measurement => 'Ukuran';

  @override
  String get measurements => 'Pengukuran';

  @override
  String get measurementCategoriesHelpText =>
      'Kategori pengukuran, seperti \'bisep\' atau \'lemak tubuh\'';

  @override
  String get measurementEntriesHelpText =>
      'Satuan yang digunakan untuk mengukur kategori, seperti \'cm\' atau \'%\'';

  @override
  String get date => 'Date';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'Nilai';

  @override
  String get start => 'Start';

  @override
  String get time => 'Waktu';

  @override
  String get timeStart => 'Waktu mulai';

  @override
  String get timeEnd => 'Waktu selesai';

  @override
  String get timeStartAhead => 'Waktu mulai tidak boleh melebihi waktu selesai';

  @override
  String get ingredient => 'Komposisi';

  @override
  String get energy => 'Energi';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Makronutrien';

  @override
  String get planned => 'Direncanakan';

  @override
  String get logged => 'Dicatat';

  @override
  String get today => 'Hari ini';

  @override
  String get loggedToday => 'Dicatat hari ini';

  @override
  String get weekAverage => 'Rata-rata 7 hari';

  @override
  String get surplus => 'Surplus';

  @override
  String get deficit => 'defisit';

  @override
  String get difference => 'Perbedaan';

  @override
  String get percentEnergy => 'Persenan Energi';

  @override
  String get gPerBodyKg => 'g per kg tubuh';

  @override
  String get total => 'Total';

  @override
  String get kcal => 'kkal';

  @override
  String kcalValue(String value) {
    return '$value kkal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Protein';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Karbohidrat';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Gula';

  @override
  String get fat => 'Lemak';

  @override
  String get fatShort => 'F';

  @override
  String get saturatedFat => 'Lemak jenuh';

  @override
  String get fiber => 'Fibre';

  @override
  String get sodium => 'Sodium';

  @override
  String get amount => 'Jumlah';

  @override
  String get unit => 'Unit';

  @override
  String get newEntry => 'Entri baru';

  @override
  String get noWeightEntries => 'Anda belum memiliki entri berat badan';

  @override
  String get noMeasurementEntries => 'Anda belum memiliki entri pengukuran apa pun';

  @override
  String get moreMeasurementEntries => 'Tambah pengukuran baru';

  @override
  String get edit => 'Edit';

  @override
  String get loadingText => 'Loading...';

  @override
  String get delete => 'Delete';

  @override
  String confirmDelete(String toDelete) {
    return 'Apakah anda yakin ingin menghapus \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Rencana nutrisi baru';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'Toggle rincian';

  @override
  String get goToDetailPage => 'Go to detail page';

  @override
  String get aboutWhySupportTitle => 'Bersifat open source & gratis ❤️';

  @override
  String get aboutDescription =>
      'Terima kasih telah menggunakan wger! wger proyek open source kolaboratif, dibuat oleh para penggemar kebugaran dari seluruh dunia.';

  @override
  String get aboutDonateTitle => 'Beri donasi';

  @override
  String get aboutDonateText =>
      'Meskipun proyek ini gratis dan akan selalu begitu, menjalankan server tetap memerlukan biaya! Pengembangan juga membutuhkan waktu dan tenaga yang tidak sedikit dari para relawan. Kontribusi Anda secara langsung membantu menutup biaya-biaya ini dan menjaga layanan tetap andal.';

  @override
  String get aboutContributeTitle => 'Kontribusi';

  @override
  String get aboutContributeText =>
      'Semua jenis kontribusi sangat kami hargai. Baik Anda seorang pengembang, penerjemah, atau sekadar memiliki semangat di bidang kebugaran, setiap bentuk dukungan sangat berarti!';

  @override
  String get aboutBugsListTitle => 'Laporkan masalah atau usulkan fitur';

  @override
  String get aboutTranslationListTitle => 'Terjemahkan aplikasi';

  @override
  String get aboutSourceListTitle => 'Lihat kode sumber';

  @override
  String get aboutJoinCommunityTitle => 'Gabung komunitas';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Lainnya';

  @override
  String get calendar => 'Kalender';

  @override
  String get goToToday => 'Pergi ke hari ini';

  @override
  String get enterValue => 'Silakan masukan nilai';

  @override
  String get selectEntry => 'Silakan pilih entri';

  @override
  String get selectExercise => 'Silakan pilih latihan';

  @override
  String enterCharacters(String min, String max) {
    return 'Silakan masukan antara $min dan $max karakter';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Silakan masukan minimal $min karakter';
  }

  @override
  String get baseNameEnglish => 'Semua latihan memerlukan nama dasar dalam Bahasa Inggris';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Sets per latihan: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Unit Set and RiR';

  @override
  String get enterValidNumber => 'Silakan masukan angka yang valid';

  @override
  String get selectIngredient => 'Silakan pilih komposisi';

  @override
  String get recentlyUsedIngredients => 'Komposisi yang baru ditambahkan';

  @override
  String get selectImage => 'Silakan pilih gambar';

  @override
  String get optionsLabel => 'Options';

  @override
  String get takePicture => 'Ambil gambar';

  @override
  String get chooseFromLibrary => 'Pilih foto dari library';

  @override
  String get gallery => 'Galeri';

  @override
  String get addImage => 'Add image';

  @override
  String get dataCopied => 'Data disalin ke entri baru';

  @override
  String get appUpdateTitle => 'Pembaruan diperlukan';

  @override
  String get appUpdateContent =>
      'Versi aplikasi ini tidak kompatibel dengan server, silakan perbarui aplikasi Anda.';

  @override
  String get productFound => 'Produk ditemukan';

  @override
  String productFoundDescription(String productName) {
    return 'Kode batang ini sesuai dengan produk: $productName. Apakah Anda ingin melanjutkan?';
  }

  @override
  String get productNotFound => 'Produk tidak ditemukan';

  @override
  String productNotFoundDescription(String barcode) {
    return 'Produk dengan kode batang $barcode tidak ditemukan dalam database wger';
  }

  @override
  String get scanBarcode => 'Pindai kode batang';

  @override
  String get close => 'Tutup';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'Gambar harus kompatibel dengan lisensi CC BY SA. Jika ragu, unggah hanya foto yang anda ambil sendiri.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'Variasi';

  @override
  String alsoKnownAs(String aliases) {
    return 'Juga dikenal sebagai: $aliases';
  }

  @override
  String get verifiedEmail => 'Email terverifikasi';

  @override
  String get unVerifiedEmail => 'Email belum diverifikasi';

  @override
  String get verifiedEmailReason =>
      'Anda perlu memverifikasi email untuk dapat menambahkan latihan';

  @override
  String verifiedEmailInfo(String email) {
    return 'Email verifikasi telah dikirim ke $email';
  }

  @override
  String get alternativeNames => 'Nama lain';

  @override
  String get oneNamePerLine => 'Satu nama per baris';

  @override
  String get whatVariationsExist => 'Apakah ada variasi dari latihan ini? Jika ada, apa saja?';

  @override
  String get previous => 'Sebelumnya';

  @override
  String get next => 'Selanjutnya';

  @override
  String get images => 'Gambar';

  @override
  String get language => 'Bahasa';

  @override
  String get addExercise => 'Tambah latihan';

  @override
  String get fitInWeek => 'Bugar dalam seminggu';

  @override
  String get fitInWeekHelp =>
      'Jika diaktifkan, hari-hari akan berulang dalam siklus mingguan. Jika tidak, hari-hari akan berjalan secara berurutan tanpa memperhatikan awal minggu baru.';

  @override
  String get addSuperset => 'Tambah superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set memiliki peningkatan';

  @override
  String get setHasProgressionWarning =>
      'Perlu diketahui, saat ini pengaturan lengkap untuk set dan konfigurasi progresi otomatis belum bisa dilakukan di aplikasi mobile. Silakan gunakan aplikasi web untuk fitur tersebut.';

  @override
  String get setHasNoExercises => 'Set ini belum memiliki latihan apa pun!';

  @override
  String get contributeExercise => 'Tambahkan latihan';

  @override
  String get translation => 'Terjemahan';

  @override
  String get translateExercise => 'Terjemahkan latihan ini sekarang';

  @override
  String get baseData => 'Dasar dalam Bahasa Inggris';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Pengaturan';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Cache latihan';

  @override
  String get settingsIngredientCacheDescription => 'Cache komposisi';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache berhasil dibersihkan';

  @override
  String get aboutPageTitle => 'Tentang kami dan dukungan';

  @override
  String contributeExerciseWarning(String days) {
    return 'Anda hanya dapat menambahkan latihan jika akun Anda berusia lebih dari $days hari dan email Anda telah terverifikasi';
  }

  @override
  String get simpleMode => 'Mode sederhana';

  @override
  String get simpleModeHelp => 'Sembunyikan beberapa pengaturan lanjutan saat mengedit latihan';

  @override
  String get progressionRules =>
      'Latihan ini memiliki aturan peningkatan dan tidak dapat diedit melalui aplikasi mobile. Silakan gunakan aplikasi web untuk mengedit latihan ini.';

  @override
  String get cacheWarning =>
      'Karena sistem cache, perubahan mungkin membutuhkan waktu sebelum terlihat di seluruh aplikasi.';

  @override
  String get textPromptTitle => 'Siap memulai?';

  @override
  String get textPromptSubheading => 'Tekan tombol untuk mulai';

  @override
  String get abs => 'Otot perut';

  @override
  String get arms => 'Lengan';

  @override
  String get back => 'Punggung';

  @override
  String get barbell => 'Barbel';

  @override
  String get bench => 'Bangku';

  @override
  String get biceps => 'Bisep';

  @override
  String get body_weight => 'Berat Badan';

  @override
  String get calves => 'Betis';

  @override
  String get cardio => 'Kardio';

  @override
  String get chest => 'Dada';

  @override
  String get dumbbell => 'Dumbel';

  @override
  String get glutes => 'Bokong';

  @override
  String get gym_mat => 'Matras Gym';

  @override
  String get hamstrings => 'Paha Belakang';

  @override
  String get incline_bench => 'Bangku Incline';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Kilometer';

  @override
  String get kilometers_per_hour => 'Kilometer Per Jam';

  @override
  String get lats => 'Otot Punggung Samping';

  @override
  String get legs => 'Kaki';

  @override
  String get lower_back => 'Punggung Bawah';

  @override
  String get max_reps => 'Repetisi Maksimal';

  @override
  String get miles => 'Mil';

  @override
  String get miles_per_hour => 'Mil Per Jam';

  @override
  String get minutes => 'Menit';

  @override
  String get plates => 'Lempeng Beban';

  @override
  String get pull_up_bar => 'Palang Pull-up';

  @override
  String get quads => 'Paha Depan';

  @override
  String get repetitions => 'Pengulangan';

  @override
  String get resistance_band => 'Karet Latihan';

  @override
  String get sz_bar => 'SZ-Bar';

  @override
  String get seconds => 'Detik';

  @override
  String get shoulders => 'Bahu';

  @override
  String get swiss_ball => 'Bola Gym';

  @override
  String get triceps => 'Trisep';

  @override
  String get until_failure => 'Sampai tidak mampu lagi';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'Tanpa alat (Latihan Berat Badan Sendiri)';

  @override
  String get log => 'Catat';

  @override
  String get done => 'Selesai';

  @override
  String get overallChangeWeight => 'Perubahan keseluruhan';

  @override
  String get goalTypeMeals => 'Dari makanan';

  @override
  String get goalTypeBasic => 'Dasar';

  @override
  String get goalTypeAdvanced => 'Lanjutan';

  @override
  String get indicatorRaw => 'Mentah';

  @override
  String get indicatorAvg => 'rata-rata';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'mode Tema';

  @override
  String get darkMode => 'Selalu mode gelap';

  @override
  String get lightMode => 'Selalu mode terang';

  @override
  String get systemMode => 'Pengaturan sitem';
}
