// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hebrew (`he`).
class AppLocalizationsHe extends AppLocalizations {
  AppLocalizationsHe([String locale = 'he']) : super(locale);

  @override
  String get userProfile => 'הפרופיל שלך';

  @override
  String get login => 'כניסה';

  @override
  String get logout => 'יציאה';

  @override
  String get register => 'הרשמה';

  @override
  String get useDefaultServer => 'שימוש בשרת ברירת מחדל';

  @override
  String get useCustomServer => 'שימוש בשרת מותאם אישית';

  @override
  String get invalidUrl => 'אנא הכנס/י כתובת URL תקינה';

  @override
  String get usernameValidChars => 'שם משתמש יכול רק להכיל אותיות, ספרות ואת התווים @, +, ., - ו _';

  @override
  String get passwordsDontMatch => 'הסיסמאות לא תואמות';

  @override
  String get passwordTooShort => 'הסיסמא קצרה מדי';

  @override
  String get selectAvailablePlates => 'Select available plates';

  @override
  String get barWeight => 'משקל Bar';

  @override
  String get useColors => 'שימוש בצבעים';

  @override
  String get password => 'סיסמא';

  @override
  String get confirmPassword => 'אשר סיסמא';

  @override
  String get invalidEmail => 'נא להקליד כתובת דואר אלקטרוני תקינה';

  @override
  String get email => 'כתובת דואר אלקטרוני';

  @override
  String get username => 'שם משתמש';

  @override
  String get invalidUsername => 'אנא הכנס שם משתמש תקין';

  @override
  String get useApiToken => 'שימוש באסימון API';

  @override
  String get useUsernameAndPassword => 'שימוש בשם משתמש וסיסמה';

  @override
  String get apiToken => 'אסימון API';

  @override
  String get invalidApiToken => 'נא להקליד אסימון API תקין';

  @override
  String get apiTokenValidChars =>
      'מפתח API יכול להכיל רק את האותיות a-f, את הספרות 0-9, ועליו להיות באורך 40 תווים בדיוק';

  @override
  String get customServerUrl => 'כתובת של ישות ווגר';

  @override
  String get customServerHint => 'הכנס את כתובת השרת שלך, אחרת יעשה שימוש בברירת המחדל';

  @override
  String get reset => 'איפוס';

  @override
  String get registerInstead => 'אין לך חשבון? הירשם עכשיו';

  @override
  String get loginInstead => 'כבר יש לך חשבון? ניתן להיכנס';

  @override
  String get labelBottomNavWorkout => 'אימון';

  @override
  String get labelBottomNavNutrition => 'תזונה';

  @override
  String get labelWorkoutLogs => 'אימונים מתועדים';

  @override
  String get labelWorkoutPlan => 'תוכנית אימונים';

  @override
  String get labelDashboard => 'לוח בקרה';

  @override
  String get success => 'הפעולה צלחה';

  @override
  String get successfullyDeleted => 'המחיקה בוצעה';

  @override
  String get successfullySaved => 'נשמר';

  @override
  String get exerciseList => 'רשימת תרגילים';

  @override
  String get exercise => 'תרגיל';

  @override
  String get exercises => 'תרגילים';

  @override
  String get exerciseName => 'שם התרגיל';

  @override
  String get searchExercise => 'חיפוש תרגילים להוספה';

  @override
  String get noIngredientsDefined => 'עדיין לא הוגדרו מרכיבים';

  @override
  String get noMatchingExerciseFound => 'לא נמצאו תרגילים תואמים';

  @override
  String get searchNamesInEnglish => 'לחפש גם לפי השמות באנגלית';

  @override
  String get equipment => 'ציוד';

  @override
  String get muscles => 'שרירים';

  @override
  String get musclesSecondary => 'שרירים משניים';

  @override
  String get category => 'קטגוריה';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => 'שגרות';

  @override
  String get newRoutine => 'שגרה חדשה';

  @override
  String get noRoutines => 'אין לך שגרות';

  @override
  String get reps => 'חזרות';

  @override
  String get restTime => 'זמן מנוחה';

  @override
  String get sets => 'סטים';

  @override
  String get rir => 'חזרות בעתודה';

  @override
  String get rirNotUsed => 'חזרות בעתודה שלא שומשו';

  @override
  String get useMetric => 'שימוש בשיטה המטרית למדידת משקל הגוף';

  @override
  String get weightUnit => 'יחידת משקל';

  @override
  String get repetitionUnit => 'יחידת חזרה';

  @override
  String get set => 'סט';

  @override
  String get dayDescriptionHelp =>
      'תיאור של מה נעשה ביום זה (למשל ,יום משיכה\') או אילו חלקי גוף יהיו באימון (למשל \'חזה וכתפיים\')';

  @override
  String exerciseNr(String nr) {
    return 'תרגיל $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'אם אתם משתמשים באותה כמות של חזרות ומשקל עבור כל הסטים, ניתן למלא רק שורה אחת. למשל עבור 4 סטים, הזינו 10 עבור חזרות, ואוטומטית הערך יהיה \"4x10\".';

  @override
  String get comment => 'הערה';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'התרשמות';

  @override
  String get notes => 'הערות';

  @override
  String get workoutSession => 'סשן אימונים';

  @override
  String get restDay => 'יום מנוחה';

  @override
  String get isRestDay => 'הוא יום מנוחה';

  @override
  String get isRestDayHelp => 'לתשומת לבך, כל הסטים והתרגילים יוסרו מימים שהגדרת בתור ימי מנוחה.';

  @override
  String get needsLogsToAdvance => 'Needs logs to advance';

  @override
  String get needsLogsToAdvanceHelp =>
      'Select if you want the routine to progress to the next scheduled day only if you\'ve logged a workout for the day';

  @override
  String get routineDays => 'ימים בשגרה';

  @override
  String get resultingRoutine => 'Resulting routine';

  @override
  String get newDay => 'יום חדש';

  @override
  String get newSet => 'סט חדש';

  @override
  String get selectExercises =>
      'אם ברצונך לבצע סופר סט ניתן לחפש כמה אימונים כך שהם יהיו מקובצים ביחד';

  @override
  String get gymMode => 'מצב חדש כושר';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'צלחות';

  @override
  String get plateCalculatorNotDivisible => 'לא אפשרי להגיע למשקל עם הצלחות הפנויות';

  @override
  String get pause => 'השהה';

  @override
  String get jumpTo => 'עבור ל';

  @override
  String get todaysWorkout => 'האימון שלך היום';

  @override
  String get logHelpEntries =>
      'אם ביום אחד ישנה יותר מרשומה אחת עם אותה כמות חזרות, אבל משקל שונה, רק הרשומה עם המשקל הגבוה יותר תופיע בדיאגרמה.';

  @override
  String get logHelpEntriesUnits =>
      'שים לב שרק רשומות עם יחידת משקל (ק\"ג או ליברות) וחזרות הן ממופות, ישנה התעלמות משילובים אחרים כגון זמן או עד כשלון.';

  @override
  String get description => 'תיאור';

  @override
  String get name => 'שם';

  @override
  String get save => 'שמירה';

  @override
  String get verify => 'אימות';

  @override
  String get addSet => 'הוספת סט';

  @override
  String get addMeal => 'הוספת ארוחה';

  @override
  String get mealLogged => 'ארוחה הוכנסה ליומן';

  @override
  String get ingredientLogged => 'המרכיב תועד ביומן';

  @override
  String get logMeal => 'תיעוד המנה ביומן התזונתי';

  @override
  String get addIngredient => 'הוספת מרכיב';

  @override
  String get logIngredient => 'תיעוד המרכיב ביומן התזונתי';

  @override
  String get searchIngredient => 'חיפוש מרכיב';

  @override
  String get nutritionalPlan => 'תכנון תזונתי';

  @override
  String get nutritionalDiary => 'יומן תזונה';

  @override
  String get nutritionalPlans => 'תוכניות תזונה';

  @override
  String get noNutritionalPlans => 'אין לך תוכניות תזונה';

  @override
  String get onlyLogging => 'מעקב אחר קלוריות בלבד';

  @override
  String get onlyLoggingHelpText =>
      'נא לסמן תיבה זו אך ורק אם ברצונך לתעד את כמות הקלוריות מבלי להגדיר תוכנית תזונתית עם מנות ספציפיות';

  @override
  String get goalMacro => 'מטרות מזעריות';

  @override
  String get selectMealToLog => 'בחירת מנה לתיעוד ביומן';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'לא הוגדרו מנות בתוכניות התזונתית הנוכחית שלך';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'לצורך הוספת מנות לתוכנית, יש לגשת לפרטי התוכנית התזונתית';

  @override
  String get goalEnergy => 'יעד אנרגיה';

  @override
  String get goalProtein => 'יעד חלבונים';

  @override
  String get goalCarbohydrates => 'Carbohydrates goal';

  @override
  String get goalFat => 'יעד שומנים';

  @override
  String get goalFiber => 'יעד סיבים תזונתיים';

  @override
  String get anErrorOccurred => 'שגיאה קרתה!';

  @override
  String get errorInfoDescription =>
      'משהו השתבש, עמך הסליחה. ניתן לעזור לנו בתיקון התקלה בעזרת דיווח על הבעיה ב־GitHub.';

  @override
  String get errorInfoDescription2 =>
      'אפשר להמשיך להשתמש ביישום, אבל ייתכן כי תכונות מסוימות לא יעבדו.';

  @override
  String get errorViewDetails => 'פרטים טכניים';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'לא היה ניתן להתחבר לשרת';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'אין באפשרות היישום להתחבר לשרת. נא לבדוק את החיבור לאינטרנט או לכתובת השרת ולנסות שוב. אם הבעיה ממשיכה להתקיים, נא לפנות למנהל השרת.';

  @override
  String get copyToClipboard => 'העתקה ללוח';

  @override
  String get weight => 'משקל';

  @override
  String get min => 'מינ׳';

  @override
  String get max => 'מקס׳';

  @override
  String chartAllTimeTitle(String name) {
    return '$name בכל הזמנים';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name ב־30 הימים האחרונים';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName במסגרת התוכנית התזונתית $planName';
  }

  @override
  String get measurement => 'מדידה';

  @override
  String get measurements => 'מדידות';

  @override
  String get measurementCategoriesHelpText => 'קטגורית מדידה, כמו \'שריר הזרוע\' או \'שומן גוף\'';

  @override
  String get measurementEntriesHelpText =>
      'היחידה שמשתמשים למדוד את הקטגוריה כגון \'ס\"מ\' או \'%\'';

  @override
  String get date => 'תאריך';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'ערך';

  @override
  String get start => 'התחלה';

  @override
  String get time => 'זמן';

  @override
  String get timeStart => 'זמן התחלה';

  @override
  String get timeEnd => 'זמן סיום';

  @override
  String get timeStartAhead => 'זמן התחלה לא יכול להיות אחרי זמן סיום';

  @override
  String get ingredient => 'מרכיב';

  @override
  String get energy => 'אנרגיה';

  @override
  String get energyShort => 'אנרגיה';

  @override
  String get macronutrients => 'מקרונוטריאנטים';

  @override
  String get planned => 'מתוכנן';

  @override
  String get logged => 'נרשם';

  @override
  String get today => 'היום';

  @override
  String get loggedToday => 'תועדו היום';

  @override
  String get weekAverage => 'ממוצע שבועי';

  @override
  String get surplus => 'surplus';

  @override
  String get deficit => 'deficit';

  @override
  String get difference => 'הבדל';

  @override
  String get percentEnergy => 'אחוז של אנרגיה';

  @override
  String get gPerBodyKg => 'גרם עבור ק\"ג של משקל גוף';

  @override
  String get total => 'סה״כ';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value ק׳ קלוריות';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'גרם';

  @override
  String gValue(String value) {
    return '$value גר׳';
  }

  @override
  String percentValue(String value) {
    return '$value%';
  }

  @override
  String get protein => 'חלבון';

  @override
  String get proteinShort => 'חל׳';

  @override
  String get carbohydrates => 'פחמימות';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'סוכרים';

  @override
  String get fat => 'שומן';

  @override
  String get fatShort => 'שומנ׳';

  @override
  String get saturatedFat => 'שומן רווי';

  @override
  String get fiber => 'סיבים';

  @override
  String get sodium => 'נתרן';

  @override
  String get amount => 'כמות';

  @override
  String get unit => 'יחידת מידה';

  @override
  String get newEntry => 'רשומה חדשה';

  @override
  String get noWeightEntries => 'אין לך רשומות של משקל';

  @override
  String get noMeasurementEntries => 'You have no measurement entries';

  @override
  String get moreMeasurementEntries => 'הוספת מדד חדש';

  @override
  String get edit => 'עריכה';

  @override
  String get loadingText => 'טוען...';

  @override
  String get delete => 'מחיקה';

  @override
  String confirmDelete(String toDelete) {
    return 'האם את/ה בטוח/ה שאת/ה רוצה למחוק את \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'תוכנית תזונה חדשה';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'הסתר/הצג פירוט';

  @override
  String get goToDetailPage => 'עבור לדף פירוט';

  @override
  String get aboutWhySupportTitle => 'תוכנה בקוד פתוח, וחופשית לשימוש ❤️';

  @override
  String get aboutDescription =>
      'תודה לך על השימוש בווגר! ווגר הוא פרויקט קוד פתוח שנעשה על ידי אוהבי כושר מרחבי העולם.';

  @override
  String get aboutDonateTitle => 'תרומה כספית';

  @override
  String get aboutDonateText =>
      'בעוד המיזם הזה חופשי ותמיד יישאר כך, תפעול השרת כן עולה לנו כסף! גם הפיתוח דורש השקעה משמעותית של זמן ומאמץ של מתנדבים. התרומה שלך תלך ישירות לכיסוי העלויות האלה, המאפשרות לספק את השירות שלנו נאמנה.';

  @override
  String get aboutContributeTitle => 'התנדבות';

  @override
  String get aboutContributeText =>
      'אנחנו מעודדים את כל סוגי התרומה. בין אם היא מתבטאת בפיתוח קוד, תרגום, או אפילו רק תשוקה לכושר, אנו מעריכים כל סוג של תמיכה!';

  @override
  String get aboutBugsListTitle => 'דיווח על בעיה או הצעת תכונה חדשה';

  @override
  String get aboutTranslationListTitle => 'עזרה בתרגום היישום';

  @override
  String get aboutSourceListTitle => 'צפייה בקוד המקור';

  @override
  String get aboutJoinCommunityTitle => 'הצטרפות לקהילה';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'אחרים';

  @override
  String get calendar => 'לוח שנה';

  @override
  String get goToToday => 'עבור להיום';

  @override
  String get enterValue => 'אנא הכנס ערך';

  @override
  String get selectEntry => 'נא לבחור ערך';

  @override
  String get selectExercise => 'אנא בחר/י אימון';

  @override
  String enterCharacters(String min, String max) {
    return 'אנא בחר/י ערך בין $min ו-$max תווים';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'נא להקליד לפחות $min תווים';
  }

  @override
  String get baseNameEnglish => 'לכל התרגילים נחוץ שם מקור באנגלית';

  @override
  String nrOfSets(String nrOfSets) {
    return 'כמות סטים לאימון: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'יחידות סט וחזרות בעתודה';

  @override
  String get enterValidNumber => 'אנא הכנס מספר תקין';

  @override
  String get selectIngredient => 'אנא בחר מרכיב';

  @override
  String get recentlyUsedIngredients => 'מרכיבים שנוספו לאחרונה';

  @override
  String get selectImage => 'אנא בחר תמונה';

  @override
  String get optionsLabel => 'אפשרויות';

  @override
  String get takePicture => 'צלם תמונה';

  @override
  String get chooseFromLibrary => 'בחר מספריית תמונות';

  @override
  String get gallery => 'גלריה';

  @override
  String get addImage => 'הוסף תמונה';

  @override
  String get dataCopied => 'הנתונים הועתקו לערך החדש';

  @override
  String get appUpdateTitle => 'צריך לעדכן';

  @override
  String get appUpdateContent => 'גרסה זו של היישום אינה מסוגלת להתחבר לשרת, נא לעדכן את היישום.';

  @override
  String get productFound => 'המוצר נמצא';

  @override
  String productFoundDescription(String productName) {
    return 'הברקוד תואם למוצר: $productName. להמשיך?';
  }

  @override
  String get productNotFound => 'המוצר לא נמצא';

  @override
  String productNotFoundDescription(String barcode) {
    return 'לא נמצא המוצר עם הברקוד שנסרק $barcode במאגר של wger';
  }

  @override
  String get scanBarcode => 'סריקת ברקוד';

  @override
  String get close => 'סגירה';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'על התמונות להיות תואמות לרישיון CC BY SA. אם יש ספק כלשהו, יש להעלות רק תמונות שצילמת בעצמך.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'וריאציות';

  @override
  String alsoKnownAs(String aliases) {
    return 'מוכר גם בתור: $aliases';
  }

  @override
  String get verifiedEmail => 'דוא״ל מאומת';

  @override
  String get unVerifiedEmail => 'דוא״ל לא מאומת';

  @override
  String get verifiedEmailReason => 'עליך לאמת את הדואר האלקטרוני שלך כדי לתרום תרגילים';

  @override
  String verifiedEmailInfo(String email) {
    return 'נשלחה הודעת אימות לכתובת $email';
  }

  @override
  String get alternativeNames => 'שמות חלופיים';

  @override
  String get oneNamePerLine => 'שם אחד בכל שורה';

  @override
  String get whatVariationsExist => 'מהן הווריאציות שיש לתרגיל זה, אם קיימות?';

  @override
  String get previous => 'הקודם';

  @override
  String get next => 'הבא';

  @override
  String get images => 'תמונות';

  @override
  String get language => 'שפה';

  @override
  String get addExercise => 'הוספת תרגיל';

  @override
  String get fitInWeek => 'Fit in week';

  @override
  String get fitInWeekHelp =>
      'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.';

  @override
  String get addSuperset => 'Add superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set has progression';

  @override
  String get setHasProgressionWarning =>
      'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.';

  @override
  String get setHasNoExercises => 'עדיין אין אימונים בסט זה!';

  @override
  String get contributeExercise => 'לתרום תרגיל';

  @override
  String get translation => 'תרגום';

  @override
  String get translateExercise => 'לתרגם את התרגיל הזה כעת';

  @override
  String get baseData => 'Basics in English';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'הגדרות';

  @override
  String get settingsCacheTitle => 'מטמון';

  @override
  String get settingsExerciseCacheDescription => 'מטמון תרגילים';

  @override
  String get settingsIngredientCacheDescription => 'מטמון מרכיב';

  @override
  String get settingsCacheDeletedSnackbar => 'המטמון נוקה בהצלחה';

  @override
  String get aboutPageTitle => 'מידע כללי ותמיכה';

  @override
  String contributeExerciseWarning(String days) {
    return 'אפשר לתרום תרגילים אך ורק אם החשבון שלך בן יותר מ־$days ימים וכתובת הדואר האלקטרוני שלך מאומתת';
  }

  @override
  String get simpleMode => 'מצב פשוט';

  @override
  String get simpleModeHelp => 'Hide some of the more advanced settings when editing exercises';

  @override
  String get progressionRules =>
      'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.';

  @override
  String get cacheWarning =>
      'Due to caching it might take some time till the changes are visible throughout the application.';

  @override
  String get textPromptTitle => 'מוכנים להתחיל?';

  @override
  String get textPromptSubheading => 'נא ללחוץ על כפתור הפעולה כדי להתחיל';

  @override
  String get abs => 'שרירי בטן';

  @override
  String get arms => 'זרועות';

  @override
  String get back => 'גב';

  @override
  String get barbell => 'Barbell';

  @override
  String get bench => '';

  @override
  String get biceps => 'שרירי הקיבורת (דו־ראשיים)';

  @override
  String get body_weight => 'משקל הגוף';

  @override
  String get calves => 'Calves';

  @override
  String get cardio => 'סיבולת';

  @override
  String get chest => 'חזה';

  @override
  String get dumbbell => 'משקולות';

  @override
  String get glutes => 'Glutes';

  @override
  String get gym_mat => 'שטיח אימונים';

  @override
  String get hamstrings => 'Hamstrings';

  @override
  String get incline_bench => 'Incline bench';

  @override
  String get kettlebell => 'משקולות קטלבל';

  @override
  String get kilometers => 'קילומטרים';

  @override
  String get kilometers_per_hour => 'קילומטרים לשעה';

  @override
  String get lats => 'Lats';

  @override
  String get legs => 'רגליים';

  @override
  String get lower_back => 'גב תחתון';

  @override
  String get max_reps => 'מספר מרבי של חזרות';

  @override
  String get miles => 'מילים';

  @override
  String get miles_per_hour => 'מילים לשעה';

  @override
  String get minutes => 'דקות';

  @override
  String get plates => 'Plates';

  @override
  String get pull_up_bar => 'Pull-up bar';

  @override
  String get quads => 'Quads';

  @override
  String get repetitions => 'חזרות';

  @override
  String get resistance_band => 'רצועת התנגדות';

  @override
  String get sz_bar => 'SZ-Bar';

  @override
  String get seconds => 'שניות';

  @override
  String get shoulders => 'כתפיים';

  @override
  String get swiss_ball => 'כדור התעמלות';

  @override
  String get triceps => 'השרירים התלת־ראשיים';

  @override
  String get until_failure => 'Until Failure';

  @override
  String get kg => 'ק״ג';

  @override
  String get lb => 'פאונד';

  @override
  String get none__bodyweight_exercise_ => 'ללא (התרגיל מסתמך על משקל גוף)';

  @override
  String get log => 'תיעוד';

  @override
  String get done => 'סיום';

  @override
  String get overallChangeWeight => 'שינוי כללי';

  @override
  String get goalTypeMeals => 'From meals';

  @override
  String get goalTypeBasic => 'בסיסי';

  @override
  String get goalTypeAdvanced => 'מתקדם';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'ממוצע';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'ערכת עיצוב';

  @override
  String get darkMode => 'עיצוב כהה תמיד';

  @override
  String get lightMode => 'עיצוב בהיר תמיד';

  @override
  String get systemMode => 'הגדרות מערכת';
}
