// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Persian (`fa`).
class AppLocalizationsFa extends AppLocalizations {
  AppLocalizationsFa([String locale = 'fa']) : super(locale);

  @override
  String get userProfile => 'پروفایل شما';

  @override
  String get login => 'ورود';

  @override
  String get logout => 'خروج';

  @override
  String get register => 'ثبت نام';

  @override
  String get useDefaultServer => 'استفاده از سرور پیش فرض';

  @override
  String get useCustomServer => 'استفاده از سرور سفارشی (خصوصی)';

  @override
  String get invalidUrl => 'لطفا یک لینک معتبر وارد کنید';

  @override
  String get usernameValidChars =>
      'نام کاربری فقط میتواند شامل حروف انگلیسی، اعداد انگلیسی و این کاراکتر ها @ + . - _ باشد';

  @override
  String get passwordsDontMatch => 'رمزهای عبور مطابقت ندارند';

  @override
  String get passwordTooShort => 'رمز عبور خیلی کوتاه است';

  @override
  String get selectAvailablePlates => 'بشقاب‌های غذایی موجود را انتخاب کنید';

  @override
  String get barWeight => 'وزن میله';

  @override
  String get useColors => 'استفاده از رنگ ها';

  @override
  String get password => 'رمزعبور';

  @override
  String get confirmPassword => 'تأیید رمز عبور';

  @override
  String get invalidEmail => 'لطفا یک آدرس ایمیل معتبر وارد کنید';

  @override
  String get email => 'آدرس ایمیل';

  @override
  String get username => 'نام کاربری';

  @override
  String get invalidUsername => 'لطفا یک نام کاربری معتبر وارد کنید';

  @override
  String get useApiToken => 'استفاده از توکن API';

  @override
  String get useUsernameAndPassword => 'استفاده از نام کاربری و رمز عبور';

  @override
  String get apiToken => 'توکن API';

  @override
  String get invalidApiToken => 'لطفا یک کلید API معتبر وارد کنید';

  @override
  String get apiTokenValidChars =>
      'یک کلید API می‌تواند فقط شامل حروف انگلیسی a تا f، اعداد انگلیسی 0 تا 9 و دقیقاً 40 کاراکتر باشد';

  @override
  String get customServerUrl => 'آدرس اینترنتی (URL) به منبع WGER';

  @override
  String get customServerHint =>
      'آدرس سرور خودتان را وارد کنید، در غیر این صورت آدرس پیش‌فرض استفاده خواهد شد';

  @override
  String get reset => 'تنظیم مجدد';

  @override
  String get registerInstead => 'حساب کاربری ندارید؟ همین حالا ثبت نام کنید';

  @override
  String get loginInstead => 'حساب کاربری دارید؟ وارد شوید';

  @override
  String get labelBottomNavWorkout => 'تمرین ورزشی';

  @override
  String get labelBottomNavNutrition => 'تغذیه';

  @override
  String get labelWorkoutLogs => 'گزارش تمرینات';

  @override
  String get labelWorkoutPlan => 'برنامه تمرین ورزشی';

  @override
  String get labelDashboard => 'داشبورد';

  @override
  String get success => 'موفقیت';

  @override
  String get successfullyDeleted => 'حذف شده';

  @override
  String get successfullySaved => 'ذخیره شده';

  @override
  String get exerciseList => 'لیست تمرینات';

  @override
  String get exercise => 'تمرین';

  @override
  String get exercises => 'تمرین ها';

  @override
  String get exerciseName => 'نام تمرین';

  @override
  String get searchExercise => 'تمرین را برای افزودن جستجو کنید';

  @override
  String get noIngredientsDefined => 'هنوز هیچ مواد تشکیل دهنده ای تعریف نشده';

  @override
  String get noMatchingExerciseFound => 'هیچ تمرین مطابقی پیدا نشد';

  @override
  String get searchNamesInEnglish => 'اسامی را به زبان انگلیسی هم جستجو کنید';

  @override
  String get equipment => 'تجهیزات';

  @override
  String get muscles => 'Muscles';

  @override
  String get musclesSecondary => 'Secondary muscles';

  @override
  String get category => 'Category';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => 'Routines';

  @override
  String get newRoutine => 'New routine';

  @override
  String get noRoutines => 'You have no routines';

  @override
  String get reps => 'Reps';

  @override
  String get restTime => 'Rest time';

  @override
  String get sets => 'Sets';

  @override
  String get rir => 'RiR';

  @override
  String get rirNotUsed => 'RiR not used';

  @override
  String get useMetric => 'Use metric units for body weight';

  @override
  String get weightUnit => 'Weight unit';

  @override
  String get repetitionUnit => 'Repetition unit';

  @override
  String get set => 'Set';

  @override
  String get dayDescriptionHelp =>
      'A description of what is done on this day (e.g. \'pull day\') or what body parts are trained (e.g. \'chest and shoulders\')';

  @override
  String exerciseNr(String nr) {
    return 'Exercise $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'If you do the same repetitions and weight for all sets you can just fill in one row. For example for 4 sets just enter 10 for the repetitions, this automatically becomes \"4 x 10\".';

  @override
  String get comment => 'نظر';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Impression';

  @override
  String get notes => 'یادداشت‌ها';

  @override
  String get workoutSession => 'Workout session';

  @override
  String get restDay => 'Rest day';

  @override
  String get isRestDay => 'Is rest day';

  @override
  String get isRestDayHelp =>
      'Please note that all sets and exercises will be removed when you mark a day as a rest day.';

  @override
  String get needsLogsToAdvance => 'Needs logs to advance';

  @override
  String get needsLogsToAdvanceHelp =>
      'Select if you want the routine to progress to the next scheduled day only if you\'ve logged a workout for the day';

  @override
  String get routineDays => 'Days in routine';

  @override
  String get resultingRoutine => 'Resulting routine';

  @override
  String get newDay => 'روز جدید';

  @override
  String get newSet => 'مجموعه جدید';

  @override
  String get selectExercises =>
      'اگر می‌خواهید مجموعه ای از حرکات را انجام دهید، می‌توانید چندین تمرین را جستجو کنید، آنها در یک گروه قرار می‌گیرند';

  @override
  String get gymMode => 'حالت باشگاه';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'دیسک ها';

  @override
  String get plateCalculatorNotDivisible => 'با دیسک های موجود نمی‌توان به وزن دلخواه رسید';

  @override
  String get pause => 'توقف';

  @override
  String get jumpTo => 'برو به';

  @override
  String get todaysWorkout => 'تمرین ورزشی امروز شما';

  @override
  String get logHelpEntries =>
      'اگر در یک روز واحد بیش از یک ورودی با همان تعداد تکرارها وجود داشته باشد ، اما وزنهای مختلف ، فقط ورودی با وزن بالاتر در نمودار نشان داده می شود.';

  @override
  String get logHelpEntriesUnits =>
      'توجه داشته باشید که فقط ورودی هایی با واحد وزنی (کیلوگرم یا پوند) و تکرارها نمودار می شوند ، ترکیبات دیگری مانند زمان یا تا زمان خستگی در اینجا نادیده گرفته می شوند.';

  @override
  String get description => 'توضیحات';

  @override
  String get name => 'نام';

  @override
  String get save => 'ذخیره';

  @override
  String get verify => 'تأیید کردن';

  @override
  String get addSet => 'افزودن مجموعه';

  @override
  String get addMeal => 'افزودن وعده';

  @override
  String get mealLogged => 'غذا به دفتر گزارشات وارد شد';

  @override
  String get ingredientLogged => 'مواد به دفتر گزارشات وارد شد';

  @override
  String get logMeal => 'افزودن وعده به دفتر گزارشات غذایی';

  @override
  String get addIngredient => 'افزودن مواد تشکیل دهنده';

  @override
  String get logIngredient => 'افزودن مواد تشکیل دهنده به دفتر گزارشات غذایی';

  @override
  String get searchIngredient => 'جستجو مواد تشکیل دهنده';

  @override
  String get nutritionalPlan => 'برنامه غذایی';

  @override
  String get nutritionalDiary => 'دفتر گزارشات غذایی';

  @override
  String get nutritionalPlans => 'برنامه های غذایی';

  @override
  String get noNutritionalPlans => 'شما هیچ برنامه غذایی ندارید';

  @override
  String get onlyLogging => 'فقط کالری را شمارش کردن';

  @override
  String get onlyLoggingHelpText =>
      'اگر فقط می خواهید کالری خود را گزارش کنید و نمی خواهید یک برنامه غذایی دقیق را با وعده های غذایی خاص تنظیم کنید ، کادر را تیک بزنید';

  @override
  String get goalMacro => 'اهداف مواد مغذی';

  @override
  String get selectMealToLog => 'یک وعده انتخاب کنید تا به گزارشات اضافه شود';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'در برنامه غذایی فعلی شما هیچ وعده ای تعریف نشده است';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'برای افزودن وعده های غذایی به برنامه ، به جزئیات برنامه غذایی بروید';

  @override
  String get goalEnergy => 'هدف انرژی';

  @override
  String get goalProtein => 'هدف پروتئینی';

  @override
  String get goalCarbohydrates => 'هدف کربوهیدراتی';

  @override
  String get goalFat => 'هدف چربی';

  @override
  String get goalFiber => 'هدف فیبری';

  @override
  String get anErrorOccurred => 'خطایی رخ داد!';

  @override
  String get errorInfoDescription =>
      'متأسفیم ، اما مشکلی پیش آمد. شما می توانید با گزارش آن در GitHub به ما در رفع این مشکل کمک کنید.';

  @override
  String get errorInfoDescription2 =>
      'شما می توانید به استفاده از برنامه ادامه دهید ، اما برخی از ویژگی ها ممکن است کار نکند.';

  @override
  String get errorViewDetails => 'جزئیات فنی';

  @override
  String get applicationLogs => 'گزارشات اپلیکیشن';

  @override
  String get errorCouldNotConnectToServer => 'اتصال به سرور امکان پذیر نیست';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'برنامه نمی تواند به سرور وصل شود. لطفاً اتصال اینترنت یا URL سرور خود را بررسی کرده و دوباره امتحان کنید. اگر مشکل ادامه پیدا کرد، با مدیر سرور تماس بگیرید.';

  @override
  String get copyToClipboard => 'کپی در کلیپ بورد';

  @override
  String get weight => 'وزن';

  @override
  String get min => 'حداقل';

  @override
  String get max => 'حداکثر';

  @override
  String chartAllTimeTitle(String name) {
    return 'نمودار کلی $name';
  }

  @override
  String chart30DaysTitle(String name) {
    return 'نمودار 30 روزه $name';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return 'نمودار $chartName در برنامه $planName';
  }

  @override
  String get measurement => 'اندازه گیری';

  @override
  String get measurements => 'اندازه گیری ها';

  @override
  String get measurementCategoriesHelpText => 'دسته اندازه گیری ، مانند \"دوسر\" یا \"چربی بدن\"';

  @override
  String get measurementEntriesHelpText =>
      'واحد مورد استفاده برای اندازه گیری دسته مانند \"سانتی متر\" یا \"٪\"';

  @override
  String get date => 'تاریخ';

  @override
  String get endDate => 'تاریخ پایان';

  @override
  String get openEnded => 'پایان باز';

  @override
  String get value => 'مقدار';

  @override
  String get start => 'شروع';

  @override
  String get time => 'زمان';

  @override
  String get timeStart => 'زمان شروع';

  @override
  String get timeEnd => 'زمان پایان';

  @override
  String get timeStartAhead => 'زمان شروع نمیتواند جلوتر از زمان پایان باشد';

  @override
  String get ingredient => 'مواد تشکیل دهنده';

  @override
  String get energy => 'انرژی';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutrients';

  @override
  String get planned => 'Planned';

  @override
  String get logged => 'Logged';

  @override
  String get today => 'Today';

  @override
  String get loggedToday => 'Logged today';

  @override
  String get weekAverage => '7 day average';

  @override
  String get surplus => 'surplus';

  @override
  String get deficit => 'deficit';

  @override
  String get difference => 'تفاوت';

  @override
  String get percentEnergy => 'Percent of energy';

  @override
  String get gPerBodyKg => 'g per body kg';

  @override
  String get total => 'Total';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Protein';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Carbohydrates';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Sugars';

  @override
  String get fat => 'Fat';

  @override
  String get fatShort => 'F';

  @override
  String get saturatedFat => 'Saturated fat';

  @override
  String get fiber => 'Fibers';

  @override
  String get sodium => 'Sodium';

  @override
  String get amount => 'Amount';

  @override
  String get unit => 'واحد';

  @override
  String get newEntry => 'New entry';

  @override
  String get noWeightEntries => 'You have no weight entries';

  @override
  String get noMeasurementEntries => 'You have no measurement entries';

  @override
  String get moreMeasurementEntries => 'Add new measurement';

  @override
  String get edit => 'ویرایش';

  @override
  String get loadingText => 'Loading...';

  @override
  String get delete => 'حذف';

  @override
  String confirmDelete(String toDelete) {
    return 'Are you sure you want to delete \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'New nutritional plan';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'Toggle details';

  @override
  String get goToDetailPage => 'Go to detail page';

  @override
  String get aboutWhySupportTitle => 'Open Source & free to use ❤️';

  @override
  String get aboutDescription =>
      'Thank you for using wger! wger is a collaborative open source project, made by fitness enthusiasts from around the world.';

  @override
  String get aboutDonateTitle => 'Make a donation';

  @override
  String get aboutDonateText =>
      'While the project is free and will always remain it, running the server isn’t! Development also takes significant time and effort from volunteers. Your contribution directly supports these costs, helping to keep the service reliable.';

  @override
  String get aboutContributeTitle => 'Contribute';

  @override
  String get aboutContributeText =>
      'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!';

  @override
  String get aboutBugsListTitle => 'Report a problem or suggest a feature';

  @override
  String get aboutTranslationListTitle => 'Translate the application';

  @override
  String get aboutSourceListTitle => 'View source code';

  @override
  String get aboutJoinCommunityTitle => 'Join the community';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Others';

  @override
  String get calendar => 'Calendar';

  @override
  String get goToToday => 'Go to today';

  @override
  String get enterValue => 'Please enter a value';

  @override
  String get selectEntry => 'Please select an entry';

  @override
  String get selectExercise => 'Please select an exercise';

  @override
  String enterCharacters(String min, String max) {
    return 'Please enter between $min and $max characters';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Please enter at least $min characters';
  }

  @override
  String get baseNameEnglish => 'All exercises need a base name in English';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Sets per exercise: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Set units and RiR';

  @override
  String get enterValidNumber => 'Please enter a valid number';

  @override
  String get selectIngredient => 'Please select an ingredient';

  @override
  String get recentlyUsedIngredients => 'Recently added ingredients';

  @override
  String get selectImage => 'Please select an image';

  @override
  String get optionsLabel => 'Options';

  @override
  String get takePicture => 'Take a picture';

  @override
  String get chooseFromLibrary => 'Choose from photo library';

  @override
  String get gallery => 'Gallery';

  @override
  String get addImage => 'Add image';

  @override
  String get dataCopied => 'Data copied to new entry';

  @override
  String get appUpdateTitle => 'Update needed';

  @override
  String get appUpdateContent =>
      'This version of the app is not compatible with the server, please update your application.';

  @override
  String get productFound => 'Product found';

  @override
  String productFoundDescription(String productName) {
    return 'The barcode corresponds to this product: $productName. Do you want to continue?';
  }

  @override
  String get productNotFound => 'Product not found';

  @override
  String productNotFoundDescription(String barcode) {
    return 'The product with the scanned barcode $barcode was not found in the wger database';
  }

  @override
  String get scanBarcode => 'Scan barcode';

  @override
  String get close => 'بستن';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'Images must be compatible with the CC BY SA license. If in doubt, upload only photos you\'ve taken yourself.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'Variations';

  @override
  String alsoKnownAs(String aliases) {
    return 'Also known as: $aliases';
  }

  @override
  String get verifiedEmail => 'Verified email';

  @override
  String get unVerifiedEmail => 'Unverified email';

  @override
  String get verifiedEmailReason => 'You need to verify your email to contribute exercises';

  @override
  String verifiedEmailInfo(String email) {
    return 'A verification email was sent to $email';
  }

  @override
  String get alternativeNames => 'Alternative names';

  @override
  String get oneNamePerLine => 'One name per line';

  @override
  String get whatVariationsExist => 'What variations of this exercise exist, if any?';

  @override
  String get previous => 'Previous';

  @override
  String get next => 'Next';

  @override
  String get images => 'Images';

  @override
  String get language => 'Language';

  @override
  String get addExercise => 'Add exercise';

  @override
  String get fitInWeek => 'Fit in week';

  @override
  String get fitInWeekHelp =>
      'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.';

  @override
  String get addSuperset => 'Add superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set has progression';

  @override
  String get setHasProgressionWarning =>
      'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.';

  @override
  String get setHasNoExercises => 'This set has no exercises yet!';

  @override
  String get contributeExercise => 'Contribute an exercise';

  @override
  String get translation => 'Translation';

  @override
  String get translateExercise => 'Translate this exercise now';

  @override
  String get baseData => 'Basics in English';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Settings';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Exercise cache';

  @override
  String get settingsIngredientCacheDescription => 'Ingredient cache';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache successfully cleared';

  @override
  String get aboutPageTitle => 'About us & Support';

  @override
  String contributeExerciseWarning(String days) {
    return 'You can only contribute exercises if your account is older than $days days and have verified your email';
  }

  @override
  String get simpleMode => 'Simple mode';

  @override
  String get simpleModeHelp => 'Hide some of the more advanced settings when editing exercises';

  @override
  String get progressionRules =>
      'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.';

  @override
  String get cacheWarning =>
      'Due to caching it might take some time till the changes are visible throughout the application.';

  @override
  String get textPromptTitle => 'Ready to start?';

  @override
  String get textPromptSubheading => 'Press the action button to begin';

  @override
  String get abs => 'Abs';

  @override
  String get arms => 'Arms';

  @override
  String get back => 'Back';

  @override
  String get barbell => 'Barbell';

  @override
  String get bench => 'Bench';

  @override
  String get biceps => 'Biceps';

  @override
  String get body_weight => 'Body Weight';

  @override
  String get calves => 'Calves';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Chest';

  @override
  String get dumbbell => 'Dumbbell';

  @override
  String get glutes => 'Glutes';

  @override
  String get gym_mat => 'Gym mat';

  @override
  String get hamstrings => 'Hamstrings';

  @override
  String get incline_bench => 'Incline bench';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Kilometers';

  @override
  String get kilometers_per_hour => 'Kilometers Per Hour';

  @override
  String get lats => 'Lats';

  @override
  String get legs => 'Legs';

  @override
  String get lower_back => 'Lower back';

  @override
  String get max_reps => 'Max Reps';

  @override
  String get miles => 'Miles';

  @override
  String get miles_per_hour => 'Miles Per Hour';

  @override
  String get minutes => 'Minutes';

  @override
  String get plates => 'Plates';

  @override
  String get pull_up_bar => 'Pull-up bar';

  @override
  String get quads => 'Quads';

  @override
  String get repetitions => 'Repetitions';

  @override
  String get resistance_band => 'Resistance band';

  @override
  String get sz_bar => 'SZ-Bar';

  @override
  String get seconds => 'Seconds';

  @override
  String get shoulders => 'Shoulders';

  @override
  String get swiss_ball => 'Swiss Ball';

  @override
  String get triceps => 'Triceps';

  @override
  String get until_failure => 'Until Failure';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'none (bodyweight exercise)';

  @override
  String get log => 'Log';

  @override
  String get done => 'Done';

  @override
  String get overallChangeWeight => 'Overall change';

  @override
  String get goalTypeMeals => 'From meals';

  @override
  String get goalTypeBasic => 'Basic';

  @override
  String get goalTypeAdvanced => 'Advanced';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'avg';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Theme mode';

  @override
  String get darkMode => 'Always dark mode';

  @override
  String get lightMode => 'Always light mode';

  @override
  String get systemMode => 'System settings';
}
