// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Spanish Castilian (`es`).
class AppLocalizationsEs extends AppLocalizations {
  AppLocalizationsEs([String locale = 'es']) : super(locale);

  @override
  String get userProfile => 'Tu perfil';

  @override
  String get login => 'Iniciar sesión';

  @override
  String get logout => 'Cerrar sesión';

  @override
  String get register => 'Registrarse';

  @override
  String get useDefaultServer => 'Usar el servidor predeterminado';

  @override
  String get useCustomServer => 'Utilizar un servidor personalizado';

  @override
  String get invalidUrl => 'Por favor, introduzca una URL válida';

  @override
  String get usernameValidChars =>
      'Un nombre de usuario solo puede contener letras, dígitos y los caracteres @, +, ., - y _';

  @override
  String get passwordsDontMatch => 'Las contraseñas no coinciden';

  @override
  String get passwordTooShort => 'La contraseña es demasiado corta';

  @override
  String get selectAvailablePlates => 'Elige los discos disponibles';

  @override
  String get barWeight => 'Peso de la barra';

  @override
  String get useColors => 'Usar colores';

  @override
  String get password => 'Contraseña';

  @override
  String get confirmPassword => 'Confirmar contraseña';

  @override
  String get invalidEmail => 'Por favor, introduce una dirección de correo electrónico válida';

  @override
  String get email => 'Dirección de correo electrónico';

  @override
  String get username => 'Nombre de usuario';

  @override
  String get invalidUsername => 'Por favor, ingrese un nombre de usuario válido';

  @override
  String get useApiToken => 'Usar tokens API';

  @override
  String get useUsernameAndPassword => 'Utilizar usuario y contraseña';

  @override
  String get apiToken => 'Token API';

  @override
  String get invalidApiToken => 'Por favor, Introduzca una clave API válida';

  @override
  String get apiTokenValidChars =>
      'Una clave API solo puede contener las letras a-f, números 0-9 y tener exactamente 40 caracteres de longitud';

  @override
  String get customServerUrl => 'URL de la instancia de wger';

  @override
  String get customServerHint =>
      'Ingresa la dirección de tu propio servidor, de lo contrario se utilizará la dirección por default';

  @override
  String get reset => 'Reiniciar';

  @override
  String get registerInstead => '¿No tienes una cuenta? Regístrate ahora';

  @override
  String get loginInstead => '¿Ya tiene una cuenta? Inicia sesión';

  @override
  String get labelBottomNavWorkout => 'Rutina';

  @override
  String get labelBottomNavNutrition => 'Nutrición';

  @override
  String get labelWorkoutLogs => 'Registros de entrenamientos';

  @override
  String get labelWorkoutPlan => 'Plan de ejercicios';

  @override
  String get labelDashboard => 'Tablero';

  @override
  String get success => 'Éxito';

  @override
  String get successfullyDeleted => 'Borrado';

  @override
  String get successfullySaved => 'Guardado correctamente';

  @override
  String get exerciseList => 'Lista de ejercicios';

  @override
  String get exercise => 'Ejercicio';

  @override
  String get exercises => 'Ejercicios';

  @override
  String get exerciseName => 'Nombre del Ejercicio';

  @override
  String get searchExercise => 'Busca el ejercicio para añadirlo';

  @override
  String get noIngredientsDefined => 'Aún no se definen ingredientes';

  @override
  String get noMatchingExerciseFound => 'No se encontraron ejercicios que coincidan';

  @override
  String get searchNamesInEnglish => 'También busque nombres en Ingles';

  @override
  String get equipment => 'Equipamiento';

  @override
  String get muscles => 'Músculos';

  @override
  String get musclesSecondary => 'Músculos secundarios';

  @override
  String get category => 'Categoría';

  @override
  String get startDate => 'Fecha de inicio';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => 'Rutinas';

  @override
  String get newRoutine => 'Nueva rutina';

  @override
  String get noRoutines => 'No hay rutinas';

  @override
  String get reps => 'Repeticiones';

  @override
  String get restTime => 'Tiempo de descanso';

  @override
  String get sets => 'El número de rondas para cada ejercicio';

  @override
  String get rir => 'ReR';

  @override
  String get rirNotUsed => 'Valor ReR sin usar';

  @override
  String get useMetric => 'Utilizar unidades metricas para el peso corporal';

  @override
  String get weightUnit => 'Unidad de peso';

  @override
  String get repetitionUnit => 'Unidad de repetición';

  @override
  String get set => 'Serie';

  @override
  String get dayDescriptionHelp =>
      'Una descripción de lo que se hace este día (ej. \'día de levantamientos\') o qué partes del cuerpo se entrenan (ej. \'pecho y hombros\')';

  @override
  String exerciseNr(String nr) {
    return 'Ejercicio $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'Si haces las mismas repeticiones y el mismo peso para todas las series, solo puedes completar una fila. Por ejemplo, para 4 series solo ingrese 10 para las repeticiones, esto automáticamente se convierte en \"4 x 10\".';

  @override
  String get comment => 'Comentar';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Impresión general';

  @override
  String get notes => 'Notas personales';

  @override
  String get workoutSession => 'Sesión de entrenamiento';

  @override
  String get restDay => 'Día de descanso';

  @override
  String get isRestDay => 'Descanso';

  @override
  String get isRestDayHelp =>
      'Favor de considerar que todos los sets y ejercicios se eliminarán al marcar el día como descanso.';

  @override
  String get needsLogsToAdvance => 'Necesita registros para avanzar';

  @override
  String get needsLogsToAdvanceHelp =>
      'Seleccione esta opción si desea que la rutina avance al siguiente día programado solo si ha registrado un entrenamiento para ese día';

  @override
  String get routineDays => 'Días en rutina';

  @override
  String get resultingRoutine => 'Rutina resultante';

  @override
  String get newDay => 'Nuevo día';

  @override
  String get newSet => 'Nueva serie';

  @override
  String get selectExercises =>
      'Si quieres hacer una superserie puedes buscar varios ejercicios, se agruparán juntos';

  @override
  String get gymMode => 'Modo gimansio';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Placas';

  @override
  String get plateCalculatorNotDivisible => 'No se puede obtener el peso con las placas disponbles';

  @override
  String get pause => 'Pausa';

  @override
  String get jumpTo => 'Saltar a';

  @override
  String get todaysWorkout => 'Tu rutina de hoy';

  @override
  String get logHelpEntries =>
      'Si en un solo día hay más de una entrada con el mismo número de repeticiones, pero diferentes pesos, solo la entrada con mayor peso se mostrará en el diagrama.';

  @override
  String get logHelpEntriesUnits =>
      'Tenga en cuenta que solo se registran las entradas con una unidad de peso (kg o lb) y las repeticiones; aquí se ignoran otras combinaciones, como el tiempo o hasta el fallo.';

  @override
  String get description => 'Descripción';

  @override
  String get name => 'Nombre';

  @override
  String get save => 'Guardar';

  @override
  String get verify => 'Verificar';

  @override
  String get addSet => 'Agregar serie';

  @override
  String get addMeal => 'Agregar comida';

  @override
  String get mealLogged => 'Comida registrada en el diario';

  @override
  String get ingredientLogged => 'Ingrediente registrado en el diario';

  @override
  String get logMeal => 'Registrar esta comida';

  @override
  String get addIngredient => 'Agregar ingrediente';

  @override
  String get logIngredient => 'Registrar en el diario nutricional';

  @override
  String get searchIngredient => 'Buscar ingrediente';

  @override
  String get nutritionalPlan => 'Plan nutricional';

  @override
  String get nutritionalDiary => 'Diario nutricional';

  @override
  String get nutritionalPlans => 'Planes nutricionales';

  @override
  String get noNutritionalPlans => 'No tienes planes nutricionales';

  @override
  String get onlyLogging => 'Solo registrar las calorías';

  @override
  String get onlyLoggingHelpText =>
      'Marque la casilla si solo desea registrar sus calorías y no desea configurar un plan nutricional detallado con comidas específicas';

  @override
  String get goalMacro => 'Meta de Macros';

  @override
  String get selectMealToLog => 'Selecciona una comida para registrar en el diario';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Tu plan de nutrición no tiene comidas definidas';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Para agregar comidas al plan, vaya a los detalles del plan nutricional';

  @override
  String get goalEnergy => 'Objetivo energético';

  @override
  String get goalProtein => 'Objetivo de proteina';

  @override
  String get goalCarbohydrates => 'Objetivo de carbohidratos';

  @override
  String get goalFat => 'Objetivo de grasas';

  @override
  String get goalFiber => 'Objetivo de fibra';

  @override
  String get anErrorOccurred => '¡Un error ha ocurrido!';

  @override
  String get errorInfoDescription =>
      'Lo sentimos pero algo no ha funcionado como esperábamos. Puedes ayudarnos a arreglarlo reportando el problema en GitHub.';

  @override
  String get errorInfoDescription2 =>
      'Puedes seguir utilizando la aplicación pero algunas características pueden no funcionar.';

  @override
  String get errorViewDetails => 'Detalles técnicos';

  @override
  String get applicationLogs => 'Registro de la aplicación';

  @override
  String get errorCouldNotConnectToServer => 'No se pudo conectar con el servidor';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'La aplicación no se pudo conectar con el servidor. Por favor, comprueba to conexión a internet o la URL del servidor y prueba de nuevo. Si el problema persiste, contacta con el administrador del servidor.';

  @override
  String get copyToClipboard => 'Copiar al portapapeles';

  @override
  String get weight => 'Peso';

  @override
  String get min => 'Mínimo';

  @override
  String get max => 'Máximo';

  @override
  String chartAllTimeTitle(String name) {
    return 'Histórico $name';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name ultimos 30 días';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName durante el plan nutricional $planName';
  }

  @override
  String get measurement => 'Medida';

  @override
  String get measurements => 'Medidas';

  @override
  String get measurementCategoriesHelpText =>
      'Categoría de medición, como \"bíceps\" o \"grasa corporal\"';

  @override
  String get measurementEntriesHelpText =>
      'La unidad utilizada para medir la categoría, como \"cm\" o \"%\"';

  @override
  String get date => 'Fecha';

  @override
  String get endDate => 'Fecha de finalización';

  @override
  String get openEnded => 'Indefinido';

  @override
  String get value => 'Valor';

  @override
  String get start => 'Comenzar';

  @override
  String get time => 'Tiempo';

  @override
  String get timeStart => 'Tiempo de inicio';

  @override
  String get timeEnd => 'Tiempo de fin';

  @override
  String get timeStartAhead => 'La hora de inicio no puede adelantarse a la hora de finalización';

  @override
  String get ingredient => 'Ingrediente';

  @override
  String get energy => 'Energía';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutrientes';

  @override
  String get planned => 'Previsto';

  @override
  String get logged => 'Registrado';

  @override
  String get today => 'Hoy';

  @override
  String get loggedToday => 'Registrado hoy';

  @override
  String get weekAverage => 'Promedio de 7 días';

  @override
  String get surplus => 'exceso calórico';

  @override
  String get deficit => 'déficit calórico';

  @override
  String get difference => 'Diferencia';

  @override
  String get percentEnergy => 'Porcentaje de energía';

  @override
  String get gPerBodyKg => 'g por kg de peso corporal';

  @override
  String get total => 'Total';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Proteína';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Carbohidratos';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Azúcares';

  @override
  String get fat => 'Grasas';

  @override
  String get fatShort => 'G';

  @override
  String get saturatedFat => 'Grasas saturadas';

  @override
  String get fiber => 'Fibra';

  @override
  String get sodium => 'Sodio';

  @override
  String get amount => 'Cantidad';

  @override
  String get unit => 'Unidad';

  @override
  String get newEntry => 'Nueva entrada';

  @override
  String get noWeightEntries => 'No tienes entradas de peso registradas';

  @override
  String get noMeasurementEntries => 'No has ingresado medidas';

  @override
  String get moreMeasurementEntries => 'Agrega una nueva medida';

  @override
  String get edit => 'Editar';

  @override
  String get loadingText => 'Cargando...';

  @override
  String get delete => 'Borrar';

  @override
  String confirmDelete(String toDelete) {
    return '¿Estás seguro de que deseas borrar \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Nuevo plan nutricional';

  @override
  String get overview => 'Descripción general';

  @override
  String get toggleDetails => 'Alternar detalles';

  @override
  String get goToDetailPage => 'Ir a la página de detalles';

  @override
  String get aboutWhySupportTitle => 'Código abierto y de uso gratuito ❤️';

  @override
  String get aboutDescription =>
      '¡Gracias por usar wger! wger es un proyecto colaborativo de código abierto, realizado por entusiastas del fitness de todo el planeta.';

  @override
  String get aboutDonateTitle => 'Realizar una donación';

  @override
  String get aboutDonateText =>
      'Si bien el proyecto es gratuito y siempre lo seguirá siendo, ¡ejecutar el servidor no lo es! El desarrollo también requiere mucho tiempo y esfuerzo por parte de los voluntarios. Su contribución respalda directamente estos costos, lo que ayuda a mantener el servicio confiable.';

  @override
  String get aboutContributeTitle => 'Contribuir';

  @override
  String get aboutContributeText =>
      'Todos los tipos de contribuciones son bien recibidas. Ya seas desarrollador, traductor o un apasionado por el deporte, toda ayuda es bien recibida.';

  @override
  String get aboutBugsListTitle => 'Informar un problema o sugerir una característica';

  @override
  String get aboutTranslationListTitle => 'Traducir la aplicación';

  @override
  String get aboutSourceListTitle => 'Ver código fuente';

  @override
  String get aboutJoinCommunityTitle => 'Unirse a la comunidad';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Otros';

  @override
  String get calendar => 'Calendario';

  @override
  String get goToToday => 'Ir a \"hoy\"';

  @override
  String get enterValue => 'Por favor ingresa un valor';

  @override
  String get selectEntry => 'Por favor selecciona una entrada';

  @override
  String get selectExercise => 'Por favor selecciona un ejercicio';

  @override
  String enterCharacters(String min, String max) {
    return 'Por favor ingresa entre $min y $max caracteres';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Por favor ingresa al menos $min caracteres';
  }

  @override
  String get baseNameEnglish => 'Todos los ejercicios necesitan un nombre base en Inglés';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Series por ejercicio: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Unidades de serie y ReR';

  @override
  String get enterValidNumber => 'Por favor ingresa un número válido';

  @override
  String get selectIngredient => 'Por favor selecciona un ingrediente';

  @override
  String get recentlyUsedIngredients => 'Ingredientes añadidos recientemente';

  @override
  String get selectImage => 'Por favor selecciona una imagen';

  @override
  String get optionsLabel => 'Opciones';

  @override
  String get takePicture => 'Toma una foto';

  @override
  String get chooseFromLibrary => 'Elije de la biblioteca de fotos';

  @override
  String get gallery => 'Galería';

  @override
  String get addImage => 'Añadir imagen';

  @override
  String get dataCopied => 'Datos copiados a la nueva entrada';

  @override
  String get appUpdateTitle => 'Es necesario actualizar';

  @override
  String get appUpdateContent =>
      'Esta versión de la aplicación no es compatible con el servidor. Por favor, actualízala.';

  @override
  String get productFound => 'Producto encontrado';

  @override
  String productFoundDescription(String productName) {
    return 'El código de barras corresponde a este producto: $productName. ¿Deseas continuar?';
  }

  @override
  String get productNotFound => 'Producto no encontrado';

  @override
  String productNotFoundDescription(String barcode) {
    return 'El producto con el código de barras escaneado $barcode no se ha encontrado en la base de datos de wger';
  }

  @override
  String get scanBarcode => 'Escanear código de barras';

  @override
  String get close => 'Cerrar';

  @override
  String get identicalExercisePleaseDiscard =>
      'Si observa un ejercicio idéntico al que está agregando, descarte el borrador y edítelo en su lugar.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Por favor verifique que la información que ingresó sea correcta antes de enviar el ejercicio';

  @override
  String get add_exercise_image_license =>
      'Las imágenes deben ser compatibles con la licencia CC BY SA. Si tienes dudas, sube solamente fotos que hayas tomado tú mismo.';

  @override
  String get imageDetailsTitle => 'Detalles de la imagen';

  @override
  String get imageDetailsLicenseTitle => 'Título';

  @override
  String get imageDetailsLicenseTitleHint => 'Introduce el título de la imagen';

  @override
  String get imageDetailsSourceLink => 'Enlace al sitio web de origen';

  @override
  String get author => 'Autor(es)';

  @override
  String get authorHint => 'Introduce el nombre del autor';

  @override
  String get imageDetailsAuthorLink => 'Enlace al sitio web o perfil del autor';

  @override
  String get imageDetailsDerivativeSource =>
      'Enlace a la fuente original, si se trata de un trabajo derivado';

  @override
  String get imageDetailsDerivativeHelp =>
      'Un trabajo derivado se basa en un trabajo anterior, pero contiene suficiente contenido nuevo y creativo para darle derecho a sus propios derechos de autor.';

  @override
  String get imageDetailsImageType => 'Tipo de imagen';

  @override
  String get imageDetailsLicenseNotice =>
      'Al enviar esta imagen, acepta divulgarla según la licencia CC-BY-SA-4. La imagen debe ser obra propia o el autor debe haberla publicado bajo una licencia compatible con ella.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'Ver texto de licencia.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat no compatible';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return 'Las imágenes $imageFormat aún no son compatibles.';
  }

  @override
  String get add => 'agregar';

  @override
  String get variations => 'Variantes';

  @override
  String alsoKnownAs(String aliases) {
    return 'También conocido como: $aliases';
  }

  @override
  String get verifiedEmail => 'Correo electrónico verificado';

  @override
  String get unVerifiedEmail => 'Correo electrónico no verificado';

  @override
  String get verifiedEmailReason =>
      'Necesitas verificar tu correo electrónico para contribuir con ejercicios';

  @override
  String verifiedEmailInfo(String email) {
    return 'Se envió un correo electrónico de verificación a $email';
  }

  @override
  String get alternativeNames => 'Nombres alternativos';

  @override
  String get oneNamePerLine => 'Un nombre por línea';

  @override
  String get whatVariationsExist => '¿Qué variantes de este ejercicio existen, si las hay?';

  @override
  String get previous => 'Anterior';

  @override
  String get next => 'Siguiente';

  @override
  String get images => 'Imágenes';

  @override
  String get language => 'Lenguaje';

  @override
  String get addExercise => 'Añadir ejercicio';

  @override
  String get fitInWeek => 'En forma en una semana';

  @override
  String get fitInWeekHelp =>
      'Si está activado, los días se repetirán en un ciclo semanal, de la otra manera, los días serán secuenciales sin importar el inicio de una nueva semana.';

  @override
  String get addSuperset => 'Añadir superserie';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set con progresión';

  @override
  String get setHasProgressionWarning =>
      'Tenga en cuenta que, por el momento, no es posible editar todos los ajustes de un set en la aplicación móvil ni configurar la progresión automática. Por ahora, utilice la aplicación web.';

  @override
  String get setHasNoExercises => '¡Esta rutina no tiene ejercicios!';

  @override
  String get contributeExercise => 'Aporta un ejercicio';

  @override
  String get translation => 'Traducción';

  @override
  String get translateExercise => 'Traduce este ejercicio ahora';

  @override
  String get baseData => 'Conceptos básicos en Inglés';

  @override
  String get enterTextInLanguage => '¡Por favor ingrese el texto en el idioma correcto!';

  @override
  String get settingsTitle => 'Configuraciones';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Cache de ejercicios';

  @override
  String get settingsIngredientCacheDescription => 'Cache de ingredientes';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache borrado exitosamente';

  @override
  String get aboutPageTitle => 'Acerca de Wger y soporte';

  @override
  String contributeExerciseWarning(String days) {
    return 'Podes contribuir ejercicios únicamente si tu cuenta tiene más de $days días y tu email fue verificado';
  }

  @override
  String get simpleMode => 'Modo simple';

  @override
  String get simpleModeHelp => 'Ocultar ajustes avanzados cuando se editan los ejercicios';

  @override
  String get progressionRules =>
      'Este ejercicio tiene reglas de progresión y no puede ser editado en la aplicación móvil. Por favor, usa la aplicación web para editarlo.';

  @override
  String get cacheWarning =>
      'Debido al cache, puede tomar un tiempo hasta que los cambios sean visibles en toda la aplicación.';

  @override
  String get textPromptTitle => '¿Listo para comenzar?';

  @override
  String get textPromptSubheading => 'Presione el botón para continuar';

  @override
  String get abs => 'Abdominales';

  @override
  String get arms => 'Brazos';

  @override
  String get back => 'Espalda';

  @override
  String get barbell => 'Barra con pesas';

  @override
  String get bench => 'Banco';

  @override
  String get biceps => 'Bíceps';

  @override
  String get body_weight => 'Peso Corporal';

  @override
  String get calves => 'Pantorrillas';

  @override
  String get cardio => 'Aerobico';

  @override
  String get chest => 'Pecho';

  @override
  String get dumbbell => 'Mancuerna';

  @override
  String get glutes => 'Glúteos';

  @override
  String get gym_mat => 'Colchoneta';

  @override
  String get hamstrings => 'Isquiotibiales';

  @override
  String get incline_bench => 'Banco inclinado';

  @override
  String get kettlebell => 'Pesa rusa';

  @override
  String get kilometers => 'Kilómetros';

  @override
  String get kilometers_per_hour => 'Kilómetros por Hora';

  @override
  String get lats => 'Laterales';

  @override
  String get legs => 'Piernas';

  @override
  String get lower_back => 'Espalda baja';

  @override
  String get max_reps => 'Reps Max';

  @override
  String get miles => 'Millas';

  @override
  String get miles_per_hour => 'Millas por Hora';

  @override
  String get minutes => 'Minutos';

  @override
  String get plates => 'Platos';

  @override
  String get pull_up_bar => 'Barra de dominadas';

  @override
  String get quads => 'Cuádriceps';

  @override
  String get repetitions => 'Repeticiones';

  @override
  String get resistance_band => 'Banda de resistencia';

  @override
  String get sz_bar => 'Barra SZ';

  @override
  String get seconds => 'Segundos';

  @override
  String get shoulders => 'Hombros';

  @override
  String get swiss_ball => 'Pelota Suiza';

  @override
  String get triceps => 'Tríceps';

  @override
  String get until_failure => 'Hasta el fallo';

  @override
  String get kg => 'Kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'Ninguno (ejercicio de peso corporal)';

  @override
  String get log => 'Registro';

  @override
  String get done => 'Listo';

  @override
  String get overallChangeWeight => 'Cambio general';

  @override
  String get goalTypeMeals => 'De las comidas';

  @override
  String get goalTypeBasic => 'Básico';

  @override
  String get goalTypeAdvanced => 'Avanzado';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'medio';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Modo del tema';

  @override
  String get darkMode => 'Siempre en modo oscuro';

  @override
  String get lightMode => 'Siempre en modo claro';

  @override
  String get systemMode => 'Configuracion del sistema';
}
