// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class AppLocalizationsDe extends AppLocalizations {
  AppLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get userProfile => 'Dein Profil';

  @override
  String get login => 'Anmelden';

  @override
  String get logout => 'Abmelden';

  @override
  String get register => 'Registrieren';

  @override
  String get useDefaultServer => 'Verwende Standard-Server';

  @override
  String get useCustomServer => 'Verwende Benutzerdefinierten Server';

  @override
  String get invalidUrl => 'Bitte gebe eine gültige URL ein';

  @override
  String get usernameValidChars =>
      'Ein Benutzername darf nur Buchstaben, Ziffern und die Zeichen @, +, ., - und _ enthalten';

  @override
  String get passwordsDontMatch => 'Die Passwörter stimmen nicht überein';

  @override
  String get passwordTooShort => 'Das Passwort ist zu kurz';

  @override
  String get selectAvailablePlates => 'Verfügbare Platten auswählen';

  @override
  String get barWeight => 'Gewicht der Stange';

  @override
  String get useColors => 'farbig';

  @override
  String get password => 'Passwort';

  @override
  String get confirmPassword => 'Passwort bestätigen';

  @override
  String get invalidEmail => 'Bitte geben Sie eine gültige E-Mail-Adresse ein';

  @override
  String get email => 'E-Mail Adresse';

  @override
  String get username => 'Benutzername';

  @override
  String get invalidUsername => 'Bitte geben Sie einen gültigen Benutzernamen ein';

  @override
  String get useApiToken => 'API Token benutzen';

  @override
  String get useUsernameAndPassword => 'Nutzername und Passwort benutzen';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Bitte geben Sie einen gültigen API-Schlüssel ein';

  @override
  String get apiTokenValidChars =>
      'Ein API-Schlüssel darf nur die Buchstaben a-f und die Zahlen 0-9 enthalten und genau 40 Zeichen lang sein';

  @override
  String get customServerUrl => 'URL der wger-Instanz';

  @override
  String get customServerHint =>
      'Geben Sie die Adresse deines eigenen Servers ein, ansonsten wird die Standardadresse verwendet';

  @override
  String get reset => 'Zurücksetzen';

  @override
  String get registerInstead => 'Du hast keinen Account? Jetzt registrieren';

  @override
  String get loginInstead => 'Du hast bereits einen Account? Stattdessen anmelden';

  @override
  String get labelBottomNavWorkout => 'Training';

  @override
  String get labelBottomNavNutrition => 'Ernährung';

  @override
  String get labelWorkoutLogs => 'Trainingsprotokolle';

  @override
  String get labelWorkoutPlan => 'Trainingsplan';

  @override
  String get labelDashboard => 'Übersicht';

  @override
  String get success => 'Erfolgreich';

  @override
  String get successfullyDeleted => 'Gelöscht';

  @override
  String get successfullySaved => 'Gespeichert';

  @override
  String get exerciseList => 'Liste der Übungen';

  @override
  String get exercise => 'Übung';

  @override
  String get exercises => 'Übungen';

  @override
  String get exerciseName => 'Name der Übung';

  @override
  String get searchExercise => 'Suche Übung zum Hinzufügen';

  @override
  String get noIngredientsDefined => 'Noch keine Zutaten definiert';

  @override
  String get noMatchingExerciseFound => 'Diese Übung wurde nicht gefunden';

  @override
  String get searchNamesInEnglish => 'Namen auch auf Englisch suchen';

  @override
  String get equipment => 'Gerät';

  @override
  String get muscles => 'Muskeln';

  @override
  String get musclesSecondary => 'Sekundäre Muskeln';

  @override
  String get category => 'Kategorie';

  @override
  String get startDate => 'Anfangsdatum';

  @override
  String get dayTypeCustom => 'personalisierte';

  @override
  String get dayTypeEnom => 'Jede volle Minute';

  @override
  String get dayTypeAmrap => 'So viele Runden wie möglich';

  @override
  String get dayTypeHiit => 'Hochintensives Intervalltraining';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Training mit zunehmender Dichte';

  @override
  String get dayTypeRft => 'Runden auf Zeit';

  @override
  String get dayTypeAfap => 'So schnell wie möglich';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Abnehmender Satz';

  @override
  String get slotEntryTypeMyo => 'Muskel';

  @override
  String get slotEntryTypePartial => 'teilweise';

  @override
  String get slotEntryTypeForced => 'erzwungen';

  @override
  String get slotEntryTypeTut => 'Zeit unter Spannung';

  @override
  String get slotEntryTypeIso => 'isometrisches Halten';

  @override
  String get slotEntryTypeJump => 'Sprung';

  @override
  String get routines => 'Routinen';

  @override
  String get newRoutine => 'Neue Routine';

  @override
  String get noRoutines => 'Du hast keine Routinen';

  @override
  String get reps => 'Wdh.';

  @override
  String get restTime => 'Pausenzeit';

  @override
  String get sets => 'Sätze';

  @override
  String get rir => 'RiR';

  @override
  String get rirNotUsed => 'RiR nicht verwendet';

  @override
  String get useMetric => 'Metrische Einheiten für das Körpergewicht verwenden';

  @override
  String get weightUnit => 'Gewichtseinheit';

  @override
  String get repetitionUnit => 'Wiederholungseinheit';

  @override
  String get set => 'Satz';

  @override
  String get dayDescriptionHelp =>
      'Eine Beschreibung, was an diesem Tag gemacht wird (z. B. „Zugtag“) oder welche Körperteile trainiert werden (z. B. „Brust und Schultern“)';

  @override
  String exerciseNr(String nr) {
    return 'Übung $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Supersatz $nr';
  }

  @override
  String get sameRepetitions =>
      'Wenn du für alle Sätze die gleichen Wiederholungen und das gleiche Gewicht verwendest, kannst du nur eine Zeile ausfüllen. Gebe z. B. für 4 Sätze einfach 10 für die Wiederholungen ein, daraus wird automatisch „4 × 10“.';

  @override
  String get comment => 'Kommentar';

  @override
  String get impressionGood => 'Gut';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Schlecht';

  @override
  String get impression => 'Eindruck';

  @override
  String get notes => 'Notizen';

  @override
  String get workoutSession => 'Trainingseinheit';

  @override
  String get restDay => 'Ruhetag';

  @override
  String get isRestDay => 'Ist Ruhetag';

  @override
  String get isRestDayHelp =>
      'Bitte beachten Sie, dass alle Sätze und Übungen entfernt werden, wenn Sie einen Tag als Ruhetag markieren.';

  @override
  String get needsLogsToAdvance => 'Benötigt Logeinträge, um fortzufahren';

  @override
  String get needsLogsToAdvanceHelp =>
      'Wählen Sie aus, ob die Routine nur dann zum nächsten geplanten Tag fortgesetzt werden soll, wenn Sie für diesen Tag ein Training protokolliert haben';

  @override
  String get routineDays => 'Tage in der Routine';

  @override
  String get resultingRoutine => 'Resultierende Routine';

  @override
  String get newDay => 'Neuer Tag';

  @override
  String get newSet => 'Neuer Satz';

  @override
  String get selectExercises =>
      'Wenn du einen Supersatz machen willst, kannst du nach mehreren Übungen suchen, sie werden dann gruppiert';

  @override
  String get gymMode => 'Studiomodus';

  @override
  String get gymModeShowExercises => 'Übersichtsseiten der Übungen anzeigen';

  @override
  String get gymModeShowTimer => 'Timer zwischen Sätzen anzeigen';

  @override
  String get gymModeTimerType => 'Timer-Typ';

  @override
  String get gymModeTimerTypeHelText =>
      'Wenn ein Satz eine Pausenzeit hat, wird immer ein Countdown genutzt.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stoppuhr';

  @override
  String get gymModeDefaultCountdownTime => 'Standard-Countdown-Zeit in Sekunden';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Benachrichtigung bei Ende des Countdowns';

  @override
  String get duration => 'Dauer';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volumen';

  @override
  String get workoutCompleted => 'Training abgeschlossen';

  @override
  String get plateCalculator => 'Platten';

  @override
  String get plateCalculatorNotDivisible =>
      'Mit den vorhandenen Platten kann das Gewicht nicht erreicht werden';

  @override
  String get pause => 'Pause';

  @override
  String get jumpTo => 'Springen zu';

  @override
  String get todaysWorkout => 'Dein Training heute';

  @override
  String get logHelpEntries =>
      'Gibt es an einem Tag mehrere Einträge mit der gleichen Anzahl von Wiederholungen, aber unterschiedlichen Gewichten, wird nur der Eintrag mit dem höheren Gewicht im Diagramm angezeigt.';

  @override
  String get logHelpEntriesUnits =>
      'Beachte, dass nur Einträge mit einer Gewichtseinheit (kg oder lb) und Wiederholungen aufgezeichnet werden, andere Kombinationen wie Zeit oder „bis zum Versagen“ werden hier ignoriert.';

  @override
  String get description => 'Beschreibung';

  @override
  String get name => 'Name';

  @override
  String get save => 'Speichern';

  @override
  String get verify => 'Verifizieren';

  @override
  String get addSet => 'Satz hinzufügen';

  @override
  String get addMeal => 'Mahlzeit hinzufügen';

  @override
  String get mealLogged => 'Mahlzeit im Tagebuch protokolliert';

  @override
  String get ingredientLogged => 'Zutat im Tagebuch protokolliert';

  @override
  String get logMeal => 'Gericht im Ernährungstagebuch protokollieren';

  @override
  String get addIngredient => 'Zutat hinzufügen';

  @override
  String get logIngredient => 'Zutat im Ernährungstagebuch protokollieren';

  @override
  String get searchIngredient => 'Zutat suchen';

  @override
  String get nutritionalPlan => 'Ernährungsplan';

  @override
  String get nutritionalDiary => 'Ernährungstagebuch';

  @override
  String get nutritionalPlans => 'Ernährungspläne';

  @override
  String get noNutritionalPlans => 'Du hast keine Ernährungspläne';

  @override
  String get onlyLogging => 'Nur Kalorien eintragen';

  @override
  String get onlyLoggingHelpText =>
      'Setze das Häkchen, wenn du nur deine Kalorien protokollieren möchtest und keinen detaillierten Ernährungsplan mit spezifischen Mahlzeiten einrichten willst';

  @override
  String get goalMacro => 'Makroziele';

  @override
  String get selectMealToLog => 'Wähle eine Mahlzeit, um sie im Tagebuch zu protokollieren';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Dein aktueller Ernährungsplan enthält keine Gerichte';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Gehe zum Ernährungsplaner um Gerichte hinzuzufügen';

  @override
  String get goalEnergy => 'Energieziel';

  @override
  String get goalProtein => 'Eiweißziel';

  @override
  String get goalCarbohydrates => 'Kohlenhydratziel';

  @override
  String get goalFat => 'Fettziel';

  @override
  String get goalFiber => 'Ballaststoffziel';

  @override
  String get anErrorOccurred => 'Es ist ein Fehler aufgetreten!';

  @override
  String get errorInfoDescription =>
      'Es tut uns leid, aber etwas ist schiefgelaufen. Sie können uns helfen, das Problem zu beheben, indem Sie es auf GitHub melden.';

  @override
  String get errorInfoDescription2 =>
      'Sie können die App weiterhin verwenden, einige Funktionen funktionieren jedoch möglicherweise nicht.';

  @override
  String get errorViewDetails => 'Technische Details';

  @override
  String get applicationLogs => 'Anwendungsprotokolle';

  @override
  String get errorCouldNotConnectToServer =>
      'Verbindung zum Server konnte nicht hergestellt werden';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'Die Anwendung konnte keine Verbindung zum Server herstellen. Bitte überprüfen Sie Ihre Internetverbindung oder die Server-URL und versuchen Sie es erneut. Sollte das Problem weiterhin bestehen, wenden Sie sich an den Serveradministrator.';

  @override
  String get copyToClipboard => 'In Zwischenablage kopieren';

  @override
  String get weight => 'Gewicht';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name aller Zeiten';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name der letzten 30 Tage';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName während des Ernährungsplans $planName';
  }

  @override
  String get measurement => 'Messung';

  @override
  String get measurements => 'Messungen';

  @override
  String get measurementCategoriesHelpText => 'Messkategorie, z. B. „Bizeps“ oder „Körperfett“';

  @override
  String get measurementEntriesHelpText =>
      'Die Einheit, die verwendet wird, um die Kategorie zu messen, wie z.B. „cm“ oder „%“';

  @override
  String get date => 'Datum';

  @override
  String get endDate => 'Enddatum';

  @override
  String get openEnded => 'Offenes Ende';

  @override
  String get value => 'Wert';

  @override
  String get start => 'Start';

  @override
  String get time => 'Zeit';

  @override
  String get timeStart => 'Startzeit';

  @override
  String get timeEnd => 'Endzeit';

  @override
  String get timeStartAhead => 'Die Startzeit kann nicht vor der Endzeit liegen';

  @override
  String get ingredient => 'Zutat';

  @override
  String get energy => 'Energie';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Makronährstoffe';

  @override
  String get planned => 'Geplant';

  @override
  String get logged => 'Protokolliert';

  @override
  String get today => 'Heute';

  @override
  String get loggedToday => 'Heute protokolliert';

  @override
  String get weekAverage => '7-Tage-Durchschnitt';

  @override
  String get surplus => 'Überschuss';

  @override
  String get deficit => 'Defizit';

  @override
  String get difference => 'Differenz';

  @override
  String get percentEnergy => 'Prozent der Energie';

  @override
  String get gPerBodyKg => 'g pro Körper-kg';

  @override
  String get total => 'Gesamt';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Eiweiß';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Kohlenhydrate';

  @override
  String get carbohydratesShort => 'K';

  @override
  String get sugars => 'Zucker';

  @override
  String get fat => 'Fett';

  @override
  String get fatShort => 'F';

  @override
  String get saturatedFat => 'Gesättigte Fettsäuren';

  @override
  String get fiber => 'Ballaststoff';

  @override
  String get sodium => 'Natrium';

  @override
  String get amount => 'Betrag';

  @override
  String get unit => 'Einheit';

  @override
  String get newEntry => 'Neuer Eintrag';

  @override
  String get noWeightEntries => 'Du hast keine Gewichtseinträge';

  @override
  String get noMeasurementEntries => 'Du hast keine Messeingaben';

  @override
  String get moreMeasurementEntries => 'Neue Messung hinzufügen';

  @override
  String get edit => 'Bearbeiten';

  @override
  String get loadingText => 'Wird geladen …';

  @override
  String get delete => 'Löschen';

  @override
  String confirmDelete(String toDelete) {
    return 'Bist du sicher, dass du \'$toDelete\' löschen möchtest?';
  }

  @override
  String get newNutritionalPlan => 'Neuer Ernährungsplan';

  @override
  String get overview => 'Überblick';

  @override
  String get toggleDetails => 'Details ein/ausblenden';

  @override
  String get goToDetailPage => 'Weiter zur Detailseite';

  @override
  String get aboutWhySupportTitle => 'Open Source und kostenlos nutzbar ❤️';

  @override
  String get aboutDescription =>
      'Danke, dass du wger verwendest! wger ist ein gemeinschaftliches quelloffenes Projekt, das von Fitness-Enthusiasten aus der ganzen Welt entwickelt wurde.';

  @override
  String get aboutDonateTitle => 'Mach eine Spende';

  @override
  String get aboutDonateText =>
      'Das Projekt ist kostenlos und wird es auch bleiben, der Betrieb des Servers hingegen ist es nicht! Die Entwicklung erfordert zudem viel Zeit und Mühe von Freiwilligen. Ihr Beitrag deckt diese Kosten direkt und trägt zur Zuverlässigkeit des Dienstes bei.';

  @override
  String get aboutContributeTitle => 'Beitragen';

  @override
  String get aboutContributeText =>
      'Beiträge aller Art sind willkommen. Egal, ob Sie Entwickler, Übersetzer oder einfach nur Fitnessbegeisterter sind – jede Unterstützung ist willkommen!';

  @override
  String get aboutBugsListTitle => 'Ein Problem melden oder eine Funktion vorschlagen';

  @override
  String get aboutTranslationListTitle => 'Übersetzen Sie die Anwendung';

  @override
  String get aboutSourceListTitle => 'Quellcode anzeigen';

  @override
  String get aboutJoinCommunityTitle => 'Treten Sie der Community bei';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Sonstiges';

  @override
  String get calendar => 'Kalender';

  @override
  String get goToToday => 'Zu heute gehen';

  @override
  String get enterValue => 'Bitte gebe einen Wert ein';

  @override
  String get selectEntry => 'Bitte einen Eintrag auswählen';

  @override
  String get selectExercise => 'Bitte wähle eine Übung aus';

  @override
  String enterCharacters(String min, String max) {
    return 'Bitte gebe zwischen $min und $max Zeichen ein';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Bitte geben Sie einen Wert zwischen $min und $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Bitte gebe mindestens $min Zeichen ein';
  }

  @override
  String get baseNameEnglish => 'Alle Übungen brauchen einen Basisnamen in Englisch';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Sätze pro Übung: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Einheiten und RiR einstellen';

  @override
  String get enterValidNumber => 'Bitte gebe eine gültige Zahl ein';

  @override
  String get selectIngredient => 'Bitte wähle eine Zutat';

  @override
  String get recentlyUsedIngredients => 'Kürzlich hinzugefügte Zutaten';

  @override
  String get selectImage => 'Bitte wähle ein Bild aus';

  @override
  String get optionsLabel => 'Optionen';

  @override
  String get takePicture => 'Bild aufnehmen';

  @override
  String get chooseFromLibrary => 'Wähle aus der Bibliothek';

  @override
  String get gallery => 'Galerie';

  @override
  String get addImage => 'Bild hinzufügen';

  @override
  String get dataCopied => 'Daten in neuen Eintrag kopiert';

  @override
  String get appUpdateTitle => 'Aktualisierung erforderlich';

  @override
  String get appUpdateContent =>
      'Diese Version der Anwendung ist nicht mit dem Server kompatibel, bitte aktualisieren Sie Ihre Anwendung.';

  @override
  String get productFound => 'Produkt gefunden';

  @override
  String productFoundDescription(String productName) {
    return 'Der Strichcode gehört zu diesem Produkt: $productName. Möchten Sie fortfahren?';
  }

  @override
  String get productNotFound => 'Produkt nicht gefunden';

  @override
  String productNotFoundDescription(String barcode) {
    return 'Das Produkt mit dem gescannten Strichcode $barcode wurde nicht in der wger-Datenbank gefunden';
  }

  @override
  String get scanBarcode => 'Strichcode scannen';

  @override
  String get close => 'Schließen';

  @override
  String get identicalExercisePleaseDiscard =>
      'Wenn Sie eine Übung entdecken, die mit der von Ihnen hinzugefügten identisch ist, verwerfen Sie bitte Ihren Entwurf und bearbeiten Sie stattdessen diese Übung.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Bitte überprüfe, ob die eingegebenen Informationen korrekt sind, bevor du die Übung abschickst';

  @override
  String get add_exercise_image_license =>
      'Bilder müssen mit der CC BY SA Lizenz vereinbar sein. Wenn du dir unsicher bist lade nur Bilder hoch, welche du selbst gemacht hast.';

  @override
  String get imageDetailsTitle => 'Bilddetails';

  @override
  String get imageDetailsLicenseTitle => 'Bildtitel';

  @override
  String get imageDetailsLicenseTitleHint => 'Bildtitel eingeben';

  @override
  String get imageDetailsSourceLink => 'Link zur Website der Quelle';

  @override
  String get author => 'Autoren';

  @override
  String get authorHint => 'Name des Autors eingeben';

  @override
  String get imageDetailsAuthorLink => 'Link zur Website oder zum Profil des Autors';

  @override
  String get imageDetailsDerivativeSource =>
      'Link zur Originalquelle, wenn es sich um ein abgeleitetes Werk handelt';

  @override
  String get imageDetailsDerivativeHelp =>
      'Ein abgeleitetes Werk basiert auf einem früheren Werk, enthält jedoch genügend neues, schöpferisches Material, um eigenständig urheberrechtlich geschützt zu sein.';

  @override
  String get imageDetailsImageType => 'Bildtyp';

  @override
  String get imageDetailsLicenseNotice =>
      'Mit der Übermittlung dieses Bildes erklären Sie sich damit einverstanden, es unter der CC-BY-SA-4 zu veröffentlichen. Das Bild muss entweder Ihr eigenes Werk sein oder der Urheber muss es unter einer damit kompatiblen Lizenz veröffentlicht haben.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'Siehe Lizenztext.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat wird nicht unterstützt';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat-Bilder werden noch nicht unterstützt.';
  }

  @override
  String get add => 'Hinzufügen';

  @override
  String get variations => 'Variationen';

  @override
  String alsoKnownAs(String aliases) {
    return 'Auch bekannt als:$aliases';
  }

  @override
  String get verifiedEmail => 'Verifizierte E-Mail';

  @override
  String get unVerifiedEmail => 'Unverifizierte E-Mail';

  @override
  String get verifiedEmailReason => 'Du musst deine E-Mail verifizieren, um Übungen hinzuzufügen';

  @override
  String verifiedEmailInfo(String email) {
    return 'Eine Bestätigungs-E-Mail wurde an $email gesendet';
  }

  @override
  String get alternativeNames => 'Alternative Namen';

  @override
  String get oneNamePerLine => 'Ein Name pro Zeile';

  @override
  String get whatVariationsExist => 'Welche Varianten dieser Übung gibt es eventuell?';

  @override
  String get previous => 'Vorherige';

  @override
  String get next => 'Weiter';

  @override
  String get images => 'Bilder';

  @override
  String get language => 'Sprache';

  @override
  String get addExercise => 'Eine Übung hinzufügen';

  @override
  String get fitInWeek => 'Tage in die Woche einpassen';

  @override
  String get fitInWeekHelp =>
      'Wenn diese Option aktiviert ist, wiederholen sich die Tage in einem wöchentlichen Zyklus, andernfalls folgen die Tage der Reihe nach, ohne Rücksicht auf den Beginn einer neuen Woche.';

  @override
  String get addSuperset => 'Supersatz hinzufügen';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set hat Fortschritt';

  @override
  String get setHasProgressionWarning =>
      'Bitte beachten Sie, dass es derzeit nicht möglich ist, alle Einstellungen für ein Set in der mobilen Anwendung zu bearbeiten oder den automatischen Fortschritt zu konfigurieren. Nutzen Sie vorerst bitte die Webanwendung.';

  @override
  String get setHasNoExercises => 'Dieser Satz enthält noch keine Übungen!';

  @override
  String get contributeExercise => 'Eine Übung beisteuern';

  @override
  String get translation => 'Übersetzung';

  @override
  String get translateExercise => 'Diese Übung jetzt übersetzen';

  @override
  String get baseData => 'Grundlagen auf Englisch';

  @override
  String get enterTextInLanguage => 'Bitte geben Sie den Text in der richtigen Sprache ein!';

  @override
  String get settingsTitle => 'Einstellungen';

  @override
  String get settingsCacheTitle => 'Zwischenspeicher';

  @override
  String get settingsExerciseCacheDescription => 'Übungs-Zwischenspeicher';

  @override
  String get settingsIngredientCacheDescription => 'Zutaten-Cache';

  @override
  String get settingsCacheDeletedSnackbar => 'Zwischenspeicher erfolgreich gelöscht';

  @override
  String get aboutPageTitle => 'Über uns & Support';

  @override
  String contributeExerciseWarning(String days) {
    return 'Sie können nur Übungen beitragen, wenn Ihr Konto älter als $days Tage ist und Sie Ihre E-Mail verifiziert haben';
  }

  @override
  String get simpleMode => 'Einfacher Modus';

  @override
  String get simpleModeHelp =>
      'Blenden Sie einige der erweiterten Einstellungen beim Bearbeiten von Übungen aus';

  @override
  String get progressionRules =>
      'Diese Übung unterliegt Fortschrittsregeln und kann in der mobilen App nicht bearbeitet werden. Bitte verwenden Sie die Webanwendung, um diese Übung zu bearbeiten.';

  @override
  String get cacheWarning =>
      'Aufgrund von Caching kann es einige Zeit dauern, bis die Änderungen in der gesamten Anwendung sichtbar sind.';

  @override
  String get textPromptTitle => 'Bereit zu starten?';

  @override
  String get textPromptSubheading => 'Drücken Sie die Aktionstaste, um zu beginnen';

  @override
  String get abs => 'Bauch';

  @override
  String get arms => 'Arme';

  @override
  String get back => 'Rücken';

  @override
  String get barbell => 'Langhantel';

  @override
  String get bench => 'Bank';

  @override
  String get biceps => 'Bizeps';

  @override
  String get body_weight => 'Körpergewicht';

  @override
  String get calves => 'Waden';

  @override
  String get cardio => 'Kardio';

  @override
  String get chest => 'Brust';

  @override
  String get dumbbell => 'Kurzhantel';

  @override
  String get glutes => 'Gesäßmuskeln';

  @override
  String get gym_mat => 'Gymnastikmatte';

  @override
  String get hamstrings => 'Oberschenkelmuskeln';

  @override
  String get incline_bench => 'Schrägbank';

  @override
  String get kettlebell => 'Kugelhantel';

  @override
  String get kilometers => 'Kilometer';

  @override
  String get kilometers_per_hour => 'Kilometer pro Stunde';

  @override
  String get lats => 'Latissimus';

  @override
  String get legs => 'Beine';

  @override
  String get lower_back => 'Unterer Rücken';

  @override
  String get max_reps => 'Max. Wiederholungen';

  @override
  String get miles => 'Meilen';

  @override
  String get miles_per_hour => 'Meilen pro Stunde';

  @override
  String get minutes => 'Minuten';

  @override
  String get plates => 'Platten';

  @override
  String get pull_up_bar => 'Klimmzugstange';

  @override
  String get quads => 'Quadrizeps';

  @override
  String get repetitions => 'Wiederholungen';

  @override
  String get resistance_band => 'Widerstandsband';

  @override
  String get sz_bar => 'SZ-Stange';

  @override
  String get seconds => 'Sekunden';

  @override
  String get shoulders => 'Schultern';

  @override
  String get swiss_ball => 'Gymnastikball';

  @override
  String get triceps => 'Trizeps';

  @override
  String get until_failure => 'Bis zum Versagen';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'keine (Körpergewichtsübung)';

  @override
  String get log => 'Protokollieren';

  @override
  String get done => 'Fertig';

  @override
  String get overallChangeWeight => 'Allgemeine Veränderung';

  @override
  String get goalTypeMeals => 'Von Mahlzeiten';

  @override
  String get goalTypeBasic => 'Normal';

  @override
  String get goalTypeAdvanced => 'Fortgeschritten';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'Durchschn.';

  @override
  String get endWorkout => 'Training beenden';

  @override
  String get themeMode => 'Theme Modus';

  @override
  String get darkMode => 'Immer Dunkelmodus';

  @override
  String get lightMode => 'Immer Hellmodus';

  @override
  String get systemMode => 'Systemeinstellungen';
}
