// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/step_through_create_list_and_map_test.dart
//
const LINE_A = 20;
// AUTOGENERATED END

const file = 'step_through_create_list_and_map_test.dart';

void code() {
  final myList = /* LINE_A */ <int>[
    1234567890,
    1234567891,
    1234567892,
    1234567893,
    1234567894,
  ];
  final myConstList = const <int>[
    1234567890,
    1234567891,
    1234567892,
    1234567893,
    1234567894,
  ];
  final myMap = <int, int>{
    1: 42,
    2: 43,
    33242344: 432432432,
    443243232: 543242454,
  };
  final myConstMap = const <int, int>{
    1: 42,
    2: 43,
    33242344: 432432432,
    443243232: 543242454,
  };
  print(myList);
  print(myConstList);
  final lookup = myMap[1]!;
  print(lookup);
  print(myMap);
  print(myConstMap);
  print(myMap[2]);
}

final stops = <String>[];
const expected = <String>[
  // Initialize list (on '[')
  '$file:${LINE_A + 0}:36',

  // Initialize const list (on '=')
  '$file:${LINE_A + 7}:21',

  // Initialize map (on '{')
  '$file:${LINE_A + 14}:27',

  // Initialize const map (on '=')
  '$file:${LINE_A + 20}:20',

  // Prints (on call to 'print')
  '$file:${LINE_A + 26}:3',
  '$file:${LINE_A + 27}:3',

  // Lookup (on '[')
  '$file:${LINE_A + 28}:23',

  // Prints (on call to 'print')
  '$file:${LINE_A + 29}:3',
  '$file:${LINE_A + 30}:3',
  '$file:${LINE_A + 31}:3',

  // Lookup (on '[') + print (on call to 'print')
  '$file:${LINE_A + 32}:14',
  '$file:${LINE_A + 32}:3',

  // End (on ending '}')
  '$file:${LINE_A + 33}:1',
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLine(LINE_A),
  runStepThroughProgramRecordingStops(stops),
  checkRecordedStops(stops, expected),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'step_through_create_list_and_map_test.dart',
      testeeConcurrent: code,
      pauseOnStart: true,
      pauseOnExit: true,
    );
