// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Ukrainian (`uk`).
class AppLocalizationsUk extends AppLocalizations {
  AppLocalizationsUk([String locale = 'uk']) : super(locale);

  @override
  String get userProfile => 'Твій профіль';

  @override
  String get login => 'Увійти';

  @override
  String get logout => 'Вийти';

  @override
  String get register => 'Реєстрація';

  @override
  String get useDefaultServer => 'Використати сервер за замовчуванням';

  @override
  String get useCustomServer => 'Використати користувацький сервер';

  @override
  String get invalidUrl => 'Будь ласка, введіть прийнятну URL-адресу';

  @override
  String get usernameValidChars =>
      'Ім\'я користувача може містити лише літери, цифри й символи @, +, ., - та _';

  @override
  String get passwordsDontMatch => 'Паролі не збігаються';

  @override
  String get passwordTooShort => 'Пароль занадто короткий';

  @override
  String get selectAvailablePlates => 'Виберіть доступні тарілки';

  @override
  String get barWeight => 'Вага штанги';

  @override
  String get useColors => 'Використовуйте кольори';

  @override
  String get password => 'Пароль';

  @override
  String get confirmPassword => 'Підтвердьте пароль';

  @override
  String get invalidEmail => 'Будь ласка, введіть прийнятну адресу електронної пошти';

  @override
  String get email => 'Адреса електронної пошти';

  @override
  String get username => 'Ім\'я користувача';

  @override
  String get invalidUsername => 'Будь ласка, введіть припустиме ім\'я користувача';

  @override
  String get useApiToken => 'Використовувати токен API';

  @override
  String get useUsernameAndPassword => 'Використовуйте ім\'я користувача та пароль';

  @override
  String get apiToken => 'Токен API';

  @override
  String get invalidApiToken => 'Будь ласка, введіть дійсний ключ API';

  @override
  String get apiTokenValidChars =>
      'Ключ API може містити лише літери a-f, цифри 0-9 та мати довжину рівно 40 символів';

  @override
  String get customServerUrl => 'URL-адреса екземпляра wger';

  @override
  String get customServerHint =>
      'Введіть адресу власного сервера, інакше буде використовуватися за замовчуванням';

  @override
  String get reset => 'Скинути';

  @override
  String get registerInstead => 'У вас немає облікового запису? Зареєструйтесь зараз';

  @override
  String get loginInstead => 'Вже маєте обліковий запис? Увійти';

  @override
  String get labelBottomNavWorkout => 'Тренування';

  @override
  String get labelBottomNavNutrition => 'Харчування';

  @override
  String get labelWorkoutLogs => 'Журнали тренувань';

  @override
  String get labelWorkoutPlan => 'План тренування';

  @override
  String get labelDashboard => 'Панель керування';

  @override
  String get success => 'Успіх';

  @override
  String get successfullyDeleted => 'Видалено';

  @override
  String get successfullySaved => 'Збережено';

  @override
  String get exerciseList => 'Список вправ';

  @override
  String get exercise => 'Вправа';

  @override
  String get exercises => 'Вправи';

  @override
  String get exerciseName => 'Назва вправи';

  @override
  String get searchExercise => 'Пошук вправ для додавання';

  @override
  String get noIngredientsDefined => 'Інгредієнти ще не визначені';

  @override
  String get noMatchingExerciseFound => 'Відповідних вправ не знайдено';

  @override
  String get searchNamesInEnglish => 'Також шукайте імена англійською мовою';

  @override
  String get equipment => 'Обладнання';

  @override
  String get muscles => 'М\'язи';

  @override
  String get musclesSecondary => 'Вторинні м\'язи';

  @override
  String get category => 'Категорія';

  @override
  String get startDate => 'Дата початку';

  @override
  String get dayTypeCustom => 'Користувацька';

  @override
  String get dayTypeEnom => 'Кожну хвилину за хвилиною';

  @override
  String get dayTypeAmrap => 'Якомога більше раундів';

  @override
  String get dayTypeHiit => 'Високоінтенсивне інтервальне тренування';

  @override
  String get dayTypeTabata => 'Табата';

  @override
  String get dayTypeEdt => 'Збільшення щільності навчання';

  @override
  String get dayTypeRft => 'Раунди на час';

  @override
  String get dayTypeAfap => 'Якомога швидше';

  @override
  String get slotEntryTypeNormal => 'Звичайний';

  @override
  String get slotEntryTypeDropset => 'Дропсет';

  @override
  String get slotEntryTypeMyo => 'Міо';

  @override
  String get slotEntryTypePartial => 'Часткове';

  @override
  String get slotEntryTypeForced => 'Примусово';

  @override
  String get slotEntryTypeTut => 'Час під Напруги';

  @override
  String get slotEntryTypeIso => 'Ізометричне утримання';

  @override
  String get slotEntryTypeJump => 'Стрибок';

  @override
  String get routines => 'Рутини';

  @override
  String get newRoutine => 'Нова рутина';

  @override
  String get noRoutines => 'У вас немає рутин';

  @override
  String get reps => 'Повтор';

  @override
  String get restTime => 'Час відпочинку';

  @override
  String get sets => 'Набори';

  @override
  String get rir => 'RiR';

  @override
  String get rirNotUsed => 'RiR не використовується';

  @override
  String get useMetric => 'Використовуйте метричні одиниці вимірювання маси тіла';

  @override
  String get weightUnit => 'Одиниця ваги';

  @override
  String get repetitionUnit => 'Одиниця повторень';

  @override
  String get set => 'Набір';

  @override
  String get dayDescriptionHelp =>
      'Опис того, що робиться в цей день (наприклад, «день підтягування») або які частини тіла тренуються (наприклад, «груди та плечі»)';

  @override
  String exerciseNr(String nr) {
    return 'Вправа $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Суперсет $nr';
  }

  @override
  String get sameRepetitions =>
      'Якщо ви робите однакові повторення та вагу для всіх наборів, то ви можете просто заповнити один рядок. Наприклад, для 4 наборів просто введіть 10 для повторень, це автоматично стане «4 x 10».';

  @override
  String get comment => 'Коментар';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Враження';

  @override
  String get notes => 'Нотатки';

  @override
  String get workoutSession => 'Сеанс тренування';

  @override
  String get restDay => 'День відпочинку';

  @override
  String get isRestDay => 'Є День відпочинку';

  @override
  String get isRestDayHelp =>
      'Будь ласка, зверніть увагу, що всі комплекси та вправи будуть видалені, коли ви позначите день як вихідний.';

  @override
  String get needsLogsToAdvance => 'Для просування потрібні журнали';

  @override
  String get needsLogsToAdvanceHelp =>
      'Виберіть, якщо ви бажаєте, щоб програма перейшла до наступного запланованого дня, лише якщо ви зареєстрували тренування на цей день';

  @override
  String get routineDays => 'Дні в рутині';

  @override
  String get resultingRoutine => 'Результативна рутина';

  @override
  String get newDay => 'Новий день';

  @override
  String get newSet => 'Новий набір';

  @override
  String get selectExercises =>
      'Якщо ви хочете зробити супер-набір, ви можете пошукати декілька вправ, вони будуть згруповані разом';

  @override
  String get gymMode => 'Режим тренажерного залу';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Пластини';

  @override
  String get plateCalculatorNotDivisible => 'Неможливо досягти ваги з наявними пластинами';

  @override
  String get pause => 'Пауза';

  @override
  String get jumpTo => 'Перейти до';

  @override
  String get todaysWorkout => 'Ваше сьогоднішнє тренування';

  @override
  String get logHelpEntries =>
      'Якщо на один день припадає більше одного запису з однаковою кількістю повторень, але різними вагами, то на графіку буде показано тільки запис з більшою вагою.';

  @override
  String get logHelpEntriesUnits =>
      'Зверніть увагу, що на графіку відображаються тільки записи з одиницями ваги (кг або lb) і повтореннями. Інші комбінації, такі як час або \"до відмови\", тут ігноруються.';

  @override
  String get description => 'Опис';

  @override
  String get name => 'Ім\'я';

  @override
  String get save => 'Зберегти';

  @override
  String get verify => 'Підтвердити';

  @override
  String get addSet => 'Додати набір';

  @override
  String get addMeal => 'Додати страву';

  @override
  String get mealLogged => 'Страву записано в щоденник';

  @override
  String get ingredientLogged => 'Інгредієнт зареєстровано в щоденнику';

  @override
  String get logMeal => 'Запис прийому їжі в щоденник харчування';

  @override
  String get addIngredient => 'Додати інгредієнт';

  @override
  String get logIngredient => 'Занесіть інгредієнт до щоденника харчування';

  @override
  String get searchIngredient => 'Пошук інгредієнта';

  @override
  String get nutritionalPlan => 'План харчування';

  @override
  String get nutritionalDiary => 'Щоденник харчування';

  @override
  String get nutritionalPlans => 'Плани харчування';

  @override
  String get noNutritionalPlans => 'Ви не маєте планів харчування';

  @override
  String get onlyLogging => 'Слідкуйте лише за калоріями';

  @override
  String get onlyLoggingHelpText =>
      'Поставте прапорець, якщо ви хочете лише реєструвати свої калорії та не хочете встановлювати детальний план харчування з певними стравами';

  @override
  String get goalMacro => 'Макроцілі';

  @override
  String get selectMealToLog => 'Виберіть страву, щоб записати в щоденник';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'У вашому поточному плані харчування не визначено жодного прийому їжі';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Щоб додати страви до плану, перейдіть до деталей плану харчування';

  @override
  String get goalEnergy => 'Енергетична мета';

  @override
  String get goalProtein => 'Білкова мета';

  @override
  String get goalCarbohydrates => 'Мета вуглеводів';

  @override
  String get goalFat => 'Товстий гол';

  @override
  String get goalFiber => 'Волокно гол';

  @override
  String get anErrorOccurred => 'Сталася помилка!';

  @override
  String get errorInfoDescription =>
      'Вибачте, але щось пішло не так. Ви можете допомогти нам виправити це, повідомивши про проблему на GitHub.';

  @override
  String get errorInfoDescription2 =>
      'Ви можете продовжувати користуватися додатком, але деякі функції можуть не працювати.';

  @override
  String get errorViewDetails => 'Технічні деталі';

  @override
  String get applicationLogs => 'Журнали програм';

  @override
  String get errorCouldNotConnectToServer => 'Не вдалося підключитися до сервера';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'Програмі не вдалося підключитися до сервера. Перевірте підключення до Інтернету або URL-адресу сервера та спробуйте ще раз. Якщо проблема не зникає, зверніться до адміністратора сервера.';

  @override
  String get copyToClipboard => 'Копіювати в буфер обміну';

  @override
  String get weight => 'Вага';

  @override
  String get min => 'Мін';

  @override
  String get max => 'Макс';

  @override
  String chartAllTimeTitle(String name) {
    return '$name за весь час';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name останні 30 днів';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName під час плану харчування $planName';
  }

  @override
  String get measurement => 'Вимірювання';

  @override
  String get measurements => 'Вимірювання';

  @override
  String get measurementCategoriesHelpText =>
      'Категорія вимірювання, така як \"біцепс\" або \"жир тіла\"';

  @override
  String get measurementEntriesHelpText =>
      'Одиниця вимірювання, яка використовується для вимірювання категорії, як от \"см\" або \"%\"';

  @override
  String get date => 'Дата';

  @override
  String get endDate => 'Дата завершення';

  @override
  String get openEnded => 'Відкритий';

  @override
  String get value => 'Значення';

  @override
  String get start => 'Старт';

  @override
  String get time => 'Час';

  @override
  String get timeStart => 'Час початку';

  @override
  String get timeEnd => 'Час закінчення';

  @override
  String get timeStartAhead => 'Час початку не може передувати часу завершення';

  @override
  String get ingredient => 'Інгредієнт';

  @override
  String get energy => 'Енергія';

  @override
  String get energyShort => 'Е';

  @override
  String get macronutrients => 'Макроелементи';

  @override
  String get planned => 'Заплановано';

  @override
  String get logged => 'Записано';

  @override
  String get today => 'Сьогодні';

  @override
  String get loggedToday => 'Зареєстровано сьогодні';

  @override
  String get weekAverage => 'В середньому за 7 днів';

  @override
  String get surplus => 'надлишок';

  @override
  String get deficit => 'дефіцит';

  @override
  String get difference => 'Різниця';

  @override
  String get percentEnergy => 'Відсоток енергії';

  @override
  String get gPerBodyKg => 'г на кг тіла';

  @override
  String get total => 'Усього';

  @override
  String get kcal => 'ккал';

  @override
  String kcalValue(String value) {
    return '$value ккал';
  }

  @override
  String get kJ => 'кДж';

  @override
  String get g => 'г';

  @override
  String gValue(String value) {
    return '$value г';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Білок';

  @override
  String get proteinShort => 'Б';

  @override
  String get carbohydrates => 'Вуглеводи';

  @override
  String get carbohydratesShort => 'В';

  @override
  String get sugars => 'Цукри';

  @override
  String get fat => 'Жири';

  @override
  String get fatShort => 'Ж';

  @override
  String get saturatedFat => 'Насичені жири';

  @override
  String get fiber => 'Волокон';

  @override
  String get sodium => 'Натрій';

  @override
  String get amount => 'Сума';

  @override
  String get unit => 'Одиниця';

  @override
  String get newEntry => 'Новий запис';

  @override
  String get noWeightEntries => 'У вас немає записів ваги';

  @override
  String get noMeasurementEntries => 'У вас немає записів вимірювання';

  @override
  String get moreMeasurementEntries => 'Додати нове вимірювання';

  @override
  String get edit => 'Змінити';

  @override
  String get loadingText => 'Завантаження...';

  @override
  String get delete => 'Видалити';

  @override
  String confirmDelete(String toDelete) {
    return 'Ви впевнені, що бажаєте видалити \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Новий план харчування';

  @override
  String get overview => 'Огляд';

  @override
  String get toggleDetails => 'Перемкнути відомості';

  @override
  String get goToDetailPage => 'Перейти до сторінки відомостей';

  @override
  String get aboutWhySupportTitle => 'Відкритий код та безкоштовний у використанні ❤️';

  @override
  String get aboutDescription =>
      'Дякуємо за використання wger! wger - це спільний проєкт з відкритим кодом, створений ентузіастами фітнесу з усього світу.';

  @override
  String get aboutDonateTitle => 'Зробіть пожертву';

  @override
  String get aboutDonateText =>
      'Хоча проект є безкоштовним і завжди ним залишатиметься, запуск сервера - ні! Розвиток також вимагає значного часу і зусиль від волонтерів. Ваш внесок безпосередньо підтримує ці витрати, допомагаючи підтримувати надійність сервісу.';

  @override
  String get aboutContributeTitle => 'Зробити внесок';

  @override
  String get aboutContributeText =>
      'Ми вітаємо будь-які види внесків. Незалежно від того, чи ви розробник, перекладач, чи просто захоплений фітнесом, ми цінуємо будь-яку підтримку!';

  @override
  String get aboutBugsListTitle => 'Повідомити про проблему або запропонувати функцію';

  @override
  String get aboutTranslationListTitle => 'Перекласти програму';

  @override
  String get aboutSourceListTitle => 'Переглянути вихідний код';

  @override
  String get aboutJoinCommunityTitle => 'Приєднуйтесь до спільноти';

  @override
  String get aboutMastodonTitle => 'Мастодонт';

  @override
  String get aboutDiscordTitle => 'Дискорд';

  @override
  String get others => 'Інші';

  @override
  String get calendar => 'Календар';

  @override
  String get goToToday => 'Перейти до сьогодні';

  @override
  String get enterValue => 'Будь ласка, введіть значення';

  @override
  String get selectEntry => 'Будь ласка, виберіть запис';

  @override
  String get selectExercise => 'Будь ласка, виберіть вправу';

  @override
  String enterCharacters(String min, String max) {
    return 'Будь ласка, введіть між$min та $max символами';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Будь ласка, введіть принаймні $min символи';
  }

  @override
  String get baseNameEnglish => 'Всі вправи потребують базової назви англійською';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Наборів на вправу: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Встановіть одиниці вимірювання та RiR';

  @override
  String get enterValidNumber => 'Будь ласка, введіть прийнятний номер';

  @override
  String get selectIngredient => 'Будь ласка, оберіть інгредієнт';

  @override
  String get recentlyUsedIngredients => 'Останні інгредієнти';

  @override
  String get selectImage => 'Будь ласка, оберіть зображення';

  @override
  String get optionsLabel => 'Параметри';

  @override
  String get takePicture => 'Зробити знімок';

  @override
  String get chooseFromLibrary => 'Вибрати з бібліотеки світлин';

  @override
  String get gallery => 'Галерея';

  @override
  String get addImage => 'Додати зображення';

  @override
  String get dataCopied => 'Дані скопійовано до нового запису';

  @override
  String get appUpdateTitle => 'Потрібне оновлення';

  @override
  String get appUpdateContent =>
      'Ця версія застосунку несумісна з сервером, будь ласка, оновіть застосунок.';

  @override
  String get productFound => 'Виріб знайдено';

  @override
  String productFoundDescription(String productName) {
    return 'Штрих-код відповідає цьому виробу: $productName. Бажаєте продовжити?';
  }

  @override
  String get productNotFound => 'Виріб не знайдено';

  @override
  String productNotFoundDescription(String barcode) {
    return 'Виріб із відсканованим штрих-кодом $barcode не знайдено в базі даних Wger';
  }

  @override
  String get scanBarcode => 'Сканувати штрих-код';

  @override
  String get close => 'Закрити';

  @override
  String get identicalExercisePleaseDiscard =>
      'Якщо ви помітили вправу, ідентичну тій, яку ви додаєте, будь ласка, відкиньте свій чернетку та відредагуйте цю вправу.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Будь ласка, перевірте правильність введеної вами інформації, перш ніж надсилати вправу';

  @override
  String get add_exercise_image_license =>
      'Зображення повинні бути сумісні з ліцензією CC BY SA. Якщо ви сумніваєтеся, завантажуйте лише фотографії, які ви зробили самі.';

  @override
  String get imageDetailsTitle => 'Деталі зображення';

  @override
  String get imageDetailsLicenseTitle => 'Назва';

  @override
  String get imageDetailsLicenseTitleHint => 'Введіть назву зображення';

  @override
  String get imageDetailsSourceLink => 'Посилання на веб-сайт джерела';

  @override
  String get author => 'Автор(и)';

  @override
  String get authorHint => 'Введіть ім\'я автора';

  @override
  String get imageDetailsAuthorLink => 'Посилання на веб-сайт або профіль автора';

  @override
  String get imageDetailsDerivativeSource =>
      'Посилання на оригінальне джерело, якщо це похідний твір';

  @override
  String get imageDetailsDerivativeHelp =>
      'Похідний твір базується на попередньому творі, але містить достатньо нового, творчого контенту, щоб мати право на власне авторське право.';

  @override
  String get imageDetailsImageType => 'Тип зображення';

  @override
  String get imageDetailsLicenseNotice =>
      'Надсилаючи це зображення, ви погоджуєтеся на його розповсюдження за ліцензією CC-BY-SA-4. Зображення має бути або вашою власною роботою, або автор має опублікувати його за ліцензією, сумісною з нею.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'Див. текст ліцензії.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat не підтримується';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return 'Зображення $imageFormat поки що не підтримуються.';
  }

  @override
  String get add => 'додати';

  @override
  String get variations => 'Варіації';

  @override
  String alsoKnownAs(String aliases) {
    return 'Також відомий як: $aliases';
  }

  @override
  String get verifiedEmail => 'Підтверджена електронна пошта';

  @override
  String get unVerifiedEmail => 'Непідтверджена електронна пошта';

  @override
  String get verifiedEmailReason =>
      'Вам потрібно підтвердити свою електронну пошту, щоб виконувати вправи';

  @override
  String verifiedEmailInfo(String email) {
    return 'Повідомлення з підтвердженням електронної пошти надіслано на $email';
  }

  @override
  String get alternativeNames => 'Альтернативні назви';

  @override
  String get oneNamePerLine => 'Одне ім\'я на рядок';

  @override
  String get whatVariationsExist => 'Які варіації цієї вправи існують, якщо такі є?';

  @override
  String get previous => 'Попередній';

  @override
  String get next => 'Наступний';

  @override
  String get images => 'Зображення';

  @override
  String get language => 'Мова';

  @override
  String get addExercise => 'Додати вправу';

  @override
  String get fitInWeek => 'Вписується в тиждень';

  @override
  String get fitInWeekHelp =>
      'Якщо ввімкнено, дні повторюватимуться в тижневому циклі, інакше дні будуть йти послідовно незалежно від початку нового тижня.';

  @override
  String get addSuperset => 'Додайте надмножину';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Набір має прогресію';

  @override
  String get setHasProgressionWarning =>
      'Зверніть увагу, що на даний момент неможливо змінити всі параметри набору в мобільному додатку або налаштувати автоматичний прогрес. Наразі використовуйте веб-додаток.';

  @override
  String get setHasNoExercises => 'У цьому комплексі ще немає вправ!';

  @override
  String get contributeExercise => 'Внести вправу';

  @override
  String get translation => 'Переклад';

  @override
  String get translateExercise => 'Перекладіть цю вправу зараз';

  @override
  String get baseData => 'Основи англійської';

  @override
  String get enterTextInLanguage => 'Будь ласка, введіть текст правильною мовою!';

  @override
  String get settingsTitle => 'налаштування';

  @override
  String get settingsCacheTitle => 'Кеш';

  @override
  String get settingsExerciseCacheDescription => 'Кеш вправ';

  @override
  String get settingsIngredientCacheDescription => 'Кеш інгредієнтів';

  @override
  String get settingsCacheDeletedSnackbar => 'Кеш успішно очищено';

  @override
  String get aboutPageTitle => 'Про нас та підтримка';

  @override
  String contributeExerciseWarning(String days) {
    return 'Ви можете брати участь у вправах, лише якщо ваш обліковий запис старший за $days днів і підтвердив вашу електронну пошту';
  }

  @override
  String get simpleMode => 'Простий режим';

  @override
  String get simpleModeHelp => 'Приховайте деякі розширені налаштування під час редагування вправ';

  @override
  String get progressionRules =>
      'Ця вправа має правила прогресу, і її не можна редагувати в мобільному додатку. Щоб відредагувати цю вправу, використовуйте веб-додаток.';

  @override
  String get cacheWarning =>
      'Через кешування може знадобитися деякий час, перш ніж зміни стануть видимими у всьому застосунку.';

  @override
  String get textPromptTitle => 'Готові почати?';

  @override
  String get textPromptSubheading => 'Натисніть кнопку дії, щоб почати';

  @override
  String get abs => 'Живіт';

  @override
  String get arms => 'Руки';

  @override
  String get back => 'Спина';

  @override
  String get barbell => 'Штанга';

  @override
  String get bench => 'Лавка';

  @override
  String get biceps => 'Біцепс';

  @override
  String get body_weight => 'Вага тіла';

  @override
  String get calves => 'Ікри';

  @override
  String get cardio => 'Кардіо';

  @override
  String get chest => 'Груди';

  @override
  String get dumbbell => 'Гантеля';

  @override
  String get glutes => 'Сідниці';

  @override
  String get gym_mat => 'Гімнастичний мат';

  @override
  String get hamstrings => 'Підколінні сухожилля';

  @override
  String get incline_bench => 'Похила лавка';

  @override
  String get kettlebell => 'Гиря';

  @override
  String get kilometers => 'Кілометри';

  @override
  String get kilometers_per_hour => 'Кілометри на годину';

  @override
  String get lats => 'Найширші м\'язи спини';

  @override
  String get legs => 'Ноги';

  @override
  String get lower_back => 'Нижня частина спини';

  @override
  String get max_reps => 'Максимальна кількість повторень';

  @override
  String get miles => 'Милі';

  @override
  String get miles_per_hour => 'Миль на годину';

  @override
  String get minutes => 'Хвилини';

  @override
  String get plates => 'Пластини';

  @override
  String get pull_up_bar => 'Перекладина';

  @override
  String get quads => 'Квадрицепс';

  @override
  String get repetitions => 'Повторень';

  @override
  String get resistance_band => 'Еспандер';

  @override
  String get sz_bar => 'SZ-Штанга';

  @override
  String get seconds => 'Секунди';

  @override
  String get shoulders => 'Плечі';

  @override
  String get swiss_ball => 'Швейцарський м\'яч';

  @override
  String get triceps => 'Трицепс';

  @override
  String get until_failure => 'До відмови';

  @override
  String get kg => 'кг';

  @override
  String get lb => 'фунт';

  @override
  String get none__bodyweight_exercise_ => 'немає (вправи з власною вагою)';

  @override
  String get log => 'Журнал';

  @override
  String get done => 'Готово';

  @override
  String get overallChangeWeight => 'Загальна зміна';

  @override
  String get goalTypeMeals => 'Від їжі';

  @override
  String get goalTypeBasic => 'Базовий';

  @override
  String get goalTypeAdvanced => 'Просунутий';

  @override
  String get indicatorRaw => 'сирий';

  @override
  String get indicatorAvg => 'середнє';

  @override
  String get endWorkout => 'Закінчити тренування';

  @override
  String get themeMode => 'Тематичний режим';

  @override
  String get darkMode => 'Завжди темний режим';

  @override
  String get lightMode => 'Завжди легкий режим';

  @override
  String get systemMode => 'Налаштування системи';
}
