// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Turkish (`tr`).
class AppLocalizationsTr extends AppLocalizations {
  AppLocalizationsTr([String locale = 'tr']) : super(locale);

  @override
  String get userProfile => 'Profilin';

  @override
  String get login => 'Giriş yap';

  @override
  String get logout => 'Çıkış yap';

  @override
  String get register => 'Kayıt ol';

  @override
  String get useDefaultServer => 'Varsayılan sunucuyu kullan';

  @override
  String get useCustomServer => 'Özel sunucu kullan';

  @override
  String get invalidUrl => 'Lütfen geçerli bir URL girin';

  @override
  String get usernameValidChars =>
      'Kullanıcı adı yalnızca harf, rakam ve @, +, ., -ve _ karakterlerini içerebilir';

  @override
  String get passwordsDontMatch => 'Şifreler eşleşmiyor';

  @override
  String get passwordTooShort => 'Şifre çok kısa';

  @override
  String get selectAvailablePlates => 'Select available plates';

  @override
  String get barWeight => 'Bar weight';

  @override
  String get useColors => 'Use colors';

  @override
  String get password => 'Şifre';

  @override
  String get confirmPassword => 'Şifreyi onayla';

  @override
  String get invalidEmail => 'Lütfen geçerli bir e-posta adresi girin';

  @override
  String get email => 'E-posta adresi';

  @override
  String get username => 'Kullanıcı adı';

  @override
  String get invalidUsername => 'Lütfen geçerli bir kullanıcı adı girin';

  @override
  String get useApiToken => 'Use API Token';

  @override
  String get useUsernameAndPassword => 'Use username and password';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Please enter a valid API key';

  @override
  String get apiTokenValidChars =>
      'An API key may only contain the letters a-f, numbers 0-9 and be exactly 40 characters long';

  @override
  String get customServerUrl => 'wger örneğinin URL\'si';

  @override
  String get customServerHint =>
      'Kendi sunucunuzun adresini girin, aksi takdirde varsayılan sunucu kullanılacaktır';

  @override
  String get reset => 'Sıfırla';

  @override
  String get registerInstead => 'Hesabınız yok mu? Şimdi kaydolun';

  @override
  String get loginInstead => 'Zaten hesabınız var mı? Oturum açın';

  @override
  String get labelBottomNavWorkout => 'Antrenman';

  @override
  String get labelBottomNavNutrition => 'Beslenme';

  @override
  String get labelWorkoutLogs => 'Eğitim günlükleri';

  @override
  String get labelWorkoutPlan => 'Antreman planları';

  @override
  String get labelDashboard => 'Gösterge Paneli';

  @override
  String get success => 'Başarılı';

  @override
  String get successfullyDeleted => 'Silindi';

  @override
  String get successfullySaved => 'Kaydedildi';

  @override
  String get exerciseList => 'Egzersiz listesi';

  @override
  String get exercise => 'Egzersiz';

  @override
  String get exercises => 'Egzersizler';

  @override
  String get exerciseName => 'Egzersiz Adı';

  @override
  String get searchExercise => 'Eklemek için egzersiz arayın';

  @override
  String get noIngredientsDefined => 'Henüz malzeme tanımlanmadı';

  @override
  String get noMatchingExerciseFound => 'Eşleşen egzersiz bulunamadı';

  @override
  String get searchNamesInEnglish => 'Ayrıca İngilizce adları da arayın';

  @override
  String get equipment => 'Ekipman';

  @override
  String get muscles => 'Kaslar';

  @override
  String get musclesSecondary => 'İkincil kaslar';

  @override
  String get category => 'Kategori';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => 'Routines';

  @override
  String get newRoutine => 'New routine';

  @override
  String get noRoutines => 'You have no routines';

  @override
  String get reps => 'Temsilciler';

  @override
  String get restTime => 'Rest time';

  @override
  String get sets => 'Sets';

  @override
  String get rir => 'RiR';

  @override
  String get rirNotUsed => 'RiR kullanılmadı';

  @override
  String get useMetric => 'Vücut ağırlığı için metrik birimler kullan';

  @override
  String get weightUnit => 'Ağırlık birimi';

  @override
  String get repetitionUnit => 'Tekrarlama birimi';

  @override
  String get set => 'Ayarla';

  @override
  String get dayDescriptionHelp =>
      'O gün yapılanların (örn. \'çekme günü\') veya hangi vücut bölümlerinin (örn. \'göğüs ve omuzlar\') çalıştırıldığının açıklaması';

  @override
  String exerciseNr(String nr) {
    return 'Exercise $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'Eğer tüm setler için aynı ağırlıklarla aynı setleri yapıyorsanız, sadece bir satır doldurabilirsiniz. Örneğin, 4 set için sadece 10 girin, bu otomatik olarak \"4 x 10\"a dönüşüyor.';

  @override
  String get comment => 'Yorum';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'İzlenim';

  @override
  String get notes => 'Notlar';

  @override
  String get workoutSession => 'Egzersiz Seansı';

  @override
  String get restDay => 'Rest day';

  @override
  String get isRestDay => 'Is rest day';

  @override
  String get isRestDayHelp =>
      'Please note that all sets and exercises will be removed when you mark a day as a rest day.';

  @override
  String get needsLogsToAdvance => 'Needs logs to advance';

  @override
  String get needsLogsToAdvanceHelp =>
      'Select if you want the routine to progress to the next scheduled day only if you\'ve logged a workout for the day';

  @override
  String get routineDays => 'Days in routine';

  @override
  String get resultingRoutine => 'Resulting routine';

  @override
  String get newDay => 'Yeni gün';

  @override
  String get newSet => 'Yeni set';

  @override
  String get selectExercises =>
      'Eğer bir süper set yapmak istiyorsanız, birkaç egzersiz için arama yapabilirsiniz, birlikte gruplanacaklardır';

  @override
  String get gymMode => 'Spor salonu modu';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Tabaklar';

  @override
  String get plateCalculatorNotDivisible =>
      'Varolan tabaklar ile istenilen ağırlığa ulaşmak mümkün değil';

  @override
  String get pause => 'Duraklat';

  @override
  String get jumpTo => 'Buraya git';

  @override
  String get todaysWorkout => 'Günlük antrenmanınız';

  @override
  String get logHelpEntries =>
      'Tek bir günde, aynı sayıda tekrara sahip ancak farklı ağırlıklara sahip birden fazla giriş varsa, diyagramda yalnızca daha yüksek ağırlığa sahip giriş gösterilir.';

  @override
  String get logHelpEntriesUnits =>
      'Yalnızca ağırlık birimi (kg veya lb) ve tekrarları olan girişlerin çizelgelendirildiğini, zaman veya arızaya kadar olan diğer kombinasyonların burada göz ardı edildiğini unutmayın.';

  @override
  String get description => 'Açıklama';

  @override
  String get name => 'İsim';

  @override
  String get save => 'Kaydet';

  @override
  String get verify => 'Doğrula';

  @override
  String get addSet => 'Set ekle';

  @override
  String get addMeal => 'Yemek ekle';

  @override
  String get mealLogged => 'Yemek günlüğe kaydedildi';

  @override
  String get ingredientLogged => 'Malzeme günlüğe kaydedildi';

  @override
  String get logMeal => 'Yemeği beslenme günlüğüne kaydet';

  @override
  String get addIngredient => 'Malzeme ekle';

  @override
  String get logIngredient => 'Malzemeyi beslenme günlüğüne kaydet';

  @override
  String get searchIngredient => 'İçerik ara';

  @override
  String get nutritionalPlan => 'Beslenme planı';

  @override
  String get nutritionalDiary => 'Beslenme Günlüğü';

  @override
  String get nutritionalPlans => 'Beslenme planları';

  @override
  String get noNutritionalPlans => 'Beslenme planınız yok';

  @override
  String get onlyLogging => 'Yalnızca kalorileri takip et';

  @override
  String get onlyLoggingHelpText =>
      'Yalnızca kalorilerinizi kaydetmek istiyorsanız ve belirli öğünler için ayrıntılı bir beslenme planı oluşturmak istemiyorsanız kutuyu işaretleyin';

  @override
  String get goalMacro => 'Makro hedefleri';

  @override
  String get selectMealToLog => 'Günlüğe kaydetmek için bir yemek seçin';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Your current nutrition plan has no meals defined';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'To add meals to the plan, go to the nutritional plan details';

  @override
  String get goalEnergy => 'Enerji hedefi';

  @override
  String get goalProtein => 'Protein hedefi';

  @override
  String get goalCarbohydrates => 'Karbonhidrat hedefi';

  @override
  String get goalFat => 'Yağ hedefi';

  @override
  String get goalFiber => 'Lif hedefi';

  @override
  String get anErrorOccurred => 'Bir hata oluştu!';

  @override
  String get errorInfoDescription =>
      'We\'re sorry, but something went wrong. You can help us fix this by reporting the issue on GitHub.';

  @override
  String get errorInfoDescription2 =>
      'You can continue using the app, but some features may not work.';

  @override
  String get errorViewDetails => 'Technical details';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Couldn\'t connect to server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'The application could not connect to the server. Please check your internet connection or the server URL and try again. If the problem persists, contact the server administrator.';

  @override
  String get copyToClipboard => 'Copy to clipboard';

  @override
  String get weight => 'Ağırlık';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return 'tüm zamanlar $name';
  }

  @override
  String chart30DaysTitle(String name) {
    return 'son 30 gün $name';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$planName beslenme planı boyunca $chartName';
  }

  @override
  String get measurement => 'Ölçüm';

  @override
  String get measurements => 'Ölçümler';

  @override
  String get measurementCategoriesHelpText => '\"Pazı\" veya \"vücut yağı\" gibi ölçüm kategorisi';

  @override
  String get measurementEntriesHelpText =>
      '\'cm\' veya \'%\' gibi kategoriyi ölçmek için kullanılan birim';

  @override
  String get date => 'Tarih';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'Değer';

  @override
  String get start => 'Başlangıç';

  @override
  String get time => 'Zaman';

  @override
  String get timeStart => 'Başlangıç zamanı';

  @override
  String get timeEnd => 'Bitiş zamanı';

  @override
  String get timeStartAhead => 'Başlangıç zamanı, bitiş zamanından önce olamaz';

  @override
  String get ingredient => 'Bileşen';

  @override
  String get energy => 'Enerji';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Makrobesinler';

  @override
  String get planned => 'Planlı';

  @override
  String get logged => 'Kaydedildi';

  @override
  String get today => 'Bugün';

  @override
  String get loggedToday => 'Bugün kaydedildi';

  @override
  String get weekAverage => '7 günlük ortalama';

  @override
  String get surplus => 'fazlalık';

  @override
  String get deficit => 'eksiklik';

  @override
  String get difference => 'Fark';

  @override
  String get percentEnergy => 'Enerji Yüzdesi';

  @override
  String get gPerBodyKg => 'vücut kg başına düşen g';

  @override
  String get total => 'Toplam';

  @override
  String get kcal => 'kilokalori';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kilo joule';

  @override
  String get g => 'gram';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '%$value';
  }

  @override
  String get protein => 'Protein';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Karbonhidratlar';

  @override
  String get carbohydratesShort => 'carb';

  @override
  String get sugars => 'Şekerler';

  @override
  String get fat => 'Yağ';

  @override
  String get fatShort => 'fat';

  @override
  String get saturatedFat => 'Doymuş yağ';

  @override
  String get fiber => 'Lif';

  @override
  String get sodium => 'Sodyum';

  @override
  String get amount => 'Miktar';

  @override
  String get unit => 'Birim';

  @override
  String get newEntry => 'Yeni giriş';

  @override
  String get noWeightEntries => 'Ağırlık girişiniz yok';

  @override
  String get noMeasurementEntries => 'Ölçüm girdiniz yok';

  @override
  String get moreMeasurementEntries => 'Yeni ölçüm ekle';

  @override
  String get edit => 'Düzenle';

  @override
  String get loadingText => 'Yükleniyor...';

  @override
  String get delete => 'Sil';

  @override
  String confirmDelete(String toDelete) {
    return '\'$toDelete\' ögesini silmek istediğinizden emin misiniz?';
  }

  @override
  String get newNutritionalPlan => 'Yeni beslenme planı';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'Ayrıntıları aç/kapat';

  @override
  String get goToDetailPage => 'Ayrıntı sayfasına git';

  @override
  String get aboutWhySupportTitle => 'Open Source & free to use ❤️';

  @override
  String get aboutDescription =>
      'wger\'ı kullandığınız için teşekkür ederiz! wger, dünyanın dört bir yanından spor tutkunları tarafından gerçekleştirilen ortak bir açık kaynaklı projedir.';

  @override
  String get aboutDonateTitle => 'Bağış yap';

  @override
  String get aboutDonateText =>
      'Projeye yardımcı olmak, sunucu masraflarını karşılamak ve geliştirmeyi desteklemek için bağış yapın';

  @override
  String get aboutContributeTitle => 'Contribute';

  @override
  String get aboutContributeText =>
      'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!';

  @override
  String get aboutBugsListTitle => 'Report a problem or suggest a feature';

  @override
  String get aboutTranslationListTitle => 'Translate the application';

  @override
  String get aboutSourceListTitle => 'View source code';

  @override
  String get aboutJoinCommunityTitle => 'Join the community';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Others';

  @override
  String get calendar => 'Takvim';

  @override
  String get goToToday => 'Bugüne git';

  @override
  String get enterValue => 'Lütfen bir değer girin';

  @override
  String get selectEntry => 'Lütfen bir giriş seçin';

  @override
  String get selectExercise => 'Lütfen bir egzersiz seçin';

  @override
  String enterCharacters(String min, String max) {
    return 'Lütfen en az $min, en fazla $max karakter girin';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Lütfen en az $min karakter girin';
  }

  @override
  String get baseNameEnglish => 'Tüm egzersizlerin İngilizce bir ismi olmalıdır';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Egzersiz başına set sayısı: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'RiR ve birimleri ayarla';

  @override
  String get enterValidNumber => 'Lütfen geçerli bir sayı girin';

  @override
  String get selectIngredient => 'Lütfen bir malzeme seçin';

  @override
  String get recentlyUsedIngredients => 'Son eklenen malzemeler';

  @override
  String get selectImage => 'Lütfen bir resim seçin';

  @override
  String get optionsLabel => 'Seçenekler';

  @override
  String get takePicture => 'Fotoğraf çek';

  @override
  String get chooseFromLibrary => 'Fotoğraf kitaplığından seç';

  @override
  String get gallery => 'Galeri';

  @override
  String get addImage => 'Resim ekle';

  @override
  String get dataCopied => 'Veriler yeni girişe kopyalandı';

  @override
  String get appUpdateTitle => 'Güncelleme gerekli';

  @override
  String get appUpdateContent =>
      'Uygulamanın bu sürümü sunucuyla uyumlu değil, lütfen uygulamanızı güncelleyin.';

  @override
  String get productFound => 'Ürün bulundu';

  @override
  String productFoundDescription(String productName) {
    return 'Barkod şu ürüne karşılık geliyor: $productName. Devam etmek istiyor musunuz?';
  }

  @override
  String get productNotFound => 'Ürün bulunamadı';

  @override
  String productNotFoundDescription(String barcode) {
    return 'Taranan $barcode barkoduna sahip ürün wger veri tabanında bulunamadı';
  }

  @override
  String get scanBarcode => 'Barkod tara';

  @override
  String get close => 'Kapat';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'Görseller CC BY SA lisansı ile uyumlu olmalıdır. Emin değilseniz, yalnızca kendi çektiğiniz fotoğrafları yükleyin.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'Varyasyonlar';

  @override
  String alsoKnownAs(String aliases) {
    return '$aliases olarak da bilinir';
  }

  @override
  String get verifiedEmail => 'Doğrulanmış e-posta adresi';

  @override
  String get unVerifiedEmail => 'Doğrulanmamış e-posta adresi';

  @override
  String get verifiedEmailReason =>
      'Egzersizlere katkıda bulunmak için e-posta adresinizi doğrulamanız gerekiyor';

  @override
  String verifiedEmailInfo(String email) {
    return '$email adresine bir doğrulama e-postası gönderildi';
  }

  @override
  String get alternativeNames => 'Alternatif isimler';

  @override
  String get oneNamePerLine => 'Satır başına bir ad';

  @override
  String get whatVariationsExist => 'Varsa, bu egzersizin hangi varyasyonları vardır?';

  @override
  String get previous => 'Önceki';

  @override
  String get next => 'Sonraki';

  @override
  String get images => 'Resimler';

  @override
  String get language => 'Dil';

  @override
  String get addExercise => 'Egzersiz ekle';

  @override
  String get fitInWeek => 'Fit in week';

  @override
  String get fitInWeekHelp =>
      'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.';

  @override
  String get addSuperset => 'Add superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set has progression';

  @override
  String get setHasProgressionWarning =>
      'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.';

  @override
  String get setHasNoExercises => 'This set has no exercises yet!';

  @override
  String get contributeExercise => 'Egzersize katkıda bulunun';

  @override
  String get translation => 'Çeviri';

  @override
  String get translateExercise => 'Bu egzersizi şimdi çevir';

  @override
  String get baseData => 'İngilizce\'de temel bilgiler';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Ayarlar';

  @override
  String get settingsCacheTitle => 'Önbellek';

  @override
  String get settingsExerciseCacheDescription => 'Egzersiz önbelleği';

  @override
  String get settingsIngredientCacheDescription => 'Malzeme önbelleği';

  @override
  String get settingsCacheDeletedSnackbar => 'Önbellek başarıyla temizlendi';

  @override
  String get aboutPageTitle => 'Wger Hakkında';

  @override
  String contributeExerciseWarning(String days) {
    return 'Yalnızca hesabınız $days günden eskiyse ve e-posta adresinizi doğruladıysanız egzersizlere katkıda bulunabilirsiniz';
  }

  @override
  String get simpleMode => 'Simple mode';

  @override
  String get simpleModeHelp => 'Hide some of the more advanced settings when editing exercises';

  @override
  String get progressionRules =>
      'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.';

  @override
  String get cacheWarning =>
      'Önbelleğe alma nedeniyle değişikliklerin uygulama genelinde görünür olması biraz zaman alabilir.';

  @override
  String get textPromptTitle => 'Başlamaya hazır mısınız?';

  @override
  String get textPromptSubheading => 'Başlamak için eylem düğmesine basın';

  @override
  String get abs => 'Karın Kasları';

  @override
  String get arms => 'Kollar';

  @override
  String get back => 'Sırt';

  @override
  String get barbell => 'Halter';

  @override
  String get bench => 'Benç';

  @override
  String get biceps => 'Pazılar';

  @override
  String get body_weight => 'Vücut Ağırlığı';

  @override
  String get calves => 'Baldırlar';

  @override
  String get cardio => 'Kardiyo';

  @override
  String get chest => 'Göğüs';

  @override
  String get dumbbell => 'Dambıl';

  @override
  String get glutes => 'Kalça kasları';

  @override
  String get gym_mat => 'Spor matı';

  @override
  String get hamstrings => 'Hamstringler';

  @override
  String get incline_bench => 'Eğim tezgahı';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Kilometre';

  @override
  String get kilometers_per_hour => 'Kilometre/Saat';

  @override
  String get lats => 'Lat kasları';

  @override
  String get legs => 'Bacaklar';

  @override
  String get lower_back => 'Alt sırt';

  @override
  String get max_reps => 'Azami Tekrar Sayısı';

  @override
  String get miles => 'Mil';

  @override
  String get miles_per_hour => 'Mil/Saat';

  @override
  String get minutes => 'Dakika';

  @override
  String get plates => 'Tabaklar';

  @override
  String get pull_up_bar => 'Barfiks çubuğu';

  @override
  String get quads => 'Quad kasları';

  @override
  String get repetitions => 'Tekrarlar';

  @override
  String get resistance_band => 'Resistance band';

  @override
  String get sz_bar => 'Z-Bar';

  @override
  String get seconds => 'Saniye';

  @override
  String get shoulders => 'Omuzlar';

  @override
  String get swiss_ball => 'Egzersiz Topu';

  @override
  String get triceps => 'Triceps kasları';

  @override
  String get until_failure => 'Başarısız olana kadar';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'yok (vücut ağırlığı egzersizi)';

  @override
  String get log => 'Kaydet';

  @override
  String get done => 'Bitti';

  @override
  String get overallChangeWeight => 'Overall change';

  @override
  String get goalTypeMeals => 'From meals';

  @override
  String get goalTypeBasic => 'Basic';

  @override
  String get goalTypeAdvanced => 'Advanced';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'avg';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Theme mode';

  @override
  String get darkMode => 'Always dark mode';

  @override
  String get lightMode => 'Always light mode';

  @override
  String get systemMode => 'System settings';
}
