// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get userProfile => 'Votre profil';

  @override
  String get login => 'Se connecter';

  @override
  String get logout => 'Se déconnecter';

  @override
  String get register => 'S’inscrire';

  @override
  String get useDefaultServer => 'Utiliser le serveur par défaut';

  @override
  String get useCustomServer => 'Utiliser le serveur personnalisé';

  @override
  String get invalidUrl => 'Veuillez entrer une URL valide';

  @override
  String get usernameValidChars =>
      'Un nom d\'utilisateur ne peut contenir que des lettres, des chiffres et les caractères @, +, ., - et _';

  @override
  String get passwordsDontMatch => 'Les mots de passe sont différents';

  @override
  String get passwordTooShort => 'Le mot de passe est trop court';

  @override
  String get selectAvailablePlates => 'Sélectionnez les poids disponibles';

  @override
  String get barWeight => 'Poids de la barre';

  @override
  String get useColors => 'Utiliser des couleurs';

  @override
  String get password => 'Mot de passe';

  @override
  String get confirmPassword => 'Confirmer le mot de passe';

  @override
  String get invalidEmail => 'Veuillez entrer une adresse courriel valide';

  @override
  String get email => 'Adresse courriel';

  @override
  String get username => 'Nom d’utilisateur';

  @override
  String get invalidUsername => 'Veuillez entrer un nom d’utilisateur valide';

  @override
  String get useApiToken => 'Utiliser un jeton API';

  @override
  String get useUsernameAndPassword => 'Utiliser le nom d’utilisateur et mot de passe';

  @override
  String get apiToken => 'Jeton API';

  @override
  String get invalidApiToken => 'Veuillez saisir une clé API valide';

  @override
  String get apiTokenValidChars =>
      'Une clé API ne peut contenir que les lettres a-f, les chiffres 0-9 et 40 caractères exactement';

  @override
  String get customServerUrl => 'URL de l’instance wger';

  @override
  String get customServerHint =>
      'Entrez l’adresse de votre propre serveur, sinon le serveur par défaut sera utilisé';

  @override
  String get reset => 'Réinitialiser';

  @override
  String get registerInstead => 'Vous n\'avez pas de compte ? Inscrivez-vous maintenant';

  @override
  String get loginInstead => 'Déjà un compte ? Connectez-vous';

  @override
  String get labelBottomNavWorkout => 'Entraînement';

  @override
  String get labelBottomNavNutrition => 'Nutrition';

  @override
  String get labelWorkoutLogs => 'Journaux d’entraînement';

  @override
  String get labelWorkoutPlan => 'Plan d’entraînement';

  @override
  String get labelDashboard => 'Accueil';

  @override
  String get success => 'Succès';

  @override
  String get successfullyDeleted => 'Supprimé';

  @override
  String get successfullySaved => 'Enregistré';

  @override
  String get exerciseList => 'Liste d\'exercices';

  @override
  String get exercise => 'Exercice';

  @override
  String get exercises => 'Exercices';

  @override
  String get exerciseName => 'Nom de l\'exercice';

  @override
  String get searchExercise => 'Chercher des exos à ajouter';

  @override
  String get noIngredientsDefined => 'Aucun ingrédient défini pour le moment';

  @override
  String get noMatchingExerciseFound => 'Aucun exercice correspondant n\'a été trouvé';

  @override
  String get searchNamesInEnglish => 'Recherchez également des noms en anglais';

  @override
  String get equipment => 'Équippement';

  @override
  String get muscles => 'Muscles';

  @override
  String get musclesSecondary => 'Muscles secondaires';

  @override
  String get category => 'Catégorie';

  @override
  String get startDate => 'Date de début';

  @override
  String get dayTypeCustom => 'Personnalisé';

  @override
  String get dayTypeEnom => 'Un mouvement par minute';

  @override
  String get dayTypeAmrap => 'Autant de rounds que possible';

  @override
  String get dayTypeHiit => 'Entraînement fractionné de haute intensité';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Entraînement à densité croissante';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'Aussi vite que possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partiel';

  @override
  String get slotEntryTypeForced => 'Forcé';

  @override
  String get slotEntryTypeTut => 'Temps sous tension';

  @override
  String get slotEntryTypeIso => 'Maintien isométrique';

  @override
  String get slotEntryTypeJump => 'Saut';

  @override
  String get routines => 'Routines';

  @override
  String get newRoutine => 'Nouvelle routine';

  @override
  String get noRoutines => 'Vous n’avez aucune de routine';

  @override
  String get reps => 'Réps';

  @override
  String get restTime => 'Temps de repos';

  @override
  String get sets => 'Séries';

  @override
  String get rir => 'RsR';

  @override
  String get rirNotUsed => 'RiR non utilisé';

  @override
  String get useMetric => 'Utiliser le système métrique pour le poids du corps';

  @override
  String get weightUnit => 'Unité de poids';

  @override
  String get repetitionUnit => 'Unité des répétitions';

  @override
  String get set => 'Série';

  @override
  String get dayDescriptionHelp =>
      'Une description de ce qui est fait ce jour-ci (par exemple : « journée de tractions ») ou des parties du corps qui sont entraînées (par exemple : « poitrine et épaules »)';

  @override
  String exerciseNr(String nr) {
    return 'Exercice $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Supersérie $nr';
  }

  @override
  String get sameRepetitions =>
      'Si vous faites les mêmes répétitions et le même poids pour toutes les séries, vous pouvez simplement remplir une ligne. Par exemple, pour 4 séries, il suffit d’entrer 10 pour les répétitions, ce qui devient automatiquement « 4 × 10 ».';

  @override
  String get comment => 'Commentaire';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Impression';

  @override
  String get notes => 'Notes';

  @override
  String get workoutSession => 'Session d’entraînement';

  @override
  String get restDay => 'Jour de repos';

  @override
  String get isRestDay => 'Est un jour de repos';

  @override
  String get isRestDayHelp =>
      'Veuillez noter que toutes les séries et tous les exercices seront supprimés lorsque vous marquerez un jour comme jour de repos.';

  @override
  String get needsLogsToAdvance => 'Nécessite des journaux pour avancer';

  @override
  String get needsLogsToAdvanceHelp =>
      'Sélectionnez si vous souhaitez que la routine passe au jour programmé suivant uniquement si vous avez enregistré une séance d\'entraînement pour la journée';

  @override
  String get routineDays => 'Jours de routine';

  @override
  String get resultingRoutine => 'Routine résultante';

  @override
  String get newDay => 'Nouvelle journée';

  @override
  String get newSet => 'Nouvelle série';

  @override
  String get selectExercises =>
      'Si vous voulez faire une supersérie, vous pouvez rechercher plusieurs exercices, ils seront regroupés';

  @override
  String get gymMode => 'Mode entraînement';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Disques';

  @override
  String get plateCalculatorNotDivisible =>
      'Impossible d\'atteindre le poids avec les disques disponibles';

  @override
  String get pause => 'Pause';

  @override
  String get jumpTo => 'Aller à';

  @override
  String get todaysWorkout => 'Entraînement d’aujourd’hui';

  @override
  String get logHelpEntries =>
      'Si durant une journée il y a plusieurs entrées avec le même nombre de répétitions, mais avec un poids différent, seule l’entrée avec le poids le plus haut sera affichée.';

  @override
  String get logHelpEntriesUnits =>
      'Notez que seules les entrées comportant une unité de poids (kg ou lb) et des répétitions sont représentées dans le graphique. Les autres combinaisons, telles que le temps ou le niveau d’échec, sont ignorées ici.';

  @override
  String get description => 'Description';

  @override
  String get name => 'Nom';

  @override
  String get save => 'Sauvegarder';

  @override
  String get verify => 'Vérifier';

  @override
  String get addSet => 'Ajouter une série';

  @override
  String get addMeal => 'Ajouter un repas';

  @override
  String get mealLogged => 'Repas journalisé';

  @override
  String get ingredientLogged => 'Ingrédient journalisé dans l\'agenda';

  @override
  String get logMeal => 'Journaliser ce repas dans l\'agenda';

  @override
  String get addIngredient => 'Ajouter ingrédients';

  @override
  String get logIngredient => 'Journaliser l\'ingrédient dans l\'agenda nutritionnel';

  @override
  String get searchIngredient => 'Rechercher un ingrédient';

  @override
  String get nutritionalPlan => 'Programme nutritionnel';

  @override
  String get nutritionalDiary => 'Journal nutritionnel';

  @override
  String get nutritionalPlans => 'Programmes nutritionnels';

  @override
  String get noNutritionalPlans => 'Aucun programme nutritionnel';

  @override
  String get onlyLogging => 'Suivre uniquement les calories';

  @override
  String get onlyLoggingHelpText =>
      'Cochez la case si vous souhaitez uniquement enregistrer vos calories et ne souhaitez pas établir un plan nutritionnel détaillé avec des repas spécifiques';

  @override
  String get goalMacro => 'Objectif de macronutriments';

  @override
  String get selectMealToLog => 'Sélectionner un repas à journaliser dans l\'agenda';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Votre plan nutritionnel actuel ne comporte pas de repas définis';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Pour ajouter des repas au plan, allez dans les détails du plan nutritionnel';

  @override
  String get goalEnergy => 'Objectif énergétique';

  @override
  String get goalProtein => 'Objectif protéines';

  @override
  String get goalCarbohydrates => 'Objectif glucides';

  @override
  String get goalFat => 'Objectif gras';

  @override
  String get goalFiber => 'Objectif fibre';

  @override
  String get anErrorOccurred => 'Une erreur s’est produite !';

  @override
  String get errorInfoDescription =>
      'Nous sommes désolés, mais quelque chose s\'est mal passé. Vous pouvez nous aider à résoudre ce problème en le signalant sur GitHub.';

  @override
  String get errorInfoDescription2 =>
      'Vous pouvez continuer à utiliser l\'application, mais certaines fonctions risquent de ne pas fonctionner.';

  @override
  String get errorViewDetails => 'Détails techniques';

  @override
  String get applicationLogs => 'Journaux d\'application';

  @override
  String get errorCouldNotConnectToServer => 'Impossible de se connecter au serveur';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'L\'application n\'a pas pu se connecter au serveur. Veuillez vérifier votre connexion internet ou l\'URL du serveur et réessayer. Si le problème persiste, contactez l\'administrateur du serveur.';

  @override
  String get copyToClipboard => 'Copier dans le presse-papiers';

  @override
  String get weight => 'Poids';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name depuis le début';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name les 30 derniers jours';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName pendant le plan nutritionnel $planName';
  }

  @override
  String get measurement => 'Mesure';

  @override
  String get measurements => 'Mesures';

  @override
  String get measurementCategoriesHelpText =>
      'Catégorie de mesure, comme « biceps » ou « graisse corporelle »';

  @override
  String get measurementEntriesHelpText =>
      'L\'unité utilisée pour mesurer la catégorie, comme cm ou %';

  @override
  String get date => 'Date';

  @override
  String get endDate => 'Date de fin';

  @override
  String get openEnded => 'Sans date de fin';

  @override
  String get value => 'Valeur';

  @override
  String get start => 'Démarrer';

  @override
  String get time => 'Horaire';

  @override
  String get timeStart => 'Horaire de départ';

  @override
  String get timeEnd => 'Horaire de fin';

  @override
  String get timeStartAhead => 'L\'heure de début ne peut pas être après à l\'heure de fin';

  @override
  String get ingredient => 'Ingrédient';

  @override
  String get energy => 'Énergie';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutriments';

  @override
  String get planned => 'Prévu';

  @override
  String get logged => 'Mangé';

  @override
  String get today => 'Aujourd\'hui';

  @override
  String get loggedToday => 'Journalisé aujourd\'hui';

  @override
  String get weekAverage => 'Moyenne sur 7 jours';

  @override
  String get surplus => 'surplus';

  @override
  String get deficit => 'déficit';

  @override
  String get difference => 'Différence';

  @override
  String get percentEnergy => 'Pourcentage de l\'énergie';

  @override
  String get gPerBodyKg => 'g par kg corporel';

  @override
  String get total => 'Total';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Protéines';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Glucides';

  @override
  String get carbohydratesShort => 'Gl';

  @override
  String get sugars => 'Sucres';

  @override
  String get fat => 'Graisses';

  @override
  String get fatShort => 'Gr';

  @override
  String get saturatedFat => 'Graisses saturées';

  @override
  String get fiber => 'fiber';

  @override
  String get sodium => 'Sodium';

  @override
  String get amount => 'Quantité';

  @override
  String get unit => 'Unité';

  @override
  String get newEntry => 'Nouvelle entrée';

  @override
  String get noWeightEntries => 'Aucune entrée de poids';

  @override
  String get noMeasurementEntries => 'Vous n\'avez pas d\'entrées de mesure';

  @override
  String get moreMeasurementEntries => 'Ajouter une mesure';

  @override
  String get edit => 'Modifier';

  @override
  String get loadingText => 'Chargement…';

  @override
  String get delete => 'Supprimer';

  @override
  String confirmDelete(String toDelete) {
    return 'Êtes-vous sûre de vouloir supprimer « $toDelete » ?';
  }

  @override
  String get newNutritionalPlan => 'Nouveau programme nutritionnel';

  @override
  String get overview => 'Aperçu';

  @override
  String get toggleDetails => 'Afficher les détails';

  @override
  String get goToDetailPage => 'Aller à la page de détails';

  @override
  String get aboutWhySupportTitle => 'Open Source et gratuit ❤️';

  @override
  String get aboutDescription =>
      'Merci d’utiliser wger ! wger est un projet collaboratif à code source ouvert, réalisé par des passionnés de fitness du monde entier.';

  @override
  String get aboutDonateTitle => 'Faire un don';

  @override
  String get aboutDonateText =>
      'Si le projet est gratuit et le restera, l\'exploitation du serveur ne l\'est pas ! Le développement requiert également beaucoup de temps et d\'efforts de la part des bénévoles. Votre contribution finance directement ces coûts et contribue à la fiabilité du service.';

  @override
  String get aboutContributeTitle => 'Contribuer';

  @override
  String get aboutContributeText =>
      'Toutes les contributions sont les bienvenues. Que vous soyez développeur, traducteur ou simplement passionné de fitness, chaque contribution est appréciée !';

  @override
  String get aboutBugsListTitle => 'Signaler un problème ou suggérer une fonctionnalité';

  @override
  String get aboutTranslationListTitle => 'Traduire l\'application';

  @override
  String get aboutSourceListTitle => 'Voir le code source';

  @override
  String get aboutJoinCommunityTitle => 'Rejoindre la communauté';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Autres';

  @override
  String get calendar => 'Calendrier';

  @override
  String get goToToday => 'Aller à aujourd’hui';

  @override
  String get enterValue => 'Insérer un valeur';

  @override
  String get selectEntry => 'Veuillez sélectionner une entrée';

  @override
  String get selectExercise => 'Veuillez sélectionner un exercice';

  @override
  String enterCharacters(String min, String max) {
    return 'Veuillez saisir un nombre de caractères compris entre $min et $max';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Veuillez entrer au moins $min caractères';
  }

  @override
  String get baseNameEnglish => 'Tous les exercices doivent avoir un nom de base en anglais';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Séries par exercice : $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Définir les unités et RiR';

  @override
  String get enterValidNumber => 'Veuillez entrer un nombre valide';

  @override
  String get selectIngredient => 'Veuillez sélectionner un ingrédient';

  @override
  String get recentlyUsedIngredients => 'Ingrédients récemment ajoutés';

  @override
  String get selectImage => 'Veuillez sélectionner une image';

  @override
  String get optionsLabel => 'Options';

  @override
  String get takePicture => 'Prendre une photo';

  @override
  String get chooseFromLibrary => 'Choisir depuis la bibliothèque';

  @override
  String get gallery => 'Galerie';

  @override
  String get addImage => 'Ajouter une image';

  @override
  String get dataCopied => 'Données copiées dans la nouvelle entrée';

  @override
  String get appUpdateTitle => 'Mise à jour nécessaire';

  @override
  String get appUpdateContent =>
      'Cette version de l\'application n\'est pas compatible avec le serveur, veuillez mettre à jour votre application.';

  @override
  String get productFound => 'Produit trouvé';

  @override
  String productFoundDescription(String productName) {
    return 'Le code-barres correspond à ce produit : $productName. Voulez-vous continuer ?';
  }

  @override
  String get productNotFound => 'Produit non trouvé';

  @override
  String productNotFoundDescription(String barcode) {
    return 'Le produit dont le code-barres a été scanné $barcode n\'a pas été trouvé dans la base de données wger';
  }

  @override
  String get scanBarcode => 'Scanner le code barre';

  @override
  String get close => 'Fermer';

  @override
  String get identicalExercisePleaseDiscard =>
      'Si vous remarquez un exercice identique à celui que vous ajoutez, veuillez supprimer votre brouillon et modifier cet exercice à la place.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Veuillez vérifier que les informations que vous avez saisies sont correctes avant de soumettre l\'exercice';

  @override
  String get add_exercise_image_license =>
      'Les images doivent être compatibles avec la licence CC BY SA. En cas de doute, ne téléchargez que des photos que vous avez prises vous-même.';

  @override
  String get imageDetailsTitle => 'Détails de l\'image';

  @override
  String get imageDetailsLicenseTitle => 'Valeur de l\'attribut \"title\" de l\'image';

  @override
  String get imageDetailsLicenseTitleHint =>
      'Saisir la valeur de l\'attribut \"title\" de l\'image';

  @override
  String get imageDetailsSourceLink => 'Lien vers le site internet source';

  @override
  String get author => 'Auteur(s)';

  @override
  String get authorHint => 'Saisir le nom de l\'auteur';

  @override
  String get imageDetailsAuthorLink => 'Lien vers le site internet de l\'auteur ou de son profil';

  @override
  String get imageDetailsDerivativeSource =>
      'Lien vers la source originale, s\'il s\'agit d\'une œuvre dérivée';

  @override
  String get imageDetailsDerivativeHelp =>
      'Une œuvre dérivée est basée sur une œuvre antérieure mais contient suffisamment de contenu nouveau et créatif pour lui donner droit à son propre droit d’auteur.';

  @override
  String get imageDetailsImageType => 'Type de l\'image';

  @override
  String get imageDetailsLicenseNotice =>
      'En soumettant cette image, vous acceptez sa publication sous licence CC-BY-SA-4. L\'image doit être votre propre création ou son auteur doit l\'avoir publiée sous une licence compatible.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'Voir le texte de la licence.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat non pris en charge';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat non pris en charge';
  }

  @override
  String get add => 'Ajouter';

  @override
  String get variations => 'Variantes';

  @override
  String alsoKnownAs(String aliases) {
    return 'Aussi connu sous le nom de : $aliases';
  }

  @override
  String get verifiedEmail => 'Email vérifié';

  @override
  String get unVerifiedEmail => 'Email non vérifié';

  @override
  String get verifiedEmailReason =>
      'Vous devez vérifier votre adresse e-mail pour contribuer aux exercices';

  @override
  String verifiedEmailInfo(String email) {
    return 'Un email de vérification a été envoyé à $email';
  }

  @override
  String get alternativeNames => 'Noms alternatifs';

  @override
  String get oneNamePerLine => 'Un nom par ligne';

  @override
  String get whatVariationsExist => 'Quelles sont les variantes de cet exercice, s\'il en existe ?';

  @override
  String get previous => 'Précédent';

  @override
  String get next => 'Suivant';

  @override
  String get images => 'Photos';

  @override
  String get language => 'Langues';

  @override
  String get addExercise => 'Ajouter un exercice';

  @override
  String get fitInWeek => 'Ajouter à la semaine';

  @override
  String get fitInWeekHelp =>
      'Si cette option est activée, les jours se répéteront selon un cycle hebdomadaire, sinon les jours se suivront séquentiellement sans tenir compte du début d\'une nouvelle semaine.';

  @override
  String get addSuperset => 'Ajouter une supersérie';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'La série a une progression';

  @override
  String get setHasProgressionWarning =>
      'Veuillez noter qu\'il n\'est actuellement pas possible de modifier tous les paramètres d\'une série sur l\'application mobile ni de configurer la progression automatique. Pour l\'instant, veuillez utiliser l\'application web.';

  @override
  String get setHasNoExercises => 'Cette série n\'a pas encore d\'exercices !';

  @override
  String get contributeExercise => 'Contribuer à un exercice';

  @override
  String get translation => 'Traduction';

  @override
  String get translateExercise => 'Traduire cet exercice maintenant';

  @override
  String get baseData => 'Les bases en anglais';

  @override
  String get enterTextInLanguage => 'Veuillez saisir le texte dans la bonne langue !';

  @override
  String get settingsTitle => 'Paramètres';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Cache d\'exercices';

  @override
  String get settingsIngredientCacheDescription => 'Cache d\'ingrédients';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache nettoyé avec succès';

  @override
  String get aboutPageTitle => 'À propos de nous et assistance';

  @override
  String contributeExerciseWarning(String days) {
    return 'Vous ne pouvez contribuer aux exercices que si votre compte a plus de $days jours et si vous avez vérifié votre adresse email';
  }

  @override
  String get simpleMode => 'Mode simple';

  @override
  String get simpleModeHelp =>
      'Masquer certains des paramètres les plus avancés lors de l\'édition des exercices';

  @override
  String get progressionRules =>
      'Cet exercice a des règles de progression et ne peut pas être édité sur l\'application mobile. Veuillez utiliser l\'application web pour éditer cet exercice.';

  @override
  String get cacheWarning =>
      'En raison de la mise en cache, il peut s\'écouler un certain temps avant que les changements soient visibles dans toute l\'application.';

  @override
  String get textPromptTitle => 'Prêt à commencer ?';

  @override
  String get textPromptSubheading => 'Cliquez sur le bouton pour commencer';

  @override
  String get abs => 'Abdos';

  @override
  String get arms => 'Bras';

  @override
  String get back => 'Dos';

  @override
  String get barbell => 'Barre';

  @override
  String get bench => 'Banc';

  @override
  String get biceps => 'Biceps';

  @override
  String get body_weight => 'Poids corporel';

  @override
  String get calves => 'Mollets';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Poitrine';

  @override
  String get dumbbell => 'Haltères';

  @override
  String get glutes => 'Fessiers';

  @override
  String get gym_mat => 'Tapis de gymnastique';

  @override
  String get hamstrings => 'Ischio-jambiers';

  @override
  String get incline_bench => 'Banc incliné';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Kilomètres';

  @override
  String get kilometers_per_hour => 'Kilomètres Par Heure';

  @override
  String get lats => 'Grand dorsal';

  @override
  String get legs => 'Jambes';

  @override
  String get lower_back => 'Bas du dos';

  @override
  String get max_reps => 'Reps Maxi';

  @override
  String get miles => 'Miles';

  @override
  String get miles_per_hour => 'Miles Par Heure';

  @override
  String get minutes => 'Minutes';

  @override
  String get plates => 'Disques de poids';

  @override
  String get pull_up_bar => 'Barre de traction';

  @override
  String get quads => 'Quadriceps';

  @override
  String get repetitions => 'Répetitions';

  @override
  String get resistance_band => 'Bande de résistance';

  @override
  String get sz_bar => 'Barre EZ';

  @override
  String get seconds => 'Secondes';

  @override
  String get shoulders => 'Epaules';

  @override
  String get swiss_ball => 'Ballon de gymnastique';

  @override
  String get triceps => 'Triceps';

  @override
  String get until_failure => 'Jusqu\'à l\'échec';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'aucun (exercice au poids du corps)';

  @override
  String get log => 'Journaliser';

  @override
  String get done => 'Fait';

  @override
  String get overallChangeWeight => 'Changement global';

  @override
  String get goalTypeMeals => 'Des repas';

  @override
  String get goalTypeBasic => 'Basique';

  @override
  String get goalTypeAdvanced => 'Avancé';

  @override
  String get indicatorRaw => 'brut';

  @override
  String get indicatorAvg => 'moy';

  @override
  String get endWorkout => 'Terminer l\'entraînement';

  @override
  String get themeMode => 'Thème';

  @override
  String get darkMode => 'Mode sombre permanent';

  @override
  String get lightMode => 'Mode clair permanent';

  @override
  String get systemMode => 'Paramètres du système';
}
