// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Modern Greek (`el`).
class AppLocalizationsEl extends AppLocalizations {
  AppLocalizationsEl([String locale = 'el']) : super(locale);

  @override
  String get userProfile => 'Το προφίλ σας';

  @override
  String get login => 'Συνδεθείτε';

  @override
  String get logout => 'Αποσύνδεση';

  @override
  String get register => 'Εγγραφή';

  @override
  String get useDefaultServer => 'Χρήση προεπιλεγμένου διακομιστή';

  @override
  String get useCustomServer => 'Χρήση προσαρμοσμένου διακομιστή';

  @override
  String get invalidUrl => 'Παρακαλώ εισάγετε ένα έγκυρο URL';

  @override
  String get usernameValidChars =>
      'Ένα όνομα χρήστη μπορεί να περιέχει μόνο γράμματα, ψηφία και τους χαρακτήρες @, +, ., - και _';

  @override
  String get passwordsDontMatch => 'Οι κωδικοί πρόσβασης δεν ταιριάζουν';

  @override
  String get passwordTooShort => 'Ο κωδικός πρόσβασης είναι πολύ σύντομος';

  @override
  String get selectAvailablePlates => 'Select available plates';

  @override
  String get barWeight => 'Bar weight';

  @override
  String get useColors => 'Use colors';

  @override
  String get password => 'Κωδικός';

  @override
  String get confirmPassword => 'Επιβεβαίωση κωδικού πρόσβασης';

  @override
  String get invalidEmail => 'Παρακαλώ εισάγετε μια έγκυρη διεύθυνση ηλεκτρονικού ταχυδρομείου';

  @override
  String get email => 'Διεύθυνση ηλεκτρονικού ταχυδρομείου';

  @override
  String get username => 'Όνομα χρήστη';

  @override
  String get invalidUsername => 'Παρακαλώ εισάγετε ένα έγκυρο όνομα χρήστη';

  @override
  String get useApiToken => 'Use API Token';

  @override
  String get useUsernameAndPassword => 'Use username and password';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Please enter a valid API key';

  @override
  String get apiTokenValidChars =>
      'An API key may only contain the letters a-f, numbers 0-9 and be exactly 40 characters long';

  @override
  String get customServerUrl => 'URL της περίπτωσης wger';

  @override
  String get customServerHint =>
      'Εισάγετε τη διεύθυνση του δικού σας διακομιστή, διαφορετικά θα χρησιμοποιηθεί η προεπιλεγμένη';

  @override
  String get reset => 'Επαναφορά';

  @override
  String get registerInstead => 'Δεν έχετε λογαριασμό; Εγγραφείτε τώρα';

  @override
  String get loginInstead => 'Έχετε ήδη λογαριασμό; Σύνδεση';

  @override
  String get labelBottomNavWorkout => 'Προπόνηση';

  @override
  String get labelBottomNavNutrition => 'Διατροφή';

  @override
  String get labelWorkoutLogs => 'Ημερολόγια προπόνησης';

  @override
  String get labelWorkoutPlan => 'Πλάνο προπόνησης';

  @override
  String get labelDashboard => 'Ταμπλό';

  @override
  String get success => 'Επιτυχία';

  @override
  String get successfullyDeleted => 'Διαγράφηκε';

  @override
  String get successfullySaved => 'Αποθηκεύτηκε';

  @override
  String get exerciseList => 'Λίστα ασκήσεων';

  @override
  String get exercise => 'Εξάσκηση';

  @override
  String get exercises => 'Εξασκήσεις';

  @override
  String get exerciseName => 'Όνομα Εξάσκησης';

  @override
  String get searchExercise => 'Αναζήτηση εξάσκησης για προσθήκη';

  @override
  String get noIngredientsDefined => 'Δεν έχουν οριστεί συστατικά ακόμα';

  @override
  String get noMatchingExerciseFound => 'Δεν βρέθηκαν αντίστοιχες ασκήσεις';

  @override
  String get searchNamesInEnglish => 'Επίσης, αναζητήστε ονόματα στα Αγγλικά';

  @override
  String get equipment => 'Εξοπλισμός';

  @override
  String get muscles => 'Μύες';

  @override
  String get musclesSecondary => 'Δευτερεύοντες μύες';

  @override
  String get category => 'Κατηγορία';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => 'Routines';

  @override
  String get newRoutine => 'New routine';

  @override
  String get noRoutines => 'You have no routines';

  @override
  String get reps => 'Επαναλήψεις';

  @override
  String get restTime => 'Rest time';

  @override
  String get sets => 'Sets';

  @override
  String get rir => 'ΕσΚ';

  @override
  String get rirNotUsed => 'ΕσΚ δεν χρησιμοποιείται';

  @override
  String get useMetric => 'Χρήση μετρικών μονάδων για το βάρος σώματος';

  @override
  String get weightUnit => 'Μονάδα βάρους';

  @override
  String get repetitionUnit => 'Μονάδα επανάληψης';

  @override
  String get set => 'Ορισμός';

  @override
  String get dayDescriptionHelp =>
      'Περιγραφή του τι γίνεται την ημέρα αυτή (π.χ. \"pull day\") ή ποια μέρη του σώματος γυμνάζονται (π.χ. \"στήθος και ώμοι\").';

  @override
  String exerciseNr(String nr) {
    return 'Exercise $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'Αν κάνετε τις ίδιες επαναλήψεις και το ίδιο βάρος για όλα τα σετ, μπορείτε να συμπληρώσετε μόνο μία σειρά. Για παράδειγμα, για 4 σετ απλά εισάγετε 10 για τις επαναλήψεις, αυτό γίνεται αυτόματα \"4 x 10\".';

  @override
  String get comment => 'Σχόλιο';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Εντύπωση';

  @override
  String get notes => 'Σημειώσεις';

  @override
  String get workoutSession => 'Περίοδος προπόνησης';

  @override
  String get restDay => 'Rest day';

  @override
  String get isRestDay => 'Is rest day';

  @override
  String get isRestDayHelp =>
      'Please note that all sets and exercises will be removed when you mark a day as a rest day.';

  @override
  String get needsLogsToAdvance => 'Needs logs to advance';

  @override
  String get needsLogsToAdvanceHelp =>
      'Select if you want the routine to progress to the next scheduled day only if you\'ve logged a workout for the day';

  @override
  String get routineDays => 'Days in routine';

  @override
  String get resultingRoutine => 'Resulting routine';

  @override
  String get newDay => 'Νέα ημέρα';

  @override
  String get newSet => 'Νέο σετ';

  @override
  String get selectExercises =>
      'Αν θέλετε να κάνετε ένα υπερσύνολο, μπορείτε να αναζητήσετε αρκετές ασκήσεις, οι οποίες θα ομαδοποιηθούν μαζί.';

  @override
  String get gymMode => 'Λειτουργία γυμναστηρίου';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Πλάκες';

  @override
  String get plateCalculatorNotDivisible =>
      'Δεν είναι δυνατή η επίτευξη βάρους με τις διαθέσιμες πλάκες';

  @override
  String get pause => 'Παύση';

  @override
  String get jumpTo => 'Μετάβαση σε';

  @override
  String get todaysWorkout => 'Η προπόνησή σας σήμερα';

  @override
  String get logHelpEntries =>
      'Εάν σε μία ημέρα υπάρχουν περισσότερες από μία εγγραφές με τον ίδιο αριθμό επαναλήψεων, αλλά με διαφορετικά βάρη, στο διάγραμμα εμφανίζεται μόνο η εγγραφή με το μεγαλύτερο βάρος.';

  @override
  String get logHelpEntriesUnits =>
      'Σημειώστε ότι καταγράφονται μόνο καταχωρήσεις με μονάδα βάρους (kg ή lb) και επαναλήψεις, ενώ άλλοι συνδυασμοί όπως χρόνος ή μέχρι αποτυχίας αγνοούνται εδώ.\nΕλληνικά';

  @override
  String get description => 'Περιγραφή';

  @override
  String get name => 'Όνομα';

  @override
  String get save => 'Αποθήκευση';

  @override
  String get verify => 'Verify';

  @override
  String get addSet => 'Add set';

  @override
  String get addMeal => 'Add meal';

  @override
  String get mealLogged => 'Meal logged to diary';

  @override
  String get ingredientLogged => 'Ingredient logged to diary';

  @override
  String get logMeal => 'Log meal to nutrition diary';

  @override
  String get addIngredient => 'Add ingredient';

  @override
  String get logIngredient => 'Log ingredient to nutrition diary';

  @override
  String get searchIngredient => 'Search ingredient';

  @override
  String get nutritionalPlan => 'Διατροφικό σχέδιο';

  @override
  String get nutritionalDiary => 'Nutritional diary';

  @override
  String get nutritionalPlans => 'Nutritional plans';

  @override
  String get noNutritionalPlans => 'You have no nutritional plans';

  @override
  String get onlyLogging => 'Only track calories';

  @override
  String get onlyLoggingHelpText =>
      'Check the box if you only want to log your calories and don\'t want to setup a detailed nutritional plan with specific meals';

  @override
  String get goalMacro => 'Macro goals';

  @override
  String get selectMealToLog => 'Select a meal to log to diary';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Your current nutrition plan has no meals defined';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'To add meals to the plan, go to the nutritional plan details';

  @override
  String get goalEnergy => 'Energy goal';

  @override
  String get goalProtein => 'Protein goal';

  @override
  String get goalCarbohydrates => 'Carbohydrates goal';

  @override
  String get goalFat => 'Fat goal';

  @override
  String get goalFiber => 'Fiber goal';

  @override
  String get anErrorOccurred => 'An Error Occurred!';

  @override
  String get errorInfoDescription =>
      'We\'re sorry, but something went wrong. You can help us fix this by reporting the issue on GitHub.';

  @override
  String get errorInfoDescription2 =>
      'You can continue using the app, but some features may not work.';

  @override
  String get errorViewDetails => 'Technical details';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Couldn\'t connect to server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'The application could not connect to the server. Please check your internet connection or the server URL and try again. If the problem persists, contact the server administrator.';

  @override
  String get copyToClipboard => 'Copy to clipboard';

  @override
  String get weight => 'Βάρος';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name all-time';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name last 30 days';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName during nutritional plan $planName';
  }

  @override
  String get measurement => 'Measurement';

  @override
  String get measurements => 'Measurements';

  @override
  String get measurementCategoriesHelpText =>
      'Measurement category, such as \'biceps\' or \'body fat\'';

  @override
  String get measurementEntriesHelpText =>
      'The unit used to measure the category such as \'cm\' or \'%\'';

  @override
  String get date => 'Ημερομηνία';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'Αξία';

  @override
  String get start => 'Start';

  @override
  String get time => 'Time';

  @override
  String get timeStart => 'Start time';

  @override
  String get timeEnd => 'End time';

  @override
  String get timeStartAhead => 'Start time cannot be ahead of end time';

  @override
  String get ingredient => 'Ingredient';

  @override
  String get energy => 'Energy';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutrients';

  @override
  String get planned => 'Planned';

  @override
  String get logged => 'Logged';

  @override
  String get today => 'Today';

  @override
  String get loggedToday => 'Logged today';

  @override
  String get weekAverage => '7 day average';

  @override
  String get surplus => 'surplus';

  @override
  String get deficit => 'deficit';

  @override
  String get difference => 'Διαφορά';

  @override
  String get percentEnergy => 'Percent of energy';

  @override
  String get gPerBodyKg => 'g per body kg';

  @override
  String get total => 'Total';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'γρ';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Protein';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Carbohydrates';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Sugars';

  @override
  String get fat => 'Fat';

  @override
  String get fatShort => 'F';

  @override
  String get saturatedFat => 'Saturated fat';

  @override
  String get fiber => 'Fibers';

  @override
  String get sodium => 'Sodium';

  @override
  String get amount => 'Amount';

  @override
  String get unit => 'Μονάδα';

  @override
  String get newEntry => 'New entry';

  @override
  String get noWeightEntries => 'You have no weight entries';

  @override
  String get noMeasurementEntries => 'You have no measurement entries';

  @override
  String get moreMeasurementEntries => 'Add new measurement';

  @override
  String get edit => 'Επεξεργασία';

  @override
  String get loadingText => 'Loading...';

  @override
  String get delete => 'Διαγραφή';

  @override
  String confirmDelete(String toDelete) {
    return 'Are you sure you want to delete \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'New nutritional plan';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'Toggle details';

  @override
  String get goToDetailPage => 'Go to detail page';

  @override
  String get aboutWhySupportTitle => 'Open Source & free to use ❤️';

  @override
  String get aboutDescription =>
      'Thank you for using wger! wger is a collaborative open source project, made by fitness enthusiasts from around the world.';

  @override
  String get aboutDonateTitle => 'Make a donation';

  @override
  String get aboutDonateText =>
      'While the project is free and will always remain it, running the server isn’t! Development also takes significant time and effort from volunteers. Your contribution directly supports these costs, helping to keep the service reliable.';

  @override
  String get aboutContributeTitle => 'Contribute';

  @override
  String get aboutContributeText =>
      'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!';

  @override
  String get aboutBugsListTitle => 'Report a problem or suggest a feature';

  @override
  String get aboutTranslationListTitle => 'Translate the application';

  @override
  String get aboutSourceListTitle => 'View source code';

  @override
  String get aboutJoinCommunityTitle => 'Join the community';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Others';

  @override
  String get calendar => 'Calendar';

  @override
  String get goToToday => 'Go to today';

  @override
  String get enterValue => 'Please enter a value';

  @override
  String get selectEntry => 'Please select an entry';

  @override
  String get selectExercise => 'Please select an exercise';

  @override
  String enterCharacters(String min, String max) {
    return 'Please enter between $min and $max characters';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Please enter at least $min characters';
  }

  @override
  String get baseNameEnglish => 'All exercises need a base name in English';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Sets per exercise: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Set units and RiR';

  @override
  String get enterValidNumber => 'Please enter a valid number';

  @override
  String get selectIngredient => 'Please select an ingredient';

  @override
  String get recentlyUsedIngredients => 'Recently added ingredients';

  @override
  String get selectImage => 'Please select an image';

  @override
  String get optionsLabel => 'Options';

  @override
  String get takePicture => 'Take a picture';

  @override
  String get chooseFromLibrary => 'Choose from photo library';

  @override
  String get gallery => 'Gallery';

  @override
  String get addImage => 'Add image';

  @override
  String get dataCopied => 'Data copied to new entry';

  @override
  String get appUpdateTitle => 'Update needed';

  @override
  String get appUpdateContent =>
      'This version of the app is not compatible with the server, please update your application.';

  @override
  String get productFound => 'Product found';

  @override
  String productFoundDescription(String productName) {
    return 'The barcode corresponds to this product: $productName. Do you want to continue?';
  }

  @override
  String get productNotFound => 'Product not found';

  @override
  String productNotFoundDescription(String barcode) {
    return 'The product with the scanned barcode $barcode was not found in the wger database';
  }

  @override
  String get scanBarcode => 'Scan barcode';

  @override
  String get close => 'Close';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'Images must be compatible with the CC BY SA license. If in doubt, upload only photos you\'ve taken yourself.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'Variations';

  @override
  String alsoKnownAs(String aliases) {
    return 'Also known as: $aliases';
  }

  @override
  String get verifiedEmail => 'Verified email';

  @override
  String get unVerifiedEmail => 'Unverified email';

  @override
  String get verifiedEmailReason => 'You need to verify your email to contribute exercises';

  @override
  String verifiedEmailInfo(String email) {
    return 'A verification email was sent to $email';
  }

  @override
  String get alternativeNames => 'Alternative names';

  @override
  String get oneNamePerLine => 'One name per line';

  @override
  String get whatVariationsExist => 'What variations of this exercise exist, if any?';

  @override
  String get previous => 'Προηγούμενο';

  @override
  String get next => 'Επόμενο';

  @override
  String get images => 'Εικόνες';

  @override
  String get language => 'Γλώσσα';

  @override
  String get addExercise => 'Add exercise';

  @override
  String get fitInWeek => 'Fit in week';

  @override
  String get fitInWeekHelp =>
      'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.';

  @override
  String get addSuperset => 'Add superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set has progression';

  @override
  String get setHasProgressionWarning =>
      'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.';

  @override
  String get setHasNoExercises => 'This set has no exercises yet!';

  @override
  String get contributeExercise => 'Contribute an exercise';

  @override
  String get translation => 'Μετάφραση';

  @override
  String get translateExercise => 'Translate this exercise now';

  @override
  String get baseData => 'Basics in English';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Settings';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Exercise cache';

  @override
  String get settingsIngredientCacheDescription => 'Ingredient cache';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache successfully cleared';

  @override
  String get aboutPageTitle => 'About us & Support';

  @override
  String contributeExerciseWarning(String days) {
    return 'You can only contribute exercises if your account is older than $days days and have verified your email';
  }

  @override
  String get simpleMode => 'Simple mode';

  @override
  String get simpleModeHelp => 'Hide some of the more advanced settings when editing exercises';

  @override
  String get progressionRules =>
      'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.';

  @override
  String get cacheWarning =>
      'Due to caching it might take some time till the changes are visible throughout the application.';

  @override
  String get textPromptTitle => 'Ready to start?';

  @override
  String get textPromptSubheading => 'Press the action button to begin';

  @override
  String get abs => 'Abs';

  @override
  String get arms => 'Arms';

  @override
  String get back => 'Back';

  @override
  String get barbell => 'Barbell';

  @override
  String get bench => 'Bench';

  @override
  String get biceps => 'Biceps';

  @override
  String get body_weight => 'Body Weight';

  @override
  String get calves => 'Calves';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Chest';

  @override
  String get dumbbell => 'Dumbbell';

  @override
  String get glutes => 'Glutes';

  @override
  String get gym_mat => 'Gym mat';

  @override
  String get hamstrings => 'Hamstrings';

  @override
  String get incline_bench => 'Incline bench';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Kilometers';

  @override
  String get kilometers_per_hour => 'Kilometers Per Hour';

  @override
  String get lats => 'Lats';

  @override
  String get legs => 'Legs';

  @override
  String get lower_back => 'Lower back';

  @override
  String get max_reps => 'Max Reps';

  @override
  String get miles => 'Miles';

  @override
  String get miles_per_hour => 'Miles Per Hour';

  @override
  String get minutes => 'Minutes';

  @override
  String get plates => 'Plates';

  @override
  String get pull_up_bar => 'Pull-up bar';

  @override
  String get quads => 'Quads';

  @override
  String get repetitions => 'Repetitions';

  @override
  String get resistance_band => 'Resistance band';

  @override
  String get sz_bar => 'SZ-Bar';

  @override
  String get seconds => 'Seconds';

  @override
  String get shoulders => 'Shoulders';

  @override
  String get swiss_ball => 'Swiss Ball';

  @override
  String get triceps => 'Triceps';

  @override
  String get until_failure => 'Until Failure';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'none (bodyweight exercise)';

  @override
  String get log => 'Log';

  @override
  String get done => 'Done';

  @override
  String get overallChangeWeight => 'Overall change';

  @override
  String get goalTypeMeals => 'From meals';

  @override
  String get goalTypeBasic => 'Basic';

  @override
  String get goalTypeAdvanced => 'Advanced';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'avg';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Theme mode';

  @override
  String get darkMode => 'Always dark mode';

  @override
  String get lightMode => 'Always light mode';

  @override
  String get systemMode => 'System settings';
}
