// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Arabic (`ar`).
class AppLocalizationsAr extends AppLocalizations {
  AppLocalizationsAr([String locale = 'ar']) : super(locale);

  @override
  String get userProfile => 'ملفك الشخصي';

  @override
  String get login => 'تسجيل الدخول';

  @override
  String get logout => 'تسجيل خروج';

  @override
  String get register => 'تسجيل';

  @override
  String get useDefaultServer => 'استخدم السيرفر الافتراضي';

  @override
  String get useCustomServer => 'استخدم سيرفر مخصص';

  @override
  String get invalidUrl => 'أدخل رابط صحيح من فضلك';

  @override
  String get usernameValidChars =>
      'يجب أن يحتوي اسم المستخدم على كلاً من : أحرف، أرقام، رموز مثل @ ، + ، . ، - ، _';

  @override
  String get passwordsDontMatch => 'كلمات المرور غير متطابقة';

  @override
  String get passwordTooShort => 'كلمة المرور قصيرة';

  @override
  String get selectAvailablePlates => 'اختر من الاطباق المتوفرة';

  @override
  String get barWeight => 'وزن القضيب الحديدي';

  @override
  String get useColors => 'استخدم الالوان';

  @override
  String get password => 'كلمة المرور';

  @override
  String get confirmPassword => 'تأكيد كلمة المرور';

  @override
  String get invalidEmail => 'الرجاء كتابة بريد إلكتروني صحيح';

  @override
  String get email => 'البريد الإلكتروني';

  @override
  String get username => 'اسم المستخدم';

  @override
  String get invalidUsername => 'الرجاء كتابة اسم مستخدم صحيح';

  @override
  String get useApiToken => 'استخدم رمز API';

  @override
  String get useUsernameAndPassword => 'استخدم اسم المستخدم وكلمة المرور';

  @override
  String get apiToken => 'رمز API';

  @override
  String get invalidApiToken => 'رجاءً أدخل مفتاح API صالح';

  @override
  String get apiTokenValidChars =>
      'إن مفتاح ال API لا يمكن أن يحتوي غير الأحرف من a-f، أرقام من 0-9، ويحب أن تكون 40 محرف تماما';

  @override
  String get customServerUrl => 'رابط عنصر wger';

  @override
  String get customServerHint => 'ادخل عنوان الخادم خاصتك أو سيستخدم الخادم الافتراضي';

  @override
  String get reset => 'إعادة ضبط';

  @override
  String get registerInstead => 'ليس لديك حساب ؟ سجّل الان';

  @override
  String get loginInstead => 'لديك حساب ؟ تسجيل الدخول';

  @override
  String get labelBottomNavWorkout => 'تمرين';

  @override
  String get labelBottomNavNutrition => 'التغذية';

  @override
  String get labelWorkoutLogs => 'سجلات التمرين';

  @override
  String get labelWorkoutPlan => 'خطط التمارين';

  @override
  String get labelDashboard => 'لوحة العمليات';

  @override
  String get success => 'مكتمل';

  @override
  String get successfullyDeleted => 'تم الحذف';

  @override
  String get successfullySaved => 'تم الحفظ';

  @override
  String get exerciseList => 'قائمة التمارين';

  @override
  String get exercise => 'تمرين';

  @override
  String get exercises => 'التمارين';

  @override
  String get exerciseName => 'اسم التمرين';

  @override
  String get searchExercise => 'ابحث عن تمرين لإضافته';

  @override
  String get noIngredientsDefined => 'No ingredients defined yet';

  @override
  String get noMatchingExerciseFound => 'لم نجد تمرين بهذا الأسم';

  @override
  String get searchNamesInEnglish => 'ابحث بأسماء التمارين بالانجليزي';

  @override
  String get equipment => 'الادوات';

  @override
  String get muscles => 'العضلات';

  @override
  String get musclesSecondary => 'العضلات الثانوية';

  @override
  String get category => 'الفئة';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get routines => 'Routines';

  @override
  String get newRoutine => 'New routine';

  @override
  String get noRoutines => 'You have no routines';

  @override
  String get reps => 'التكرارات الفعالة';

  @override
  String get restTime => 'Rest time';

  @override
  String get sets => 'Sets';

  @override
  String get rir => 'عدد التكرارات المتبقية';

  @override
  String get rirNotUsed => 'عدد التكرارات المتبقية غير موجود';

  @override
  String get useMetric => 'Use metric units for body weight';

  @override
  String get weightUnit => 'وحدة الوزن';

  @override
  String get repetitionUnit => 'عدد التكرارات المتبقية';

  @override
  String get set => 'مجموعة';

  @override
  String get dayDescriptionHelp =>
      'وصف لما يتم القيام به في هذا اليوم (مثال، \"يوم السحب\") أو ما هي أجزاء الجسم التي سيتم تدريبها (مثال، \"الصدر والكتفين\")';

  @override
  String exerciseNr(String nr) {
    return 'Exercise $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'إذا قمت بنفس التكرارات والوزن لجميع المجموعات، فيمكنك فقط ملء صف واحد، مثال : لأربع مجموعات فقط أدخل 10 للتكرارات، ويصبح هذا تلقائيًا \"4 × 10\".';

  @override
  String get comment => 'تعليق';

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'انطباع';

  @override
  String get notes => 'ملاحظات';

  @override
  String get workoutSession => 'جلسة تدريب';

  @override
  String get restDay => 'Rest day';

  @override
  String get isRestDay => 'Is rest day';

  @override
  String get isRestDayHelp =>
      'Please note that all sets and exercises will be removed when you mark a day as a rest day.';

  @override
  String get needsLogsToAdvance => 'Needs logs to advance';

  @override
  String get needsLogsToAdvanceHelp =>
      'Select if you want the routine to progress to the next scheduled day only if you\'ve logged a workout for the day';

  @override
  String get routineDays => 'Days in routine';

  @override
  String get resultingRoutine => 'Resulting routine';

  @override
  String get newDay => 'يوم جديد';

  @override
  String get newSet => 'مجموعة جديدة';

  @override
  String get selectExercises =>
      'إذا كنت تريد إجراء مجموعة شاملة، يمكنك البحث عن عدة تمارين، وسيتم جمعها معًا';

  @override
  String get gymMode => 'وضع النادي';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'الأطباق';

  @override
  String get plateCalculatorNotDivisible => 'لا يمكن الوصول إلى الوزن بالأطباق المتوفرة';

  @override
  String get pause => 'إيقاف';

  @override
  String get jumpTo => 'القفز إلى';

  @override
  String get todaysWorkout => 'تمرينك اليوم';

  @override
  String get logHelpEntries =>
      'إذا كان هناك في يوم واحد أكثر من إدخال بنفس عدد التكرارات، ولكن بأوزان مختلفة، فسيتم عرض الإدخال ذو الوزن الأعلى فقط في الرسم البياني.';

  @override
  String get logHelpEntriesUnits =>
      'لاحظ أنه يتم رسم الإدخالات التي تحتوي على وحدة الوزن (كجم أو رطل) والتكرارات فقط، ويتم هنا تجاهل المجموعات الأخرى مثل الوقت أو حتى الفشل العضلي.';

  @override
  String get description => 'الوصف';

  @override
  String get name => 'الاسم';

  @override
  String get save => 'حفظ';

  @override
  String get verify => 'تأكيد';

  @override
  String get addSet => 'أضف مجموعة';

  @override
  String get addMeal => 'أضف وجبة';

  @override
  String get mealLogged => 'سُجّلت الوجبة في اليوميات';

  @override
  String get ingredientLogged => 'Ingredient logged to diary';

  @override
  String get logMeal => 'سجّل الوجبة';

  @override
  String get addIngredient => 'أضف مكونًا';

  @override
  String get logIngredient => 'حفظ في مذكرة التغذية';

  @override
  String get searchIngredient => 'ابحث عن عنصر';

  @override
  String get nutritionalPlan => 'الخطة الغذائية';

  @override
  String get nutritionalDiary => 'مذكرة التغذية';

  @override
  String get nutritionalPlans => 'خطط غذائية';

  @override
  String get noNutritionalPlans => 'لا يوجد لديك أي خطط تغذية';

  @override
  String get onlyLogging => 'Only track calories';

  @override
  String get onlyLoggingHelpText =>
      'Check the box if you only want to log your calories and don\'t want to setup a detailed nutritional plan with specific meals';

  @override
  String get goalMacro => 'Macro goals';

  @override
  String get selectMealToLog => 'Select a meal to log to diary';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Your current nutrition plan has no meals defined';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'To add meals to the plan, go to the nutritional plan details';

  @override
  String get goalEnergy => 'Energy goal';

  @override
  String get goalProtein => 'Protein goal';

  @override
  String get goalCarbohydrates => 'Carbohydrates goal';

  @override
  String get goalFat => 'Fat goal';

  @override
  String get goalFiber => 'Fiber goal';

  @override
  String get anErrorOccurred => 'حصل خطأ!';

  @override
  String get errorInfoDescription =>
      'We\'re sorry, but something went wrong. You can help us fix this by reporting the issue on GitHub.';

  @override
  String get errorInfoDescription2 =>
      'You can continue using the app, but some features may not work.';

  @override
  String get errorViewDetails => 'Technical details';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Couldn\'t connect to server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'The application could not connect to the server. Please check your internet connection or the server URL and try again. If the problem persists, contact the server administrator.';

  @override
  String get copyToClipboard => 'Copy to clipboard';

  @override
  String get weight => 'الوزن';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name all-time';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name last 30 days';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName during nutritional plan $planName';
  }

  @override
  String get measurement => 'القياس';

  @override
  String get measurements => 'القياسات';

  @override
  String get measurementCategoriesHelpText =>
      'فئة القياس، مثل \"العضلة ذات الرأسين\" أو \"دهون الجسم\"';

  @override
  String get measurementEntriesHelpText => 'الوحدة المستخدمة لقياس الفئة مثل \"سم\" أو \"%\"';

  @override
  String get date => 'التاريخ';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'قيمة';

  @override
  String get start => 'ابدأ';

  @override
  String get time => 'وقت';

  @override
  String get timeStart => 'وقت البدء';

  @override
  String get timeEnd => 'وقت الانتهاء';

  @override
  String get timeStartAhead => 'وقت البدء لا يجب أن يكون متقدمًا على وقت الانتهاء';

  @override
  String get ingredient => 'المكونات';

  @override
  String get energy => 'الطاقة';

  @override
  String get energyShort => 'ط';

  @override
  String get macronutrients => 'مغذيات كبيرة';

  @override
  String get planned => 'مخططة';

  @override
  String get logged => 'سُجلت';

  @override
  String get today => 'Today';

  @override
  String get loggedToday => 'Logged today';

  @override
  String get weekAverage => 'متوسط سبع أيام';

  @override
  String get surplus => 'surplus';

  @override
  String get deficit => 'deficit';

  @override
  String get difference => 'الفرق';

  @override
  String get percentEnergy => 'نسبة الطاقة';

  @override
  String get gPerBodyKg => 'قرام لكل كيلو قرام من الجسم';

  @override
  String get total => 'المجموع';

  @override
  String get kcal => 'سعرة';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'كيلو جول';

  @override
  String get g => 'قرام';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'بروتين';

  @override
  String get proteinShort => 'ب';

  @override
  String get carbohydrates => 'كربوهيدرات';

  @override
  String get carbohydratesShort => 'ك';

  @override
  String get sugars => 'سكريات';

  @override
  String get fat => 'دهون';

  @override
  String get fatShort => 'د';

  @override
  String get saturatedFat => 'الدهون المشبعة';

  @override
  String get fiber => 'الألياف';

  @override
  String get sodium => 'صوديوم';

  @override
  String get amount => 'الكمية';

  @override
  String get unit => 'الوحدة';

  @override
  String get newEntry => 'إضافة جديدة';

  @override
  String get noWeightEntries => 'ليس لديك أي إدخالات للوزن';

  @override
  String get noMeasurementEntries => 'لا يوجد إدخالات قياس';

  @override
  String get moreMeasurementEntries => 'أضف قياس جديد';

  @override
  String get edit => 'تعديل';

  @override
  String get loadingText => 'تحميل ...';

  @override
  String get delete => 'حذف';

  @override
  String confirmDelete(String toDelete) {
    return 'أمتأكد لحذف \'$toDelete\'؟';
  }

  @override
  String get newNutritionalPlan => 'خطة تغذية جديدة';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'تبديل التفاصيل';

  @override
  String get goToDetailPage => 'الذهاب لصفحة التفاصيل';

  @override
  String get aboutWhySupportTitle => 'Open Source & free to use ❤️';

  @override
  String get aboutDescription =>
      'شكرًا لاستخدامك وقر! وقر مشروع تعاوني مفتوح المصدر، تم إنشاؤه بواسطة عشّاق اللياقة البدنية من جميع أنحاء العالم.';

  @override
  String get aboutDonateTitle => 'Make a donation';

  @override
  String get aboutDonateText =>
      'While the project is free and will always remain it, running the server isn’t! Development also takes significant time and effort from volunteers. Your contribution directly supports these costs, helping to keep the service reliable.';

  @override
  String get aboutContributeTitle => 'Contribute';

  @override
  String get aboutContributeText =>
      'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!';

  @override
  String get aboutBugsListTitle => 'Report a problem or suggest a feature';

  @override
  String get aboutTranslationListTitle => 'Translate the application';

  @override
  String get aboutSourceListTitle => 'View source code';

  @override
  String get aboutJoinCommunityTitle => 'Join the community';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Others';

  @override
  String get calendar => 'التقويم';

  @override
  String get goToToday => 'الذهاب لليوم';

  @override
  String get enterValue => 'ادخل قيمة من فضلك';

  @override
  String get selectEntry => 'اختر قيمة';

  @override
  String get selectExercise => 'اختر تمرين';

  @override
  String enterCharacters(String min, String max) {
    return 'الرجاء إدخال ما بين $min و$max من الأحرف';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'الرجاء إدخال $min حرفًا على الأقل';
  }

  @override
  String get baseNameEnglish => 'جميع التمارين تتطلب اسم أساسي بالإنجليزية';

  @override
  String nrOfSets(String nrOfSets) {
    return 'المجموعات لكل تمرين: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'تعيين الوحدات و RiR';

  @override
  String get enterValidNumber => 'أدخل رقمًا صحيحًا';

  @override
  String get selectIngredient => 'الرجاء تحديد العنصر';

  @override
  String get recentlyUsedIngredients => 'المكونات المضافة مؤخرًا';

  @override
  String get selectImage => 'الرجاء اختيار صورة';

  @override
  String get optionsLabel => 'الخيارات';

  @override
  String get takePicture => 'إلتقط صورة';

  @override
  String get chooseFromLibrary => 'اختر من الألبوم';

  @override
  String get gallery => 'الألبوم';

  @override
  String get addImage => 'إضافة صورة';

  @override
  String get dataCopied => 'تم نسخ البيانات إلى الإدخال الجديد';

  @override
  String get appUpdateTitle => 'التحديث متطلب';

  @override
  String get appUpdateContent => 'لا يتوافق الإصدار الحالي مع السيرفر، يرجى تحديث التطبيق.';

  @override
  String get productFound => 'عُثِر على المنتج';

  @override
  String productFoundDescription(String productName) {
    return 'يتوافق رمز الباركود مع هذا المنتج: $productName. أتريد الاستمرار؟';
  }

  @override
  String get productNotFound => 'المنتج غير موجود';

  @override
  String productNotFoundDescription(String barcode) {
    return 'لم يتم العثور على المنتج الممسوح ضوئيًا $barcode في wger';
  }

  @override
  String get scanBarcode => '‌صوّر الرمز التسلسلي';

  @override
  String get close => 'إقفال';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'يجب أن تكون الصور متوافقة مع ترخيص CC BY SA. في حال عدم تأكدك، قم بتحميل الصور التي إلتقطتها.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'اختلافات';

  @override
  String alsoKnownAs(String aliases) {
    return 'يُعرف أيضًا باسم: $aliases';
  }

  @override
  String get verifiedEmail => 'بريد إلكتروني مفعّل';

  @override
  String get unVerifiedEmail => 'بريد إلكتروني غير مفعّل';

  @override
  String get verifiedEmailReason => 'تحتاج إلى التحقق من بريدك الإلكتروني للمساهمة في التمارين';

  @override
  String verifiedEmailInfo(String email) {
    return 'أُرسلت رسالة للتحقق إلى $email';
  }

  @override
  String get alternativeNames => 'أسماء بديلة';

  @override
  String get oneNamePerLine => 'اسم واحد لكل سطر';

  @override
  String get whatVariationsExist => 'ما الاختلافات الموجودة في التمرين، إن وجدت؟';

  @override
  String get previous => 'السابق';

  @override
  String get next => 'التالي';

  @override
  String get images => 'الصور';

  @override
  String get language => 'اللغة';

  @override
  String get addExercise => 'أضف التمرين';

  @override
  String get fitInWeek => 'Fit in week';

  @override
  String get fitInWeekHelp =>
      'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.';

  @override
  String get addSuperset => 'Add superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set has progression';

  @override
  String get setHasProgressionWarning =>
      'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.';

  @override
  String get setHasNoExercises => 'This set has no exercises yet!';

  @override
  String get contributeExercise => 'ساهم في التمرين';

  @override
  String get translation => 'الترجمة';

  @override
  String get translateExercise => 'ترجم التدريب الآن';

  @override
  String get baseData => 'الأساسيات بالإنجليزية';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Settings';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Exercise cache';

  @override
  String get settingsIngredientCacheDescription => 'Ingredient cache';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache successfully cleared';

  @override
  String get aboutPageTitle => 'عن وقر wger';

  @override
  String contributeExerciseWarning(String days) {
    return 'لا يمكنك المساهمة بالتمارين إلا إذا كان حسابك أقدم من $days يومًا وبريدك الإلكتروني مفعّل';
  }

  @override
  String get simpleMode => 'Simple mode';

  @override
  String get simpleModeHelp => 'Hide some of the more advanced settings when editing exercises';

  @override
  String get progressionRules =>
      'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.';

  @override
  String get cacheWarning =>
      'بسبب التخزين المؤقت، قد يستغرق الأمر بعض الوقت حتى تصبح التغييرات مرئية في التطبيق.';

  @override
  String get textPromptTitle => 'مستعد للبدء ؟';

  @override
  String get textPromptSubheading => 'اضغط على الزر للبدء';

  @override
  String get abs => 'عضلات المعدة';

  @override
  String get arms => 'الأدوات';

  @override
  String get back => 'الظهر';

  @override
  String get barbell => 'الحديد';

  @override
  String get bench => 'المقعد';

  @override
  String get biceps => 'العضلة ذات الرأسين أو عضلة الذراع';

  @override
  String get body_weight => 'وزن الجسم';

  @override
  String get calves => 'بطة الرجل';

  @override
  String get cardio => 'عضلة القلب';

  @override
  String get chest => 'الصدر';

  @override
  String get dumbbell => 'أثقال صغيرة';

  @override
  String get glutes => 'المؤخرة';

  @override
  String get gym_mat => 'سجّاد التمارين';

  @override
  String get hamstrings => 'أوتار الركبة';

  @override
  String get incline_bench => 'مقعد مائل للأعلى';

  @override
  String get kettlebell => 'الكرة الحديدية';

  @override
  String get kilometers => 'كيلومترات';

  @override
  String get kilometers_per_hour => 'كيلومترات في الساعة';

  @override
  String get lats => 'العضلة الظهرية العريضة';

  @override
  String get legs => 'الأرجل';

  @override
  String get lower_back => 'أسفل الظهر';

  @override
  String get max_reps => 'أقصى عدد للتكرارات الفعالة';

  @override
  String get miles => 'أميال';

  @override
  String get miles_per_hour => 'أميال في الساعة';

  @override
  String get minutes => 'دقائق';

  @override
  String get plates => 'أطباق';

  @override
  String get pull_up_bar => 'بار السحب';

  @override
  String get quads => 'عضلات الفخذ';

  @override
  String get repetitions => 'التكرار';

  @override
  String get resistance_band => 'Resistance band';

  @override
  String get sz_bar => 'البار المجعد SZ-Bar';

  @override
  String get seconds => 'ثواني';

  @override
  String get shoulders => 'أكتاف';

  @override
  String get swiss_ball => 'الكرة السويسرية';

  @override
  String get triceps => 'العضلة ثلاثة الرؤوس العضدية';

  @override
  String get until_failure => 'وصولاً للفشل';

  @override
  String get kg => 'كغم';

  @override
  String get lb => 'رطل';

  @override
  String get none__bodyweight_exercise_ => 'لا شيء (تمرين وزن الجسم)';

  @override
  String get log => 'Log';

  @override
  String get done => 'Done';

  @override
  String get overallChangeWeight => 'Overall change';

  @override
  String get goalTypeMeals => 'From meals';

  @override
  String get goalTypeBasic => 'Basic';

  @override
  String get goalTypeAdvanced => 'Advanced';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'avg';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Theme mode';

  @override
  String get darkMode => 'Always dark mode';

  @override
  String get lightMode => 'Always light mode';

  @override
  String get systemMode => 'System settings';
}
