Pod::Spec.new do |s|
  s.name = "rive_common"
  s.version = "0.0.1"
  s.summary = "Rive text abstraction."
  s.description = <<-DESC
Rive 2 Flutter Runtime. This package provides runtime functionality for playing back and interacting with animations built with the Rive editor available at https://rive.app.
                       DESC
  s.homepage = "https://rive.app"
  s.license = { :file => "../LICENSE" }
  s.author = { "Rive" => "hello@rive.app" }

  s.source = { :path => "." }
  s.source_files = [
    "Classes/**/*",
    "rive_text/**/*.{cpp,hpp,c,h}",
    "common.cpp",
    "rive-cpp/src/audio/audio_engine.cpp",
    "rive-cpp/src/audio/audio_sound.cpp",
    "rive-cpp/src/audio/audio_reader.cpp",
    "rive-cpp/src/audio/audio_source.cpp",
    "rive-cpp/src/math/raw_path.cpp",
    "rive-cpp/src/math/mat2d.cpp",
    "rive-cpp/src/renderer.cpp",
    "rive-cpp/src/text/font_hb.cpp",
    "rive-cpp/src/text/line_breaker.cpp",

    "harfbuzz/src/hb-aat-layout.cc",
    "harfbuzz/src/hb-aat-map.cc",
    "harfbuzz/src/hb-blob.cc",
    "harfbuzz/src/hb-buffer-serialize.cc",
    "harfbuzz/src/hb-buffer-verify.cc",
    "harfbuzz/src/hb-buffer.cc",
    "harfbuzz/src/hb-common.cc",
    "harfbuzz/src/hb-draw.cc",
    "harfbuzz/src/hb-face.cc",
    "harfbuzz/src/hb-font.cc",
    "harfbuzz/src/hb-map.cc",
    "harfbuzz/src/hb-number.cc",
    "harfbuzz/src/hb-ot-cff1-table.cc",
    "harfbuzz/src/hb-ot-cff2-table.cc",
    "harfbuzz/src/hb-ot-color.cc",
    "harfbuzz/src/hb-ot-face.cc",
    "harfbuzz/src/hb-ot-font.cc",
    "harfbuzz/src/hb-ot-layout.cc",
    "harfbuzz/src/hb-ot-map.cc",
    "harfbuzz/src/hb-ot-math.cc",
    "harfbuzz/src/hb-ot-meta.cc",
    "harfbuzz/src/hb-ot-metrics.cc",
    "harfbuzz/src/hb-ot-name.cc",
    "harfbuzz/src/hb-ot-shaper-arabic.cc",
    "harfbuzz/src/hb-ot-shaper-default.cc",
    "harfbuzz/src/hb-ot-shaper-hangul.cc",
    "harfbuzz/src/hb-ot-shaper-hebrew.cc",
    "harfbuzz/src/hb-ot-shaper-indic-table.cc",
    "harfbuzz/src/hb-ot-shaper-indic.cc",
    "harfbuzz/src/hb-ot-shaper-khmer.cc",
    "harfbuzz/src/hb-ot-shaper-myanmar.cc",
    "harfbuzz/src/hb-ot-shaper-syllabic.cc",
    "harfbuzz/src/hb-ot-shaper-thai.cc",
    "harfbuzz/src/hb-ot-shaper-use.cc",
    "harfbuzz/src/hb-ot-shaper-vowel-constraints.cc",
    "harfbuzz/src/hb-ot-shape-fallback.cc",
    "harfbuzz/src/hb-ot-shape-normalize.cc",
    "harfbuzz/src/hb-ot-shape.cc",
    "harfbuzz/src/hb-ot-tag.cc",
    "harfbuzz/src/hb-ot-var.cc",
    "harfbuzz/src/hb-set.cc",
    "harfbuzz/src/hb-shape-plan.cc",
    "harfbuzz/src/hb-shape.cc",
    "harfbuzz/src/hb-shaper.cc",
    "harfbuzz/src/hb-static.cc",
    "harfbuzz/src/hb-subset-cff-common.cc",
    "harfbuzz/src/hb-subset-cff1.cc",
    "harfbuzz/src/hb-subset-cff2.cc",
    "harfbuzz/src/hb-subset-input.cc",
    "harfbuzz/src/hb-subset-plan.cc",
    "harfbuzz/src/hb-subset-repacker.cc",
    "harfbuzz/src/hb-subset.cc",
    "harfbuzz/src/hb-ucd.cc",
    "harfbuzz/src/hb-unicode.cc",
    "harfbuzz/src/graph/gsubgpos-context.cc",
    "harfbuzz/src/hb-paint.cc",
    "harfbuzz/src/hb-paint-extents.cc",
    "harfbuzz/src/hb-outline.cc",
    "harfbuzz/src/hb-subset-instancer-solver.cc",
    "harfbuzz/src/hb-face-builder.cc",
    "harfbuzz/src/hb-style.cc",

    # "SheenBidi/Headers/*.h",
    "SheenBidi/Source/SheenBidi.c",

    "yoga/yoga/Utils.cpp",
    "yoga/yoga/YGConfig.cpp",
    "yoga/yoga/YGLayout.cpp",
    "yoga/yoga/YGEnums.cpp",
    "yoga/yoga/YGNodePrint.cpp",
    "yoga/yoga/YGNode.cpp",
    "yoga/yoga/YGValue.cpp",
    "yoga/yoga/YGStyle.cpp",
    "yoga/yoga/Yoga.cpp",
    "yoga/yoga/event/event.cpp",
    "yoga/yoga/log.cpp",
  ]
  s.dependency "FlutterMacOS"

  s.platform = :osx, "10.13"
  s.pod_target_xcconfig = {
    "ENABLE_MODULE_VERIFIER" => "NO",
    "CLANG_WARN_QUOTED_INCLUDE_IN_FRAMEWORK_HEADER" => "NO",
    "DEFINES_MODULE" => "YES",
    "OTHER_CFLAGS" => "-DYOGA_EXPORT= -DSB_CONFIG_UNITY -DWITH_RIVE_TEXT -DWITH_RIVE_AUDIO_TOOLS -DWITH_RIVE_AUDIO -DMA_NO_RESOURCE_MANAGER -DMA_NO_RESOURCE_MANAGER -DMA_NO_RESOURCE_MANAGER -DRIVE_NO_CORETEXT -DHAVE_OT -DHB_NO_FALLBACK_SHAPE -DHB_NO_WIN1256  -DHB_NO_CFF -DHB_NO_BUFFER_VERIFY -DHB_NO_BUFFER_MESSAGE -DHB_NO_PAINT -DHB_NO_MMAP -DHB_NO_META -Wno-documentation -Wno-comma -Wno-unreachable-code  -Wno-shorten-64-to-32 -Wno-quoted-include-in-framework-header",
    "OTHER_CPLUSPLUSFLAGS" => "-DYOGA_EXPORT= -DWITH_RIVE_TEXT -DWITH_RIVE_AUDIO_TOOLS -DWITH_RIVE_AUDIO -DMA_NO_RESOURCE_MANAGER -DMA_NO_RESOURCE_MANAGER -DMA_NO_RESOURCE_MANAGER -DRIVE_NO_CORETEXT -DHAVE_OT -DHB_NO_FALLBACK_SHAPE -DHB_NO_WIN1256 -Wno-conditional-uninitialized -Wno-documentation -Wno-comma -Wno-unreachable-code -Wno-shorten-64-to-32 -Wno-quoted-include-in-framework-header -std=c++11",
    "USER_HEADER_SEARCH_PATHS" => '"$(PODS_TARGET_SRCROOT)/miniaudio" "$(PODS_TARGET_SRCROOT)/SheenBidi/Headers" "$(PODS_TARGET_SRCROOT)/harfbuzz/src" "$(PODS_TARGET_SRCROOT)/rive-cpp/include" "$(PODS_TARGET_SRCROOT)/rive-cpp/skia/renderer/include"',
    "HEADER_SEARCH_PATHS" => '"$(PODS_TARGET_SRCROOT)/yoga" "$(PODS_TARGET_SRCROOT)/SheenBidi/Headers"',
    "OTHER_CPLUSPLUSFLAGS[config=Release]" => "-DNDEBUG -DYOGA_EXPORT= -DWITH_RIVE_TEXT -DWITH_RIVE_AUDIO_TOOLS -DWITH_RIVE_AUDIO -DMA_NO_RESOURCE_MANAGER -DMA_NO_RESOURCE_MANAGER -DMA_NO_RESOURCE_MANAGER -DRIVE_NO_CORETEXT -DHAVE_OT -DHB_NO_FALLBACK_SHAPE -DHB_NO_WIN1256 -Wno-conditional-uninitialized -Wno-documentation -Wno-comma -Wno-unreachable-code -Wno-shorten-64-to-32 -std=c++11",
    "CLANG_CXX_LANGUAGE_STANDARD" => "c++11",
    "CLANG_CXX_LIBRARY" => "libc++",
  }
  s.swift_version = "5.0"
  s.resource_bundles = {'rive_common_privacy' => ['Resources/PrivacyInfo.xcprivacy']}
end
