// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is automatically generated. Do not modify it.

import '../material_color_utilities.dart';

/// This class is the same concept as Flutter's ColorScheme class.
///
/// In standard MCU the [Scheme] class is deprecated in favor of newer and more
/// complex [DynamicScheme]. Please see
/// https://github.com/material-foundation/material-color-utilities/blob/main/make_schemes.md
/// for migration guidance.
///
/// In FlexSeedScheme we keep [Scheme] available and it can be used for legacy
/// `ColorScheme` generation if so needed. Internally FlexSeedScheme does not
/// use it fr legacy scheme. It uses its own FlexTones based legacy version to
/// make a ColorScheme that can be equal to this [Scheme] based one.
///
/// In the resurrection of this legacy Scheme version, we also added all the
/// new fixed, fixedDim and their on colors and all the new surface colors that
/// did not exist in the original Scheme class. This is to make it more
/// compatible with the new `ColorScheme` in Flutter 3.22.0 and later.
///
/// In the resurrection the dark mode [onErrorContainer] was also corrected to
/// use tone (90) instead of the wrong tone (80), that was used in the original
/// [Scheme] class.
///
/// The [Scheme] tones of course keeps the original legacy tones for surface
/// and background and does not change to the new tones used in Flutter 3.22.0
/// and later. This in order to offer the legacy [Scheme] color tones as it
/// was in the original older MCU and before Flutter 3.22.0.
class Scheme {
  /// Default Scheme constructor.
  const Scheme({
    required this.primary,
    required this.onPrimary,
    required this.primaryContainer,
    required this.onPrimaryContainer,
    required this.primaryFixed,
    required this.primaryFixedDim,
    required this.onPrimaryFixed,
    required this.onPrimaryFixedVariant,
    required this.secondary,
    required this.onSecondary,
    required this.secondaryContainer,
    required this.onSecondaryContainer,
    required this.secondaryFixed,
    required this.secondaryFixedDim,
    required this.onSecondaryFixed,
    required this.onSecondaryFixedVariant,
    required this.tertiary,
    required this.onTertiary,
    required this.tertiaryContainer,
    required this.onTertiaryContainer,
    required this.tertiaryFixed,
    required this.tertiaryFixedDim,
    required this.onTertiaryFixed,
    required this.onTertiaryFixedVariant,
    required this.error,
    required this.onError,
    required this.errorContainer,
    required this.onErrorContainer,
    required this.background,
    required this.onBackground,
    required this.surface,
    required this.surfaceDim,
    required this.surfaceBright,
    required this.surfaceContainerLowest,
    required this.surfaceContainerLow,
    required this.surfaceContainer,
    required this.surfaceContainerHigh,
    required this.surfaceContainerHighest,
    required this.onSurface,
    required this.surfaceVariant,
    required this.onSurfaceVariant,
    required this.outline,
    required this.outlineVariant,
    required this.shadow,
    required this.scrim,
    required this.inverseSurface,
    required this.inverseOnSurface,
    required this.inversePrimary,
  });

  /// primary color as int.
  final int primary;

  /// onPrimary color as int.
  final int onPrimary;

  /// primaryContainer color as int.
  final int primaryContainer;

  /// onPrimaryContainer color as int.
  final int onPrimaryContainer;

  /// primaryFixed color as int.
  final int primaryFixed;

  /// primaryFixedDim color as int.
  final int primaryFixedDim;

  /// onPrimaryFixed color as int.
  final int onPrimaryFixed;

  /// onPrimaryFixedVariant color as int.
  final int onPrimaryFixedVariant;

  /// secondary color as int.
  final int secondary;

  /// onSecondary color as int.
  final int onSecondary;

  /// secondaryContainer color as int.
  final int secondaryContainer;

  /// onSecondaryContainer color as int.
  final int onSecondaryContainer;

  /// secondaryFixed color as int.
  final int secondaryFixed;

  /// secondaryFixedDim color as int.
  final int secondaryFixedDim;

  /// onSecondaryFixed color as int.
  final int onSecondaryFixed;

  /// onSecondaryFixedVariant color as int.
  final int onSecondaryFixedVariant;

  /// tertiary color as int.
  final int tertiary;

  /// onTertiary color as int.
  final int onTertiary;

  /// tertiaryContainer color as int.
  final int tertiaryContainer;

  /// onTertiaryContainer color as int.
  final int onTertiaryContainer;

  /// tertiaryFixed color as int.
  final int tertiaryFixed;

  /// tertiaryFixedDim color as int.
  final int tertiaryFixedDim;

  /// onTertiaryFixed color as int.
  final int onTertiaryFixed;

  /// onTertiaryFixedVariant color as int.
  final int onTertiaryFixedVariant;

  /// error color as int.
  final int error;

  /// onError color as int.
  final int onError;

  /// errorContainer color as int.
  final int errorContainer;

  /// onErrorContainer color as int.
  final int onErrorContainer;

  /// background color as int.
  final int background;

  /// onBackground color as int.
  final int onBackground;

  /// surface color as int.
  final int surface;

  /// surfaceDim color as int.
  final int surfaceDim;

  /// surfaceBright color as int.
  final int surfaceBright;

  /// surfaceContainerLowest color as int.
  final int surfaceContainerLowest;

  /// surfaceContainerLow color as int.
  final int surfaceContainerLow;

  /// surfaceContainer color as int.
  final int surfaceContainer;

  /// surfaceContainerHigh color as int.
  final int surfaceContainerHigh;

  /// surfaceContainerHighest color as int.
  final int surfaceContainerHighest;

  /// onSurface color as int.
  final int onSurface;

  /// surfaceVariant color as int.
  final int surfaceVariant;

  /// onSurfaceVariant color as int.
  final int onSurfaceVariant;

  /// outline color as int.
  final int outline;

  /// outlineVariant color as int.
  final int outlineVariant;

  /// shadow color as int.
  final int shadow;

  /// scrim color as int.
  final int scrim;

  /// inverseSurface color as int.
  final int inverseSurface;

  /// inverseOnSurface color as int.
  final int inverseOnSurface;

  /// inversePrimary color as int.
  final int inversePrimary;

  /// Get light Scheme from CorePalette.
  static Scheme light(int color) => lightFromCorePalette(CorePalette.of(color));

  /// Get dark Scheme from CorePalette.
  static Scheme dark(int color) => darkFromCorePalette(CorePalette.of(color));

  /// Get Scheme for lightContent from CorePalette.
  static Scheme lightContent(int color) =>
      lightFromCorePalette(CorePalette.contentOf(color));

  /// Get Scheme for darkContent from CorePalette.
  static Scheme darkContent(int color) =>
      darkFromCorePalette(CorePalette.contentOf(color));

  /// Get Scheme from lightFromCorePalette.
  static Scheme lightFromCorePalette(CorePalette palette) => Scheme(
        primary: palette.primary.get(40),
        onPrimary: palette.primary.get(100),
        primaryContainer: palette.primary.get(90),
        onPrimaryContainer: palette.primary.get(10),
        primaryFixed: palette.primary.get(90),
        primaryFixedDim: palette.primary.get(80),
        onPrimaryFixed: palette.primary.get(10),
        onPrimaryFixedVariant: palette.primary.get(30),
        //
        secondary: palette.secondary.get(40),
        onSecondary: palette.secondary.get(100),
        secondaryContainer: palette.secondary.get(90),
        onSecondaryContainer: palette.secondary.get(10),
        secondaryFixed: palette.secondary.get(90),
        secondaryFixedDim: palette.secondary.get(80),
        onSecondaryFixed: palette.secondary.get(10),
        onSecondaryFixedVariant: palette.secondary.get(30),
        //
        tertiary: palette.tertiary.get(40),
        onTertiary: palette.tertiary.get(100),
        tertiaryContainer: palette.tertiary.get(90),
        onTertiaryContainer: palette.tertiary.get(10),
        tertiaryFixed: palette.tertiary.get(90),
        tertiaryFixedDim: palette.tertiary.get(80),
        onTertiaryFixed: palette.tertiary.get(10),
        onTertiaryFixedVariant: palette.tertiary.get(30),
        //
        error: palette.error.get(40),
        onError: palette.error.get(100),
        errorContainer: palette.error.get(90),
        onErrorContainer: palette.error.get(10),
        //
        background: palette.neutral.get(99),
        onBackground: palette.neutral.get(10),
        //
        // Since this is legacy compatible it continues to use tone 99 here
        surface: palette.neutral.get(99),
        surfaceDim: palette.neutral.get(87),
        surfaceBright: palette.neutral.get(98),
        surfaceContainerLowest: palette.neutral.get(100),
        surfaceContainerLow: palette.neutral.get(96),
        surfaceContainer: palette.neutral.get(94),
        surfaceContainerHigh: palette.neutral.get(92),
        surfaceContainerHighest: palette.neutral.get(90),
        //
        onSurface: palette.neutral.get(10),
        surfaceVariant: palette.neutralVariant.get(90),
        onSurfaceVariant: palette.neutralVariant.get(30),
        //
        outline: palette.neutralVariant.get(50),
        outlineVariant: palette.neutralVariant.get(80),
        shadow: palette.neutral.get(0),
        scrim: palette.neutral.get(0),
        inverseSurface: palette.neutral.get(20),
        inverseOnSurface: palette.neutral.get(95),
        inversePrimary: palette.primary.get(80),
      );

  /// Get Scheme from darkFromCorePalette.
  static Scheme darkFromCorePalette(CorePalette palette) => Scheme(
        primary: palette.primary.get(80),
        onPrimary: palette.primary.get(20),
        primaryContainer: palette.primary.get(30),
        onPrimaryContainer: palette.primary.get(90),
        primaryFixed: palette.primary.get(90),
        primaryFixedDim: palette.primary.get(80),
        onPrimaryFixed: palette.primary.get(10),
        onPrimaryFixedVariant: palette.primary.get(30),
        //
        secondary: palette.secondary.get(80),
        onSecondary: palette.secondary.get(20),
        secondaryContainer: palette.secondary.get(30),
        onSecondaryContainer: palette.secondary.get(90),
        secondaryFixed: palette.secondary.get(90),
        secondaryFixedDim: palette.secondary.get(80),
        onSecondaryFixed: palette.secondary.get(10),
        onSecondaryFixedVariant: palette.secondary.get(30),
        //
        tertiary: palette.tertiary.get(80),
        onTertiary: palette.tertiary.get(20),
        tertiaryContainer: palette.tertiary.get(30),
        onTertiaryContainer: palette.tertiary.get(90),
        tertiaryFixed: palette.tertiary.get(90),
        tertiaryFixedDim: palette.tertiary.get(80),
        onTertiaryFixed: palette.tertiary.get(10),
        onTertiaryFixedVariant: palette.tertiary.get(30),
        //
        error: palette.error.get(80),
        onError: palette.error.get(20),
        errorContainer: palette.error.get(30),
        // The tone in orig MCU is wrong, based on both past
        // and current it should be tone 90. MCU has always used the wrong
        // tone 80 here whereas FSS has used the one from the spec. We modified
        // this tone in the rescued Scheme to match the spec and use 90.
        onErrorContainer: palette.error.get(90),
        //
        background: palette.neutral.get(10),
        onBackground: palette.neutral.get(90),
        //
        // Since this is legacy compatible it continues to use tone 10 here
        surface: palette.neutral.get(10),
        surfaceDim: palette.neutral.get(6),
        surfaceBright: palette.neutral.get(24),
        surfaceContainerLowest: palette.neutral.get(4),
        surfaceContainerLow: palette.neutral.get(10),
        surfaceContainer: palette.neutral.get(12),
        surfaceContainerHigh: palette.neutral.get(17),
        surfaceContainerHighest: palette.neutral.get(22),
        //
        onSurface: palette.neutral.get(90),
        surfaceVariant: palette.neutralVariant.get(30),
        onSurfaceVariant: palette.neutralVariant.get(80),
        //
        outline: palette.neutralVariant.get(60),
        outlineVariant: palette.neutralVariant.get(30),
        shadow: palette.neutral.get(0),
        scrim: palette.neutral.get(0),
        inverseSurface: palette.neutral.get(90),
        inverseOnSurface: palette.neutral.get(20),
        inversePrimary: palette.primary.get(40),
      );
}
