package de.westnordost.streetcomplete.ui.theme

import androidx.compose.material.Typography
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign

private val material2 = Typography()

val Typography = Typography(
    h4 = material2.h4.copy(fontWeight = FontWeight.Bold),
    h5 = material2.h5.copy(fontWeight = FontWeight.Bold),
    h6 = material2.h6.copy(fontWeight = FontWeight.Bold),
    subtitle1 = material2.subtitle1.copy(fontWeight = FontWeight.Bold),
    subtitle2 = material2.subtitle2.copy(fontWeight = FontWeight.Bold)
)

/** For an input field that is the sole element on the screen */
val Typography.extraLargeInput get() = h3.copy(
    textAlign = TextAlign.Center
)

/** For an input field that is amongst a few input elements on the screen */
val Typography.largeInput get() = h5.copy(
    textAlign = TextAlign.Center
)

// for easier conversion to M3
val Typography.headlineLarge get() = h4
val Typography.headlineSmall get() = h5
val Typography.titleLarge get() = h6
val Typography.titleMedium get() = subtitle1
val Typography.titleSmall get() = subtitle2
