import { lazy } from "./Utils.js";
/**
 * Function which accepts another function. On first invocation
 * of this resulting function result will be remembered and returned
 * on consequent invocations.
 */
export declare function lazyMemoized<T>(source: () => T): lazy<T>;
/**
 * Returns a cached version of {@param fn}.
 * Cached function checks that argument is the same (with ===) and if it is then it returns the cached result.
 * If the cached argument has changed then {@param fn} will be called with new argument and result will be cached again.
 * Only remembers the last argument.
 */
export declare function memoized<F extends (...args: any[]) => any>(fn: F): F;
/**
 * Returns a cached version of {@param fn}.
 * Cached function checks that argument is deeply the same and if it is then it returns the cached result.
 * If the cached argument has changed then {@param fn} will be called with new argument and result will be cached again.
 * Only remembers the last argument.
 */
export declare function deepMemoized<F extends (...args: any[]) => any>(fn: F): F;
/**
 * Like {@link memoized} but the argument is passed in via {@param argumentProvider}.
 * Useful for the cases where we want to keep only one field around e.g. for lazy getters
 */
export declare function memoizedWithHiddenArgument<T, R>(argumentProvider: () => T, computationFunction: (arg: T) => R): () => R;
