// Important: Keep ASC order for application names
export const AppNameEnum = Object.freeze({
    Accounting: "accounting",
    Base: "base",
    Gossip: "gossip",
    Monitor: "monitor",
    Storage: "storage",
    Sys: "sys",
    Tutanota: "tutanota",
    Usage: "usage",
});
/**
 * T should be restricted to Entity.
 */
export class TypeRef {
    app;
    typeId;
    /**
     * Field that is never set. Used to make two TypeRefs incompatible (they are structurally compared otherwise).
     * Cannot be private.
     */
    phantom = null;
    constructor(app, typeId) {
        this.app = app;
        this.typeId = typeId;
        Object.freeze(this);
    }
    /**
     * breaks when the object passes worker barrier
     */
    toString() {
        return `[TypeRef ${this.app} ${this.typeId}]`;
    }
}
export function getTypeString(typeRef) {
    return typeRef.app + "/" + typeRef.typeId;
}
export function parseTypeString(s) {
    const parts = s.split("/");
    const [app, versionString] = parts;
    if (app == null || versionString == null) {
        throw new TypeError(`invalid type string: ${s}`);
    }
    return new TypeRef(app, parseInt(parts[1], 10));
}
export function isSameTypeRefByAttr(typeRef, app, typeId) {
    return typeRef.app === app && typeRef.typeId === typeId;
}
export function isSameTypeRef(typeRef1, typeRef2) {
    return isSameTypeRefByAttr(typeRef1, typeRef2.app, typeRef2.typeId);
}
export function isSameTypeRefNullable(typeRef1, typeRef2) {
    return (typeRef1 == null && typeRef2 == null) || (typeRef1 != null && typeRef2 !== null && isSameTypeRef(typeRef1, typeRef2));
}
