export type AppName = Values<typeof AppNameEnum>;
export declare const AppNameEnum: Readonly<{
    Accounting: "accounting";
    Base: "base";
    Gossip: "gossip";
    Monitor: "monitor";
    Storage: "storage";
    Sys: "sys";
    Tutanota: "tutanota";
    Usage: "usage";
}>;
/**
 * T should be restricted to Entity.
 */
export declare class TypeRef<T> {
    readonly app: AppName;
    readonly typeId: number;
    /**
     * Field that is never set. Used to make two TypeRefs incompatible (they are structurally compared otherwise).
     * Cannot be private.
     */
    readonly phantom: T | null;
    constructor(app: AppName, typeId: number);
    /**
     * breaks when the object passes worker barrier
     */
    toString(): string;
}
export declare function getTypeString(typeRef: TypeRef<unknown>): string;
export declare function parseTypeString(s: string): TypeRef<unknown>;
export declare function isSameTypeRefByAttr(typeRef: TypeRef<unknown>, app: string, typeId: number): boolean;
export declare function isSameTypeRef(typeRef1: TypeRef<unknown>, typeRef2: TypeRef<unknown>): boolean;
export declare function isSameTypeRefNullable(typeRef1: TypeRef<unknown> | null, typeRef2: TypeRef<unknown> | null): boolean;
