import type { lazy } from "./Utils.js";
/**
 * Returns a string which contains the given number padded with 0s.
 * @param num The number to pad.
 * @param size The number of resulting digits.
 * @return The padded number as string.
 */
export declare function pad(num: number, size: number): string;
/**
 * Checks if a string starts with another string.
 * @param string The string to test.
 * @param substring If the other string begins with this one, we return true.
 * @return True if string begins with substring, false otherwise.
 */
export declare function startsWith(string: string, substring: string): boolean;
/**
 * uppercase the first letter of a string, lowercase the rest
 * @param str string to transform
 * @returns {string} str in lowercase with first letter Capitalized
 */
export declare function capitalizeFirstLetter(str: string): string;
/**
 * Checks if a string ends with another string.
 * @param string The string to test.
 * @param substring If the other string ends with this one, we return true.
 * @return True if string ends with substring, false otherwise.
 */
export declare function endsWith(string: string, substring: string): boolean;
export declare function lazyStringValue(valueOrLazy: string | lazy<string>): string;
export declare function repeat(value: string, length: number): string;
export declare function cleanMatch(s1: string, s2: string): boolean;
/**
 * Non-breaking space character
 */
export declare const NBSP = "\u00A0";
/**
 * split a string at a given index
 * @param str
 * @param index
 */
export declare function splitAt(str: string, index: number): [string, string];
/**
 * Wrapper around String.prototype.toLowerCase, nice for calls to Array.prototype.map
 * @param str
 */
export declare function toLowerCase(str: string): string;
/**
 * Wrapper around String.prototype.localeCompare, for passing to Array.prototype.sort
 * @param a
 * @param b
 * @returns {number}
 */
export declare function localeCompare(a: string, b: string): number;
export declare function byteLength(str: string | null | undefined): number;
