export type CompareFn<T> = (arg0: T, arg1: T) => number;
/**
 * An array that keeps itself sorted
 */
export declare class SortedArray<T> {
    private contents;
    private compareFn;
    private constructor();
    static fromNumbers(array: ReadonlyArray<number>): SortedArray<number>;
    static empty<U>(compareFn: CompareFn<U>): SortedArray<U>;
    static from<U>(array: ReadonlyArray<U>, compareFn: CompareFn<U>): SortedArray<U>;
    get length(): number;
    get array(): ReadonlyArray<T>;
    get(index: number): T;
    insertAll(array: ReadonlyArray<T>): void;
    insert(item: T): void;
    removeFirst(finder: (arg0: T) => boolean): boolean;
}
