import type { Options as PromiseMapOptions } from "./PromiseMap.js";
export type $Promisable<T> = Promise<T> | T;
type PromiseMapCallback<T, U> = (el: T, index: number) => $Promisable<U>;
/**
 * Map array of values to promise of arrays or array. Mapper function may return promise or value. If value is returned,
 * we avoid promise scheduling.
 *
 * This is needed to run the whole operation in one microtask (e.g. keep IndexedDB transaction active, which is closed in
 * some browsers (e.g. Safari) when event loop iteration ends).
 */
export declare function mapInCallContext<T, U>(values: T[], callback: PromiseMapCallback<T, U>): PromisableWrapper<Array<U>>;
export { pMap as promiseMap } from "./PromiseMap.js";
export type PromiseMapFn = <T, U>(values: T[], callback: PromiseMapCallback<T, U>, options?: PromiseMapOptions) => PromisableWrapper<U[]>;
/** Factory function which gives you ack promiseMap implementation. {@see mapInCallContext} for what it means. */
export declare function promiseMapCompat(useMapInCallContext: boolean): PromiseMapFn;
export declare class PromisableWrapper<T> {
    static from<U>(value: $Promisable<U>): PromisableWrapper<U>;
    value: $Promisable<T>;
    constructor(value: $Promisable<PromisableWrapper<T> | T>);
    thenOrApply<R>(onFulfill: (arg0: T) => $Promisable<PromisableWrapper<R> | R>, onReject?: (arg0: any) => $Promisable<R | PromisableWrapper<R>>): PromisableWrapper<R>;
    toPromise(): Promise<T>;
}
export declare function delay(ms: number): Promise<void>;
/**
 * Pass to Promise.then to perform an action while forwarding on the result
 * @param action
 */
export declare function tap<T>(action: (arg0: T) => unknown): (arg0: T) => T;
/**
 * Helper utility intended to be used with typed exceptions and .catch() method of promise like so:
 *
 * ```js
 *  class SpecificError extends Error {}
 *
 *  Promise.reject(new SpecificError())
 *      .catch(ofClass(SpecificError, (e) => console.log("some error", e)))
 *      .catch((e) => console.log("generic error", e))
 * ```
 *
 * @param cls Class which will be caught
 * @param catcher to handle only errors of type cls
 * @returns handler which either forwards to catcher or rethrows
 */
export declare function ofClass<E, R>(cls: Class<E>, catcher: (arg0: E) => $Promisable<R>): (arg0: any) => Promise<R>;
/**
 * Filter iterable. Just like Array.prototype.filter but callback can return promises
 */
export declare function promiseFilter<T>(iterable: Iterable<T>, filter: (item: T, index: number) => $Promisable<boolean>): Promise<Array<T>>;
/** Call the handler for both resolution and rejection. Unlike finally() will not propagate the error. */
export declare function settledThen<T, R>(promise: Promise<T>, handler: () => R): Promise<R>;
