/**
 * Merges multiple maps into a single map with lists of values.
 * @param maps
 */
export declare function mergeMaps<T>(maps: Map<string, T>[]): Map<string, T[]>;
/**
 * Gets an item from the map and returns it.
 *
 * In the case that the key-value pair was not present OR !!value === false (such as null or undefined), then
 * {@link byDefault} will be called, and its return value will be inserted into the map and returned.
 */
export declare function getFromMap<K, V>(map: Map<K, V>, key: K, byDefault: () => V): V;
/**
 * Removes an item from the map and returns it.
 *
 * In the case that the key-value pair was present but its value was undefined, you can read wasPresent to
 * check that it was present (and therefore deleted).
 */
export declare function takeFromMap<K, V>(map: Map<K, V>, key: K): {
    item: V | undefined;
    wasPresent: boolean;
};
/** Creates a new map with key and value added to {@param map}. It is like set() but for immutable map. */
export declare function addMapEntry<K, V>(map: ReadonlyMap<K, V>, key: K, value: V): Map<K, V>;
export declare function deleteMapEntry<K, V>(map: ReadonlyMap<K, V>, key: K): Map<K, V>;
/**
 * Convert values of {@param map} using {@param mapper} like {@link Array.prototype.map},
 */
export declare function mapMap<K, V, R>(map: ReadonlyMap<K, V>, mapper: (value: V) => R): Map<K, R>;
