export type Base64 = string;
export type Base64Ext = string;
export type Base64Url = string;
export type Hex = string;
export declare function uint8ArrayToArrayBuffer(uint8Array: Uint8Array): ArrayBuffer;
/**
 * Converts a hex coded string into a base64 coded string.
 *
 * @param hex A hex encoded string.
 * @return A base64 encoded string.
 */
export declare function hexToBase64(hex: Hex): Base64;
/**
 * Converts a base64 coded string into a hex coded string.
 *
 * @param base64 A base64 encoded string.
 * @return A hex encoded string.
 */
export declare function base64ToHex(base64: Base64): Hex;
/**
 * Converts a base64 string to a url-conform base64 string. This is used for
 * base64 coded url parameters.
 *
 * @param base64 The base64 string.
 * @return The base64url string.
 */
export declare function base64ToBase64Url(base64: Base64): Base64Url;
/**
 * Converts a base64 string to a base64ext string. Base64ext uses another character set than base64 in order to make it sortable.
 *
 *
 * @param base64 The base64 string.
 * @return The base64Ext string.
 */
export declare function base64ToBase64Ext(base64: Base64): Base64Ext;
/**
 * Converts a Base64Ext string to a Base64 string and appends the padding if needed.
 * @param base64ext The base64Ext string
 * @returns The base64 string
 */
export declare function base64ExtToBase64(base64ext: Base64Ext): Base64;
/**
 * Converts a base64 url string to a "normal" base64 string. This is used for
 * base64 coded url parameters.
 *
 * @param base64url The base64 url string.
 * @return The base64 string.
 */
export declare function base64UrlToBase64(base64url: Base64Url): Base64;
export declare function _stringToUtf8Uint8ArrayLegacy(string: string): Uint8Array;
export declare function _replaceLoneSurrogates(s: string | null | undefined): string;
/**
 * Converts a string to a Uint8Array containing a UTF-8 string data.
 *
 * @param string The string to convert.
 * @return The array.
 */
export declare function stringToUtf8Uint8Array(string: string): Uint8Array;
export declare function _utf8Uint8ArrayToStringLegacy(uint8Array: Uint8Array): string;
/**
 * Converts an Uint8Array containing UTF-8 string data into a string.
 *
 * @param uint8Array The Uint8Array.
 * @return The string.
 */
export declare function utf8Uint8ArrayToString(uint8Array: Uint8Array): string;
export declare function hexToUint8Array(hex: Hex): Uint8Array;
export declare function uint8ArrayToHex(uint8Array: Uint8Array): Hex;
/**
 * Converts an Uint8Array to a Base64 encoded string.
 *
 * @param bytes The bytes to convert.
 * @return The Base64 encoded string.
 */
export declare function uint8ArrayToBase64(bytes: Uint8Array): Base64;
export declare function int8ArrayToBase64(bytes: Int8Array): Base64;
/**
 * Converts a base64 encoded string to a Uint8Array.
 *
 * @param base64 The Base64 encoded string.
 * @return The bytes.
 */
export declare function base64ToUint8Array(base64: Base64): Uint8Array;
/**
 * Converts a Uint8Array containing string data into a string, given the charset the data is in.
 * @param charset The charset. Must be supported by TextDecoder.
 * @param bytes The string data
 * @trhows RangeError if the charset is not supported
 * @return The string
 */
export declare function uint8ArrayToString(charset: string, bytes: Uint8Array): string;
/**
 * Decodes a quoted-printable piece of text in a given charset.
 * This was copied and modified from https://github.com/mathiasbynens/quoted-printable/blob/master/src/quoted-printable.js (MIT licensed)
 *
 * @param charset Must be supported by TextEncoder
 * @param input The encoded text
 * @throws RangeError if the charset is not supported
 * @returns The text as a JavaScript string
 */
export declare function decodeQuotedPrintable(charset: string, input: string): string;
export declare function decodeBase64(charset: string, input: string): string;
export declare function stringToBase64(str: string): string;
/**
 * Encodes a variable number of byte arrays as a single byte array. Format:
 * short(length of byteArray[0]) | byteArray[0] | ... | short(length of byteArray[n]) | byteArray[n]
 *
 * @return encoded byte array
 */
export declare function byteArraysToBytes(byteArrays: Array<Uint8Array>): Uint8Array;
/**
 * Decodes a byte array encoded by #byteArraysToBytes.
 *
 * @return list of byte arrays
 */
export declare function bytesToByteArrays(encodedByteArrays: Uint8Array, expectedByteArrays: number): Array<Uint8Array>;
