/**
 * @file DateUtils which do not use Luxon. Used in worker as well as in client parts.
 * As functions here do not use Luxon it cannot be used for calculating things in different time zones, they
 * are dependent on the system time zone.
 */
/**
 * The minimum length of a calendar year.
 *
 * This should not be used for calculating duration since leap years (which are 97/400 of all years) have 366 days.
 */
export declare const YEAR_IN_MILLIS: number;
/**
 * dates from before 1970 have negative timestamps and are currently considered edge cases
 */
export declare const TIMESTAMP_ZERO_YEAR = 0;
/**
 * Provides a date representing the beginning of the next day of the given date in local time.
 */
export declare function getStartOfNextDay(date: Date): Date;
/**
 * Provides a date representing the end of the given date in local time.
 */
export declare function getEndOfDay(date: Date): Date;
/**
 * Provides a date representing the beginning of the given date in local time.
 */
export declare function getStartOfDay(date: Date): Date;
/**
 * Provides a date representing the day of the given date at the given hour in local time.
 */
export declare function getHourOfDay(date: Date, hour: number): Date;
export declare function isStartOfDay(date: Date): boolean;
/**
 * Returns true if the given date is today in local time.
 */
export declare function isToday(date: Date): boolean;
/**
 * Returns true if the given dates represent the same day (time of day is ignored).
 */
export declare function isSameDay(date1: Date, date2: Date): boolean;
/**
 * Creates new date in with {@param days} added to it as if the days are just fixed
 * periods of time and are not subject to daylight saving.
 */
export declare function getDayShifted(date: Date, days: number): Date;
/**
 * Increment the date in place and return it
 */
export declare function incrementDate(date: Date, byValue: number): Date;
export declare function incrementMonth(d: Date, byValue: number): Date;
export declare function isSameDayOfDate(date1: Date | null | undefined, date2: Date | null | undefined): boolean;
/**
 * Formats as yyyy-mm-dd
 */
export declare function formatSortableDate(date: Date): string;
/**
 * Formats as yyyy-mm-dd-<hh>h-<mm>m-<ss>
 */
export declare function formatSortableDateTime(date: Date): string;
/**
 * @returns {string} sortableDateTime of the current time
 */
export declare function sortableTimestamp(): string;
export declare function isValidDate(date: Date): boolean;
/**
 * not interested in any fancy calendar edge cases, only use this where approximation is ok
 */
export declare function millisToDays(millis: number): number;
