// fields containing newlines, double quotes or the separator need to be escaped
// by wrapping the whole field in double quotes, and then duplicating any double quotes in the field
const escapeColumn = (column, separator) => {
    if (!column.includes(separator) && !column.includes("\n") && !column.includes('"')) {
        return column;
    }
    return `"${column.replaceAll('"', '""')}"`;
};
export function renderCsv(header, rows, separator = ";") {
    return renderCsvHeader(header, separator).concat("\n", renderCsvBody(rows, separator));
}
export function renderCsvHeader(header, separator = ";") {
    return header.map((col) => escapeColumn(col, separator)).join(separator);
}
export function renderCsvBody(rows, separator = ";") {
    return rows.map((row) => row.map((col) => escapeColumn(col, separator)).join(separator)).join("\n");
}
