/**
 * Everything that is in both array1 and array2
 * This is a naive implementation, don't use it on large inputs
 */
export declare function intersection<T>(set1: Set<T>, set2: Set<T>): Set<T>;
export declare function setEquals<T>(set1: ReadonlySet<T>, set2: ReadonlySet<T>): boolean;
export declare function setMap<T, R>(set: ReadonlySet<T>, mapper: (item: T) => R): Set<R>;
export declare function min<T extends Iterable<number>>(set: T): number | null;
export declare function minBy<E, T extends Iterable<E>>(collection: T, selector: (item: E) => number): E | null;
export declare function max<T extends Iterable<number>>(set: T): number | null;
export declare function maxBy<E, T extends Iterable<E>>(collection: T, selector: (item: E) => number): E | null;
export declare function setAddAll<T>(set: Set<T>, toAdd: Iterable<T>): void;
/**
 * Returns an element of the {@param collection} if it satisfies {@param selector} or {@code null} otherwise.
 */
export declare function findBy<T>(collection: Iterable<T>, selector: (item: T) => boolean): T | null;
export declare function mapWith<K, V>(map: ReadonlyMap<K, V>, key: K, value: V): Map<K, V>;
export declare function mapWithout<K, V>(map: ReadonlyMap<K, V>, key: K): Map<K, V>;
/**
 * diff two maps by keys
 * @param before the map that's considered the old contents
 * @param after the map that's representing the current contents.
 * @returns arrays containing the kept, added, and deleted values.
 */
export declare function trisectingDiff<T>(before: ReadonlyMap<unknown, T>, after: ReadonlyMap<unknown, T>): {
    kept: Array<T>;
    added: Array<T>;
    deleted: Array<T>;
};
/**
 * return a new set containing every item from {@param set1} that isn't in {@param set2}
 */
export declare function setDifference<T>(set1: ReadonlySet<T>, set2: ReadonlySet<T>): Set<T>;
