type StatePending<T> = {
    status: "pending";
    promise: Promise<T>;
};
type StateComplete<T> = {
    status: "complete";
    result: T;
};
type StateFailure = {
    status: "failure";
    error: any;
};
type AsyncResultState<T> = StatePending<T> | StateComplete<T> | StateFailure;
/**
 * Represents a resource that is either not ready, ready, or error
 * Sort of fills a similar role to LazyLoaded, usage is more verbose but also more typesafe. maybe this should be reconciled.
 */
export declare class AsyncResult<T> {
    _state: AsyncResultState<T>;
    constructor(promise: Promise<T>);
    state(): Readonly<AsyncResultState<T>>;
}
export {};
