export declare function concat(...arrays: Uint8Array[]): Uint8Array;
/**
 * Create an array filled with the numbers min..max (inclusive)
 */
export declare function numberRange(min: number, max: number): Array<number>;
/**
 * Create a generator for integer range in [min; max).
 */
export declare function lazyNumberRange(min: number, max: number): Generator<number>;
/**
 * Compares two arrays for equality based on ===.
 * @param {Array} a1 The first array.
 * @param {Array} a2 The second array.
 * @return {boolean} True if the arrays are equal, false otherwise.
 *
 * It is valid to compare Uint8Array to Array<T>, don't restrict it to be one type
 */
export declare function arrayEquals<T, A extends Uint8Array | Array<T>>(a1: A, a2: A): boolean;
/**
 * Compares two arrays for equality based on a predicate
 * @param a1
 * @param a2
 * @param predicate
 * @returns {boolean}
 */
export declare function arrayEqualsWithPredicate<T>(a1: ReadonlyArray<T>, a2: ReadonlyArray<T>, predicate: (arg0: T, arg1: T) => boolean): boolean;
export declare function arrayHashSigned(array: Uint8Array): number;
export declare function arrayHashUnsigned(array: Uint8Array): number;
/**
 * Remove the element from theArray if it is contained in the array.
 * @param theArray The array to remove the element from.
 * @param elementToRemove The element to remove from the array.
 * @return True if the element was removed, false otherwise.
 */
export declare function remove<T>(theArray: Array<T>, elementToRemove: T): boolean;
/**
 * truncates the array and discards all elements
 */
export declare function clear(theArray: Array<unknown>): void;
/**
 * Find all items in an array that pass the given predicate
 */
export declare function findAll<T>(theArray: Array<T>, finder: (arg0: T) => boolean): Array<T>;
/**
 * @param theArray
 * @param finder
 * @return {boolean} if the element was found
 */
export declare function findAndRemove<T>(theArray: Array<T>, finder: (arg0: T) => boolean): boolean;
/** find all matches inside an array and remove them. returns true if any instances were removed. */
export declare function findAllAndRemove<T>(theArray: Array<T>, finder: (arg0: T) => boolean, startIndex?: number): boolean;
export declare function replace(theArray: Array<any>, oldElement: any, newElement: any): boolean;
/**
 * Same as filterMap in some languages. Apply mapper and then only include non-nullable items.
 */
export declare function mapAndFilterNull<T, R>(array: ReadonlyArray<T>, mapper: (arg0: T) => R | null | undefined): Array<R>;
export declare function filterNull<T>(array: ReadonlyArray<T | null | undefined>): Array<T>;
/**
 * Provides the last element of the given array.
 * @param theArray The array.
 * @return The last element of the array.
 */
export declare function last<T>(theArray: ReadonlyArray<T>): T | null | undefined;
export declare function isEmpty<T>(array: ReadonlyArray<T>): boolean;
export declare function isNotEmpty(array: ReadonlyArray<unknown>): boolean;
export declare function lastThrow<T>(array: ReadonlyArray<T>): T;
/**
 * get first item or throw if there is none
 */
export declare function getFirstOrThrow<T>(array: ReadonlyArray<T>): T;
export declare function first<T>(array: ReadonlyArray<T>): T | null;
export declare function findLast<T>(array: ReadonlyArray<T>, predicate: (arg0: T) => boolean): T | null | undefined;
export declare function findLastIndex<T>(array: ReadonlyArray<T>, predicate: (arg0: T) => boolean): number;
export declare function contains(theArray: ReadonlyArray<any>, elementToCheck: any): boolean;
/**
 * count how many of the items in {@param theArray} return true when passed to the predicate {@param pred}
 */
export declare function count<T>(theArray: ReadonlyArray<T>, pred: (e: T) => boolean): number;
export declare function addAll(array: Array<any>, elements: Array<any>): void;
export declare function removeAll(array: Array<any>, elements: Array<any>): void;
/**
 * Group an array based on the given discriminator, but each group will have only unique items
 */
export declare function groupByAndMapUniquely<T, R, E>(iterable: Iterable<T>, discriminator: (arg0: T) => R, mapper: (arg0: T) => E): Map<R, Set<E>>;
/**
 * convert an Array of T's into a Map of Arrays of E's by
 * * grouping them based on a discriminator
 * * mapping them from T to E
 * @param iterable the array to split into groups
 * @param discriminator a function that produces the keys to group the elements by
 * @param mapper a function that maps the array elements before they get added to the group
 * @returns {Map<R, Array<E>>}
 */
export declare function groupByAndMap<T, R, E>(iterable: Iterable<T>, discriminator: (arg0: T) => R, mapper: (arg0: T) => E): Map<R, Array<E>>;
/**
 * Group array elements based on keys produced by a discriminator
 * @param iterable the array to split into groups
 * @param discriminator a function that produces the keys to group the elements by
 * @returns {NodeJS.Global.Map<R, Array<T>>}
 */
export declare function groupBy<T, R>(iterable: Iterable<T>, discriminator: (arg0: T) => R): Map<R, Array<T>>;
/**
 * Collect an iterable into a map based on {@param keyExtractor}.
 */
export declare function collectToMap<T, R>(iterable: Iterable<T>, keyExtractor: (element: T) => R): Map<R, T>;
/**
 * split an array into chunks of a given size.
 * the last chunk will be smaller if there are less than chunkSize elements left.
 * @param chunkSize
 * @param array
 * @returns {Array<Array<T>>}
 */
export declare function splitInChunks<T>(chunkSize: number, array: ReadonlyArray<T>): Array<Array<T>>;
export declare function splitUint8ArrayInChunks(chunkSize: number, array: Uint8Array): Array<Uint8Array>;
/**
 * Maps an array into a nested array and then flattens it
 * @param array
 * @param mapper
 * @returns {T|*[]}
 */
export declare function flatMap<T, U>(array: ReadonlyArray<T>, mapper: (arg0: T) => Array<U>): Array<U>;
/**
 * Inserts element into the sorted array. Will find <b>the last</b> matching position.
 * Might add or replace element based on {@param replaceIf} identity check.
 * Equality per {@param comparator} is precondition for replacement.
 * @param element to place
 * @param array where element should be placed
 * @param comparator for sorting
 * @param replaceIf identity comparison for replacement
 */
export declare function insertIntoSortedArray<T>(element: T, array: Array<T>, comparator: (left: T, right: T) => number, replaceIf?: (newElement: T, existing: T) => boolean): void;
export declare function zip<A, B>(arr1: Array<A>, arr2: Array<B>): Array<[A, B]>;
export declare function deduplicate<T>(arr: Array<T>, comp?: (arg0: T, arg1: T) => boolean): Array<T>;
/**
 * http://jsfiddle.net/aryzhov/pkfst550/
 * Binary search in JavaScript.
 * Returns the index of the element in a sorted array or (-n-1) where n is the insertion point for the new element.
 * Parameters:
 *     array - A sorted array
 *     element - An element to search for
 *     compareFn - A comparator function. The function takes two arguments: (a, b) and returns:
 *        a negative number  if a is less than b;
 *        0 if a is equal to b;
 *        a positive number of a is greater than b.
 * The array may contain duplicate elements. If there are more than one equal elements in the array,
 * the returned value can be the index of any one of the equal elements.
 */
export declare function binarySearch<T>(array: ReadonlyArray<T>, element: T, compareFn: (left: T, right: T) => number): number;
export declare function lastIndex<T>(array: ReadonlyArray<T>): number;
/**
 * All of the elements in all of the arguments combined, and deduplicated
 */
export declare function union<T>(...iterables: Array<Iterable<T>>): Set<T>;
/**
 * return a new array containing every item from array1 that isn't in array2
 * @template T
 * @param array1
 * @param array2
 * @param compare {(l: T, r: T) => boolean} compare items in the array for equality
 * @returns {Array<T>}
 */
export declare function difference<T>(array1: ReadonlyArray<T>, array2: ReadonlyArray<T>, compare?: (l: T, r: T) => boolean): Array<T>;
/**
 * Returns a set with elements that are *not* in both sets.
 *
 * {a, b, c} △ {b, c, d} == {a, d}
 */
export declare function symmetricDifference<T>(set1: ReadonlySet<T>, set2: ReadonlySet<T>): Set<T>;
/**
 * Splits an array into two based on a predicate, where elements that match the predicate go into the left side.
 *
 * This exists in two overloads:
 *  - one that requires a type guard. Specifically, if an item is A | B and type guard is "item is A" it returns [Array<A>, Array<B>]
 *  - one that takes a plain predicate and returns two arrays of the same type, without type narrowing
 *
 * Please note that tsc cannot infer that a function is a type predicate/type guard. Declaring function as a type predicate is also unsafe.
 * see: https://github.com/microsoft/TypeScript/issues/16069
 *
 * @return a tuple of partitioned elements. The first array has all the matching elements and the second one has the rest.
 */
export declare function partition<Generic, Specific extends Generic>(array: ReadonlyArray<Generic>, predicate: (item: Generic) => item is Specific): [Array<Specific>, Array<Exclude<Generic, Specific>>];
export declare function partition<TL>(array: ReadonlyArray<TL>, predicate: (item: TL) => boolean): [Array<TL>, Array<TL>];
/**
 * Like {@link partition}, but async and only for TL = TR.
 * Rejects if any of the predicates reject.
 */
export declare function partitionAsync<T>(array: Array<T>, predicate: (item: T) => Promise<boolean>): Promise<[Array<T>, Array<T>]>;
/**
 * Create an array with n elements by calling the provided factory
 */
export declare function arrayOf<T>(n: number, factory: (idx: number) => T): Array<T>;
/**
 * Destroy contents of the byte arrays passed. Useful for purging unwanted memory.
 */
export declare function zeroOut(...arrays: (Uint8Array | Int8Array)[]): void;
/**
 * @return 1 if first is bigger than second, -1 if second is bigger than first and 0 otherwise
 */
export declare function compare(first: Uint8Array, second: Uint8Array): number;
/**
 * Split the array at the given index, returning the left and right side.
 *
 * The element at the given index will be included in the right side if it exists. For example, splitting at index 3 for
 * `[0,1,2,3,4,5]` returns `[[0,1,2], [3,4,5]]`
 *
 * If `index >= array.length` then the right side will be an empty array, and the left side will be a shallow copy of
 * {@link array}.
 *
 * @param {Array} array array to split
 * @param {number} index index to split at (exclusive for left side, inclusive for right side)
 * @returns An array containing two arrays: all elements from 0 to {@link index} (exclusive), and all elements from
 *          {@link index} to the end.
 */
export declare function splitArrayAt<T>(array: readonly T[], index: number): [T[], T[]];
