import { UsageTest } from "./UsageTest.js";
import { PingAdapter } from "../storage/PingAdapter.js";
/** Centralized place which holds all the {@link UsageTest}s. */
export declare class UsageTestController {
    private readonly pingAdapter;
    private readonly tests;
    private readonly obsoleteUsageTest;
    constructor(pingAdapter: PingAdapter);
    addTest(test: UsageTest): void;
    addTests(tests: UsageTest[]): void;
    setTests(tests: UsageTest[]): void;
    /**
     * Searches a test first by its ID and then, if no match is found, by its name.
     * If no test matches by name either, then we assume that the test is finished and the server no longer sends assignments for it.
     * In that case, we want to render the no-participation variant, so a sham test instance needs to be returned.
     *
     * @param testIdOrName The test's ID or its name
     */
    getTest(testIdOrName: string): UsageTest;
    /**
     * some components are used in multiple places, but only want to do a test in one of them.
     * use this to get a test that always renders variant 0 and doesn't send pings.
     */
    getObsoleteTest(): UsageTest;
}
