import { PingIdTuple, Stage } from "./Stage.js";
import { PingAdapter } from "../storage/PingAdapter.js";
export type VariantsIndex<ReturnT> = {
    [key: number]: () => ReturnT;
};
/** Holds all variants and can render current variant. Combines a test's config and the user's assignment. */
export declare class UsageTest {
    readonly testId: string;
    readonly testName: string;
    variant: number;
    active: boolean;
    private readonly stages;
    pingAdapter?: PingAdapter;
    lastCompletedStage: number;
    meta: Record<string, any>;
    private _invalidate;
    /**
     * Enabling this makes it possible to restart a test even if the last stage has not been sent.
     */
    allowEarlyRestarts: boolean;
    private sentPings;
    private started;
    recordTime: boolean;
    private lastPingDate?;
    constructor(testId: string, testName: string, variant: number, active: boolean);
    /**
    Tries to restart the test (by sending stage 0) regardless of the allowEarlyRestarts setting
     */
    forceRestart(): Promise<PingIdTuple | undefined>;
    isStarted(): boolean;
    getStage(stageNum: number): Stage;
    addStage(stage: Stage): Stage;
    getVariant<T>(variants: VariantsIndex<T>): T;
    invalidateTest(): void;
    /**
     * Should not be used directly. Use stage.complete() instead.
     */
    completeStage(stage: Stage, { forceRestart, finalizeStage }?: {
        forceRestart: boolean;
        finalizeStage: boolean;
    }): Promise<PingIdTuple | undefined>;
    deletePing(pingIdTuple: PingIdTuple): Promise<void>;
}
export declare class ObsoleteUsageTest extends UsageTest {
    private readonly obsoleteStage;
    constructor(testId: string, testName: string, variant: number);
    getStage(stageNum: number): Stage;
    addStage(stage: Stage): Stage;
    getVariant<T>(variants: VariantsIndex<T>): T;
    completeStage(stage: Stage): Promise<PingIdTuple | undefined>;
}
