/** One part of the test. Has multiple metrics that are sent together. */
export class Stage {
    number;
    test;
    minPings;
    maxPings;
    collectedMetrics = new Map();
    metricConfigs = new Map();
    // store ping list id and ping id to make it undo-able
    pingList = [];
    constructor(number, test, minPings, maxPings) {
        this.number = number;
        this.test = test;
        this.minPings = minPings;
        this.maxPings = maxPings;
    }
    /**
     * Attempts to complete the stage and enables to undo the sent ping later, if necessary
     */
    async complete(finalizeStage = false) {
        const pingIdTuple = await this.test.completeStage(this, { forceRestart: false, finalizeStage });
        if (pingIdTuple)
            this.pingList.push(pingIdTuple);
    }
    async deletePing() {
        if (this.pingList.length === 0)
            return;
        const pingIdTuple = this.pingList.pop();
        return this.test.deletePing(pingIdTuple);
    }
    setMetric(metric) {
        this.collectedMetrics.set(metric.name, metric);
    }
    setMetricConfig(metricConfig) {
        this.metricConfigs.set(metricConfig.name, metricConfig);
    }
}
export class ObsoleteStage extends Stage {
    async complete() {
        return;
    }
    setMetric(metric) {
        // no op
    }
}
