import { UsageTest } from "./UsageTest.js";
type MetricName = string;
type Metric = {
    name: MetricName;
    value: string;
};
type MetricConfig = {
    name: MetricName;
    type: string;
    configValues: Map<string, string>;
};
export type PingIdTuple = {
    pingListId: string;
    pingId: string;
};
/** One part of the test. Has multiple metrics that are sent together. */
export declare class Stage {
    readonly number: number;
    private readonly test;
    readonly minPings: number;
    readonly maxPings: number;
    readonly collectedMetrics: Map<string, Metric>;
    readonly metricConfigs: Map<string, MetricConfig>;
    private pingList;
    constructor(number: number, test: UsageTest, minPings: number, maxPings: number);
    /**
     * Attempts to complete the stage and enables to undo the sent ping later, if necessary
     */
    complete(finalizeStage?: boolean): Promise<void>;
    deletePing(): Promise<void>;
    setMetric(metric: Metric): void;
    setMetricConfig(metricConfig: MetricConfig): void;
}
export declare class ObsoleteStage extends Stage {
    complete(): Promise<void>;
    setMetric(metric: Metric): void;
}
export {};
