import * as td from "testdouble";
/**
 * Mocks an attribute (function or object) on an object and makes sure that it can be restored to the original attribute by calling unmockAttribute() later.
 * Additionally creates a spy for the attribute if the attribute is a function.
 * @param object The object on which the attribute exists.
 * @param attributeOnObject The attribute to mock.
 * @param attributeMock The attribute mock.
 * @returns An object to be passed to unmockAttribute() in order to restore the original attribute.
 */
export declare function mockAttribute(object: Record<string, any>, attributeOnObject: ((...args: Array<any>) => any) | Record<string, any>, attributeMock: ((...args: Array<any>) => any) | Record<string, any>): Record<string, any>;
export declare function unmockAttribute(mock: Record<string, any>): void;
export type Spy = ((...args: any) => any) & {
    invocations: any[];
};
export declare function spy(producer?: (...args: any) => any): Spy;
/**
 * Create partial mock, i.e. allows mocking attributes or functions on actual instances
 * @param obj The base mock object on which mocker may overwrite attributes or functions
 * @param mocker This function receives obj and can overwrite attributes or functions.
 * @returns {T}
 */
export declare const mock: <T>(obj: T, mocker: (arg0: any) => any) => T;
export declare function mapToObject<K extends string | number | symbol, V>(map: Map<K, V>): Record<K, V>;
export declare function replaceAllMaps(toReplace: any): any;
export declare function assertThrows<T extends Error>(expected: Class<T>, fn: () => Promise<unknown>): Promise<T>;
export interface TimeoutMock {
    (fn: () => unknown, time: number): ReturnType<typeof setTimeout>;
    next(): void;
}
export declare function makeTimeoutMock(): TimeoutMock;
/** Verify using testdouble, but register as an otest assertion */
export declare function verify(demonstration: any, config?: td.VerificationConfig): void;
export declare function throwsErrorWithMessage(errorClass: any, message: any): (fn: any) => {
    pass: boolean;
    message: string;
};
