#!/usr/bin/env node
import { minimist } from './index.js';
export declare function printUsage(): void;
export declare const argv: minimist.ParsedArgs;
export declare function main(): Promise<void>;
export declare function runScript(script: string): Promise<void>;
export declare function scriptFromStdin(): Promise<boolean>;
export declare function scriptFromHttp(remote: string): Promise<void>;
export declare function writeAndImport(script: string | Buffer, filepath: string, origin?: string): Promise<void>;
export declare function importPath(filepath: string, origin?: string): Promise<void>;
export declare function injectGlobalRequire(origin: string): void;
export declare function transformMarkdown(buf: Buffer): string;
export declare function getVersion(): string;
export declare function isMain(metaurl?: string, scriptpath?: string): boolean;
