import type { Base64, Base64Url } from "@tutao/tutanota-utils";
import { AesKey } from "../encryption/Aes.js";
export type BitArray = number[];
export declare function padAes(bytes: Uint8Array): Uint8Array;
export declare function unpadAes(bytes: Uint8Array): Uint8Array;
/**
 * Creates the auth verifier from the password key.
 * @param passwordKey The key.
 * @returns The auth verifier
 */
export declare function createAuthVerifier(passwordKey: AesKey): Uint8Array;
export declare function createAuthVerifierAsBase64Url(passwordKey: AesKey): Base64Url;
/**
 * Provides the information if a key is 128 or 256 bit length.
 * @param key The key.
 * @returns True if the key length is 128, false if the key length is 256 bit.
 * @throws If the key is not 128 bit and not 256 bit.
 */
export declare function checkIs128BitKey(key: AesKey): boolean;
/**
 * Converts the given BitArray (SJCL) to an Uint8Array.
 * @param bits The BitArray.
 * @return The uint8array.
 */
export declare function bitArrayToUint8Array(bits: BitArray): Uint8Array;
/**
 * Converts the given uint8array to a BitArray (SJCL).
 * @param uint8Array The uint8Array key.
 * @return The key.
 */
export declare function uint8ArrayToBitArray(uint8Array: Uint8Array): BitArray;
/**
 * Converts the given key to a base64 coded string.
 * @param key The key.
 * @return The base64 coded string representation of the key.
 */
export declare function keyToBase64(key: BitArray): Base64;
/**
 * Converts the given base64 coded string to a key.
 * @param base64 The base64 coded string representation of the key.
 * @return The key.
 * @throws {CryptoError} If the conversion fails.
 */
export declare function base64ToKey(base64: Base64): BitArray;
export declare function uint8ArrayToKey(array: Uint8Array): AesKey;
export declare function keyToUint8Array(key: BitArray): Uint8Array;
export declare const fixedIv: Uint8Array;
