import { AesKey } from "./Aes.js";
export type MacTag = Uint8Array & {
    __brand: "macTag";
};
/**
 * Create an HMAC-SHA-256 tag over the given data using the given key.
 */
export declare function hmacSha256(key: AesKey, data: Uint8Array): MacTag;
/**
 * Verify an HMAC-SHA-256 tag against the given data and key.
 * @throws CryptoError if the tag does not match the data and key.
 */
export declare function verifyHmacSha256(key: AesKey, data: Uint8Array, tag: MacTag): void;
