import { PluginContext } from "rollup";
export interface FallbackOptions {
    command: string;
    /**
     * Path where the JS fallback should reside. Useful for caching.
     * Will be passed as {@code WASM_FALLBACK} env variable to the {@link command}.
     */
    outputPath: string;
    workingDir?: string;
}
export interface Library {
    /** Name of the module, how it is imported in JS */
    name: string;
    /** Command to run to generate WASM */
    command: string;
    /** Where to run the command */
    workingDir?: string;
    /**
     * Path where the WASM output should reside.
     * Will be passed as {@code WASM} env variable to the {@link command} and to {@link FallbackOptions#command}.
     */
    outputPath: string;
    /** WASM -> JS fallback options */
    fallback?: FallbackOptions;
}
/**
 * Top-level plugin options
 */
export interface PluginOptions {
    /** List of webassembly files to be compiled and get fallback generated */
    webassemblyLibraries: Library[];
}
export declare function rollupWasmLoader(options: PluginOptions): {
    name: string;
    resolveId(source: string): Promise<{
        id: string;
        external: boolean;
    } | undefined>;
    resolveDynamicImport(specifier: string, importer: string): Promise<{
        external: boolean;
        id: string;
    } | undefined>;
    load(this: PluginContext, id: string): Promise<string | undefined>;
};
