import { TestResult } from "./TestResult.js";
export type AssertionDescriber = (description: string) => void;
/**
 * A started assertion.
 */
export declare class Assertion<T> {
    private readonly actual;
    private readonly testResult;
    constructor(actual: T, testResult: TestResult);
    /**
     * Verify that two items are deeply equal.
     * For arrays length and each element must be deeply equal.
     * For objects the key sets must match and each property must be deeply equal.
     */
    deepEquals(expected: T): AssertionDescriber;
    /**
     * Verify that two items are referentially equal.
     */
    equals(expected: T | null | undefined): AssertionDescriber;
    /** {@see deepEquals} */
    notDeepEquals(value: T): AssertionDescriber;
    /** {@see equals} */
    notEquals(value: T | null | undefined): AssertionDescriber;
    /**
     * Verify that the value satisfies the {@param check}.
     */
    satisfies(check: (value: T) => {
        pass: false;
        message: string;
    } | {
        pass: true;
    }): AssertionDescriber;
    /**
     * Same as {@link satisfies} but the check function is async.
     */
    asyncSatisfies(check: (value: T) => Promise<{
        pass: boolean;
        message: string;
    }>): Promise<AssertionDescriber>;
    /** {@see satisfies} */
    notSatisfies(check: (value: T) => {
        pass: boolean;
        message: string;
    }): AssertionDescriber;
    /**
     * Verify that the value returned by the subject function matches the description.
     * In case of a string description the message is matched, otherwise the error is checked by instanceof.
     */
    throws(errorDescription: string | ErrorConstructor | Class<any>): AssertionDescriber;
    /**
     * Verity that the value returned by the subject function matches the description.
     * In case of a string description the message is matched, otherwise the error is checked by instanceof.
     */
    asyncThrows(errorDescription: string | ErrorConstructor | Class<any>): Promise<AssertionDescriber>;
    private addError;
    private errorName;
}
interface Class<T> {
    new (...args: any[]): T;
}
export {};
