/* auto-generated by NAPI-RS */
/* eslint-disable */
export declare class ImporterApi {
  /** check the disk for any leftover import state and attempt to reconstitute it to be resumed */
  static getResumableImport(mailboxId: string, configDirectory: string, targetOwnerGroup: string, tutaCredentials: TutaCredentials): Promise<ImporterApi | null>
  /** get the id of the remote import state entity that is stored on disk for this import */
  getImportStateId(): ImportMailStateId
  /**
   * use the given credentials and files to prepare to import some mails into the given mailbox.
   * if there is still state left from a previous import into the same mailbox, it will be removed by this operation
   * after this returns, a remote import state exists and can be used to control the import process.
   */
  static prepareNewImport(mailboxId: string, tutaCredentials: TutaCredentials, targetOwnerGroup: string, targetMailset: [string, string], sourcePaths: Array<string>, configDirectory: string): Promise<ImporterApi>
  /**
   * set a new state for the next import loop. the current upload will be finished before
   * changing to the given state and before returning.
   */
  setProgressAction(nextProgressAction: ImportProgressAction): Promise<void>
  /** override the previous error hook with the new function to call if the loop encounters an error it can't ignore */
  setMessageHook(hook: (arg: MailImportMessage) => any): void
  /** arrange for rust log messages to appear in the log files sent via support/error mail */
  static initLog(): void
  /**
   * to be able to log to the js console, we start a task and
   * hold references to some state while the module is active.
   * this cleans up that state so the process can exit.
   * log messages after this point will not be included in log files.
   */
  static deinitLog(): void
}

export declare const enum ImportErrorKind {
  SdkError = 'SdkError',
  /** No import feature on the server (it's disabled) */
  ImportFeatureDisabled = 'ImportFeatureDisabled',
  /** Blob responded with empty server url list */
  EmptyBlobServerList = 'EmptyBlobServerList',
  /** Some mail was too big */
  TooBigChunk = 'TooBigChunk',
  /** Error that occured when deleting a file */
  FileDeletionError = 'FileDeletionError',
  /**
   * The import was finished, but some files
   * were left behind and marked as failures.
   * the path is the directory where the failures can be inspected
   */
  SourceExhaustedSomeError = 'SourceExhaustedSomeError'
}

export interface ImportMailStateId {
  listId: string
  elementId: string
}

export declare const enum ImportOkKind {
  SourceExhaustedNoError = 'SourceExhaustedNoError',
  UserCancelInterruption = 'UserCancelInterruption',
  UserPauseInterruption = 'UserPauseInterruption'
}

/** A running import can be stopped or paused */
export declare const enum ImportProgressAction {
  Continue = 0,
  Pause = 1,
  Stop = 2
}

/**
 * current state of the imap_reader import for this tuta account
 * requires an initialized SDK!
 * keep in sync with TutanotaConstants.ts
 */
export declare const enum ImportStatus {
  Running = 0,
  Paused = 1,
  Canceled = 2,
  Finished = 3
}

/** needed because napi_rs doesn't support structured enums yet */
export interface MailImportErrorMessage {
  kind: ImportErrorKind
  path?: string
}

/**
 * note: this type can be simplified once napi have structural enum support,
 * it can be:
 *```ignore
 * use std::path::PathBuf;
 * use tutao_node_mimimi::importer::messages::{ImportOkKind, MailImportErrorMessage };
 *
 * enum ImportMessage {
 * 	Ok{kind: ImportOkKind},
 * 	Err{kind: MailImportErrorMessage, path: Option<PathBuf>}
 * }
 * ```
 */
export interface MailImportMessage {
  okMessage?: ImportOkKind
  errorMessage?: MailImportErrorMessage
}

/**
 * Errors that can happen when we are preparing for an import.
 * i.e before we enter importer loop
 */
export declare const enum PreparationError {
  /** Can not create a native Rest client */
  NoNativeRestClient = 'NoNativeRestClient',
  /** Can not create a native file client */
  NoNativeFileClient = 'NoNativeFileClient',
  /** some error occurred while reading import directory */
  CannotReadOldStateId = 'CannotReadOldStateId',
  /** Error when trying to resume the session passed from client */
  LoginError = 'LoginError',
  /** Can not read all the eml files in import directory */
  FailedToReadEmls = 'FailedToReadEmls',
  /** can not get mail group key from sdk */
  NoMailGroupKey = 'NoMailGroupKey',
  /** can not load remote state */
  CannotLoadRemoteState = 'CannotLoadRemoteState',
  /** No import feature on the server (it's disabled) */
  ImportFeatureDisabled = 'ImportFeatureDisabled',
  /** Can not write to state file */
  StateFileWriteFailed = 'StateFileWriteFailed',
  /** Can not create directory to keep selected files */
  CanNotCreateImportDir = 'CanNotCreateImportDir',
  /** Can not delete import directory */
  CanNotDeleteImportDir = 'CanNotDeleteImportDir',
  /** Can not read one of selected file */
  FileReadError = 'FileReadError',
  /** Can not parse file content to Message format */
  NotAValidEmailFile = 'NotAValidEmailFile',
  /** Can not write eml file to import dir */
  EmlFileWriteFailure = 'EmlFileWriteFailure'
}

/**
 * when state callback function is called after every chunk of import,
 * javascript handle is expected to respond with this struct
 */
export interface StateCallbackResponse {
  action: ImportProgressAction
}

/** Passed in from js-side, will be validated before being converted to proper tuta sdk credentials. */
export interface TutaCredentials {
  apiUrl: string
  clientVersion: string
  login: string
  userId: string
  accessToken: string
  encryptedPassphraseKey: Array<number>
  isInternalCredential: boolean
}
