const HEADER = "/* generated file, don't edit. */\n";
export class Accumulator {
    appender;
    code = "";
    imports = new Set();
    constructor(appender = (code) => (this.code += code)) {
        this.appender = appender;
    }
    line(code = "") {
        this.appender(code + "\n");
        return this;
    }
    /**
     * Add multiple lines with an optional line-suffix
     */
    lines(lines, opts) {
        const lineJoiner = opts?.suffix ?? "";
        const trailingJoiner = opts?.trailing ?? false;
        for (const [idx, line] of lines.entries()) {
            const joiner = trailingJoiner || idx < lines.length - 1 ? lineJoiner : "";
            this.line(line + joiner);
        }
        return this;
    }
    /**
     * Do something in a callback with this accumulator
     */
    do(callback) {
        callback(this);
        return this;
    }
    /**
     * Do something in a callback with an indented accumulator
     */
    indented(callback) {
        callback(this.indent());
        return this;
    }
    indent(indent = "\t") {
        return new Accumulator((code) => {
            this.appender(indent + code);
        });
    }
    addImport(imp) {
        this.imports.add(imp);
    }
    finish() {
        return HEADER + "\n" + Array.from(this.imports).join("\n") + "\n" + this.code;
    }
}
