// Generated by dts-bundle-generator v9.5.1

/// <reference types="node" />

import { Buffer } from 'node:buffer';
import * as cp from 'node:child_process';
import EventEmitter from 'node:events';
import { Readable, Transform, Writable } from 'node:stream';

type ColorSupportLevel = 0 | 1 | 2 | 3;
export interface ChalkInstance {
	(...text: unknown[]): string;
	/**
	The color support for Chalk.

	By default, color support is automatically detected based on the environment.

	Levels:
	- `0` - All colors disabled.
	- `1` - Basic 16 colors support.
	- `2` - ANSI 256 colors support.
	- `3` - Truecolor 16 million colors support.
	*/
	level: ColorSupportLevel;
	/**
	Use RGB values to set text color.

	@example
	```
	import chalk from 'chalk';

	chalk.rgb(222, 173, 237);
	```
	*/
	rgb: (red: number, green: number, blue: number) => this;
	/**
	Use HEX value to set text color.

	@param color - Hexadecimal value representing the desired color.

	@example
	```
	import chalk from 'chalk';

	chalk.hex('#DEADED');
	```
	*/
	hex: (color: string) => this;
	/**
	Use an [8-bit unsigned number](https://en.wikipedia.org/wiki/ANSI_escape_code#8-bit) to set text color.

	@example
	```
	import chalk from 'chalk';

	chalk.ansi256(201);
	```
	*/
	ansi256: (index: number) => this;
	/**
	Use RGB values to set background color.

	@example
	```
	import chalk from 'chalk';

	chalk.bgRgb(222, 173, 237);
	```
	*/
	bgRgb: (red: number, green: number, blue: number) => this;
	/**
	Use HEX value to set background color.

	@param color - Hexadecimal value representing the desired color.

	@example
	```
	import chalk from 'chalk';

	chalk.bgHex('#DEADED');
	```
	*/
	bgHex: (color: string) => this;
	/**
	Use a [8-bit unsigned number](https://en.wikipedia.org/wiki/ANSI_escape_code#8-bit) to set background color.

	@example
	```
	import chalk from 'chalk';

	chalk.bgAnsi256(201);
	```
	*/
	bgAnsi256: (index: number) => this;
	/**
	Modifier: Reset the current style.
	*/
	readonly reset: this;
	/**
	Modifier: Make the text bold.
	*/
	readonly bold: this;
	/**
	Modifier: Make the text have lower opacity.
	*/
	readonly dim: this;
	/**
	Modifier: Make the text italic. *(Not widely supported)*
	*/
	readonly italic: this;
	/**
	Modifier: Put a horizontal line below the text. *(Not widely supported)*
	*/
	readonly underline: this;
	/**
	Modifier: Put a horizontal line above the text. *(Not widely supported)*
	*/
	readonly overline: this;
	/**
	Modifier: Invert background and foreground colors.
	*/
	readonly inverse: this;
	/**
	Modifier: Print the text but make it invisible.
	*/
	readonly hidden: this;
	/**
	Modifier: Puts a horizontal line through the center of the text. *(Not widely supported)*
	*/
	readonly strikethrough: this;
	/**
	Modifier: Print the text only when Chalk has a color level above zero.

	Can be useful for things that are purely cosmetic.
	*/
	readonly visible: this;
	readonly black: this;
	readonly red: this;
	readonly green: this;
	readonly yellow: this;
	readonly blue: this;
	readonly magenta: this;
	readonly cyan: this;
	readonly white: this;
	/*
	Alias for `blackBright`.
	*/
	readonly gray: this;
	/*
	Alias for `blackBright`.
	*/
	readonly grey: this;
	readonly blackBright: this;
	readonly redBright: this;
	readonly greenBright: this;
	readonly yellowBright: this;
	readonly blueBright: this;
	readonly magentaBright: this;
	readonly cyanBright: this;
	readonly whiteBright: this;
	readonly bgBlack: this;
	readonly bgRed: this;
	readonly bgGreen: this;
	readonly bgYellow: this;
	readonly bgBlue: this;
	readonly bgMagenta: this;
	readonly bgCyan: this;
	readonly bgWhite: this;
	/*
	Alias for `bgBlackBright`.
	*/
	readonly bgGray: this;
	/*
	Alias for `bgBlackBright`.
	*/
	readonly bgGrey: this;
	readonly bgBlackBright: this;
	readonly bgRedBright: this;
	readonly bgGreenBright: this;
	readonly bgYellowBright: this;
	readonly bgBlueBright: this;
	readonly bgMagentaBright: this;
	readonly bgCyanBright: this;
	readonly bgWhiteBright: this;
}
declare const chalk: ChalkInstance;
type AppendNullIfNothrow<TOptions, TRet> = TOptions extends {
	nothrow: infer TVal;
} ? TVal extends false ? TRet : TRet | null : TRet;
type TransformToArrayIfAll<TOptions, TRet> = TOptions extends {
	all: infer TVal;
} ? TVal extends true ? readonly TRet[] : TVal extends false ? TRet : readonly TRet[] | TRet : TRet;
type ReturnType$1<TOptions> = AppendNullIfNothrow<TOptions, TransformToArrayIfAll<TOptions, string>>;
type Exact<T, U extends T> = {
	[Key in keyof U]: Key extends keyof T ? U[Key] : never;
};
declare function which<TOptions extends which.Options>(cmd: string, options?: Exact<which.Options, TOptions>): Promise<ReturnType$1<Exact<which.Options, TOptions>>>;
declare namespace which {
	/** Finds all instances of a specified executable in the PATH environment variable */
	function sync<TOptions extends Options>(cmd: string, options?: Exact<Options, TOptions>): ReturnType$1<Exact<Options, TOptions>>;
	/** Options for which() API */
	interface Options {
		/** If true, return all matches, instead of just the first one. Note that this means the function returns an array of strings instead of a single string. */
		all?: boolean | undefined;
		/** Use instead of the PATH environment variable. */
		path?: string | undefined;
		/** Use instead of the PATHEXT environment variable. */
		pathExt?: string | undefined;
		/** Use instead of the platform's native path separator. */
		delimiter?: string | undefined;
		/** If true, returns null when not found */
		nothrow?: boolean | undefined;
	}
}
type TPsLookupCallback = (err: any, processList?: TPsLookupEntry[]) => void;
type TPsLookupEntry = {
	pid: string;
	ppid?: string;
	command: string;
	arguments: string[];
};
type TPsLookupQuery = {
	pid?: number | string | (string | number)[];
	command?: string;
	arguments?: string;
	ppid?: number | string;
	psargs?: string | string[];
};
type TPsKillOptions = {
	timeout?: number;
	signal?: string | number | NodeJS.Signals;
};
type TPsNext = (err?: any, data?: any) => void;
type TPsTreeOpts = {
	pid: string | number;
	recursive?: boolean;
};
declare const _default: {
	kill: (pid: string | number, opts?: TPsNext | TPsKillOptions | TPsKillOptions["signal"], next?: TPsNext) => Promise<void>;
	lookup: {
		(query?: TPsLookupQuery, cb?: TPsLookupCallback): Promise<TPsLookupEntry[]>;
		sync: (query?: TPsLookupQuery, cb?: TPsLookupCallback) => TPsLookupEntry[];
	};
	lookupSync: (query?: TPsLookupQuery, cb?: TPsLookupCallback) => TPsLookupEntry[];
	tree: {
		(opts?: string | number | TPsTreeOpts | undefined, cb?: TPsLookupCallback): Promise<TPsLookupEntry[]>;
		sync: (opts?: string | number | TPsTreeOpts | undefined, cb?: TPsLookupCallback) => TPsLookupEntry[];
	};
	treeSync: (opts?: string | number | TPsTreeOpts | undefined, cb?: TPsLookupCallback) => TPsLookupEntry[];
};
export declare const isStringLiteral: (pieces: any, ...rest: any[]) => pieces is TemplateStringsArray;
type TQuote = (input: string) => string;
export declare const buildCmd: (quote: TQuote, pieces: TemplateStringsArray, args: any[], subs?: TSubstitute) => string | Promise<string>;
type TSubstitute = (arg: any) => string;
type TSpawnError = any;
type TPushable<T = any> = {
	push(...args: T[]): number;
};
type TJoinable = {
	join(sep?: string): string;
};
type TReducible<T, R> = {
	reduce<U>(fn: (acc: U, cur: T, i: number, arr: T[]) => U, init: U): R;
};
type TArrayLike<T> = Iterable<T> & TPushable<T> & TJoinable & TReducible<T, any> & {
	length: number;
	[i: number]: T | undefined;
};
export type TSpawnStoreChunks = TArrayLike<string | Buffer>;
export type TSpawnStore = {
	stdout: TSpawnStoreChunks;
	stderr: TSpawnStoreChunks;
	stdall: TSpawnStoreChunks;
};
type TSpawnResult = {
	stderr: string;
	stdout: string;
	stdall: string;
	stdio: [
		Readable | Writable,
		Writable,
		Writable
	];
	status: number | null;
	signal: NodeJS.Signals | null;
	duration: number;
	ctx: TSpawnCtxNormalized;
	error?: TSpawnError;
	child?: TChild;
};
type TSpawnListeners = {
	start: (data: TChild, ctx: TSpawnCtxNormalized) => void;
	stdout: (data: Buffer, ctx: TSpawnCtxNormalized) => void;
	stderr: (data: Buffer, ctx: TSpawnCtxNormalized) => void;
	stdall: (data: Buffer, ctx: TSpawnCtxNormalized) => void;
	abort: (error: Event, ctx: TSpawnCtxNormalized) => void;
	err: (error: Error, ctx: TSpawnCtxNormalized) => void;
	end: (result: TSpawnResult, ctx: TSpawnCtxNormalized) => void;
};
type TSpawnCtx = Partial<Omit<TSpawnCtxNormalized, "child">>;
type TChild = ReturnType<typeof cp.spawn>;
type TInput = string | Buffer | Readable;
interface TSpawnCtxNormalized {
	id: string;
	cwd: string;
	cmd: string;
	sync: boolean;
	args: ReadonlyArray<string>;
	input: TInput | null;
	stdio: cp.StdioOptions;
	detached: boolean;
	env: Record<string, string | undefined>;
	ee: EventEmitter;
	on: Partial<TSpawnListeners>;
	ac: AbortController;
	signal: AbortController["signal"];
	shell: string | boolean | undefined;
	spawn: typeof cp.spawn;
	spawnSync: typeof cp.spawnSync;
	spawnOpts: Record<string, any>;
	store: TSpawnStore;
	callback: (err: TSpawnError, result: TSpawnResult) => void;
	stdin: Readable;
	stdout: Writable;
	stderr: Writable;
	child?: TChild;
	fulfilled?: TSpawnResult;
	error?: any;
	run: (cb: () => void, ctx: TSpawnCtxNormalized) => void;
	stack: string;
}
/**
 * Transformer that emits data but does not consume it.
 */
export declare class VoidStream extends Transform {
	_transform(chunk: any, _: string, cb: (err?: Error) => void): void;
}
/**
 * Executes a child process
 * @param ctx TSpawnCtx
 * @returns TSpawnCtxNormalized
 */
export declare const exec: (ctx: TSpawnCtx) => TSpawnCtxNormalized;
export declare const bus: {
	override: (key: string, value: any) => Map<string, any>;
	store: Map<string, any>;
	wrap: <T extends object>(name: string, api: T) => T;
};
export type RequestInfo = Parameters<typeof globalThis.fetch>[0];
type RequestInit$1 = Parameters<typeof globalThis.fetch>[1] & {
	signal?: AbortSignal;
};
declare const chalk$1: typeof chalk;
declare const which$1: typeof which;
export declare const ps: typeof _default;

export {
	RequestInit$1 as RequestInit,
	chalk$1 as chalk,
	which$1 as which,
};

export {};
